/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams$class;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol$class;
import org.apache.spark.ml.param.shared.HasThresholds$class;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u0001\u0003\u0003\u0003i!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\rqQCI\n\u0004\u0001=1\u0003\u0003\u0002\t\u0012'\u0005j\u0011AA\u0005\u0003%\t\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\taa)Z1ukJ,7\u000fV=qKF\u0011\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\b\u001d>$\b.\u001b8h!\tIr$\u0003\u0002!5\t\u0019\u0011I\\=\u0011\u0005Q\u0011C!B\u0012\u0001\u0005\u0004!#!A'\u0012\u0005a)\u0003\u0003\u0002\t\u0001'\u0005\u0002\"\u0001E\u0014\n\u0005!\u0012!!\b)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005)\u0003\"B\u0017\u0001\t\u0003q\u0013!E:fiB\u0013xNY1cS2LG/_\"pYR\u0011\u0011e\f\u0005\u0006a1\u0002\r!M\u0001\u0006m\u0006dW/\u001a\t\u0003eUr!!G\u001a\n\u0005QR\u0012A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001\u000e\u000e\t\u000be\u0002A\u0011\u0001\u001e\u0002\u001bM,G\u000f\u00165sKNDw\u000e\u001c3t)\t\t3\bC\u00031q\u0001\u0007A\bE\u0002\u001a{}J!A\u0010\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005e\u0001\u0015BA!\u001b\u0005\u0019!u.\u001e2mK\")1\t\u0001C!\t\u0006IAO]1og\u001a|'/\u001c\u000b\u0003\u000bf\u0003\"A\u0012,\u000f\u0005\u001d\u001bfB\u0001%R\u001d\tI\u0005K\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001*\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003)V\u000bq\u0001]1dW\u0006<WM\u0003\u0002S\r%\u0011q\u000b\u0017\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001V+\t\u000bi\u0013\u0005\u0019A.\u0002\u000f\u0011\fG/Y:fiB\u0012A,\u0019\t\u0004;z\u0003W\"A+\n\u0005}+&a\u0002#bi\u0006\u001cX\r\u001e\t\u0003)\u0005$\u0011BY-\u0002\u0002\u0003\u0005)\u0011A\f\u0003\u0007}#\u0013\u0007C\u0003e\u0001\u0019EQ-\u0001\fsC^\u0014\u0004O]8cC\nLG.\u001b;z\u0013:\u0004F.Y2f)\t1G\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j\t\u00051A.\u001b8bY\u001eL!a\u001b5\u0003\rY+7\r^8s\u0011\u0015i7\r1\u0001g\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\")q\u000e\u0001C\ta\u0006y!/Y<3aJ|'-\u00192jY&$\u0018\u0010\u0006\u0002gc\")QN\u001ca\u0001M\")1\u000f\u0001C)i\u0006q!/Y<3aJ,G-[2uS>tGCA v\u0011\u0015i'\u000f1\u0001g\u0011\u00159\b\u0001\"\u0005y\u0003I\u0001(/\u001a3jGR\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\u0005\u0019L\b\"\u0002>w\u0001\u0004\u0019\u0012\u0001\u00034fCR,(/Z:\t\u000bq\u0004A\u0011C?\u0002-A\u0014xNY1cS2LG/\u001f\u001aqe\u0016$\u0017n\u0019;j_:$\"a\u0010@\t\u000b}\\\b\u0019\u00014\u0002\u0017A\u0014xNY1cS2LG/\u001f\u0015\u0004\u0001\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%a!\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\b\taA)\u001a<fY>\u0004XM]!qS\u001eA\u0011\u0011\u0003\u0002\t\u0002\u0011\t\u0019\"\u0001\u0011Qe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007c\u0001\t\u0002\u0016\u00199\u0011A\u0001E\u0001\t\u0005]1CBA\u000b\u00033\ty\u0002E\u0002\u001a\u00037I1!!\b\u001b\u0005\u0019\te.\u001f*fMB\u0019\u0011$!\t\n\u0007\u0005\r\"D\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004+\u0003+!\t!a\n\u0015\u0005\u0005M\u0001\u0002CA\u0016\u0003+!\t!!\f\u0002?9|'/\\1mSj,Gk\u001c)s_\n\f'-\u001b7ji&,7/\u00138QY\u0006\u001cW\r\u0006\u0003\u00020\u0005U\u0002cA\r\u00022%\u0019\u00111\u0007\u000e\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003o\tI\u00031\u0001\u0002:\u0005\ta\u000fE\u0002h\u0003wI1!!\u0010i\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u0015\u0005\u0005\u0013QCA\u0001\n\u0013\t\u0019%A\u0006sK\u0006$'+Z:pYZ,GCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nA\u0001\\1oO*\u0011\u0011qJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002T\u0005%#AB(cU\u0016\u001cG\u000f")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds$class.getThresholds(this);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol$class.getProbabilityCol(this);
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        Predef$.MODULE$.require(value.length == this.numClasses(), (Function0)new Serializable(this, value){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProbabilisticClassificationModel $outer;
            private final double[] value$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".setThresholds() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.value$1.length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.value$1 = (double[])value$1;
            }
        });
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        if (this.isDefined(this.thresholds())) {
            Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".transform() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.$outer.$(this.$outer.thresholds()).length)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        Dataset outputData = dataset;
        int numColsOutput = 0;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                }
            }
            UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final Vector apply(Object features) {
                    return this.$outer.predictRaw(features);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
            outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})));
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final Vector apply(Vector rawPrediction) {
                        return this.$outer.raw2probability(rawPrediction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final Vector apply(Object features) {
                        return this.$outer.predictProbability(features);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column probUDF = column;
            outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF);
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Vector rawPrediction) {
                        return this.$outer.raw2prediction(rawPrediction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
            } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Vector probability) {
                        return this.$outer.probability2prediction(probability);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
            } else {
                UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Object features) {
                        return this.$outer.predict(features);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column predUDF = column;
            outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF);
            ++numColsOutput;
        }
        if (numColsOutput == 0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ProbabilisticClassificationModel.transform() was called as NOOP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uid()}))).append((Object)" since no output columns were set.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return outputData.toDF();
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return this.isDefined(this.thresholds()) ? this.probability2prediction(this.raw2probability(rawPrediction)) : (double)rawPrediction.argmax();
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        double d;
        if (this.isDefined(this.thresholds())) {
            double[] thresholds2 = this.getThresholds();
            int argMax = 0;
            double max2 = Double.NEGATIVE_INFINITY;
            int probabilitySize = probability.size();
            for (int i = 0; i < probabilitySize; ++i) {
                double scaled = probability.apply(i) / thresholds2[i];
                if (!(scaled > max2)) continue;
                max2 = scaled;
                argMax = i;
            }
            d = argMax;
        } else {
            d = probability.argmax();
        }
        return d;
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol$class.$init$(this);
        HasThresholds$class.$init$(this);
        ProbabilisticClassifierParams$class.$init$(this);
    }
}

