/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.util.Random;

@DeveloperApi
public final class SVMDataGenerator$ {
    public static final SVMDataGenerator$ MODULE$;

    static {
        new SVMDataGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: SVMGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 1000;
        int nfeatures = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 2;
        int parts = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "SVMGenerator");
        Random globalRnd = new Random(94720);
        double[] trueWeights = (double[])Array$.MODULE$.fill(nfeatures + 1, (Function0)new Serializable(globalRnd){
            public static final long serialVersionUID = 0L;
            private final Random globalRnd$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.globalRnd$1.nextGaussian();
            }
            {
                this.globalRnd$1 = globalRnd$1;
            }
        }, ClassTag$.MODULE$.Double());
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nexamples), parts, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(nfeatures, trueWeights){
            public static final long serialVersionUID = 0L;
            private final int nfeatures$1;
            private final double[] trueWeights$1;

            public final LabeledPoint apply(int idx) {
                Random rnd = new Random(42 + idx);
                double[] x = (double[])Array$.MODULE$.fill(this.nfeatures$1, (Function0)new Serializable(this, rnd){
                    public static final long serialVersionUID = 0L;
                    private final Random rnd$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.rnd$1.nextDouble() * 2.0 - 1.0;
                    }
                    {
                        this.rnd$1 = rnd$1;
                    }
                }, ClassTag$.MODULE$.Double());
                double yD = BLAS.getInstance().ddot(this.trueWeights$1.length, x, 1, this.trueWeights$1, 1) + rnd.nextGaussian() * 0.1;
                double y = yD < 0.0 ? 0.0 : 1.0;
                return new LabeledPoint(y, Vectors$.MODULE$.dense(x));
            }
            {
                this.nfeatures$1 = nfeatures$1;
                this.trueWeights$1 = trueWeights$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    private SVMDataGenerator$() {
        MODULE$ = this;
    }
}

