/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.storage.Zero;
import org.apache.spark.Partitioner;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix$;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001=\u0011\u0001cQ8pe\u0012Lg.\u0019;f\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\t&\u001cHO]5ckR,G-T1ue&D\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f\u0015tGO]5fgV\tQ\u0004E\u0002\u001fC\rj\u0011a\b\u0006\u0003A!\t1A\u001d3e\u0013\t\u0011sDA\u0002S\t\u0012\u0003\"a\u0006\u0013\n\u0005\u0015\u0012!aC'biJL\u00070\u00128uefD3AG\u0014.!\tA3&D\u0001*\u0015\tQ\u0003\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001L\u0015\u0003\u000bMKgnY3\"\u00039\nQ!\r\u00181]AB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!H\u0001\tK:$(/[3tA!\u001aqfJ\u0017\t\u0011M\u0002!\u00111A\u0005\nQ\nQA\u001c*poN,\u0012!\u000e\t\u0003#YJ!a\u000e\n\u0003\t1{gn\u001a\u0005\ts\u0001\u0011\t\u0019!C\u0005u\u0005IaNU8xg~#S-\u001d\u000b\u0003wy\u0002\"!\u0005\u001f\n\u0005u\u0012\"\u0001B+oSRDqa\u0010\u001d\u0002\u0002\u0003\u0007Q'A\u0002yIEB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006K!N\u0001\u0007]J{wo\u001d\u0011\t\u0011\r\u0003!\u00111A\u0005\nQ\nQA\\\"pYND\u0001\"\u0012\u0001\u0003\u0002\u0004%IAR\u0001\n]\u000e{Gn]0%KF$\"aO$\t\u000f}\"\u0015\u0011!a\u0001k!A\u0011\n\u0001B\u0001B\u0003&Q'\u0001\u0004o\u0007>d7\u000f\t\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5s\u0005+\u0015\t\u0003/\u0001AQa\u0007&A\u0002uA3AT\u0014.\u0011\u0015\u0019$\n1\u00016\u0011\u0015\u0019%\n1\u00016Q\rQu%\f\u0005\u0006\u0017\u0002!\t\u0001\u0016\u000b\u0003\u001bVCQaG*A\u0002uA3aU\u0014.\u0011\u0015A\u0006\u0001\"\u0011Z\u0003\u001dqW/\\\"pYN$\u0012!\u000e\u0015\u0004/\u001ej\u0003\"\u0002/\u0001\t\u0003J\u0016a\u00028v[J{wo\u001d\u0015\u00047\u001ej\u0003\"B0\u0001\t\u0003\u0001\u0017!\u0003;sC:\u001c\bo\\:f)\u0005i\u0005f\u00010(E\u0006\n1-A\u00032]Mr\u0003\u0007C\u0003f\u0001\u0011\u0005a-\u0001\nu_&sG-\u001a=fIJ{w/T1ue&DH#A4\u0011\u0005]A\u0017BA5\u0003\u0005AIe\u000eZ3yK\u0012\u0014vn^'biJL\u0007\u0010K\u0002eO5BQ\u0001\u001c\u0001\u0005\u00025\f1\u0002^8S_^l\u0015\r\u001e:jqR\ta\u000e\u0005\u0002\u0018_&\u0011\u0001O\u0001\u0002\n%><X*\u0019;sSbD3a[\u0014.\u0011\u0015\u0019\b\u0001\"\u0001u\u00035!xN\u00117pG.l\u0015\r\u001e:jqR\tQ\u000f\u0005\u0002\u0018m&\u0011qO\u0001\u0002\f\u00052|7m['biJL\u0007\u0010K\u0002sO\tDQa\u001d\u0001\u0005\u0002i$B!^>\u0002\u0002!)A0\u001fa\u0001{\u0006a!o\\<t!\u0016\u0014(\t\\8dWB\u0011\u0011C`\u0005\u0003\u007fJ\u00111!\u00138u\u0011\u0019\t\u0019!\u001fa\u0001{\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001a\u0011p\n2\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f\u0005Y1m\\7qkR,7+\u001b>f)\u0005Y\u0004\u0002CA\b\u0001\u0011\u0005c!!\u0005\u0002\u0011Q|'I]3fu\u0016$\"!a\u0005\u0011\r\u0005U\u0011QDA\u0011\u001b\t\t9BC\u0002\u0006\u00033Q!!a\u0007\u0002\r\t\u0014X-\u001a>f\u0013\u0011\ty\"a\u0006\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\t\u0004#\u0005\r\u0012bAA\u0013%\t1Ai\\;cY\u0016D3\u0001A\u0014.\u0001")
public class CoordinateMatrix
implements DistributedMatrix {
    private final RDD<MatrixEntry> entries;
    private long nRows;
    private long nCols;

    public RDD<MatrixEntry> entries() {
        return this.entries;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0L) {
            this.computeSize();
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.computeSize();
        }
        return this.nRows();
    }

    public CoordinateMatrix transpose() {
        return new CoordinateMatrix((RDD<MatrixEntry>)this.entries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MatrixEntry apply(MatrixEntry x) {
                return new MatrixEntry(x.j(), x.i(), x.value());
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class)), this.numCols(), this.numRows());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        long nl = this.numCols();
        if (nl > Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot convert to a row-oriented format because the number of columns ", " is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nl)}))).append((Object)"too large.").toString());
        }
        int n = (int)nl;
        RDD indexedRows = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(MatrixEntry entry) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)entry.i()), (Object)new Tuple2.mcID.sp((int)entry.j(), entry.value()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final IndexedRow apply(Tuple2<Object, Iterable<Tuple2<Object, Object>>> x0$1) {
                Tuple2<Object, Iterable<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    Iterable vectorEntries = (Iterable)tuple2._2();
                    IndexedRow indexedRow = new IndexedRow(i, Vectors$.MODULE$.sparse(this.n$1, (Seq<Tuple2<Object, Object>>)vectorEntries.toSeq()));
                    return indexedRow;
                }
                throw new MatchError(tuple2);
            }
            {
                this.n$1 = n$1;
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.numRows(), n);
    }

    public RowMatrix toRowMatrix() {
        return this.toIndexedRowMatrix().toRowMatrix();
    }

    public BlockMatrix toBlockMatrix() {
        return this.toBlockMatrix(1024, 1024);
    }

    public BlockMatrix toBlockMatrix(int rowsPerBlock, int colsPerBlock) {
        Predef$.MODULE$.require(rowsPerBlock > 0, (Function0)new Serializable(this, rowsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowsPerBlock needs to be greater than 0. rowsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rowsPerBlock$1)}));
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
            }
        });
        Predef$.MODULE$.require(colsPerBlock > 0, (Function0)new Serializable(this, colsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int colsPerBlock$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"colsPerBlock needs to be greater than 0. colsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock$1)}));
            }
            {
                this.colsPerBlock$1 = colsPerBlock$1;
            }
        });
        long m = this.numRows();
        long n = this.numCols();
        int numRowBlocks = (int)package$.MODULE$.ceil((double)m / (double)rowsPerBlock);
        int numColBlocks = (int)package$.MODULE$.ceil((double)n / (double)colsPerBlock);
        GridPartitioner partitioner = GridPartitioner$.MODULE$.apply(numRowBlocks, numColBlocks, this.entries().partitions().length);
        RDD blocks = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1)new Serializable(this, rowsPerBlock, colsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;
            private final int colsPerBlock$1;

            public final Tuple2<Tuple2<Object, Object>, Tuple3<Object, Object, Object>> apply(MatrixEntry entry) {
                int blockRowIndex = (int)(entry.i() / (long)this.rowsPerBlock$1);
                int blockColIndex = (int)(entry.j() / (long)this.colsPerBlock$1);
                long rowId = entry.i() % (long)this.rowsPerBlock$1;
                long colId = entry.j() % (long)this.colsPerBlock$1;
                return new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((int)rowId)), (Object)BoxesRunTime.boxToInteger((int)((int)colId)), (Object)BoxesRunTime.boxToDouble((double)entry.value())));
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
                this.colsPerBlock$1 = colsPerBlock$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple3.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey((Partitioner)partitioner).map((Function1)new Serializable(this, rowsPerBlock, colsPerBlock, m, n){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;
            private final int colsPerBlock$1;
            private final long m$1;
            private final long n$2;

            public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Iterable<Tuple3<Object, Object, Object>>> x0$2) {
                Tuple2<Tuple2<Object, Object>, Iterable<Tuple3<Object, Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Iterable entry = (Iterable)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        int effRows = (int)package$.MODULE$.min(this.m$1 - (long)blockRowIndex * (long)this.rowsPerBlock$1, (long)this.rowsPerBlock$1);
                        int effCols = (int)package$.MODULE$.min(this.n$2 - (long)blockColIndex * (long)this.colsPerBlock$1, (long)this.colsPerBlock$1);
                        Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)SparseMatrix$.MODULE$.fromCOO(effRows, effCols, (Iterable<Tuple3<Object, Object, Object>>)entry));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
                this.colsPerBlock$1 = colsPerBlock$1;
                this.m$1 = m$1;
                this.n$2 = n$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)blocks, rowsPerBlock, colsPerBlock, m, n);
    }

    private void computeSize() {
        Tuple2 tuple2 = (Tuple2)this.entries().map((Function1)new $anonfun$5(this), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$6(this));
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long m1 = tuple2._1$mcJ$sp();
            long n1 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(m1, n1);
            long m12 = sp3._1$mcJ$sp();
            long n12 = sp3._2$mcJ$sp();
            this.nRows_$eq(package$.MODULE$.max(this.nRows(), m12 + 1L));
            this.nCols_$eq(package$.MODULE$.max(this.nCols(), n12 + 1L));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])this.entries().collect()).foreach((Function1)new Serializable(this, mat){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix mat$1;

            public final void apply(MatrixEntry x0$4) {
                MatrixEntry matrixEntry = x0$4;
                if (matrixEntry != null) {
                    long i = matrixEntry.i();
                    long j = matrixEntry.j();
                    double value = matrixEntry.value();
                    this.mat$1.update$mcD$sp((int)i, (int)j, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)matrixEntry);
            }
            {
                this.mat$1 = mat$1;
            }
        });
        return var3_3;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries, long nRows, long nCols) {
        this.entries = entries;
        this.nRows = nRows;
        this.nCols = nCols;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries) {
        this(entries, 0L, 0L);
    }
}

