/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLUtils$$anonfun$4$;
import org.apache.spark.rdd.PartitionwiseSampledRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.BernoulliCellSampler;
import org.apache.spark.util.random.RandomSampler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MLUtils$ {
    public static final MLUtils$ MODULE$;
    private double EPSILON;
    private volatile boolean bitmap$0;

    static {
        new MLUtils$();
    }

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        MLUtils$ mLUtils$ = this;
        synchronized (mLUtils$) {
            if (!this.bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                this.EPSILON = var2_2;
                this.bitmap$0 = true;
            }
            return this.EPSILON;
        }
    }

    public double EPSILON() {
        return this.bitmap$0 ? this.EPSILON : this.EPSILON$lzycompute();
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures, int minPartitions) {
        int n;
        RDD parsed = sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, ClassTag$.MODULE$.apply(String.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String line) {
                return !line.isEmpty() && !line.startsWith("#");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, int[], double[]> apply(String line) {
                String[] items = new StringOps(Predef$.MODULE$.augmentString(line)).split(' ');
                double label = new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])items).head())).toDouble();
                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])items).tail()).filter((Function1)new anonfun$4$$anonfun$5(this))).map((Function1)new anonfun$4$$anonfun$6(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    IndexedSeq indices = (IndexedSeq)tuple2._1();
                    IndexedSeq values = (IndexedSeq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)indices, (Object)values);
                    IndexedSeq indices2 = (IndexedSeq)tuple23._1();
                    IndexedSeq values2 = (IndexedSeq)tuple23._2();
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), indices2.toArray(ClassTag$.MODULE$.Int()), values2.toArray(ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        if (numFeatures > 0) {
            n = numFeatures;
        } else {
            parsed.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
            n = BoxesRunTime.unboxToInt((Object)parsed.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple3<Object, int[], double[]> x0$1) {
                    Tuple3<Object, int[], double[]> tuple3 = x0$1;
                    if (tuple3 != null) {
                        int[] indices = (int[])tuple3._2();
                        int n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(indices).lastOption().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        return n;
                    }
                    throw new MatchError(tuple3);
                }
            }, ClassTag$.MODULE$.Int()).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(int x, int y) {
                    return this.apply$mcIII$sp(x, y);
                }

                public int apply$mcIII$sp(int x, int y) {
                    return package$.MODULE$.max(x, y);
                }
            })) + 1;
        }
        int d = n;
        return parsed.map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final LabeledPoint apply(Tuple3<Object, int[], double[]> x0$2) {
                Tuple3<Object, int[], double[]> tuple3 = x0$2;
                if (tuple3 != null) {
                    double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    int[] indices = (int[])tuple3._2();
                    double[] values = (double[])tuple3._3();
                    LabeledPoint labeledPoint = new LabeledPoint(label, Vectors$.MODULE$.sparse(this.d$1, indices, values));
                    return labeledPoint;
                }
                throw new MatchError(tuple3);
            }
            {
                this.d$1 = d$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, boolean multiclass, int numFeatures, int minPartitions) {
        return this.loadLibSVMFile(sc, path, numFeatures, minPartitions);
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures) {
        return this.loadLibSVMFile(sc, path, numFeatures, sc.defaultMinPartitions());
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, boolean multiclass, int numFeatures) {
        return this.loadLibSVMFile(sc, path, numFeatures);
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, boolean multiclass) {
        return this.loadLibSVMFile(sc, path);
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path) {
        return this.loadLibSVMFile(sc, path, -1);
    }

    public void saveAsLibSVMFile(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LabeledPoint x0$3) {
                LabeledPoint labeledPoint = x0$3;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    StringBuilder sb = new StringBuilder(((Object)BoxesRunTime.boxToDouble((double)label)).toString());
                    features.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, sb){
                        public static final long serialVersionUID = 0L;
                        private final StringBuilder sb$1;

                        public final void apply(int x0$4, double x1$1) {
                            this.apply$mcVID$sp(x0$4, x1$1);
                        }

                        public void apply$mcVID$sp(int x0$4, double x1$1) {
                            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$1);
                            if (sp2 != null) {
                                int i = sp2._1$mcI$sp();
                                double v = sp2._2$mcD$sp();
                                this.sb$1.$plus$eq(' ');
                                this.sb$1.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1)), BoxesRunTime.boxToDouble((double)v)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)sp2);
                        }
                        {
                            this.sb$1 = sb$1;
                        }
                    });
                    String string = sb.mkString();
                    return string;
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path) {
        return sc.textFile(path, sc.defaultMinPartitions()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String s) {
                return LabeledPoint$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String dir) {
        return this.loadLabeledPoints(sc, dir, sc.defaultMinPartitions());
    }

    public RDD<LabeledPoint> loadLabeledData(SparkContext sc, String dir) {
        return sc.textFile(dir, sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String line) {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                double label = new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble();
                Vector features = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1].trim())).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$4) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                return new LabeledPoint(label, features);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public void saveLabeledData(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LabeledPoint x) {
                return new StringBuilder().append(x.label()).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(x.features().toArray()).mkString(" ")).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    @Experimental
    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, int seed, ClassTag<T> evidence$1) {
        float numFoldsF = numFolds;
        return (Tuple2[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFolds).map((Function1)new Serializable(rdd, seed, evidence$1, numFoldsF){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$1;
            private final int seed$1;
            private final ClassTag evidence$1$1;
            private final float numFoldsF$1;

            public final Tuple2<PartitionwiseSampledRDD<T, T>, PartitionwiseSampledRDD<T, T>> apply(int fold) {
                BernoulliCellSampler sampler = new BernoulliCellSampler((double)((float)(fold - 1) / this.numFoldsF$1), (double)((float)fold / this.numFoldsF$1), false);
                PartitionwiseSampledRDD validation = new PartitionwiseSampledRDD(this.rdd$1, (RandomSampler)sampler, true, (long)this.seed$1, this.evidence$1$1, this.evidence$1$1);
                PartitionwiseSampledRDD training = new PartitionwiseSampledRDD(this.rdd$1, (RandomSampler)sampler.cloneComplement(), true, (long)this.seed$1, this.evidence$1$1, this.evidence$1$1);
                return new Tuple2((Object)training, (Object)validation);
            }
            {
                this.rdd$1 = rdd$1;
                this.seed$1 = seed$1;
                this.evidence$1$1 = evidence$1$1;
                this.numFoldsF$1 = numFoldsF$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector appendBias(Vector vector) {
        breeze.linalg.Vector<Object> vector2;
        block6: {
            DenseVector denseVector;
            block5: {
                block4: {
                    vector2 = vector.toBreeze();
                    if (!(vector2 instanceof DenseVector)) break block4;
                    DenseVector denseVector2 = (DenseVector)vector2;
                    denseVector = DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{denseVector2, new DenseVector.mcD.sp(new double[]{1.0})}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                    break block5;
                }
                if (!(vector2 instanceof breeze.linalg.SparseVector)) break block6;
                breeze.linalg.SparseVector sparseVector = (breeze.linalg.SparseVector)vector2;
                denseVector = SparseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.SparseVector[]{sparseVector, new SparseVector.mcD.sp(new int[]{0}, new double[]{1.0}, 1, (Zero)Zero.DoubleZero$.MODULE$)}), (Zero)Zero.DoubleZero$.MODULE$, ClassTag$.MODULE$.Double());
            }
            DenseVector vector1 = denseVector;
            return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)vector1);
        }
        if (vector2 != null) {
            breeze.linalg.Vector<Object> vector3 = vector2;
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector3.getClass()).toString());
        }
        throw new MatchError(vector2);
    }

    public double fastSquaredDistance(Vector v1, double norm1, Vector v2, double norm2, double precision2) {
        int n = v1.size();
        Predef$.MODULE$.require(v2.size() == n);
        Predef$.MODULE$.require(norm1 >= 0.0 && norm2 >= 0.0);
        double sumSquaredNorm = norm1 * norm1 + norm2 * norm2;
        double normDiff = norm1 - norm2;
        double sqDist = 0.0;
        double precisionBound1 = 2.0 * this.EPSILON() * sumSquaredNorm / (normDiff * normDiff + this.EPSILON());
        if (precisionBound1 < precision2) {
            sqDist = sumSquaredNorm - 2.0 * BLAS$.MODULE$.dot(v1, v2);
        } else if (v1 instanceof SparseVector || v2 instanceof SparseVector) {
            double dotValue = BLAS$.MODULE$.dot(v1, v2);
            sqDist = package$.MODULE$.max(sumSquaredNorm - 2.0 * dotValue, 0.0);
            double precisionBound2 = this.EPSILON() * (sumSquaredNorm + 2.0 * package$.MODULE$.abs(dotValue)) / (sqDist + this.EPSILON());
            if (precisionBound2 > precision2) {
                sqDist = Vectors$.MODULE$.sqdist(v1, v2);
            }
        } else {
            sqDist = Vectors$.MODULE$.sqdist(v1, v2);
        }
        return sqDist;
    }

    public double fastSquaredDistance$default$5() {
        return 1.0E-6;
    }

    public double log1pExp(double x) {
        return x > 0.0 ? x + package$.MODULE$.log1p(package$.MODULE$.exp(-x)) : package$.MODULE$.log1p(package$.MODULE$.exp(x));
    }

    private MLUtils$() {
        MODULE$ = this;
    }
}

