/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import com.github.fommil.netlib.BLAS;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@DeveloperApi
public final class LinearDataGenerator$ {
    public static final LinearDataGenerator$ MODULE$;

    static {
        new LinearDataGenerator$();
    }

    public List<LabeledPoint> generateLinearInputAsList(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return JavaConversions$.MODULE$.seqAsJavaList(this.generateLinearInput(intercept, weights, nPoints, seed, eps));
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return this.generateLinearInput(intercept, weights, (double[])Array$.MODULE$.fill(weights.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.fill(weights.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.3333333333333333;
            }
        }, ClassTag$.MODULE$.Double()), nPoints, seed, eps);
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, double[] xMean, double[] xVariance, int nPoints, int seed, double eps) {
        Random rnd = new Random(seed);
        double[][] x = (double[][])Array$.MODULE$.fill(nPoints, (Function0)new Serializable(weights, rnd){
            public static final long serialVersionUID = 0L;
            private final double[] weights$1;
            public final Random rnd$1;

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(this.weights$1.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rnd$1.nextDouble();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.weights$1 = weights$1;
                this.rnd$1 = rnd$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Predef$.MODULE$.refArrayOps((Object[])x).foreach((Function1)new Serializable(xMean, xVariance){
            public static final long serialVersionUID = 0L;
            private final double[] xMean$1;
            private final double[] xVariance$1;

            public final void apply(double[] v) {
                int len = v.length;
                for (int i = 0; i < len; ++i) {
                    v[i] = (v[i] - 0.5) * package$.MODULE$.sqrt(12.0 * this.xVariance$1[i]) + this.xMean$1[i];
                }
            }
            {
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
            }
        });
        double[] y = (double[])Predef$.MODULE$.refArrayOps((Object[])x).map((Function1)new Serializable(intercept, weights, eps, rnd){
            public static final long serialVersionUID = 0L;
            private final double intercept$1;
            private final double[] weights$1;
            private final double eps$1;
            private final Random rnd$1;

            public final double apply(double[] xi) {
                return BLAS.getInstance().ddot(this.weights$1.length, xi, 1, this.weights$1, 1) + this.intercept$1 + this.eps$1 * this.rnd$1.nextGaussian();
            }
            {
                this.intercept$1 = intercept$1;
                this.weights$1 = weights$1;
                this.eps$1 = eps$1;
                this.rnd$1 = rnd$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(y).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(Tuple2<Object, double[]> p) {
                return new LabeledPoint(p._1$mcD$sp(), Vectors$.MODULE$.dense((double[])p._2()));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public double generateLinearInput$default$5() {
        return 0.1;
    }

    public RDD<LabeledPoint> generateLinearRDD(SparkContext sc, int nexamples, int nfeatures, double eps, int nparts, double intercept) {
        Random random = new Random(42);
        double[] w = (double[])Array$.MODULE$.fill(nfeatures, (Function0)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.random$1.nextDouble() - 0.5;
            }
            {
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.Double());
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nparts), nparts, ClassTag$.MODULE$.Int()).flatMap((Function1)new Serializable(nexamples, eps, nparts, intercept, w){
            public static final long serialVersionUID = 0L;
            private final int nexamples$1;
            private final double eps$2;
            private final int nparts$1;
            private final double intercept$2;
            private final double[] w$1;

            public final Seq<LabeledPoint> apply(int p) {
                int seed = 42 + p;
                int examplesInPartition = this.nexamples$1 / this.nparts$1;
                return LinearDataGenerator$.MODULE$.generateLinearInput(this.intercept$2, (double[])Predef$.MODULE$.doubleArrayOps(this.w$1).toArray(ClassTag$.MODULE$.Double()), examplesInPartition, seed, this.eps$2);
            }
            {
                this.nexamples$1 = nexamples$1;
                this.eps$2 = eps$2;
                this.nparts$1 = nparts$1;
                this.intercept$2 = intercept$2;
                this.w$1 = w$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return data;
    }

    public int generateLinearRDD$default$5() {
        return 2;
    }

    public double generateLinearRDD$default$6() {
        return 0.0;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: LinearDataGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 1000;
        int nfeatures = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 100;
        int parts = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 2;
        int eps = 10;
        SparkContext sc = new SparkContext(sparkMaster, "LinearDataGenerator");
        RDD<LabeledPoint> data = this.generateLinearRDD(sc, nexamples, nfeatures, eps, parts, this.generateLinearRDD$default$6());
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    private LinearDataGenerator$() {
        MODULE$ = this;
    }
}

