/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u00015\u0011Ac\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c(BA\u0002\u0005\u0003\u0011!(/Z3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013%Q$\u0001\tc_>\u001cH/\u001b8h'R\u0014\u0018\r^3hsV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\t\u0011\u0003!\t{wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#\t|wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0005C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u0003\tAQ\u0001\b\u0014A\u0002yAQ!\f\u0001\u0005\u00029\n1A];o)\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u00023\u0005\u0005)Qn\u001c3fY&\u0011A'\r\u0002\u001a\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:N_\u0012,G\u000eC\u00037Y\u0001\u0007q'A\u0003j]B,H\u000fE\u00029wuj\u0011!\u000f\u0006\u0003u\u0019\t1A\u001d3e\u0013\ta\u0014HA\u0002S\t\u0012\u0003\"AP!\u000e\u0003}R!\u0001\u0011\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002C\u007f\taA*\u00192fY\u0016$\u0007k\\5oi\")Q\u0006\u0001C\u0001\tR\u0011q&\u0012\u0005\u0006m\r\u0003\rA\u0012\t\u0004\u000f2kT\"\u0001%\u000b\u0005%S\u0015\u0001\u00026bm\u0006T!a\u0013\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002N\u0011\n9!*\u0019<b%\u0012#\u0005\"B(\u0001\t\u0003\u0001\u0016!\u0005:v]^KG\u000f\u001b,bY&$\u0017\r^5p]R\u0019q&\u0015*\t\u000bYr\u0005\u0019A\u001c\t\u000bMs\u0005\u0019A\u001c\u0002\u001fY\fG.\u001b3bi&|g.\u00138qkRDQa\u0014\u0001\u0005\u0002U#2a\f,X\u0011\u00151D\u000b1\u0001G\u0011\u0015\u0019F\u000b1\u0001GQ\t\u0001\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005y[&\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006dw!\u00021\u0003\u0011\u0003\t\u0017\u0001F$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7\u000f\u0005\u0002+E\u001a)\u0011A\u0001E\u0001GN!!MD\f\u0015\u0011\u00159#\r\"\u0001f)\u0005\t\u0007\"B4c\t\u0003A\u0017!\u0002;sC&tGcA\u0018jU\")aG\u001aa\u0001o!)AD\u001aa\u0001=!)qM\u0019C\u0001YR\u0019q&\u001c8\t\u000bYZ\u0007\u0019\u0001$\t\u000bqY\u0007\u0019\u0001\u0010\t\u000bA\u0014G\u0011B9\u0002\u000b\t|wn\u001d;\u0015\u000b=\u00128\u000f^;\t\u000bYz\u0007\u0019A\u001c\t\u000bM{\u0007\u0019A\u001c\t\u000bqy\u0007\u0019\u0001\u0010\t\u000bY|\u0007\u0019A<\u0002\u0011Y\fG.\u001b3bi\u0016\u0004\"a\u0004=\n\u0005e\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\bw\n\f\t\u0011\"\u0003}\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u00042A`A\u0003\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA\u0001\\1oO*\t\u0011*C\u0002\u0002\b}\u0014aa\u00142kK\u000e$\b")
public class GradientBoostedTrees
implements Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        void var2_2;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, input, this.boostingStrategy(), false);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedInput, this.boostingStrategy(), false);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput) {
        void var3_3;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, validationInput, this.boostingStrategy(), true);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD remappedValidationInput = validationInput.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedValidationInput, this.boostingStrategy(), true);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3})));
    }

    public GradientBoostedTreesModel runWithValidation(JavaRDD<LabeledPoint> input, JavaRDD<LabeledPoint> validationInput) {
        return this.runWithValidation((RDD<LabeledPoint>)input.rdd(), (RDD<LabeledPoint>)validationInput.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this.boostingStrategy = boostingStrategy;
        Logging.class.$init$((Logging)this);
    }
}

