/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u0011q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f+A\u0019q\u0002\u0005\n\u000e\u0003\tI!!\u0005\u0002\u00035\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/\u00117h_JLG\u000f[7\u0011\u0005=\u0019\u0012B\u0001\u000b\u0003\u0005Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0004%I!H\u0001\tgR,\u0007oU5{KV\ta\u0004\u0005\u0002\u0017?%\u0011\u0001e\u0006\u0002\u0007\t>,(\r\\3\t\u0011\t\u0002!\u00111A\u0005\n\r\nAb\u001d;faNK'0Z0%KF$\"\u0001J\u0014\u0011\u0005Y)\u0013B\u0001\u0014\u0018\u0005\u0011)f.\u001b;\t\u000f!\n\u0013\u0011!a\u0001=\u0005\u0019\u0001\u0010J\u0019\t\u0011)\u0002!\u0011!Q!\ny\t\u0011b\u001d;faNK'0\u001a\u0011\t\u00111\u0002!\u00111A\u0005\n5\nQB\\;n\u0013R,'/\u0019;j_:\u001cX#\u0001\u0018\u0011\u0005Yy\u0013B\u0001\u0019\u0018\u0005\rIe\u000e\u001e\u0005\te\u0001\u0011\t\u0019!C\u0005g\u0005\tb.^7Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0011\"\u0004b\u0002\u00152\u0003\u0003\u0005\rA\f\u0005\tm\u0001\u0011\t\u0011)Q\u0005]\u0005qa.^7Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005;\u0001\t\u0005\r\u0011\"\u0003<\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"\u0001\n\u001f\t\u000f!J\u0014\u0011!a\u0001=!Aa\b\u0001B\u0001B\u0003&a$\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003B\u0002!\u0001\t\u0003!\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0005\u000e#U\t\u0005\u0002\u0010\u0001!)Ad\u0010a\u0001=!)Af\u0010a\u0001]!)\u0001h\u0010a\u0001=!9q\t\u0001b\u0001\n\u0013A\u0015\u0001C4sC\u0012LWM\u001c;\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001\u0014\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u00059[%\u0001\u0006'fCN$8+];be\u0016\u001cxI]1eS\u0016tG\u000f\u0003\u0004Q\u0001\u0001\u0006I!S\u0001\nOJ\fG-[3oi\u0002BqA\u0015\u0001C\u0002\u0013%1+A\u0004va\u0012\fG/\u001a:\u0016\u0003Q\u0003\"AS+\n\u0005Y[%!D*j[BdW-\u00169eCR,'\u000f\u0003\u0004Y\u0001\u0001\u0006I\u0001V\u0001\tkB$\u0017\r^3sA!9!\f\u0001b\u0001\n\u0003Z\u0016!C8qi&l\u0017N_3s+\u0005a\u0006C\u0001&^\u0013\tq6JA\bHe\u0006$\u0017.\u001a8u\t\u0016\u001c8-\u001a8u\u0011\u0019\u0001\u0007\u0001)A\u00059\u0006Qq\u000e\u001d;j[&TXM\u001d\u0011\t\u000b\u0001\u0003A\u0011\u00012\u0015\u0003\tCa\u0001\u001a\u0001\u0005R\u0011)\u0017aC2sK\u0006$X-T8eK2$2A\u00054o\u0011\u001597\r1\u0001i\u0003\u001d9X-[4iiN\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0003\u0002\r1Lg.\u00197h\u0013\ti'N\u0001\u0004WK\u000e$xN\u001d\u0005\u0006_\u000e\u0004\rAH\u0001\nS:$XM]2faR<Q!\u001d\u0002\t\u0002I\fq\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u0011\u0005=\u0019h!B\u0001\u0003\u0011\u0003!8cA:v+A\u0011aC^\u0005\u0003o^\u0011a!\u00118z%\u00164\u0007\"\u0002!t\t\u0003IH#\u0001:\t\u000bm\u001cH\u0011\u0001?\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0015Ii\u0018\u0011CA\n\u0003+\t9\u0002C\u0003\u007fu\u0002\u0007q0A\u0003j]B,H\u000f\u0005\u0004\u0002\u0002\u0005\u001d\u00111B\u0007\u0003\u0003\u0007Q1!!\u0002\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0013\t\u0019AA\u0002S\t\u0012\u00032aDA\u0007\u0013\r\tyA\u0001\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006Yi\u0004\rA\f\u0005\u00069i\u0004\rA\b\u0005\u0006qi\u0004\rA\b\u0005\u0007\u00033Q\b\u0019\u00015\u0002\u001d%t\u0017\u000e^5bY^+\u0017n\u001a5ug\"11p\u001dC\u0001\u0003;!\u0012BEA\u0010\u0003C\t\u0019#!\n\t\ry\fY\u00021\u0001\u0000\u0011\u0019a\u00131\u0004a\u0001]!1A$a\u0007A\u0002yAa\u0001OA\u000e\u0001\u0004q\u0002BB>t\t\u0003\tI\u0003F\u0004\u0013\u0003W\ti#a\f\t\ry\f9\u00031\u0001\u0000\u0011\u0019a\u0013q\u0005a\u0001]!1A$a\nA\u0002yAaa_:\u0005\u0002\u0005MB#\u0002\n\u00026\u0005]\u0002B\u0002@\u00022\u0001\u0007q\u0010\u0003\u0004-\u0003c\u0001\rA\f\u0005\n\u0003w\u0019\u0018\u0011!C\u0005\u0003{\t1B]3bIJ+7o\u001c7wKR\u0011\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0013\u0001\u00026bm\u0006LA!!\u0014\u0002D\t1qJ\u00196fGR\u0004")
public class LinearRegressionWithSGD
extends GeneralizedLinearAlgorithm<LinearRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SimpleUpdater updater;
    private final GradientDescent optimizer;

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static LinearRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, Vector vector) {
        return LinearRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SimpleUpdater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public LinearRegressionModel createModel(Vector weights, double intercept) {
        return new LinearRegressionModel(weights, intercept);
    }

    public LinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SimpleUpdater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public LinearRegressionWithSGD() {
        this(1.0, 100, 1.0);
    }
}

