/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001b;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u001fmI!\u0001\b\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005yyR\"\u0001\u0004\n\u0005\u00012!a\u0002'pO\u001eLgn\u001a\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005!!/\u00198l+\u0005!\u0003CA\b&\u0013\t1\u0003CA\u0002J]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006e\u0006t7\u000e\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u0005aQo]3s\r\u0016\fG/\u001e:fgV\tA\u0006E\u0002.aIj\u0011A\f\u0006\u0003_\u0019\t1A\u001d3e\u0013\t\tdFA\u0002S\t\u0012\u0003BaD\u001a%k%\u0011A\u0007\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007=1\u0004(\u0003\u00028!\t)\u0011I\u001d:bsB\u0011q\"O\u0005\u0003uA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u001bU\u001cXM\u001d$fCR,(/Z:!\u0011!q\u0004A!b\u0001\n\u0003Y\u0013a\u00049s_\u0012,8\r\u001e$fCR,(/Z:\t\u0011\u0001\u0003!\u0011!Q\u0001\n1\n\u0001\u0003\u001d:pIV\u001cGOR3biV\u0014Xm\u001d\u0011\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\u0011!ei\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\u0002\t\u000b\t\n\u0005\u0019\u0001\u0013\t\u000b)\n\u0005\u0019\u0001\u0017\t\u000by\n\u0005\u0019\u0001\u0017\t\u000b)\u0003A\u0011B&\u0002!Y\fG.\u001b3bi\u00164U-\u0019;ve\u0016\u001cHc\u0001'P1B\u0011q\"T\u0005\u0003\u001dB\u0011A!\u00168ji\")\u0001+\u0013a\u0001#\u0006!a.Y7f!\t\u0011VK\u0004\u0002\u0010'&\u0011A\u000bE\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U!!)\u0011,\u0013a\u0001Y\u0005Aa-Z1ukJ,7\u000fC\u0003\\\u0001\u0011\u0005A,A\u0004qe\u0016$\u0017n\u0019;\u0015\u0007ajv\fC\u0003_5\u0002\u0007A%\u0001\u0003vg\u0016\u0014\b\"\u00021[\u0001\u0004!\u0013a\u00029s_\u0012,8\r\u001e\u0005\u00067\u0002!\tA\u0019\u000b\u0003G\u001e\u00042!\f\u0019e!\t)U-\u0003\u0002g\u0005\t1!+\u0019;j]\u001eDQ\u0001[1A\u0002%\fQ\"^:feN\u0004&o\u001c3vGR\u001c\bcA\u00171UB!qb\r\u0013%\u0011\u0015Y\u0006\u0001\"\u0001m)\tiW\u000fE\u0002og\u0012l\u0011a\u001c\u0006\u0003aF\fAA[1wC*\u0011!OB\u0001\u0004CBL\u0017B\u0001;p\u0005\u001dQ\u0015M^1S\t\u0012CQ\u0001[6A\u0002Y\u0004BA\\<zs&\u0011\u0001p\u001c\u0002\f\u0015\u00064\u0018\rU1jeJ#E\t\u0005\u0002{}6\t1P\u0003\u0002}{\u0006!A.\u00198h\u0015\u0005\u0001\u0018BA@|\u0005\u001dIe\u000e^3hKJDq!a\u0001\u0001\t\u0003\t)!A\tsK\u000e|W.\\3oIB\u0013x\u000eZ;diN$b!a\u0002\u0002\n\u0005-\u0001cA\b7I\"1a,!\u0001A\u0002\u0011Bq!!\u0004\u0002\u0002\u0001\u0007A%A\u0002ok6Dq!!\u0005\u0001\t\u0003\t\u0019\"\u0001\bsK\u000e|W.\\3oIV\u001bXM]:\u0015\r\u0005\u001d\u0011QCA\f\u0011\u0019\u0001\u0017q\u0002a\u0001I!9\u0011QBA\b\u0001\u0004!\u0003\"CA\u000e\u0001\t\u0007I\u0011KA\u000f\u000351wN]7biZ+'o]5p]V\t\u0011\u000bC\u0004\u0002\"\u0001\u0001\u000b\u0011B)\u0002\u001d\u0019|'/\\1u-\u0016\u00148/[8oA!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012\u0001B:bm\u0016$R\u0001TA\u0015\u0003gA\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\u0003g\u000e\u00042AHA\u0018\u0013\r\t\tD\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003k\t\u0019\u00031\u0001R\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u0005I\"/Z2p[6,g\u000e\u001a)s_\u0012,8\r^:G_J,6/\u001a:t)\u0011\ti$!\u0011\u0011\t5\u0002\u0014q\b\t\u0006\u001fM\"\u0013q\u0001\u0005\b\u0003\u001b\t9\u00041\u0001%\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\n\u0011D]3d_6lWM\u001c3Vg\u0016\u00148OR8s!J|G-^2ugR!\u0011QHA%\u0011\u001d\ti!a\u0011A\u0002\u0011:q!!\u0014\u0003\u0011\u0003\ty%\u0001\rNCR\u0014\u0018\u000e\u001f$bGR|'/\u001b>bi&|g.T8eK2\u00042!RA)\r\u0019\t!\u0001#\u0001\u0002TM1\u0011\u0011\u000b\b\u0002Vi\u0001B!FA,\t&\u0019\u0011\u0011\f\f\u0003\r1{\u0017\rZ3s\u0011\u001d\u0011\u0015\u0011\u000bC\u0001\u0003;\"\"!a\u0014\t\u0011\u0005\u0005\u0014\u0011\u000bC\u0005\u0003G\n\u0011B]3d_6lWM\u001c3\u0015\u0011\u0005\u0015\u0014\u0011NA7\u0003c\u0002Ba\u0004\u001c\u0002hA!qb\r\u00139\u0011\u001d\tY'a\u0018A\u0002U\n1C]3d_6lWM\u001c3U_\u001a+\u0017\r^;sKNDq!a\u001c\u0002`\u0001\u0007A&A\u000bsK\u000e|W.\\3oI\u0006\u0014G.\u001a$fCR,(/Z:\t\u000f\u00055\u0011q\fa\u0001I!A\u0011QOA)\t\u0013\t9(A\bsK\u000e|W.\\3oI\u001a{'/\u00117m))\tI(! \u0002\u0000\u0005\r\u0015q\u0011\t\u0005[A\nY\bE\u0003\u0010g\u0011\n)\u0007\u0003\u0004#\u0003g\u0002\r\u0001\n\u0005\b\u0003\u0003\u000b\u0019\b1\u0001-\u0003-\u0019(o\u0019$fCR,(/Z:\t\u000f\u0005\u0015\u00151\u000fa\u0001Y\u0005YAm\u001d;GK\u0006$XO]3t\u0011\u001d\ti!a\u001dA\u0002\u0011B\u0001\"a#\u0002R\u0011%\u0011QR\u0001\tE2|7m[5gsR1\u0011qRAQ\u0003G\u0003B!\f\u0019\u0002\u0012B1qbMAJ\u0003+\u00032a\u0004\u001c%!\u0011\t9*!(\u000e\u0005\u0005e%bAAN\t\u00051A.\u001b8bY\u001eLA!a(\u0002\u001a\nYA)\u001a8tK6\u000bGO]5y\u0011\u0019\u0011\u0013\u0011\u0012a\u0001I!1\u0011,!#A\u00021B\u0001\"a*\u0002R\u0011\u0005\u0013\u0011V\u0001\u0005Y>\fG\rF\u0003E\u0003W\u000bi\u000b\u0003\u0005\u0002,\u0005\u0015\u0006\u0019AA\u0017\u0011\u001d\t)$!*A\u0002E;\u0011\"!-\u0002R!\u0005!!a-\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\t\u0005U\u0016qW\u0007\u0003\u0003#2\u0011\"!/\u0002R!\u0005!!a/\u0003\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0014\u0007\u0005]f\u0002C\u0004C\u0003o#\t!a0\u0015\u0005\u0005M\u0006BCAb\u0003o\u0013\r\u0011\"\u0003\u0002F\u0006\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005\u001d\u0007c\u0001>\u0002J&\u0011ak\u001f\u0005\n\u0003\u001b\f9\f)A\u0005\u0003\u000f\f!\u0003\u001e5jg\u001a{'/\\1u-\u0016\u00148/[8oA!Y\u0011\u0011[A\\\u0005\u0004%\tAAAc\u00035!\b.[:DY\u0006\u001c8OT1nK\"I\u0011Q[A\\A\u0003%\u0011qY\u0001\u000fi\"L7o\u00117bgNt\u0015-\\3!\u0011!\t)#a.\u0005\u0002\u0005eG#\u0002'\u0002\\\u0006}\u0007bBAo\u0003/\u0004\r\u0001R\u0001\u0006[>$W\r\u001c\u0005\b\u0003k\t9\u000e1\u0001R\u0011!\t9+a.\u0005\u0002\u0005\rH#\u0002#\u0002f\u0006\u001d\b\u0002CA\u0016\u0003C\u0004\r!!\f\t\u000f\u0005U\u0012\u0011\u001da\u0001#\"A\u00111^A\\\t\u0013\ti/\u0001\u0005vg\u0016\u0014\b+\u0019;i)\r\t\u0016q\u001e\u0005\b\u0003k\tI\u000f1\u0001R\u0011!\t\u00190a.\u0005\n\u0005U\u0018a\u00039s_\u0012,8\r\u001e)bi\"$2!UA|\u0011\u001d\t)$!=A\u0002EC!\"a?\u0002R\u0005\u0005I\u0011BA\u007f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\bc\u0001>\u0003\u0002%\u0019!1A>\u0003\r=\u0013'.Z2u\u0001")
public class MatrixFactorizationModel
implements Saveable,
Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModel $outer;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " feature dimension does not match the rank ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)this.$outer.rank())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)"Prediction on individual records could be slow.").toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. Prediction could be slow."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
    }

    public double predict(int user, int product) {
        double[] userVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head();
        double[] productVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head();
        return BLAS.getInstance().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                            return rating;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$3) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, user){
                        public static final long serialVersionUID = 0L;
                        private final int user$2;

                        public final Rating apply(Tuple2<Object, Object> x0$4) {
                            Tuple2<Object, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                int product = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(this.user$2, product, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.user$2 = user$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$5) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$5;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, product){
                        public static final long serialVersionUID = 0L;
                        private final int product$2;

                        public final Rating apply(Tuple2<Object, Object> x0$6) {
                            Tuple2<Object, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                int user = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(user, this.product$2, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.product$2 = product$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

