/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.mllib.rdd.RandomVectorRDD$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u0001\u0003\u0001\u0011a!a\u0004*b]\u0012|WNV3di>\u0014(\u000b\u0012#\u000b\u0005\r!\u0011a\u0001:eI*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dA\u0011R\"A\b\u000b\u0005\r1\u0011BA\t\u0010\u0005\r\u0011F\t\u0012\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\ta\u0001\\5oC2<\u0017BA\f\u0015\u0005\u00191Vm\u0019;pe\"A\u0011\u0004\u0001B\u0001B\u0003%1$\u0001\u0002tG\u000e\u0001\u0001C\u0001\u000f\u001e\u001b\u00051\u0011B\u0001\u0010\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=uQ\tA\u0002\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0005ue\u0006t7/[3oi\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0003tSj,\u0007CA\u0011*\u0013\tQ#E\u0001\u0003M_:<\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0015Y,7\r^8s'&TX\r\u0005\u0002\"]%\u0011qF\t\u0002\u0004\u0013:$\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014a\u0001:oOB\u0019Q\u0007\u000f\u001e\u000e\u0003YR!a\u000e\u0003\u0002\rI\fg\u000eZ8n\u0013\tIdGA\nSC:$w.\u001c#bi\u0006<UM\\3sCR|'\u000f\u0005\u0002\"w%\u0011AH\t\u0002\u0007\t>,(\r\\3)\u0005I\u0002\u0003\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\tM,W\r\u001a\u0015\u0003}\u0001BQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtDc\u0002#G\u000f\"K%j\u0013\t\u0003\u000b\u0002i\u0011A\u0001\u0005\u00063\u0005\u0003\ra\u0007\u0005\u0006O\u0005\u0003\r\u0001\u000b\u0005\u0006Y\u0005\u0003\r!\f\u0005\u0006c\u0005\u0003\r!\f\u0005\u0006g\u0005\u0003\r\u0001\u000e\u0005\b\u007f\u0005\u0003\n\u00111\u0001)\u0011\u0015i\u0005\u0001\"\u0011O\u0003\u001d\u0019w.\u001c9vi\u0016$2aT.a!\r\u0001\u0006L\u0005\b\u0003#Zs!AU+\u000e\u0003MS!\u0001\u0016\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA,#\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0011%#XM]1u_JT!a\u0016\u0012\t\u000bqc\u0005\u0019A/\u0002\u000fM\u0004H.\u001b;J]B\u0011ADX\u0005\u0003?\u001a\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000b\u0005d\u0005\u0019\u00012\u0002\u000f\r|g\u000e^3yiB\u0011AdY\u0005\u0003I\u001a\u00111\u0002V1tW\u000e{g\u000e^3yi\")a\r\u0001C)O\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N,\u0012\u0001\u001b\t\u0004C%l\u0016B\u00016#\u0005\u0015\t%O]1z\u000f!a'!!A\t\u0002\u0011i\u0017a\u0004*b]\u0012|WNV3di>\u0014(\u000b\u0012#\u0011\u0005\u0015sg\u0001C\u0001\u0003\u0003\u0003E\t\u0001B8\u0014\u00079\u00048\u000f\u0005\u0002\"c&\u0011!O\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\"\u0018BA;#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0011e\u000e\"\u0001x)\u0005i\u0007bB=o#\u0003%\tA_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0003mT#\u0001\u000b?,\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015!%\u0001\u0006b]:|G/\u0019;j_:L1!!\u0003\u0000\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u001bq\u0017\u0011!C\u0005\u0003\u001f\t1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t1qJ\u00196fGR\u0004")
public class RandomVectorRDD
extends RDD<Vector> {
    private final long size;
    private final int vectorSize;
    private final int numPartitions;
    private final transient RandomDataGenerator<Object> rng;
    private final transient long seed;

    public static long $lessinit$greater$default$6() {
        return RandomVectorRDD$.MODULE$.$lessinit$greater$default$6();
    }

    public Iterator<Vector> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getVectorIterator(split, this.vectorSize);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng, this.seed);
    }

    public RandomVectorRDD(SparkContext sc, long size, int vectorSize, int numPartitions, RandomDataGenerator<Object> rng, long seed) {
        this.size = size;
        this.vectorSize = vectorSize;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Vector.class));
        Predef$.MODULE$.require(size > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive RDD size required.";
            }
        });
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive number of partitions required";
            }
        });
        Predef$.MODULE$.require(vectorSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive vector size required.";
            }
        });
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition size cannot exceed Int.MaxValue";
            }
        });
    }
}

