/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u00164Vm\u0019;pe*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004WK\u000e$xN\u001d\u0005\t3\u0001\u0011)\u0019!C\u00015\u00051a/\u00197vKN,\u0012a\u0007\t\u0004\u001fqq\u0012BA\u000f\u0011\u0005\u0015\t%O]1z!\tyq$\u0003\u0002!!\t1Ai\\;cY\u0016D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\bm\u0006dW/Z:!\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011ae\n\t\u0003+\u0001AQ!G\u0012A\u0002mAQ!\u000b\u0001\u0005B)\nAa]5{KV\t1\u0006\u0005\u0002\u0010Y%\u0011Q\u0006\u0005\u0002\u0004\u0013:$\b\"B\u0018\u0001\t\u0003\u0002\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003E\u0002\"AM\u001b\u000f\u0005=\u0019\u0014B\u0001\u001b\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u0002\u0002\"B\u001d\u0001\t\u0003R\u0012a\u0002;p\u0003J\u0014\u0018-\u001f\u0005\u0007w\u0001!\tE\u0002\u001f\u0002\u0011Q|'I]3fu\u0016,\u0012!\u0010\t\u0004}\tsR\"A \u000b\u0005\r\u0001%\"A!\u0002\r\t\u0014X-\u001a>f\u0013\t9r\bC\u0003E\u0001\u0011\u0005S)A\u0003baBd\u0017\u0010\u0006\u0002\u001f\r\")qi\u0011a\u0001W\u0005\t\u0011\u000eC\u0003J\u0001\u0011\u0005#*\u0001\u0003d_BLX#\u0001\u0014\t\r1\u0003A\u0011\t\u0004N\u000351wN]3bG\"\f5\r^5wKR\u0011a*\u0015\t\u0003\u001f=K!\u0001\u0015\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006%.\u0003\raU\u0001\u0002MB)q\u0002V\u0016\u001f\u001d&\u0011Q\u000b\u0005\u0002\n\rVt7\r^5p]JBQa\u0016\u0001\u0005Ba\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002W!)!\f\u0001C!U\u0005Qa.^7BGRLg/Z:\t\u000bq\u0003A\u0011\t\u0016\u0002\u00179,XNT8ou\u0016\u0014xn\u001d\u0005\u0006=\u0002!\teX\u0001\ti>\u001c\u0006/\u0019:tKV\t\u0001\r\u0005\u0002\u0016C&\u0011!M\u0001\u0002\r'B\f'o]3WK\u000e$xN\u001d\u0005\u0007I\u0002!\tA\u0002\u0016\u0002\r\u0005\u0014x-\\1yQ\u0011\u0001aM\\8\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017!\u0002;za\u0016\u001c(BA6\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003[\"\u0014!cU)M+N,'\u000fR3gS:,G\rV=qK\u0006\u0019Q\u000f\u001a;$\u0003A\u0004\"!F9\n\u0005I\u0014!!\u0003,fGR|'/\u0016#U\u000f\u0015!(\u0001#\u0001v\u0003-!UM\\:f-\u0016\u001cGo\u001c:\u0011\u0005U1h!B\u0001\u0003\u0011\u000398c\u0001<\u000fqB\u0011q\"_\u0005\u0003uB\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001\n<\u0005\u0002q$\u0012!\u001e\u0005\u0006}Z$\ta`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t!a\u0002\u0011\t=\t\u0019aG\u0005\u0004\u0003\u000b\u0001\"AB(qi&|g\u000e\u0003\u0004\u0002\nu\u0004\rAJ\u0001\u0003IZD\u0011\"!\u0004w\u0003\u0003%I!a\u0004\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011Q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class DenseVector
implements Vector {
    private final double[] values;

    public static Option<double[]> unapply(DenseVector denseVector) {
        return DenseVector$.MODULE$.unapply(denseVector);
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values().length;
    }

    public String toString() {
        return Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]");
    }

    @Override
    public double[] toArray() {
        return this.values();
    }

    @Override
    public breeze.linalg.Vector<Object> toBreeze() {
        return new DenseVector.mcD.sp(this.values());
    }

    @Override
    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector((double[])this.values().clone());
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(i, localValues[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = package$.MODULE$.min(this.values().length, 16);
        for (int i = 0; i < end; ++i) {
            double v = this.values()[i];
            if (v == 0.0) continue;
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(this.values()[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.size();
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = new IntRef(0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$1;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$1.elem;
                }
            }
            {
                this.nnz$1 = nnz$1;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparse() {
        int nnz = this.numNonzeros();
        int[] ii = new int[nnz];
        double[] vv = new double[nnz];
        IntRef k = new IntRef(0);
        this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
            public static final long serialVersionUID = 0L;
            private final int[] ii$1;
            private final double[] vv$1;
            private final IntRef k$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (v != 0.0) {
                    this.ii$1[this.k$1.elem] = i;
                    this.vv$1[this.k$1.elem] = v;
                    ++this.k$1.elem;
                }
            }
            {
                this.ii$1 = ii$1;
                this.vv$1 = vv$1;
                this.k$1 = k$1;
            }
        });
        return new SparseVector(this.size(), ii, vv);
    }

    /*
     * WARNING - void declaration
     */
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else {
            void var1_1;
            int maxIdx = 0;
            double maxValue = this.values()[0];
            for (int i = 1; i < this.size(); ++i) {
                if (!(this.values()[i] > maxValue)) continue;
                maxIdx = i;
                maxValue = this.values()[i];
            }
            n = var1_1;
        }
        return n;
    }

    public DenseVector(double[] values) {
        this.values = values;
        Vector$class.$init$(this);
    }
}

