/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\t1\u0011\u0011\u0004U3sS>$\u0017nY$sCBD7\t[3dWB|\u0017N\u001c;fe*\u00111\u0001B\u0001\u0005S6\u0004HN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-F\u0002\u000eI9\u001a2\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\r%\u0011qC\u0002\u0002\b\u0019><w-\u001b8h\u0011!I\u0002A!a\u0001\n\u0003Y\u0012\u0001D2veJ,g\u000e^$sCBD7\u0001A\u000b\u00029A!Q\u0004\t\u0012.\u001b\u0005q\"BA\u0010\u0007\u0003\u00199'/\u00199iq&\u0011\u0011E\b\u0002\u0006\u000fJ\f\u0007\u000f\u001b\t\u0003G\u0011b\u0001\u0001B\u0003&\u0001\t\u0007aE\u0001\u0002W\tF\u0011qE\u000b\t\u0003\u001f!J!!\u000b\t\u0003\u000f9{G\u000f[5oOB\u0011qbK\u0005\u0003YA\u00111!\u00118z!\t\u0019c\u0006B\u00030\u0001\t\u0007aE\u0001\u0002F\t\"A\u0011\u0007\u0001BA\u0002\u0013\u0005!'\u0001\tdkJ\u0014XM\u001c;He\u0006\u0004\bn\u0018\u0013fcR\u00111G\u000e\t\u0003\u001fQJ!!\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\boA\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\ts\u0001\u0011\t\u0011)Q\u00059\u0005i1-\u001e:sK:$xI]1qQ\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001P\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.F\u0001>!\tya(\u0003\u0002@!\t\u0019\u0011J\u001c;\t\u0011\u0005\u0003!\u0011!Q\u0001\nu\n1c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\u0002BQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtDcA#H\u0011B!a\t\u0001\u0012.\u001b\u0005\u0011\u0001\"B\rC\u0001\u0004a\u0002\"B\u001eC\u0001\u0004i\u0004b\u0002&\u0001\u0005\u0004%IaS\u0001\u0010G\",7m\u001b9pS:$\u0018+^3vKV\tA\nE\u0002N%ri\u0011A\u0014\u0006\u0003\u001fB\u000bq!\\;uC\ndWM\u0003\u0002R!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ms%!B)vKV,\u0007BB+\u0001A\u0003%A*\u0001\tdQ\u0016\u001c7\u000e]8j]R\fV/Z;fA!9q\u000b\u0001b\u0001\n\u0013Y\u0015A\u00049feNL7\u000f^3e#V,W/\u001a\u0005\u00073\u0002\u0001\u000b\u0011\u0002'\u0002\u001fA,'o]5ti\u0016$\u0017+^3vK\u0002Bqa\u0017\u0001A\u0002\u0013%A(A\u0006va\u0012\fG/Z\"pk:$\bbB/\u0001\u0001\u0004%IAX\u0001\u0010kB$\u0017\r^3D_VtGo\u0018\u0013fcR\u00111g\u0018\u0005\boq\u000b\t\u00111\u0001>\u0011\u0019\t\u0007\u0001)Q\u0005{\u0005aQ\u000f\u001d3bi\u0016\u001cu.\u001e8uA!91\r\u0001b\u0001\n\u0013!\u0017AA:d+\u0005)\u0007CA\u000bg\u0013\t9gA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0004j\u0001\u0001\u0006I!Z\u0001\u0004g\u000e\u0004\u0003\"B6\u0001\t\u0003a\u0017aC;qI\u0006$Xm\u0012:ba\"$\"aM7\t\u000b9T\u0007\u0019\u0001\u000f\u0002\u00119,wo\u0012:ba\"DQ\u0001\u001d\u0001\u0005\u0002E\fA\u0003Z3mKR,\u0017\t\u001c7DQ\u0016\u001c7\u000e]8j]R\u001cH#A\u001a\t\u000bM\u0004A\u0011B9\u0002)I,Wn\u001c<f\u0007\",7m\u001b9pS:$h)\u001b7f\u0001")
public class PeriodicGraphCheckpointer<VD, ED>
implements Logging {
    private Graph<VD, ED> currentGraph;
    private final int checkpointInterval;
    private final Queue<Graph<VD, ED>> checkpointQueue;
    private final Queue<Graph<VD, ED>> persistedQueue;
    private int updateCount;
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Graph<VD, ED> currentGraph() {
        return this.currentGraph;
    }

    public void currentGraph_$eq(Graph<VD, ED> x$1) {
        this.currentGraph = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    private Queue<Graph<VD, ED>> checkpointQueue() {
        return this.checkpointQueue;
    }

    private Queue<Graph<VD, ED>> persistedQueue() {
        return this.persistedQueue;
    }

    private int updateCount() {
        return this.updateCount;
    }

    private void updateCount_$eq(int x$1) {
        this.updateCount = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    public void updateGraph(Graph<VD, ED> newGraph) {
        StorageLevel storageLevel = newGraph.vertices().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Object object = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null) ? newGraph.persist(newGraph.persist$default$1()) : BoxedUnit.UNIT;
        this.persistedQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Graph[]{newGraph}));
        while (this.persistedQueue().size() > 3) {
            Graph graphToUnpersist = (Graph)this.persistedQueue().dequeue();
            graphToUnpersist.unpersist(false);
        }
        this.updateCount_$eq(this.updateCount() + 1);
        if (this.updateCount() % this.checkpointInterval() == 0 && this.sc().getCheckpointDir().nonEmpty()) {
            newGraph.checkpoint();
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Graph[]{newGraph}));
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                if (((Graph)this.checkpointQueue().get(1).get()).isCheckpointed()) {
                    this.removeCheckpointFile();
                    continue;
                }
                canDelete = false;
            }
        }
    }

    public void deleteAllCheckpoints() {
        while (this.checkpointQueue().size() > 0) {
            this.removeCheckpointFile();
        }
    }

    private void removeCheckpointFile() {
        Graph old = (Graph)this.checkpointQueue().dequeue();
        FileSystem fs = FileSystem.get((Configuration)this.sc().hadoopConfiguration());
        old.getCheckpointFiles().foreach((Function1)new Serializable(this, fs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicGraphCheckpointer $outer;
            private final FileSystem fs$1;

            public final Object apply(String checkpointFile) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.fs$1.delete(new Path(checkpointFile), true));
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, checkpointFile){
                        public static final long serialVersionUID = 0L;
                        private final String checkpointFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"PeriodicGraphCheckpointer could not remove old checkpoint file: ").append((Object)this.checkpointFile$1).toString();
                        }
                        {
                            this.checkpointFile$1 = checkpointFile$1;
                        }
                    });
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
            }
        });
    }

    public PeriodicGraphCheckpointer(Graph<VD, ED> currentGraph, int checkpointInterval) {
        this.currentGraph = currentGraph;
        this.checkpointInterval = checkpointInterval;
        Logging.class.$init$((Logging)this);
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.persistedQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.updateCount = 0;
        this.sc = this.currentGraph().vertices().sparkContext();
        this.updateGraph(this.currentGraph());
    }
}

