/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tmd\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\t'\u00064X-\u00192mK\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0003n_\u0012,G\u000e\u0005\u0003!G\u0019JcBA\b\"\u0013\t\u0011\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u00121!T1q\u0015\t\u0011\u0003\u0003\u0005\u0002!O%\u0011\u0001&\n\u0002\u0007'R\u0014\u0018N\\4\u0011\u0007=QC&\u0003\u0002,!\t)\u0011I\u001d:bsB\u0011q\"L\u0005\u0003]A\u0011QA\u00127pCRDa\u0001\r\u0001\u0005\u0002\u0011\t\u0014A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002\u0005!)ad\fa\u0001?!9a\u0007\u0001b\u0001\n\u00139\u0014\u0001C<pe\u0012d\u0015n\u001d;\u0016\u0003a\u00022a\u0004\u0016'\u0011\u0019Q\u0004\u0001)A\u0005q\u0005Iqo\u001c:e\u0019&\u001cH\u000f\t\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0003%9xN\u001d3J]\u0012,\u00070F\u0001?!\u0011\u00013EJ \u0011\u0005=\u0001\u0015BA!\u0011\u0005\rIe\u000e\u001e\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002 \u0002\u0015]|'\u000fZ%oI\u0016D\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0015Y,7\r^8s'&TX-F\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u007f\u0005Ya/Z2u_J\u001c\u0016N_3!\u0011\u001dQ\u0005A1A\u0005\n\u0019\u000b\u0001B\\;n/>\u0014Hm\u001d\u0005\u0007\u0019\u0002\u0001\u000b\u0011B \u0002\u00139,XnV8sIN\u0004\u0003b\u0002(\u0001\u0003\u0003\u0006IaT\u0001\u0004q\u0012*\u0004\u0003B\bQSIK!!\u0015\t\u0003\rQ+\b\u000f\\33!\ry!f\u0015\t\u0003\u001fQK!!\u0016\t\u0003\r\u0011{WO\u00197f\u0011\u001d9\u0006A1A\u0005\na\u000b1b^8sIZ+7\r^8sgV\t\u0011\u0006\u0003\u0004[\u0001\u0001\u0006I!K\u0001\ro>\u0014HMV3di>\u00148\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u000319xN\u001d3WK\u000etuN]7t+\u0005\u0011\u0006BB0\u0001A\u0003%!+A\u0007x_J$g+Z2O_Jl7\u000f\t\u0005\u0006C\u0002!IAY\u0001\u0011G>\u001c\u0018N\\3TS6LG.\u0019:jif$2aU2f\u0011\u0015!\u0007\r1\u0001*\u0003\t1\u0018\u0007C\u0003gA\u0002\u0007\u0011&\u0001\u0002we!)\u0001\u000e\u0001C)S\u0006iam\u001c:nCR4VM]:j_:,\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001\\1oO*\tq.\u0001\u0003kCZ\f\u0017B\u0001\u0015m\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0011\u0019\u0018M^3\u0015\u0007Q<X\u0010\u0005\u0002\u0010k&\u0011a\u000f\u0005\u0002\u0005+:LG\u000fC\u0003yc\u0002\u0007\u00110\u0001\u0002tGB\u0011!p_\u0007\u0002\r%\u0011AP\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006}F\u0004\rAJ\u0001\u0005a\u0006$\b\u000eC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA\u0003\u0003#\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017!\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002\u0010\u0005%!A\u0002,fGR|'\u000f\u0003\u0004\u0002\u0014}\u0004\rAJ\u0001\u0005o>\u0014H\rC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002\u0019\u0019Lg\u000eZ*z]>t\u00170\\:\u0015\r\u0005m\u0011qDA\u0011!\u0011y!&!\b\u0011\t=\u0001fe\u0015\u0005\b\u0003'\t)\u00021\u0001'\u0011\u001d\t\u0019#!\u0006A\u0002}\n1A\\;n\u0011\u001d\t9\u0002\u0001C\u0001\u0003O!b!a\u0007\u0002*\u00055\u0002\u0002CA\u0016\u0003K\u0001\r!!\u0002\u0002\rY,7\r^8s\u0011\u001d\t\u0019#!\nA\u0002}Bq!!\r\u0001\t\u0003\t\u0019$\u0001\u0006hKR4Vm\u0019;peN,\u0012a\b\u0015\u0004\u0001\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub!\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u0002<\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011Q\t\u0002\t\u0002\u0005\u001d\u0013!D,pe\u0012\u0014d+Z2N_\u0012,G\u000eE\u00024\u0003\u00132a!\u0001\u0002\t\u0002\u0005-3CBA%\u001d\u00055C\u0003\u0005\u0003\u0019\u0003\u001f\u0012\u0014bAA)3\t1Aj\\1eKJDq\u0001MA%\t\u0003\t)\u0006\u0006\u0002\u0002H\u001dA\u0011\u0011LA%\u0011\u0013\tY&\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007\u0005\u0003\u0002^\u0005}SBAA%\r!\t\t'!\u0013\t\n\u0005\r$\u0001D*bm\u0016du.\u00193Wc}\u00034cAA0\u001d!9\u0001'a\u0018\u0005\u0002\u0005\u001dDCAA.\u0011%\tY'a\u0018C\u0002\u0013\u0005\u0011.A\tg_Jl\u0017\r\u001e,feNLwN\u001c,2?BB\u0001\"a\u001c\u0002`\u0001\u0006IA[\u0001\u0013M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003\u0004\u0005C\u0005\u0002t\u0005}#\u0019!C\u0001S\u0006i1\r\\1tg:\u000bW.\u001a,2?BB\u0001\"a\u001e\u0002`\u0001\u0006IA[\u0001\u000fG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019!\r\u001d\tY(a\u0018A\u0003{\u0012A\u0001R1uCN1\u0011\u0011\u0010\b\u0002\u0000Q\u00012aDAA\u0013\r\t\u0019\t\u0005\u0002\b!J|G-^2u\u0011-\t\u0019\"!\u001f\u0003\u0016\u0004%\t!a\"\u0016\u0003\u0019B!\"a#\u0002z\tE\t\u0015!\u0003'\u0003\u00159xN\u001d3!\u0011)\tY#!\u001f\u0003\u0016\u0004%\t\u0001\u0017\u0005\u000b\u0003#\u000bIH!E!\u0002\u0013I\u0013a\u0002<fGR|'\u000f\t\u0005\ba\u0005eD\u0011AAK)\u0019\t9*a'\u0002\u001eB!\u0011\u0011TA=\u001b\t\ty\u0006C\u0004\u0002\u0014\u0005M\u0005\u0019\u0001\u0014\t\u000f\u0005-\u00121\u0013a\u0001S!Q\u0011\u0011UA=\u0003\u0003%\t!a)\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003/\u000b)+a*\t\u0013\u0005M\u0011q\u0014I\u0001\u0002\u00041\u0003\"CA\u0016\u0003?\u0003\n\u00111\u0001*\u0011)\tY+!\u001f\u0012\u0002\u0013\u0005\u0011QV\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyKK\u0002'\u0003c[#!a-\u0011\t\u0005U\u0016QX\u0007\u0003\u0003oSA!!/\u0002<\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{\u0001\u0012\u0002BA`\u0003o\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\u0019-!\u001f\u0012\u0002\u0013\u0005\u0011QY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9MK\u0002*\u0003cC\u0011\"a3\u0002z\u0005\u0005I\u0011I5\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011%\ty-!\u001f\u0002\u0002\u0013\u0005a)\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0002T\u0006e\u0014\u0011!C\u0001\u0003+\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002X\u0006u\u0007cA\b\u0002Z&\u0019\u00111\u001c\t\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002`\u0006E\u0017\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\t\u0015\u0005\r\u0018\u0011PA\u0001\n\u0003\n)/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u000f\u0005\u0004\u0002j\u0006=\u0018q[\u0007\u0003\u0003WT1!!<\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\fYO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\t)0!\u001f\u0002\u0002\u0013\u0005\u0011q_\u0001\tG\u0006tW)];bYR!\u0011\u0011`A\u0000!\ry\u00111`\u0005\u0004\u0003{\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003?\f\u00190!AA\u0002\u0005]\u0007B\u0003B\u0002\u0003s\n\t\u0011\"\u0011\u0003\u0006\u0005A\u0001.Y:i\u0007>$W\rF\u0001@\u0011)\u0011I!!\u001f\u0002\u0002\u0013\u0005#1B\u0001\ti>\u001cFO]5oOR\t!\u000e\u0003\u0006\u0003\u0010\u0005e\u0014\u0011!C!\u0005#\ta!Z9vC2\u001cH\u0003BA}\u0005'A!\"a8\u0003\u000e\u0005\u0005\t\u0019AAl\u000f)\u00119\"a\u0018\u0002\u0002#\u0005!\u0011D\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0002\u001a\nmaACA>\u0003?\n\t\u0011#\u0001\u0003\u001eM)!1\u0004B\u0010)AA!\u0011\u0005B\u0014M%\n9*\u0004\u0002\u0003$)\u0019!Q\u0005\t\u0002\u000fI,h\u000e^5nK&!!\u0011\u0006B\u0012\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\ba\tmA\u0011\u0001B\u0017)\t\u0011I\u0002\u0003\u0006\u0003\n\tm\u0011\u0011!C#\u0005\u0017A!Ba\r\u0003\u001c\u0005\u0005I\u0011\u0011B\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t9Ja\u000e\u0003:!9\u00111\u0003B\u0019\u0001\u00041\u0003bBA\u0016\u0005c\u0001\r!\u000b\u0005\u000b\u0005{\u0011Y\"!A\u0005\u0002\n}\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0012I\u0005E\u0003\u0010\u0005\u0007\u00129%C\u0002\u0003FA\u0011aa\u00149uS>t\u0007\u0003B\bQM%B!Ba\u0013\u0003<\u0005\u0005\t\u0019AAL\u0003\rAH\u0005\r\u0005\u000b\u0005\u001f\u0012Y\"!A\u0005\n\tE\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0015\u0011\u0007-\u0014)&C\u0002\u0003X1\u0014aa\u00142kK\u000e$\b\u0002\u0003B.\u0003?\"\tA!\u0018\u0002\t1|\u0017\r\u001a\u000b\u0006e\t}#\u0011\r\u0005\u0007q\ne\u0003\u0019A=\t\ry\u0014I\u00061\u0001'\u0011\u001d\u0011\u0018q\fC\u0001\u0005K\"r\u0001\u001eB4\u0005S\u0012Y\u0007\u0003\u0004y\u0005G\u0002\r!\u001f\u0005\u0007}\n\r\u0004\u0019\u0001\u0014\t\ry\u0011\u0019\u00071\u0001 \u0011!\u0011Y&!\u0013\u0005B\t=D#\u0002\u001a\u0003r\tM\u0004B\u0002=\u0003n\u0001\u0007\u0011\u0010\u0003\u0004\u007f\u0005[\u0002\rA\n\u0005\u000b\u0005\u001f\nI%!A\u0005\n\tE\u0003\u0006BA%\u0003oAC!a\u0011\u00028\u0001")
public class Word2VecModel
implements Serializable,
Saveable {
    private final Map<String, float[]> model;
    private final String[] wordList;
    private final Map<String, Object> wordIndex;
    private final int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    private final int numWords;
    private final Tuple2<float[], double[]> x$5;
    private final float[] org$apache$spark$mllib$feature$Word2VecModel$$wordVectors;
    private final double[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    private String[] wordList() {
        return this.wordList;
    }

    private Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    }

    private int numWords() {
        return this.numWords;
    }

    public float[] org$apache$spark$mllib$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors;
    }

    private double[] wordVecNorms() {
        return this.wordVecNorms;
    }

    private double cosineSimilarity(float[] v1, float[] v2) {
        Predef$.MODULE$.require(v1.length == v2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vectors should have the same length";
            }
        });
        int n = v1.length;
        float norm1 = BLAS.getInstance().snrm2(n, v1, 1);
        float norm2 = BLAS.getInstance().snrm2(n, v2, 1);
        if (norm1 == 0.0f || norm2 == 0.0f) {
            return 0.0;
        }
        return BLAS.getInstance().sdot(n, v1, 1, v2, 1) / norm1 / norm2;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.model.get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            float[] vec = (float[])some.x();
            Vector vector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(float x$6) {
                    return this.apply$mcDF$sp(x$6);
                }

                public double apply$mcDF$sp(float x$6) {
                    return x$6;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            return vector;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not in vocabulary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num);
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        Predef$.MODULE$.require(num > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of similar words should > 0";
            }
        });
        float[] fVector = (float[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$7) {
                return this.apply$mcFD$sp(x$7);
            }

            public float apply$mcFD$sp(double x$7) {
                return (float)x$7;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = (float[])Array$.MODULE$.fill(this.numWords(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        float alpha = 1.0f;
        float beta = 0.0f;
        BLAS.getInstance().sgemv("T", this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), this.numWords(), alpha, this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors(), this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), fVector, 1, beta, cosineVec, 1);
        double[] updatedCosines = new double[this.numWords()];
        for (int ind = 0; ind < this.numWords(); ++ind) {
            updatedCosines[ind] = (double)cosineVec[ind] / this.wordVecNorms()[ind];
        }
        return (Tuple2[])((TraversableOnce)((TraversableLike)((IterableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.wordList()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(updatedCosines), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$8) {
                return -x$8._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(num + 1)).tail()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;

            public final Tuple2<String, float[]> apply(Tuple2<String, Object> x0$4) {
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    int ind = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)word, Predef$.MODULE$.floatArrayOps(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors()).slice(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind, this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind + this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Word2VecModel(Map<String, float[]> model) {
        this.model = model;
        this.wordList = (String[])model.keys().toArray(ClassTag$.MODULE$.apply(String.class));
        this.wordIndex = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.wordList()).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), model.size()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize = Predef$.MODULE$.floatArrayOps((float[])((Tuple2)model.head())._2()).size();
        this.numWords = this.wordIndex().size();
        float[] wordVectors = new float[this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * this.numWords()];
        double[] wordVecNorms = new double[this.numWords()];
        for (int i = 0; i < this.numWords(); ++i) {
            float[] vec = (float[])model.get((Object)this.wordList()[i]).get();
            Array$.MODULE$.copy((Object)vec, 0, (Object)wordVectors, i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
            wordVecNorms[i] = BLAS.getInstance().snrm2(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), vec, 1);
        }
        Tuple2 tuple2 = new Tuple2((Object)wordVectors, (Object)wordVecNorms);
        if (tuple2 != null) {
            float[] wordVectors2 = (float[])tuple2._1();
            double[] wordVecNorms2 = (double[])tuple2._2();
            if (wordVectors2 != null) {
                float[] fArray = wordVectors2;
                if (wordVecNorms2 != null) {
                    Tuple2 tuple22;
                    double[] dArray = wordVecNorms2;
                    this.x$5 = tuple22 = new Tuple2((Object)fArray, (Object)dArray);
                    this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors = (float[])this.x$5._1();
                    this.wordVecNorms = (double[])this.x$5._2();
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }
}

