/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u00111DQ5oCJL8\t\\1tg&4\u0017nY1uS>tW*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!a\u0002'pO\u001eLgn\u001a\u0005\t3\u0001\u0011)\u0019!C\u00015\u0005q1oY8sK\u0006sG\rT1cK2\u001cX#A\u000e\u0011\u0007qy\u0012%D\u0001\u001e\u0015\tqb!A\u0002sI\u0012L!\u0001I\u000f\u0003\u0007I#E\t\u0005\u0003\u0010E\u0011\"\u0013BA\u0012\u0011\u0005\u0019!V\u000f\u001d7feA\u0011q\"J\u0005\u0003MA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u001fM\u001cwN]3B]\u0012d\u0015MY3mg\u0002B\u0001B\u000b\u0001\u0003\u0006\u0004%\taK\u0001\b]Vl')\u001b8t+\u0005a\u0003CA\b.\u0013\tq\u0003CA\u0002J]RD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\t]Vl')\u001b8tA!)!\u0007\u0001C\u0001g\u00051A(\u001b8jiz\"2\u0001\u000e\u001c8!\t)\u0004!D\u0001\u0003\u0011\u0015I\u0012\u00071\u0001\u001c\u0011\u0015Q\u0013\u00071\u0001-\u0011\u0015\u0011\u0004\u0001\"\u0001:)\t!$\bC\u0003\u001aq\u0001\u00071\u0004\u0003\u00043\u0001\u0011\u0005A\u0001\u0010\u000b\u0003iuBQ!G\u001eA\u0002y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0004\u0002\u0007M\fH.\u0003\u0002D\u0001\nIA)\u0019;b\rJ\fW.\u001a\u0005\u0006\u000b\u0002!\tAR\u0001\nk:\u0004XM]:jgR$\u0012a\u0012\t\u0003\u001f!K!!\u0013\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u000bi\"\u0014Xm\u001d5pY\u0012\u001cH#A'\u0011\u0007qyB\u0005C\u0003P\u0001\u0011\u0005\u0001+A\u0002s_\u000e$\u0012a\u0007\u0005\u0006%\u0002!\taU\u0001\rCJ,\u0017-\u00168eKJ\u0014vj\u0011\u000b\u0002I!)Q\u000b\u0001C\u0001!\u0006\u0011\u0001O\u001d\u0005\u0006/\u0002!\taU\u0001\fCJ,\u0017-\u00168eKJ\u0004&\u000bC\u0003Z\u0001\u0011\u0005!,A\ng\u001b\u0016\f7/\u001e:f\u0005f$\u0006N]3tQ>dG\r\u0006\u0002\u001c7\")A\f\u0017a\u0001I\u0005!!-\u001a;b\u0011\u0015I\u0006\u0001\"\u0001Q\u0011\u0015y\u0006\u0001\"\u0001Q\u0003Q\u0001(/Z2jg&|gNQ=UQJ,7\u000f[8mI\")\u0011\r\u0001C\u0001!\u0006\t\"/Z2bY2\u0014\u0015\u0010\u00165sKNDw\u000e\u001c3\t\u0011\r\u0004\u0001r1Q\u0005\n\u0011\f1\u0001\u001f\u00135+\u0005)\u0007\u0003B\b#M:\u00042\u0001H\u0010h!\u0011y!\u0005\n5\u0011\u0005%dW\"\u00016\u000b\u0005-\u0014\u0011A\u00022j]\u0006\u0014\u00180\u0003\u0002nU\n\u0011\")\u001b8befd\u0015MY3m\u0007>,h\u000e^3s!\rard\u001c\t\u0005\u001f\t\"\u0003\u000f\u0005\u0002jc&\u0011!O\u001b\u0002\u0016\u0005&t\u0017M]=D_:4Wo]5p]6\u000bGO]5y\u0011!!\b\u0001#A!B\u0013)\u0017\u0001\u0002=%i\u0001B\u0001B\u001e\u0001\t\u0006\u0004%Ia^\u0001\u0011GVlW\u000f\\1uSZ,7i\\;oiN,\u0012A\u001a\u0005\ts\u0002A\t\u0011)Q\u0005M\u0006\t2-^7vY\u0006$\u0018N^3D_VtGo\u001d\u0011\t\u0011m\u0004\u0001R1A\u0005\nq\f!bY8oMV\u001c\u0018n\u001c8t+\u0005q\u0007\u0002\u0003@\u0001\u0011\u0003\u0005\u000b\u0015\u00028\u0002\u0017\r|gNZ;tS>t7\u000f\t\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003-\u0019'/Z1uK\u000e+(O^3\u0015\u0007m\t)\u0001C\u0004\u0002\b}\u0004\r!!\u0003\u0002\u0003e\u00042![A\u0006\u0013\r\tiA\u001b\u0002#\u0005&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8NKR\u0014\u0018nY\"p[B,H/\u001a:\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0012Q)1$a\u0005\u0002\u0018!A\u0011QCA\b\u0001\u0004\tI!A\u0001y\u0011!\t9!a\u0004A\u0002\u0005%\u0001f\u0001\u0001\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\b\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public class BinaryClassificationMetrics
implements Logging {
    private final RDD<Tuple2<Object, Object>> scoreAndLabels;
    private final int numBins;
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$4;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$4$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                RDD rDD;
                OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.scoreAndLabels(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1)new $anonfun$2(this), (Function2)new $anonfun$3(this), (Function2)new $anonfun$4(this)), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                boolean x$5 = false;
                int x$6 = qual$1.sortByKey$default$2();
                RDD counts = qual$1.sortByKey(x$5, x$6);
                if (this.numBins() == 0) {
                    rDD = counts;
                } else {
                    long countsSize = counts.count();
                    LongRef grouping = new LongRef(countsSize / (long)this.numBins());
                    if (grouping.elem < 2L) {
                        this.logInfo((Function0<String>)new $anonfun$5(this, countsSize));
                        rDD = counts;
                    } else {
                        if (grouping.elem >= Integer.MAX_VALUE) {
                            this.logWarning((Function0<String>)new $anonfun$6(this, countsSize));
                            grouping.elem = Integer.MAX_VALUE;
                        }
                        rDD = counts.mapPartitions((Function1)new $anonfun$7(this, grouping), counts.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                }
                RDD binnedCounts = rDD;
                RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(binnedCounts, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.Double$.MODULE$).values();
                $anonfun$8 x$7 = new $anonfun$8(this);
                boolean x$8 = qual$2.mapPartitions$default$2();
                BinaryLabelCounter[] agg = (BinaryLabelCounter[])qual$2.mapPartitions((Function1)x$7, x$8, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])Predef$.MODULE$.refArrayOps((Object[])agg).scanLeft((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryLabelCounter.class)));
                BinaryLabelCounter totalCount = (BinaryLabelCounter)Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts).last();
                this.logInfo((Function0<String>)new $anonfun$10(this, totalCount));
                RDD cumulativeCounts = binnedCounts.mapPartitionsWithIndex((Function2)new $anonfun$11(this, partitionwiseCumulativeCounts), true, ClassTag$.MODULE$.apply(Tuple2.class));
                cumulativeCounts.persist();
                RDD confusions2 = cumulativeCounts.map((Function1)new $anonfun$12(this, totalCount), ClassTag$.MODULE$.apply(Tuple2.class));
                Tuple2 tuple22 = new Tuple2((Object)cumulativeCounts, (Object)confusions2);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                RDD cumulativeCounts2 = (RDD)tuple22._1();
                RDD confusions3 = (RDD)tuple22._2();
                if (cumulativeCounts2 == null) throw new MatchError((Object)tuple22);
                RDD rDD2 = cumulativeCounts2;
                if (confusions3 == null) throw new MatchError((Object)tuple22);
                RDD rDD3 = confusions3;
                this.x$4 = tuple2 = new Tuple2((Object)rDD2, (Object)rDD3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$4;
        }
    }

    private RDD cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$4()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.cumulativeCounts;
        }
    }

    private RDD confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$4()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.confusions;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Tuple2<Object, Object>> scoreAndLabels() {
        return this.scoreAndLabels;
    }

    public int numBins() {
        return this.numBins;
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, BinaryLabelCounter> x$1) {
                return x$1._1$mcD$sp();
            }
        }, ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD last = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return new UnionRDD(sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{first, rocCurve, last})), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return first.union(prCurve);
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$4() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$4$lzycompute() : this.x$4;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cumulativeCounts$lzycompute() : this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer y$2;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$3) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$3;
                if (tuple2 != null) {
                    double s = tuple2._1$mcD$sp();
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(s, this.y$2.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.y$2 = y$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, x, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer x$9;
            private final BinaryClassificationMetricComputer y$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$4) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$4;
                if (tuple2 != null) {
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(this.x$9.apply(c), this.y$1.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x$9 = x$9;
                this.y$1 = y$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels, int numBins) {
        this.scoreAndLabels = scoreAndLabels;
        this.numBins = numBins;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(numBins >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "numBins must be nonnegative";
            }
        });
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this(scoreAndLabels, 0);
    }

    public BinaryClassificationMetrics(DataFrame scoreAndLabels) {
        this((RDD<Tuple2<Object, Object>>)scoreAndLabels.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

