/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t\re\u0001B\u0001\u0003\u00015\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0005kRLG.\u0003\u0002\u001d3\tA1+\u0019<fC\ndW\r\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003\u001d9X-[4iiN,\u0012\u0001\t\t\u0004\u001f\u0005\u001a\u0013B\u0001\u0012\u0011\u0005\u0015\t%O]1z!\tyA%\u0003\u0002&!\t1Ai\\;cY\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\to\u0016Lw\r\u001b;tA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0005hCV\u001c8/[1ogV\t1\u0006E\u0002\u0010C1\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005E\"\u0011\u0001B:uCRL!a\r\u0018\u0003)5+H\u000e^5wCJL\u0017\r^3HCV\u001c8/[1o\u0011!)\u0004A!A!\u0002\u0013Y\u0013AC4bkN\u001c\u0018.\u00198tA!)q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"2!O\u001e=!\tQ\u0004!D\u0001\u0003\u0011\u0015qb\u00071\u0001!\u0011\u0015Ic\u00071\u0001,\u0011\u0015q\u0004\u0001\"\u0015@\u000351wN]7biZ+'o]5p]V\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!A.\u00198h\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\rM#(/\u001b8h\u0011\u0015I\u0005\u0001\"\u0011K\u0003\u0011\u0019\u0018M^3\u0015\u0007-sE\u000b\u0005\u0002\u0010\u0019&\u0011Q\n\u0005\u0002\u0005+:LG\u000fC\u0003P\u0011\u0002\u0007\u0001+\u0001\u0002tGB\u0011\u0011KU\u0007\u0002\r%\u00111K\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006+\"\u0003\rAV\u0001\u0005a\u0006$\b\u000e\u0005\u0002X5:\u0011q\u0002W\u0005\u00033B\ta\u0001\u0015:fI\u00164\u0017BA$\\\u0015\tI\u0006\u0003C\u0003^\u0001\u0011\u0005a,A\u0001l+\u0005y\u0006CA\ba\u0013\t\t\u0007CA\u0002J]RDQa\u0019\u0001\u0005\u0002\u0011\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002fWB\u0019a-[0\u000e\u0003\u001dT!\u0001\u001b\u0004\u0002\u0007I$G-\u0003\u0002kO\n\u0019!\u000b\u0012#\t\u000b1\u0014\u0007\u0019A7\u0002\rA|\u0017N\u001c;t!\r1\u0017N\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0012\ta\u0001\\5oC2<\u0017BA:q\u0005\u00191Vm\u0019;pe\")Q\u000f\u0001C\u0001m\u0006Y\u0001O]3eS\u000e$8k\u001c4u)\t9\b\u0010E\u0002gS\u0002BQ\u0001\u001c;A\u00025DQA\u001f\u0001\u0005\nm\facY8naV$XmU8gi\u0006\u001b8/[4o[\u0016tGo\u001d\u000b\tAq\fY!a\u0004\u0002\u0012!)Q0\u001fa\u0001}\u0006\u0011\u0001\u000f\u001e\t\u0005\u007f\u0006\u001d1%\u0004\u0002\u0002\u0002)\u0019\u0011/a\u0001\u000b\u0005\u0005\u0015\u0011A\u00022sK\u0016TX-\u0003\u0003\u0002\n\u0005\u0005!a\u0003#f]N,g+Z2u_JDa!!\u0004z\u0001\u0004Y\u0013!\u00023jgR\u001c\b\"\u0002\u0010z\u0001\u0004\u0001\u0003\"B/z\u0001\u0004y\u0006f\u0001\u0001\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty\"!\u0007\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005\r\"\u0001#\u0001\u0002&\u0005!r)Y;tg&\fg.T5yiV\u0014X-T8eK2\u00042AOA\u0014\r\u0019\t!\u0001#\u0001\u0002*M1\u0011q\u0005\b\u0002,Q\u0001B\u0001GA\u0017s%\u0019\u0011qF\r\u0003\r1{\u0017\rZ3s\u0011\u001d9\u0014q\u0005C\u0001\u0003g!\"!!\n\b\u0011\u0005]\u0012q\u0005E\u0005\u0003s\tAbU1wK2{\u0017\r\u001a,2?B\u0002B!a\u000f\u0002>5\u0011\u0011q\u0005\u0004\t\u0003\u007f\t9\u0003#\u0003\u0002B\ta1+\u0019<f\u0019>\fGMV\u0019`aM\u0019\u0011Q\b\b\t\u000f]\ni\u0004\"\u0001\u0002FQ\u0011\u0011\u0011\b\u0004\b\u0003\u0013\ni\u0004QA&\u0005\u0011!\u0015\r^1\u0014\r\u0005\u001dc\"!\u0014\u0015!\ry\u0011qJ\u0005\u0004\u0003#\u0002\"a\u0002)s_\u0012,8\r\u001e\u0005\f\u0003+\n9E!f\u0001\n\u0003\t9&\u0001\u0004xK&<\u0007\u000e^\u000b\u0002G!Q\u00111LA$\u0005#\u0005\u000b\u0011B\u0012\u0002\u000f],\u0017n\u001a5uA!Y\u0011qLA$\u0005+\u0007I\u0011AA1\u0003\tiW/F\u0001o\u0011)\t)'a\u0012\u0003\u0012\u0003\u0006IA\\\u0001\u0004[V\u0004\u0003bCA5\u0003\u000f\u0012)\u001a!C\u0001\u0003W\nQa]5h[\u0006,\"!!\u001c\u0011\u0007=\fy'C\u0002\u0002rA\u0014a!T1ue&D\bbCA;\u0003\u000f\u0012\t\u0012)A\u0005\u0003[\naa]5h[\u0006\u0004\u0003bB\u001c\u0002H\u0011\u0005\u0011\u0011\u0010\u000b\t\u0003w\ny(!!\u0002\u0004B!\u0011QPA$\u001b\t\ti\u0004C\u0004\u0002V\u0005]\u0004\u0019A\u0012\t\u000f\u0005}\u0013q\u000fa\u0001]\"A\u0011\u0011NA<\u0001\u0004\ti\u0007\u0003\u0006\u0002\b\u0006\u001d\u0013\u0011!C\u0001\u0003\u0013\u000bAaY8qsRA\u00111PAF\u0003\u001b\u000by\tC\u0005\u0002V\u0005\u0015\u0005\u0013!a\u0001G!I\u0011qLAC!\u0003\u0005\rA\u001c\u0005\u000b\u0003S\n)\t%AA\u0002\u00055\u0004BCAJ\u0003\u000f\n\n\u0011\"\u0001\u0002\u0016\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAALU\r\u0019\u0013\u0011T\u0016\u0003\u00037\u0003B!!(\u0002&6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0004\t\n\t\u0005\u001d\u0016q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAV\u0003\u000f\n\n\u0011\"\u0001\u0002.\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAXU\rq\u0017\u0011\u0014\u0005\u000b\u0003g\u000b9%%A\u0005\u0002\u0005U\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003oSC!!\u001c\u0002\u001a\"I\u00111XA$\u0003\u0003%\teP\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0013\u0005}\u0016qIA\u0001\n\u0003q\u0016\u0001\u00049s_\u0012,8\r^!sSRL\bBCAb\u0003\u000f\n\t\u0011\"\u0001\u0002F\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAd\u0003\u001b\u00042aDAe\u0013\r\tY\r\u0005\u0002\u0004\u0003:L\b\"CAh\u0003\u0003\f\t\u00111\u0001`\u0003\rAH%\r\u0005\u000b\u0003'\f9%!A\u0005B\u0005U\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0007CBAm\u0003?\f9-\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0006m'\u0001C%uKJ\fGo\u001c:\t\u0015\u0005\u0015\u0018qIA\u0001\n\u0003\t9/\u0001\u0005dC:,\u0015/^1m)\u0011\tI/a<\u0011\u0007=\tY/C\u0002\u0002nB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002P\u0006\r\u0018\u0011!a\u0001\u0003\u000fD!\"a=\u0002H\u0005\u0005I\u0011IA{\u0003!A\u0017m\u001d5D_\u0012,G#A0\t\u0015\u0005e\u0018qIA\u0001\n\u0003\nY0\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0005BCA\u0000\u0003\u000f\n\t\u0011\"\u0011\u0003\u0002\u00051Q-];bYN$B!!;\u0003\u0004!Q\u0011qZA\u007f\u0003\u0003\u0005\r!a2\b\u0015\t\u001d\u0011QHA\u0001\u0012\u0003\u0011I!\u0001\u0003ECR\f\u0007\u0003BA?\u0005\u00171!\"!\u0013\u0002>\u0005\u0005\t\u0012\u0001B\u0007'\u0015\u0011YAa\u0004\u0015!)\u0011\tBa\u0006$]\u00065\u00141P\u0007\u0003\u0005'Q1A!\u0006\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0007\u0003\u0014\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f]\u0012Y\u0001\"\u0001\u0003\u001eQ\u0011!\u0011\u0002\u0005\u000b\u0003s\u0014Y!!A\u0005F\u0005m\bB\u0003B\u0012\u0005\u0017\t\t\u0011\"!\u0003&\u0005)\u0011\r\u001d9msRA\u00111\u0010B\u0014\u0005S\u0011Y\u0003C\u0004\u0002V\t\u0005\u0002\u0019A\u0012\t\u000f\u0005}#\u0011\u0005a\u0001]\"A\u0011\u0011\u000eB\u0011\u0001\u0004\ti\u0007\u0003\u0006\u00030\t-\u0011\u0011!CA\u0005c\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00034\t}\u0002#B\b\u00036\te\u0012b\u0001B\u001c!\t1q\n\u001d;j_:\u0004ra\u0004B\u001eG9\fi'C\u0002\u0003>A\u0011a\u0001V;qY\u0016\u001c\u0004B\u0003B!\u0005[\t\t\u00111\u0001\u0002|\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u0015#1BA\u0001\n\u0013\u00119%A\u0006sK\u0006$'+Z:pYZ,GC\u0001B%!\r\t%1J\u0005\u0004\u0005\u001b\u0012%AB(cU\u0016\u001cG\u000fC\u0005\u0003R\u0005u\"\u0019!C\u0001\u007f\u0005\tbm\u001c:nCR4VM]:j_:4\u0016g\u0018\u0019\t\u0011\tU\u0013Q\bQ\u0001\n\u0001\u000b!CZ8s[\u0006$h+\u001a:tS>tg+M01A!I!\u0011LA\u001f\u0005\u0004%\taP\u0001\u000eG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019\t\u0011\tu\u0013Q\bQ\u0001\n\u0001\u000bab\u00197bgNt\u0015-\\3Wc}\u0003\u0004\u0005C\u0004J\u0003{!\tA!\u0019\u0015\u0013-\u0013\u0019G!\u001a\u0003h\t%\u0004BB(\u0003`\u0001\u0007\u0001\u000b\u0003\u0004V\u0005?\u0002\rA\u0016\u0005\u0007=\t}\u0003\u0019\u0001\u0011\t\r%\u0012y\u00061\u0001,\u0011!\u0011i'!\u0010\u0005\u0002\t=\u0014\u0001\u00027pC\u0012$R!\u000fB9\u0005gBaa\u0014B6\u0001\u0004\u0001\u0006BB+\u0003l\u0001\u0007a\u000b\u0003\u0005\u0003n\u0005\u001dB\u0011\tB<)\u0015I$\u0011\u0010B>\u0011\u0019y%Q\u000fa\u0001!\"1QK!\u001eA\u0002YC!B!\u0012\u0002(\u0005\u0005I\u0011\u0002B$Q\u0011\t9#!\u0006)\t\u0005\u0005\u0012Q\u0003")
public class GaussianMixtureModel
implements Serializable,
Saveable {
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;

    public static GaussianMixtureModel load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        GaussianMixtureModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.weights(), this.gaussians());
    }

    public int k() {
        return this.weights().length;
    }

    public RDD<Object> predict(RDD<Vector> points) {
        RDD<double[]> responsibilityMatrix = this.predictSoft(points);
        return responsibilityMatrix.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(double[] r) {
                return Predef$.MODULE$.doubleArrayOps(r).indexOf(Predef$.MODULE$.doubleArrayOps(r).max((Ordering)Ordering.Double$.MODULE$));
            }
        }, ClassTag$.MODULE$.Int());
    }

    public RDD<double[]> predictSoft(RDD<Vector> points) {
        SparkContext sc = points.sparkContext();
        Broadcast bcDists = sc.broadcast((Object)this.gaussians(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MultivariateGaussian.class)));
        Broadcast bcWeights = sc.broadcast((Object)this.weights(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return points.map((Function1)new Serializable(this, bcDists, bcWeights){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureModel $outer;
            private final Broadcast bcDists$1;
            private final Broadcast bcWeights$1;

            public final double[] apply(Vector x) {
                return this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureModel$$computeSoftAssignments((DenseVector<Object>)x.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), (MultivariateGaussian[])this.bcDists$1.value(), (double[])this.bcWeights$1.value(), this.$outer.k());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcDists$1 = bcDists$1;
                this.bcWeights$1 = bcWeights$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] org$apache$spark$mllib$clustering$GaussianMixtureModel$$computeSoftAssignments(DenseVector<Object> pt, MultivariateGaussian[] dists, double[] weights, int k) {
        double[] p = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(weights).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, pt){
            public static final long serialVersionUID = 0L;
            private final DenseVector pt$1;

            public final double apply(Tuple2<Object, MultivariateGaussian> x0$1) {
                Tuple2<Object, MultivariateGaussian> tuple2 = x0$1;
                if (tuple2 != null) {
                    double weight = tuple2._1$mcD$sp();
                    MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
                    double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((breeze.linalg.Vector<Object>)this.pt$1);
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pt$1 = pt$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(p).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)new Serializable(this, p, pSum){
            public static final long serialVersionUID = 0L;
            private final double[] p$1;
            private final double pSum$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.p$1[i] = this.p$1[i] / this.pSum$1;
            }
            {
                this.p$1 = p$1;
                this.pSum$1 = pSum$1;
            }
        });
        return p;
    }

    public GaussianMixtureModel(double[] weights, MultivariateGaussian[] gaussians) {
        this.weights = weights;
        this.gaussians = gaussians;
        Predef$.MODULE$.require(weights.length == gaussians.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Length of weight and Gaussian arrays must match";
            }
        });
    }
}

