/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecBase$class;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\tiqk\u001c:eeY+7-T8eK2T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!B'pI\u0016d\u0007CA\n\u0001\u001b\u0005\u0011\u0001CA\n\u0016\u0013\t1\"A\u0001\u0007X_J$'GV3d\u0005\u0006\u001cX\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0011\u001a\u0003\r)\u0018\u000eZ\u000b\u00025A\u00111$\t\b\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%H\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!;!AQ\u0005\u0001B\u0001B\u0003%!$\u0001\u0003vS\u0012\u0004\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0017]|'\u000f\u001a,fGR|'o\u001d\t\u0003S5j\u0011A\u000b\u0006\u0003\u0007-R!\u0001\f\u0004\u0002\u000b5dG.\u001b2\n\u0005\u0005Q\u0003BB\u0018\u0001\t\u0003!\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0004%E\u0012\u0004\"\u0002\r/\u0001\u0004Q\u0002\"B\u0014/\u0001\u0004A\u0003\"\u0002\u001b\u0001\t\u0003)\u0014aC:fi&s\u0007/\u001e;D_2$\"AN\u001c\u000e\u0003\u0001AQ\u0001O\u001aA\u0002i\tQA^1mk\u0016DQA\u000f\u0001\u0005\u0002m\nAb]3u\u001fV$\b/\u001e;D_2$\"A\u000e\u001f\t\u000baJ\u0004\u0019\u0001\u000e\t\u000by\u0002A\u0011I \u0002\u0013Q\u0014\u0018M\\:g_JlGC\u0001!G!\t\tE)D\u0001C\u0015\t\u0019e!A\u0002tc2L!!\u0012\"\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B$>\u0001\u0004\u0001\u0015a\u00023bi\u0006\u001cX\r\u001e\u0005\u0006\u0013\u0002!\tES\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\n\u000bQ\u0001^=qKNL!\u0001U'\u0003\u0015M#(/^2u)f\u0004X\rC\u0003S\u0011\u0002\u00071*\u0001\u0004tG\",W.\u0019\u0015\u0003\u0001Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Z-\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase {
    private final String uid;
    private final org.apache.spark.mllib.feature.Word2VecModel wordVectors;
    private final IntParam vectorSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase$class.getVectorSize(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase$class.getNumPartitions(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase$class.getMinCount(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema(), true);
        Broadcast bWordVectors = dataset.sqlContext().sparkContext().broadcast((Object)this.wordVectors, ClassTag$.MODULE$.apply(org.apache.spark.mllib.feature.Word2VecModel.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$)})));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        UserDefinedFunction word2Vec = functions$.MODULE$.udf((Function1)new Serializable(this, bWordVectors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;
            public final Broadcast bWordVectors$1;

            /*
             * WARNING - void declaration
             */
            public final Vector apply(Seq<String> sentence) {
                Vector vector;
                if (sentence.size() == 0) {
                    vector = Vectors$.MODULE$.sparse(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.vectorSize())), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                } else {
                    void var2_2;
                    Vector cum = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.vectorSize())));
                    Map<String, float[]> model = ((org.apache.spark.mllib.feature.Word2VecModel)this.bWordVectors$1.value()).getVectors();
                    sentence.foreach((Function1)new Serializable(this, cum, model){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;
                        private final Vector cum$1;
                        private final Map model$1;

                        public final void apply(String word) {
                            if (this.model$1.contains((Object)word)) {
                                BLAS$.MODULE$.axpy(1.0, ((org.apache.spark.mllib.feature.Word2VecModel)this.$outer.bWordVectors$1.value()).transform(word), this.cum$1);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.cum$1 = cum$1;
                            this.model$1 = model$1;
                        }
                    });
                    BLAS$.MODULE$.scal(1.0 / (double)sentence.size(), cum);
                    vector = var2_2;
                }
                return vector;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bWordVectors$1 = bWordVectors$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(this)));
        return dataset.withColumn(this.$(this.outputCol()), word2Vec.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.wordVectors = wordVectors;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        HasSeed$class.$init$(this);
        Word2VecBase$class.$init$(this);
    }
}

