/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.VectorIndexerModel$;
import org.apache.spark.ml.feature.VectorIndexerParams;
import org.apache.spark.ml.feature.VectorIndexerParams$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u0011!CV3di>\u0014\u0018J\u001c3fq\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003E\u0002\u0010!Ii\u0011\u0001B\u0005\u0003#\u0011\u0011Q!T8eK2\u0004\"a\u0005\u0001\u000e\u0003\t\u0001\"aE\u000b\n\u0005Y\u0011!a\u0005,fGR|'/\u00138eKb,'\u000fU1sC6\u001c\b\u0002\u0003\r\u0001\u0005\u000b\u0007I\u0011I\r\u0002\u0007ULG-F\u0001\u001b!\tY\u0012E\u0004\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001S$\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\u001e\u0011!)\u0003A!A!\u0002\u0013Q\u0012\u0001B;jI\u0002B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001K\u0001\f]Vlg)Z1ukJ,7/F\u0001*!\ta\"&\u0003\u0002,;\t\u0019\u0011J\u001c;\t\u00115\u0002!\u0011!Q\u0001\n%\nAB\\;n\r\u0016\fG/\u001e:fg\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\rG\u0006$XmZ8ss6\u000b\u0007o]\u000b\u0002cA!1DM\u00155\u0013\t\u00194EA\u0002NCB\u0004Ba\u0007\u001a6SA\u0011ADN\u0005\u0003ou\u0011a\u0001R8vE2,\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u001b\r\fG/Z4pefl\u0015\r]:!\u0011\u0019Y\u0004\u0001\"\u0001\u0005y\u00051A(\u001b8jiz\"BAE\u001f?\u007f!)\u0001D\u000fa\u00015!)qE\u000fa\u0001S!)qF\u000fa\u0001c!)\u0011\t\u0001C\u0001\u0005\u0006\u0001\".\u0019<b\u0007\u0006$XmZ8ss6\u000b\u0007o]\u000b\u0002\u0007B!A)\u0013&Q\u001b\u0005)%B\u0001$H\u0003\u0011)H/\u001b7\u000b\u0003!\u000bAA[1wC&\u00111'\u0012\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u001e\u000bA\u0001\\1oO&\u0011q\n\u0014\u0002\b\u0013:$XmZ3s!\u0011!\u0015*\u0015&\u0011\u0005-\u0013\u0016BA\u001cM\u0011\u001d!\u0006A1A\u0005\nU\u000b\u0001\u0004]1si&\fGNR3biV\u0014X-\u0011;ue&\u0014W\u000f^3t+\u00051\u0006c\u0001\u000fX3&\u0011\u0001,\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00035vk\u0011a\u0017\u0006\u00039\u0012\t\u0011\"\u0019;ue&\u0014W\u000f^3\n\u0005y[&!C!uiJL'-\u001e;f\u0011\u0019\u0001\u0007\u0001)A\u0005-\u0006I\u0002/\u0019:uS\u0006dg)Z1ukJ,\u0017\t\u001e;sS\n,H/Z:!\u0011\u001d\u0011\u0007A1A\u0005\n\r\fQ\u0002\u001e:b]N4wN]7Gk:\u001cW#\u00013\u0011\tq)wmZ\u0005\u0003Mv\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017A\u00027j]\u0006dwM\u0003\u0002m\r\u0005)Q\u000e\u001c7jE&\u0011a.\u001b\u0002\u0007-\u0016\u001cGo\u001c:\t\rA\u0004\u0001\u0015!\u0003e\u00039!(/\u00198tM>\u0014XNR;oG\u0002BQA\u001d\u0001\u0005\u0002M\f1b]3u\u0013:\u0004X\u000f^\"pYR\u0011A/^\u0007\u0002\u0001!)a/\u001da\u00015\u0005)a/\u00197vK\")\u0001\u0010\u0001C\u0001s\u0006a1/\u001a;PkR\u0004X\u000f^\"pYR\u0011AO\u001f\u0005\u0006m^\u0004\rA\u0007\u0005\u0006y\u0002!\t%`\u0001\niJ\fgn\u001d4pe6$2A`A\u0005!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u000f\t\tAA\u0005ECR\fgI]1nK\"1\u00111B>A\u0002y\fq\u0001Z1uCN,G\u000fC\u0004\u0002\u0010\u0001!\t%!\u0005\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a\u0005\u0002 A!\u0011QCA\u000e\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005\u0005\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u000f\u0003/\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\t\t#!\u0004A\u0002\u0005M\u0011AB:dQ\u0016l\u0017\rC\u0004\u0002&\u0001!I!a\n\u0002\u001fA\u0014X\r](viB,HOR5fY\u0012$B!!\u000b\u00020A!\u0011QCA\u0016\u0013\u0011\ti#a\u0006\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\t\u0003C\t\u0019\u00031\u0001\u0002\u0014!\u001a\u0001!a\r\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\t9D\u0001\u0007FqB,'/[7f]R\fG\u000e")
public class VectorIndexerModel
extends Model<VectorIndexerModel>
implements VectorIndexerParams {
    private final String uid;
    private final int numFeatures;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, Object>> categoryMaps;
    private final Attribute[] partialFeatureAttributes;
    private final Function1<Vector, Vector> transformFunc;
    private final IntParam maxCategories;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public IntParam maxCategories() {
        return this.maxCategories;
    }

    @Override
    public void org$apache$spark$ml$feature$VectorIndexerParams$_setter_$maxCategories_$eq(IntParam x$1) {
        this.maxCategories = x$1;
    }

    @Override
    public int getMaxCategories() {
        return VectorIndexerParams$class.getMaxCategories(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, Object>> categoryMaps() {
        return this.categoryMaps;
    }

    public java.util.Map<Integer, java.util.Map<Double, Integer>> javaCategoryMaps() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.categoryMaps().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> x$4) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(x$4).asJava();
            }
        })).asJava();
    }

    private Attribute[] partialFeatureAttributes() {
        return this.partialFeatureAttributes;
    }

    private Function1<Vector, Vector> transformFunc() {
        return this.transformFunc;
    }

    public VectorIndexerModel setInputCol(String value) {
        return (VectorIndexerModel)this.set(this.inputCol(), value);
    }

    public VectorIndexerModel setOutputCol(String value) {
        return (VectorIndexerModel)this.set(this.outputCol(), value);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema(), true);
        StructField newField = this.prepOutputField(dataset.schema());
        Column newCol = functions$.MODULE$.callUDF(this.transformFunc(), (DataType)new VectorUDT(), dataset.apply(this.$(this.inputCol())));
        return dataset.withColumn(this.$(this.outputCol()), newCol.as(this.$(this.outputCol()), newField.metadata()));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        VectorUDT dataType = new VectorUDT();
        Predef$.MODULE$.require(this.isDefined(this.inputCol()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerModel $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VectorIndexerModel requires input column parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputCol()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.isDefined(this.outputCol()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerModel $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VectorIndexerModel requires output column parameter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outputCol()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.inputCol()), (DataType)dataType);
        AttributeGroup origAttrGroup = AttributeGroup$.MODULE$.fromStructField(schema.apply(this.$(this.inputCol())));
        Some origNumFeatures = origAttrGroup.attributes().nonEmpty() ? new Some((Object)BoxesRunTime.boxToInteger((int)((Attribute[])origAttrGroup.attributes().get()).length)) : origAttrGroup.numAttributes();
        Predef$.MODULE$.require(origNumFeatures.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerModel $outer;

            public final boolean apply(int x$8) {
                return this.apply$mcZI$sp(x$8);
            }

            public boolean apply$mcZI$sp(int x$8) {
                return x$8 == this.$outer.numFeatures();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0)new Serializable(this, origAttrGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerModel $outer;
            private final AttributeGroup origAttrGroup$1;

            public final String apply() {
                return new StringBuilder().append((Object)"VectorIndexerModel expected").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " features, but input column ", " had metadata specifying"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numFeatures()), this.$outer.$(this.$outer.inputCol())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " features."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.origAttrGroup$1.numAttributes().get()}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.origAttrGroup$1 = origAttrGroup$1;
            }
        });
        StructField newField = this.prepOutputField(schema);
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).$colon$plus((Object)newField, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    private StructField prepOutputField(StructType schema) {
        Attribute[] attributeArray;
        AttributeGroup origAttrGroup = AttributeGroup$.MODULE$.fromStructField(schema.apply(this.$(this.inputCol())));
        if (origAttrGroup.attributes().nonEmpty()) {
            Attribute[] origAttrs = (Attribute[])origAttrGroup.attributes().get();
            attributeArray = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])origAttrs).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.partialFeatureAttributes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Attribute apply(Tuple2<Attribute, Attribute> x0$5) {
                    Tuple2<Attribute, Attribute> tuple2;
                    block6: {
                        Attribute attribute;
                        block3: {
                            Attribute attribute2;
                            Attribute origAttr;
                            block5: {
                                block4: {
                                    block2: {
                                        tuple2 = x0$5;
                                        if (tuple2 == null) break block2;
                                        Attribute origAttr2 = (Attribute)tuple2._1();
                                        Attribute featAttr = (Attribute)tuple2._2();
                                        if (origAttr2 == null) break block2;
                                        Attribute attribute3 = origAttr2;
                                        if (!(featAttr instanceof BinaryAttribute)) break block2;
                                        BinaryAttribute binaryAttribute = (BinaryAttribute)featAttr;
                                        attribute = attribute3.name().nonEmpty() ? binaryAttribute.withName((String)attribute3.name().get()) : binaryAttribute;
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    Attribute origAttr3 = (Attribute)tuple2._1();
                                    Attribute featAttr = (Attribute)tuple2._2();
                                    if (origAttr3 == null) break block4;
                                    Attribute attribute4 = origAttr3;
                                    if (!(featAttr instanceof NominalAttribute)) break block4;
                                    NominalAttribute nominalAttribute = (NominalAttribute)featAttr;
                                    attribute = attribute4.name().nonEmpty() ? nominalAttribute.withName((String)attribute4.name().get()) : nominalAttribute;
                                    break block3;
                                }
                                if (tuple2 == null) break block5;
                                Attribute origAttr4 = (Attribute)tuple2._1();
                                Attribute featAttr = (Attribute)tuple2._2();
                                if (origAttr4 == null) break block5;
                                Attribute attribute5 = origAttr4;
                                if (!(featAttr instanceof NumericAttribute)) break block5;
                                NumericAttribute numericAttribute = (NumericAttribute)featAttr;
                                attribute = attribute5.withIndex(BoxesRunTime.unboxToInt((Object)numericAttribute.index().get()));
                                break block3;
                            }
                            if (tuple2 == null || (origAttr = (Attribute)tuple2._1()) == null) break block6;
                            attribute = attribute2 = origAttr;
                        }
                        return attribute;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
        } else {
            attributeArray = this.partialFeatureAttributes();
        }
        Attribute[] featureAttributes = attributeArray;
        AttributeGroup newAttributeGroup = new AttributeGroup(this.$(this.outputCol()), featureAttributes);
        return newAttributeGroup.toStructField();
    }

    public VectorIndexerModel(String uid, int numFeatures, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, Object>> categoryMaps) {
        this.uid = uid;
        this.numFeatures = numFeatures;
        this.categoryMaps = categoryMaps;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        VectorIndexerParams$class.$init$(this);
        Attribute[] attrs = new Attribute[numFeatures];
        int categoricalFeatureCount = 0;
        for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
            if (categoryMaps.contains((Object)BoxesRunTime.boxToInteger((int)featureIndex))) {
                String[] featureValues = (String[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)categoryMaps.apply((Object)BoxesRunTime.boxToInteger((int)featureIndex))).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new $anonfun$6(this), (Ordering)Ordering.Double$.MODULE$)).map((Function1)new $anonfun$7(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).map((Function1)new $anonfun$8(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                if (featureValues.length == 2) {
                    Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                    Some x$10 = new Some((Object)featureValues);
                    Option<String> x$11 = BinaryAttribute$.MODULE$.$lessinit$greater$default$1();
                    attrs[featureIndex] = new BinaryAttribute(x$11, (Option<Object>)x$9, (Option<String[]>)x$10);
                } else {
                    Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                    Some x$13 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
                    Some x$14 = new Some((Object)featureValues);
                    Option<String> x$15 = NominalAttribute$.MODULE$.$lessinit$greater$default$1();
                    Option<Object> x$16 = NominalAttribute$.MODULE$.$lessinit$greater$default$4();
                    attrs[featureIndex] = new NominalAttribute(x$15, (Option<Object>)x$12, (Option<Object>)x$13, x$16, (Option<String[]>)x$14);
                }
                ++categoricalFeatureCount;
                continue;
            }
            Some x$17 = new Some((Object)BoxesRunTime.boxToInteger((int)featureIndex));
            Option<String> x$18 = NumericAttribute$.MODULE$.$lessinit$greater$default$1();
            Option<Object> x$19 = NumericAttribute$.MODULE$.$lessinit$greater$default$3();
            Option<Object> x$20 = NumericAttribute$.MODULE$.$lessinit$greater$default$4();
            Option<Object> x$21 = NumericAttribute$.MODULE$.$lessinit$greater$default$5();
            Option<Object> x$22 = NumericAttribute$.MODULE$.$lessinit$greater$default$6();
            attrs[featureIndex] = new NumericAttribute(x$18, (Option<Object>)x$17, x$19, x$20, x$21, x$22);
        }
        Predef$.MODULE$.require(categoricalFeatureCount == categoryMaps.size(), (Function0)new $anonfun$9(this));
        this.partialFeatureAttributes = attrs;
        int[] sortedCatFeatureIndices = (int[])Predef$.MODULE$.intArrayOps((int[])categoryMaps.keys().toArray(ClassTag$.MODULE$.Int())).sorted((Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, Object>> localVectorMap = categoryMaps;
        int localNumFeatures = numFeatures;
        $anonfun$10 f = new $anonfun$10(this, sortedCatFeatureIndices, localVectorMap, localNumFeatures);
        this.transformFunc = f;
    }
}

