/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dm\u0001Ba\u0004\t\u001355\t!!\u0003\u0002\u0012\u0005\t\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00109%\u0011QD\u0001\u0002\u0019\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eU1sC6\u001c\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\t\u0011\u0002\u0007ULG-F\u0001\"!\t\u0011\u0003F\u0004\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9C%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014%\u0011!a\u0003A!A!\u0002\u0013\t\u0013\u0001B;jI\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\bo\u0016Lw\r\u001b;t+\u0005\u0011\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011],\u0017n\u001a5ug\u0002B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001N\u0001\nS:$XM]2faR,\u0012!\u000e\t\u0003GYJ!a\u000e\u0013\u0003\r\u0011{WO\u00197f\u0011!I\u0004A!A!\u0002\u0013)\u0014AC5oi\u0016\u00148-\u001a9uA!11\b\u0001C\u0001\tq\na\u0001P5oSRtD\u0003\u0002\u000e>}}BQa\b\u001eA\u0002\u0005BQA\f\u001eA\u0002IAQa\r\u001eA\u0002UBQ!\u0011\u0001\u0005\u0002\t\u000bAb]3u)\"\u0014Xm\u001d5pY\u0012$\"a\u0011#\u000e\u0003\u0001AQ!\u0012!A\u0002U\nQA^1mk\u0016Dqa\u0012\u0001C\u0002\u0013%\u0001*\u0001\u0004nCJ<\u0017N\\\u000b\u0002\u0013B!1E\u0013\n6\u0013\tYEEA\u0005Gk:\u001cG/[8oc!1Q\n\u0001Q\u0001\n%\u000bq!\\1sO&t\u0007\u0005C\u0004P\u0001\t\u0007I\u0011\u0002%\u0002\u000bM\u001cwN]3\t\rE\u0003\u0001\u0015!\u0003J\u0003\u0019\u00198m\u001c:fA!91\u000b\u0001b\u0001\n\u0003\"\u0016A\u00038v[\u000ec\u0017m]:fgV\tQ\u000b\u0005\u0002$-&\u0011q\u000b\n\u0002\u0004\u0013:$\bBB-\u0001A\u0003%Q+A\u0006ok6\u001cE.Y:tKN\u0004\u0003\"B.\u0001\t#b\u0016a\u00029sK\u0012L7\r\u001e\u000b\u0003kuCQA\u0018.A\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\u0006A\u0002!\t&Y\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0011!C\u0019\u0005\u0006G~\u0003\rAE\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\t\u000b\u0015\u0004A\u0011\u000b4\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000f\u0006\u0002\u0013O\")a\f\u001aa\u0001%!)\u0011\u000e\u0001C!U\u0006!1m\u001c9z)\tQ2\u000eC\u0003mQ\u0002\u0007Q.A\u0003fqR\u0014\u0018\r\u0005\u0002oc6\tqN\u0003\u0002q\t\u0005)\u0001/\u0019:b[&\u0011!o\u001c\u0002\t!\u0006\u0014\u0018-\\'ba\")A\u000f\u0001C)k\u0006q!/Y<3aJ,G-[2uS>tGCA\u001bw\u0011\u0015\u00197\u000f1\u0001\u0013\u0011\u0015A\b\u0001\"\u0015z\u0003Y\u0001(o\u001c2bE&d\u0017\u000e^=3aJ,G-[2uS>tGCA\u001b{\u0011\u0015Yx\u000f1\u0001\u0013\u0003-\u0001(o\u001c2bE&d\u0017\u000e^=)\u0005\u0001i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0019\t!\"\u00198o_R\fG/[8o\u0013\r\t)a \u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Object> score;
    private final int numClasses;
    private final DoubleParam threshold;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final double getThreshold() {
        return HasThreshold$class.getThreshold(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        return this.copyValues(new LogisticRegressionModel(this.uid(), this.weights(), this.intercept()), extra);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double t = this.getThreshold();
        double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : package$.MODULE$.log(t / (1.0 - t)));
        return rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return probability.apply(1) > this.getThreshold() ? 1.0 : 0.0;
    }

    public LogisticRegressionModel(String uid, Vector weights, double intercept) {
        this.uid = uid;
        this.weights = weights;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasThreshold$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new $anonfun$8(this);
        this.score = new $anonfun$9(this);
        this.numClasses = 2;
    }
}

