/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001f\t!R*\u001e7uSZ\f'/[1uK\u001e\u000bWo]:jC:T!a\u0001\u0003\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001B:uCRT!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\tiW/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0004mS:\fGnZ\u0005\u0003Cy\u0011aAV3di>\u0014\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u00075,\b\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0015\u0019\u0018nZ7b+\u00059\u0003CA\u000f)\u0013\tIcD\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\tW\u0001\u0011\t\u0011)A\u0005O\u000511/[4nC\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00182eA\u0011\u0001\u0007A\u0007\u0002\u0005!)!\u0004\fa\u00019!)Q\u0005\fa\u0001O!9A\u0007\u0001b\u0001\n\u0013)\u0014\u0001\u00032sK\u0016TX-T;\u0016\u0003Y\u00022aN\u001e>\u001b\u0005A$BA\u0010:\u0015\u0005Q\u0014A\u00022sK\u0016TX-\u0003\u0002=q\tYA)\u001a8tKZ+7\r^8s!\t\tb(\u0003\u0002@%\t1Ai\\;cY\u0016Da!\u0011\u0001!\u0002\u00131\u0014!\u00032sK\u0016TX-T;!\u0011\u0019i\u0003\u0001\"\u0001\u0007\u0007R\u0019q\u0006R#\t\u000bi\u0011\u0005\u0019\u0001\u001c\t\u000b\u0015\u0012\u0005\u0019\u0001$\u0011\u0007]:U(\u0003\u0002Iq\tYA)\u001a8tK6\u000bGO]5y\u0011\u001dQ\u0005!!Q\u0001\n-\u000b1\u0001\u001f\u00132!\u0011\tBJR\u001f\n\u00055\u0013\"A\u0002+va2,'\u0007C\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u0019I|w\u000e^*jO6\f\u0017J\u001c<\u0016\u0003\u0019CaA\u0015\u0001!\u0002\u00131\u0015!\u0004:p_R\u001c\u0016nZ7b\u0013:4\b\u0005C\u0004U\u0001\t\u0007I\u0011B+\u0002\u0003U,\u0012!\u0010\u0005\u0007/\u0002\u0001\u000b\u0011B\u001f\u0002\u0005U\u0004\u0003\"B-\u0001\t\u0003Q\u0016a\u00019eMR\u0011Qh\u0017\u0005\u00069b\u0003\r\u0001H\u0001\u0002q\")a\f\u0001C\u0001?\u00061An\\4qI\u001a$\"!\u00101\t\u000bqk\u0006\u0019\u0001\u000f\t\re\u0003A\u0011\u0001\u0004c)\ti4\rC\u0003]C\u0002\u0007A\rE\u00028KvJ!!\t\u001d\t\ry\u0003A\u0011\u0001\u0004h)\ti\u0004\u000eC\u0003]M\u0002\u0007A\rC\u0003k\u0001\u0011%1.\u0001\u000fdC2\u001cW\u000f\\1uK\u000e{g/\u0019:jC:\u001cWmQ8ogR\fg\u000e^:\u0016\u0003-C#\u0001A7\u0011\u00059\fX\"A8\u000b\u0005AD\u0011AC1o]>$\u0018\r^5p]&\u0011!o\u001c\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public class MultivariateGaussian
implements Serializable {
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private final DenseVector<Object> breezeMu;
    private final Tuple2<DenseMatrix<Object>, Object> x$1;
    private final DenseMatrix<Object> rootSigmaInv;
    private final double u;

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu() {
        return this.breezeMu;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return this.rootSigmaInv;
    }

    private double u() {
        return this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.toBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.toBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot(DenseVector$.MODULE$.canDotD()))) * -0.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().toBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) throw new MatchError((Object)eigSym2);
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)d, (Object)u);
        DenseVector d2 = (DenseVector)tuple22._1();
        DenseMatrix u2 = (DenseMatrix)tuple22._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final boolean apply(double x$3) {
                    return this.apply$mcZD$sp(x$3);
                }

                public boolean apply$mcZD$sp(double x$3) {
                    return x$3 > this.tol$1;
                }
                {
                    this.tol$1 = tol$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.log(x);
                }
            }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map((Function1)new Serializable(this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$1;

                public final double apply(double v) {
                    return this.apply$mcDD$sp(v);
                }

                public double apply$mcDD$sp(double v) {
                    return v > this.tol$1 ? package$.MODULE$.sqrt(1.0 / v) : 0.0;
                }
                {
                    this.tol$1 = tol$1;
                }
            }, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            return new Tuple2(pinvS.$times((Object)u2, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(2.0 * package$.MODULE$.Pi()) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
    }

    public MultivariateGaussian(Vector mu, org.apache.spark.mllib.linalg.Matrix sigma) {
        this.mu = mu;
        this.sigma = sigma;
        Predef$.MODULE$.require(sigma.numCols() == sigma.numRows(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Covariance matrix must be square";
            }
        });
        Predef$.MODULE$.require(mu.size() == sigma.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Mean vector length must match covariance matrix size";
            }
        });
        this.breezeMu = mu.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        Tuple2<DenseMatrix<Object>, Object> tuple2 = this.calculateCovarianceConstants();
        if (tuple2 != null) {
            DenseMatrix rootSigmaInv = (DenseMatrix)tuple2._1();
            double u = tuple2._2$mcD$sp();
            if (rootSigmaInv != null) {
                Tuple2 tuple22;
                DenseMatrix denseMatrix = rootSigmaInv;
                double d = u;
                this.x$1 = tuple22 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
                this.rootSigmaInv = (DenseMatrix)this.x$1._1();
                this.u = this.x$1._2$mcD$sp();
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    public MultivariateGaussian(DenseVector<Object> mu, DenseMatrix<Object> sigma) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
    }
}

