/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.correlation;

import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix;
import org.apache.spark.Logging;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.stat.correlation.Correlation;
import org.apache.spark.mllib.stat.correlation.Correlation$class;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.math.package$;

public final class PearsonCorrelation$
implements Correlation,
Logging {
    public static final PearsonCorrelation$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new PearsonCorrelation$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public double computeCorrelationWithMatrixImpl(RDD<Object> x, RDD<Object> y) {
        return Correlation$class.computeCorrelationWithMatrixImpl(this, x, y);
    }

    @Override
    public double computeCorrelation(RDD<Object> x, RDD<Object> y) {
        return this.computeCorrelationWithMatrixImpl(x, y);
    }

    @Override
    public org.apache.spark.mllib.linalg.Matrix computeCorrelationMatrix(RDD<Vector> X) {
        RowMatrix rowMatrix = new RowMatrix(X);
        org.apache.spark.mllib.linalg.Matrix cov = rowMatrix.computeCovariance();
        return this.computeCorrelationMatrixFromCovariance(cov);
    }

    public org.apache.spark.mllib.linalg.Matrix computeCorrelationMatrixFromCovariance(org.apache.spark.mllib.linalg.Matrix covarianceMatrix) {
        int i;
        DenseMatrix cov = (DenseMatrix)covarianceMatrix.toBreeze();
        int n = cov.cols();
        for (i = 0; i < n; ++i) {
            cov.update$mcD$sp(i, i, this.closeToZero(cov.apply$mcD$sp(i, i), this.closeToZero$default$2()) ? 0.0 : package$.MODULE$.sqrt(cov.apply$mcD$sp(i, i)));
        }
        double sigma = 0.0;
        boolean containNaN = false;
        for (int j = 0; j < n; ++j) {
            sigma = cov.apply$mcD$sp(j, j);
            for (i = 0; i < j; ++i) {
                double d;
                if (sigma == 0.0 || cov.apply$mcD$sp(i, i) == 0.0) {
                    containNaN = true;
                    d = Double.NaN;
                } else {
                    d = cov.apply$mcD$sp(i, j) / (sigma * cov.apply$mcD$sp(i, i));
                }
                double corr = d;
                cov.update$mcD$sp(i, j, corr);
                cov.update$mcD$sp(j, i, corr);
            }
        }
        for (i = 0; i < n; ++i) {
            cov.update$mcD$sp(i, i, 1.0);
        }
        if (containNaN) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Pearson correlation matrix contains NaN values.";
                }
            });
        }
        return Matrices$.MODULE$.fromBreeze((Matrix<Object>)cov);
    }

    private boolean closeToZero(double value, double threshhold) {
        return package$.MODULE$.abs(value) <= threshhold;
    }

    private double closeToZero$default$2() {
        return 1.0E-12;
    }

    private PearsonCorrelation$() {
        MODULE$ = this;
        Correlation$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

