/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.util.Arrays;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\t9\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0003S>T\u0011!G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001c-\ta1+\u001a:jC2L'0\u00192mK\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0006c_VtG-\u0019:jKN,\u0012a\b\t\u0004\u001f\u0001\u0012\u0013BA\u0011\u0011\u0005\u0015\t%O]1z!\ty1%\u0003\u0002%!\t1Ai\\;cY\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\fE>,h\u000eZ1sS\u0016\u001c\b\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003-\u0001(/\u001a3jGRLwN\\:\t\u0011)\u0002!\u0011!Q\u0001\n}\tA\u0002\u001d:fI&\u001cG/[8og\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\tSN|Go\u001c8jGV\ta\u0006\u0005\u0002\u0010_%\u0011\u0001\u0007\u0005\u0002\b\u0005>|G.Z1o\u0011!\u0011\u0004A!A!\u0002\u0013q\u0013!C5t_R|g.[2!\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q!a\u0007O\u001d;!\t9\u0004!D\u0001\u0003\u0011\u0015i2\u00071\u0001 \u0011\u0015A3\u00071\u0001 \u0011\u0015a3\u00071\u0001/\u0011\u001da\u0004A1A\u0005\nu\nQ\u0002\u001d:fI&\u001cG/[8o\u001fJ$W#\u0001 \u0011\u0007}\u0012%%D\u0001A\u0015\t\t\u0005#\u0001\u0003nCRD\u0017BA\"A\u0005!y%\u000fZ3sS:<\u0007BB#\u0001A\u0003%a(\u0001\bqe\u0016$\u0017n\u0019;j_:|%\u000f\u001a\u0011\t\u000b\u001d\u0003A\u0011\u0002%\u0002\u001b\u0005\u001c8/\u001a:u\u001fJ$WM]3e)\tI%\f\u0006\u0002K\u001bB\u0011qbS\u0005\u0003\u0019B\u0011A!\u00168ji\")aJ\u0012a\u0002\u001f\u0006\u0019qN\u001d3\u0011\u0007AC&E\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011A\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0016\t\u0002\u000fA\f7m[1hK&\u00111)\u0017\u0006\u0003/BAQa\u0017$A\u0002}\t!\u0001_:\t\u000bu\u0003A\u0011\u00010\u0002\u000fA\u0014X\rZ5diR\u0011q,\u001a\t\u0004A\u000e\u0014S\"A1\u000b\u0005\t4\u0011a\u0001:eI&\u0011A-\u0019\u0002\u0004%\u0012#\u0005\"\u00024]\u0001\u0004y\u0016\u0001\u0003;fgR$\u0015\r^1\t\u000bu\u0003A\u0011\u00015\u0015\u0005%\u0004\bC\u00016o\u001b\u0005Y'BA\rm\u0015\tig!A\u0002ba&L!a\\6\u0003\u001b)\u000bg/\u0019#pk\ndWM\u0015#E\u0011\u00151w\r1\u0001j\u0011\u0015i\u0006\u0001\"\u0001s)\t\u00113\u000fC\u0003gc\u0002\u0007!\u0005\u000b\u0002\u0001kB\u0011a/_\u0007\u0002o*\u0011\u0001PB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001>x\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class IsotonicRegressionModel
implements java.io.Serializable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = new IntRef(1);
        while (i.elem < xs.length) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0)new Serializable(this, xs, i){
                public static final long serialVersionUID = 0L;
                private final double[] xs$1;
                private final IntRef i$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elements (", ", ", ") are not ordered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem - 1]), BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem])}));
                }
                {
                    this.xs$1 = xs$1;
                    this.i$1 = i$1;
                }
            });
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData) {
        return testData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegressionModel $outer;

            public final double apply(double testData) {
                return this.apply$mcDD$sp(testData);
            }

            public double apply$mcDD$sp(double testData) {
                return this.$outer.predict(testData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).last()) : (foundIndex < 0 ? this.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    private final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }
}

