/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001b;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u001fmI!\u0001\b\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005yyR\"\u0001\u0004\n\u0005\u00012!a\u0002'pO\u001eLgn\u001a\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005!!/\u00198l+\u0005!\u0003CA\b&\u0013\t1\u0003CA\u0002J]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006e\u0006t7\u000e\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u0005aQo]3s\r\u0016\fG/\u001e:fgV\tA\u0006E\u0002.aIj\u0011A\f\u0006\u0003_\u0019\t1A\u001d3e\u0013\t\tdFA\u0002S\t\u0012\u0003BaD\u001a%k%\u0011A\u0007\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007=1\u0004(\u0003\u00028!\t)\u0011I\u001d:bsB\u0011q\"O\u0005\u0003uA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u001bU\u001cXM\u001d$fCR,(/Z:!\u0011!q\u0004A!b\u0001\n\u0003Y\u0013a\u00049s_\u0012,8\r\u001e$fCR,(/Z:\t\u0011\u0001\u0003!\u0011!Q\u0001\n1\n\u0001\u0003\u001d:pIV\u001cGOR3biV\u0014Xm\u001d\u0011\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\u0011!ei\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\u0002\t\u000b\t\n\u0005\u0019\u0001\u0013\t\u000b)\n\u0005\u0019\u0001\u0017\t\u000by\n\u0005\u0019\u0001\u0017\t\u000b)\u0003A\u0011B&\u0002!Y\fG.\u001b3bi\u00164U-\u0019;ve\u0016\u001cHc\u0001'P1B\u0011q\"T\u0005\u0003\u001dB\u0011A!\u00168ji\")\u0001+\u0013a\u0001#\u0006!a.Y7f!\t\u0011VK\u0004\u0002\u0010'&\u0011A\u000bE\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U!!)\u0011,\u0013a\u0001Y\u0005Aa-Z1ukJ,7\u000fC\u0003\\\u0001\u0011\u0005A,A\u0004qe\u0016$\u0017n\u0019;\u0015\u0007ajv\fC\u0003_5\u0002\u0007A%\u0001\u0003vg\u0016\u0014\b\"\u00021[\u0001\u0004!\u0013a\u00029s_\u0012,8\r\u001e\u0005\u00067\u0002!\tA\u0019\u000b\u0003G\u001e\u00042!\f\u0019e!\t)U-\u0003\u0002g\u0005\t1!+\u0019;j]\u001eDQ\u0001[1A\u0002%\fQ\"^:feN\u0004&o\u001c3vGR\u001c\bcA\u00171UB!qb\r\u0013%\u0011\u0015Y\u0006\u0001\"\u0001m)\tiW\u000fE\u0002og\u0012l\u0011a\u001c\u0006\u0003aF\fAA[1wC*\u0011!OB\u0001\u0004CBL\u0017B\u0001;p\u0005\u001dQ\u0015M^1S\t\u0012CQ\u0001[6A\u0002Y\u0004BA\\<zs&\u0011\u0001p\u001c\u0002\f\u0015\u00064\u0018\rU1jeJ#E\t\u0005\u0002{}6\t1P\u0003\u0002}{\u0006!A.\u00198h\u0015\u0005\u0001\u0018BA@|\u0005\u001dIe\u000e^3hKJDq!a\u0001\u0001\t\u0003\t)!A\tsK\u000e|W.\\3oIB\u0013x\u000eZ;diN$b!a\u0002\u0002\n\u0005-\u0001cA\b7I\"1a,!\u0001A\u0002\u0011Bq!!\u0004\u0002\u0002\u0001\u0007A%A\u0002ok6Dq!!\u0005\u0001\t\u0003\t\u0019\"\u0001\bsK\u000e|W.\\3oIV\u001bXM]:\u0015\r\u0005\u001d\u0011QCA\f\u0011\u0019\u0001\u0017q\u0002a\u0001I!9\u0011QBA\b\u0001\u0004!\u0003\"CA\u000e\u0001\t\u0007I\u0011KA\u000f\u000351wN]7biZ+'o]5p]V\t\u0011\u000bC\u0004\u0002\"\u0001\u0001\u000b\u0011B)\u0002\u001d\u0019|'/\\1u-\u0016\u00148/[8oA!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012\u0001B:bm\u0016$R\u0001TA\u0015\u0003gA\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\u0003g\u000e\u00042AHA\u0018\u0013\r\t\tD\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003k\t\u0019\u00031\u0001R\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005I!/Z2p[6,g\u000e\u001a\u000b\t\u0003{\t\t%!\u0012\u0002JA!qBNA !\u0011y1\u0007\n\u001d\t\u000f\u0005\r\u0013q\u0007a\u0001k\u0005\u0019\"/Z2p[6,g\u000e\u001a+p\r\u0016\fG/\u001e:fg\"9\u0011qIA\u001c\u0001\u0004a\u0013!\u0006:fG>lW.\u001a8eC\ndWMR3biV\u0014Xm\u001d\u0005\b\u0003\u001b\t9\u00041\u0001%\u000f\u001d\tiE\u0001E\u0001\u0003\u001f\n\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m!\r)\u0015\u0011\u000b\u0004\u0007\u0003\tA\t!a\u0015\u0014\r\u0005Ec\"!\u0016\u001b!\u0011)\u0012q\u000b#\n\u0007\u0005ecC\u0001\u0004M_\u0006$WM\u001d\u0005\b\u0005\u0006EC\u0011AA/)\t\ty\u0005\u0003\u0005\u0002b\u0005EC\u0011IA2\u0003\u0011aw.\u00193\u0015\u000b\u0011\u000b)'a\u001a\t\u0011\u0005-\u0012q\fa\u0001\u0003[Aq!!\u000e\u0002`\u0001\u0007\u0011kB\u0005\u0002l\u0005E\u0003\u0012\u0001\u0002\u0002n\u0005a1+\u0019<f\u0019>\fGMV\u0019`aA!\u0011qNA9\u001b\t\t\tFB\u0005\u0002t\u0005E\u0003\u0012\u0001\u0002\u0002v\ta1+\u0019<f\u0019>\fGMV\u0019`aM\u0019\u0011\u0011\u000f\b\t\u000f\t\u000b\t\b\"\u0001\u0002zQ\u0011\u0011Q\u000e\u0005\u000b\u0003{\n\tH1A\u0005\n\u0005}\u0014!\u0005;iSN4uN]7biZ+'o]5p]V\u0011\u0011\u0011\u0011\t\u0004u\u0006\r\u0015B\u0001,|\u0011%\t9)!\u001d!\u0002\u0013\t\t)\u0001\nuQ&\u001chi\u001c:nCR4VM]:j_:\u0004\u0003bCAF\u0003c\u0012\r\u0011\"\u0001\u0003\u0003\u007f\nQ\u0002\u001e5jg\u000ec\u0017m]:OC6,\u0007\"CAH\u0003c\u0002\u000b\u0011BAA\u00039!\b.[:DY\u0006\u001c8OT1nK\u0002B\u0001\"!\n\u0002r\u0011\u0005\u00111\u0013\u000b\u0006\u0019\u0006U\u0015\u0011\u0014\u0005\b\u0003/\u000b\t\n1\u0001E\u0003\u0015iw\u000eZ3m\u0011\u001d\t)$!%A\u0002EC\u0001\"!\u0019\u0002r\u0011\u0005\u0011Q\u0014\u000b\u0006\t\u0006}\u0015\u0011\u0015\u0005\t\u0003W\tY\n1\u0001\u0002.!9\u0011QGAN\u0001\u0004\t\u0006\u0002CAS\u0003c\"I!a*\u0002\u0011U\u001cXM\u001d)bi\"$2!UAU\u0011\u001d\t)$a)A\u0002EC\u0001\"!,\u0002r\u0011%\u0011qV\u0001\faJ|G-^2u!\u0006$\b\u000eF\u0002R\u0003cCq!!\u000e\u0002,\u0002\u0007\u0011\u000b\u0003\u0006\u00026\u0006E\u0013\u0011!C\u0005\u0003o\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0018\t\u0004u\u0006m\u0016bAA_w\n1qJ\u00196fGR\u0004")
public class MatrixFactorizationModel
implements Saveable,
Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps((double[])((Tuple2)features.first())._2()).size() == this.rank(), (Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModel $outer;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " feature dimension does not match the rank ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)this.$outer.rank())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)"Prediction on individual records could be slow.").toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. Prediction could be slow."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
    }

    public double predict(int user, int product) {
        DoubleMatrix userVector = new DoubleMatrix((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head());
        DoubleMatrix productVector = new DoubleMatrix((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head());
        return userVector.dot(productVector);
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            DoubleMatrix userVector = new DoubleMatrix(uFeatures);
                            DoubleMatrix productVector = new DoubleMatrix(pFeatures);
                            Rating rating = new Rating(user, product, userVector.dot(productVector));
                            return rating;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    private Tuple2<Object, Object>[] recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        DoubleMatrix recommendToVector = new DoubleMatrix(recommendToFeatures);
        RDD scored = recommendableFeatures.map((Function1)new Serializable(this, recommendToVector){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix recommendToVector$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x0$3) {
                Tuple2<Object, double[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    double[] features = (double[])tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, this.recommendToVector$1.dot(new DoubleMatrix(features)));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.recommendToVector$1 = recommendToVector$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$1) {
                return x$1._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

