/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import java.util.Arrays;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u0016l\u0015\r\u001e:jq*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\t3\u0001\u0011)\u0019!C\u00015\u00059a.^7S_^\u001cX#A\u000e\u0011\u0005=a\u0012BA\u000f\u0011\u0005\rIe\u000e\u001e\u0005\t?\u0001\u0011\t\u0011)A\u00057\u0005Aa.^7S_^\u001c\b\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u001dqW/\\\"pYND\u0001b\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\t]Vl7i\u001c7tA!AQ\u0005\u0001BC\u0002\u0013\u0005a%\u0001\u0004wC2,Xm]\u000b\u0002OA\u0019q\u0002\u000b\u0016\n\u0005%\u0002\"!B!se\u0006L\bCA\b,\u0013\ta\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005O\u00059a/\u00197vKN\u0004\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011I\u0019\u0002\u0019%\u001cHK]1ogB|7/\u001a3\u0016\u0003I\u0002\"aD\u001a\n\u0005Q\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005e\u0005i\u0011n\u001d+sC:\u001c\bo\\:fI\u0002BQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtD#\u0002\u001e<yur\u0004CA\u000b\u0001\u0011\u0015Ir\u00071\u0001\u001c\u0011\u0015\ts\u00071\u0001\u001c\u0011\u0015)s\u00071\u0001(\u0011\u0015\u0001t\u00071\u00013\u0011\u0015A\u0004\u0001\"\u0001A)\u0011Q\u0014IQ\"\t\u000bey\u0004\u0019A\u000e\t\u000b\u0005z\u0004\u0019A\u000e\t\u000b\u0015z\u0004\u0019A\u0014\t\u000b\u0015\u0003A\u0011\t$\u0002\r\u0015\fX/\u00197t)\t\u0011t\tC\u0003I\t\u0002\u0007\u0011*A\u0001p!\ty!*\u0003\u0002L!\t\u0019\u0011I\\=\t\r5\u0003A\u0011\u0001\u0003O\u0003!!xN\u0011:fKj,W#A(\u0011\u0007A#&&D\u0001R\u0015\t\u0019!KC\u0001T\u0003\u0019\u0011'/Z3{K&\u0011q#\u0015\u0005\u0007-\u0002!\t\u0001B,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005)B\u0006\"B-V\u0001\u0004Y\u0012!A5\t\u000bY\u0003A\u0011I.\u0015\u0007)bV\fC\u0003Z5\u0002\u00071\u0004C\u0003_5\u0002\u00071$A\u0001k\u0011\u0019\u0001\u0007\u0001\"\u0001\u0005C\u0006)\u0011N\u001c3fqR\u00191DY2\t\u000be{\u0006\u0019A\u000e\t\u000by{\u0006\u0019A\u000e\t\r\u0015\u0004A\u0011\u0001\u0003g\u0003\u0019)\b\u000fZ1uKR!qM[6m!\ty\u0001.\u0003\u0002j!\t!QK\\5u\u0011\u0015IF\r1\u0001\u001c\u0011\u0015qF\r1\u0001\u001c\u0011\u0015iG\r1\u0001+\u0003\u00051\b\"B8\u0001\t\u0003\u0002\u0018\u0001B2paf,\u0012A\u000f\u0005\u0007e\u0002!\t\u0001B:\u0002\u00075\f\u0007\u000f\u0006\u0002;i\")Q/\u001da\u0001m\u0006\ta\r\u0005\u0003\u0010o*R\u0013B\u0001=\u0011\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004f\u0001\u0011\u0005AA\u001f\u000b\u0003umDQ!^=A\u0002YDQ! \u0001\u0005BA\f\u0011\u0002\u001e:b]N\u0004xn]3\t\u000f}\u0004A\u0011\t\u0004\u0002\u0002\u0005iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$2aZA\u0002\u0011\u0019)h\u00101\u0001\u0002\u0006A9q\"a\u0002\u001c7):\u0017bAA\u0005!\tIa)\u001e8di&|gn\r\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003!!xn\u00159beN,WCAA\t!\r)\u00121C\u0005\u0004\u0003+\u0011!\u0001D*qCJ\u001cX-T1ue&DxaBA\r\u0005!\u0005\u00111D\u0001\f\t\u0016t7/Z'biJL\u0007\u0010E\u0002\u0016\u0003;1a!\u0001\u0002\t\u0002\u0005}1#BA\u000f\u001d\u0005\u0005\u0002cA\b\u0002$%\u0019\u0011Q\u0005\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fa\ni\u0002\"\u0001\u0002*Q\u0011\u00111\u0004\u0005\t\u0003[\ti\u0002\"\u0001\u00020\u0005)!0\u001a:pgR)!(!\r\u00024!1\u0011$a\u000bA\u0002mAa!IA\u0016\u0001\u0004Y\u0002\u0002CA\u001c\u0003;!\t!!\u000f\u0002\t=tWm\u001d\u000b\u0006u\u0005m\u0012Q\b\u0005\u00073\u0005U\u0002\u0019A\u000e\t\r\u0005\n)\u00041\u0001\u001c\u0011!\t\t%!\b\u0005\u0002\u0005\r\u0013aA3zKR\u0019!(!\u0012\t\u000f\u0005\u001d\u0013q\ba\u00017\u0005\ta\u000e\u0003\u0005\u0002L\u0005uA\u0011AA'\u0003\u0011\u0011\u0018M\u001c3\u0015\u000fi\ny%!\u0015\u0002T!1\u0011$!\u0013A\u0002mAa!IA%\u0001\u0004Y\u0002\u0002CA+\u0003\u0013\u0002\r!a\u0016\u0002\u0007Itw\r\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003C\nAA[1wC&!\u0011QMA.\u0005\u0019\u0011\u0016M\u001c3p[\"A\u0011\u0011NA\u000f\t\u0003\tY'A\u0003sC:$g\u000eF\u0004;\u0003[\ny'!\u001d\t\re\t9\u00071\u0001\u001c\u0011\u0019\t\u0013q\ra\u00017!A\u0011QKA4\u0001\u0004\t9\u0006\u0003\u0005\u0002v\u0005uA\u0011AA<\u0003\u0011!\u0017.Y4\u0015\u0007i\nI\b\u0003\u0005\u0002|\u0005M\u0004\u0019AA?\u0003\u00191Xm\u0019;peB\u0019Q#a \n\u0007\u0005\u0005%A\u0001\u0004WK\u000e$xN\u001d\u0005\u000b\u0003\u000b\u000bi\"!A\u0005\n\u0005\u001d\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!#\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bSA!a$\u0002`\u0005!A.\u00198h\u0013\u0011\t\u0019*!$\u0003\r=\u0013'.Z2u\u0001")
public class DenseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final double[] values;
    private final boolean isTransposed;

    public static DenseMatrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public static DenseMatrix randn(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.randn(n, n2, random);
    }

    public static DenseMatrix rand(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.rand(n, n2, random);
    }

    public static DenseMatrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public static DenseMatrix ones(int n, int n2) {
        return DenseMatrix$.MODULE$.ones(n, n2);
    }

    public static DenseMatrix zeros(int n, int n2) {
        return DenseMatrix$.MODULE$.zeros(n, n2);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public double[] toArray() {
        return Matrix$class.toArray(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        DenseMatrix denseMatrix;
        Object object = o;
        boolean bl = object instanceof DenseMatrix ? (denseMatrix = (DenseMatrix)object).numRows() == this.numRows() && denseMatrix.numCols() == this.numCols() && Arrays.equals(this.toArray(), denseMatrix.toArray()) : false;
        return bl;
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        DenseMatrix.mcD.sp sp2;
        if (this.isTransposed()) {
            DenseMatrix.mcD.sp breezeMatrix = new DenseMatrix.mcD.sp(this.numCols(), this.numRows(), this.values());
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(breeze.linalg.DenseMatrix$.MODULE$.canTranspose());
        } else {
            sp2 = new DenseMatrix.mcD.sp(this.numRows(), this.numCols(), this.values());
        }
        return sp2;
    }

    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public double apply(int i, int j) {
        return this.values()[this.index(i, j)];
    }

    @Override
    public int index(int i, int j) {
        return this.isTransposed() ? j + this.numCols() * i : i + this.numRows() * j;
    }

    @Override
    public void update(int i, int j, double v) {
        this.values()[this.index((int)i, (int)j)] = v;
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])this.values().clone());
    }

    @Override
    public DenseMatrix map(Function1<Object, Object> f) {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])Predef$.MODULE$.doubleArrayOps(this.values()).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public DenseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public DenseMatrix transpose() {
        return new DenseMatrix(this.numCols(), this.numRows(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (this.isTransposed()) {
            for (int i = 0; i < this.numRows(); ++i) {
                int indStart = i * this.numCols();
                for (int j = 0; j < this.numCols(); ++j) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + j]));
                }
            }
        } else {
            for (int j = 0; j < this.numCols(); ++j) {
                int indStart = j * this.numRows();
                for (int i = 0; i < this.numRows(); ++i) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + i]));
                }
            }
        }
    }

    public SparseMatrix toSparse() {
        ArrayBuilder.ofDouble spVals = new ArrayBuilder.ofDouble();
        int[] colPtrs = new int[this.numCols() + 1];
        ArrayBuilder.ofInt rowIndices = new ArrayBuilder.ofInt();
        int nnz = 0;
        int j = 0;
        while (j < this.numCols()) {
            for (int i = 0; i < this.numRows(); ++i) {
                double v = this.values()[this.index(i, j)];
                if (v == 0.0) continue;
                rowIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                spVals.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++nnz;
            }
            colPtrs[++j] = nnz;
        }
        return new SparseMatrix(this.numRows(), this.numCols(), colPtrs, (int[])rowIndices.result(), (double[])spVals.result());
    }

    public DenseMatrix(int numRows2, int numCols, double[] values, boolean isTransposed) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == numRows2 * numCols, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DenseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of values supplied doesn't match the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of the matrix! values.length: ", ", numRows * numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)(this.$outer.numRows() * this.$outer.numCols()))}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public DenseMatrix(int numRows2, int numCols, double[] values) {
        this(numRows2, numCols, values, false);
    }
}

