/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t\u00192\u000b^1oI\u0006\u0014HmU2bY\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0012-\u0016\u001cGo\u001c:Ue\u0006t7OZ8s[\u0016\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u0007M$H-F\u0001\u001c!\tar$D\u0001\u001e\u0015\tqB!\u0001\u0004mS:\fGnZ\u0005\u0003Au\u0011aAV3di>\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\tM$H\r\t\u0005\tI\u0001\u0011)\u0019!C\u00015\u0005!Q.Z1o\u0011!1\u0003A!A!\u0002\u0013Y\u0012!B7fC:\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0007I\u0011A\u0015\u0002\u000f]LG\u000f[*uIV\t!\u0006\u0005\u0002\u0010W%\u0011A\u0006\u0005\u0002\b\u0005>|G.Z1o\u0011!q\u0003A!a\u0001\n\u0003y\u0013aC<ji\"\u001cF\u000fZ0%KF$\"\u0001M\u001a\u0011\u0005=\t\u0014B\u0001\u001a\u0011\u0005\u0011)f.\u001b;\t\u000fQj\u0013\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\t\u0011Y\u0002!\u0011!Q!\n)\n\u0001b^5uQN#H\r\t\u0005\tq\u0001\u0011\t\u0019!C\u0001S\u0005Aq/\u001b;i\u001b\u0016\fg\u000e\u0003\u0005;\u0001\t\u0005\r\u0011\"\u0001<\u000319\u0018\u000e\u001e5NK\u0006tw\fJ3r)\t\u0001D\bC\u00045s\u0005\u0005\t\u0019\u0001\u0016\t\u0011y\u0002!\u0011!Q!\n)\n\u0011b^5uQ6+\u0017M\u001c\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\t)\u0002\u0001C\u0003\u001a\u007f\u0001\u00071\u0004C\u0003%\u007f\u0001\u00071\u0004C\u0003)\u007f\u0001\u0007!\u0006C\u00039\u007f\u0001\u0007!\u0006C\u0003A\u0001\u0011\u0005\u0001\nF\u0002C\u0013*CQ!G$A\u0002mAQ\u0001J$A\u0002mAQ\u0001\u0011\u0001\u0005\u00021#\"AQ'\t\u000beY\u0005\u0019A\u000e\t\u000b=\u0003A\u0011\u0001)\u0002\u0017M,GoV5uQ6+\u0017M\u001c\u000b\u0003#Jk\u0011\u0001\u0001\u0005\u0006q9\u0003\rA\u000b\u0015\u0003\u001dR\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Z-\naA)\u001a<fY>\u0004XM]!qS\")1\f\u0001C\u00019\u0006Q1/\u001a;XSRD7\u000b\u001e3\u0015\u0005Ek\u0006\"\u0002\u0015[\u0001\u0004Q\u0003F\u0001.U\u0011!\u0001\u0007\u0001#b\u0001\n\u0013\t\u0017!B:iS\u001a$X#\u00012\u0011\u0007=\u0019W-\u0003\u0002e!\t)\u0011I\u001d:bsB\u0011qBZ\u0005\u0003OB\u0011a\u0001R8vE2,\u0007\u0002C5\u0001\u0011\u0003\u0005\u000b\u0015\u00022\u0002\rMD\u0017N\u001a;!\u0011\u0015Y\u0007\u0001\"\u0011m\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002\u001c[\")aN\u001ba\u00017\u00051a/Z2u_JD#\u0001\u00019\u0011\u0005U\u000b\u0018B\u0001:W\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class StandardScalerModel
implements VectorTransformer {
    private final Vector std;
    private final Vector mean;
    private boolean withStd;
    private boolean withMean;
    private double[] shift;
    private volatile boolean bitmap$0;

    private double[] shift$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if (!this.bitmap$0) {
                this.shift = this.mean().toArray();
                this.bitmap$0 = true;
            }
            return this.shift;
        }
    }

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    public Vector std() {
        return this.std;
    }

    public Vector mean() {
        return this.mean;
    }

    public boolean withStd() {
        return this.withStd;
    }

    public void withStd_$eq(boolean x$1) {
        this.withStd = x$1;
    }

    public boolean withMean() {
        return this.withMean;
    }

    public void withMean_$eq(boolean x$1) {
        this.withMean = x$1;
    }

    @DeveloperApi
    public StandardScalerModel setWithMean(boolean withMean) {
        Predef$.MODULE$.require(!withMean || this.mean() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot set withMean to true while mean is null";
            }
        });
        this.withMean_$eq(withMean);
        return this;
    }

    @DeveloperApi
    public StandardScalerModel setWithStd(boolean withStd) {
        Predef$.MODULE$.require(!withStd || this.std() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot set withStd to true while std is null";
            }
        });
        this.withStd_$eq(withStd);
        return this;
    }

    private double[] shift() {
        return this.bitmap$0 ? this.shift : this.shift$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        Predef$.MODULE$.require(this.mean().size() == vector.size());
        if (this.withMean()) {
            Vector vector3;
            DenseVector denseVector;
            Option<double[]> option;
            double[] localShift = this.shift();
            Vector vector4 = vector;
            if (!(vector4 instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector4)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
            double[] vs = (double[])option.get();
            double[] values = (double[])vs.clone();
            int size = Predef$.MODULE$.doubleArrayOps(values).size();
            if (this.withStd()) {
                for (int i = 0; i < size; ++i) {
                    values[i] = this.std().apply(i) != 0.0 ? (values[i] - localShift[i]) * (1.0 / this.std().apply(i)) : 0.0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] - localShift[i];
                }
            }
            vector2 = vector3 = Vectors$.MODULE$.dense(values);
            return vector2;
        }
        if (this.withStd()) {
            Vector vector5;
            DenseVector denseVector;
            Option<double[]> option;
            Vector vector6 = vector;
            if (vector6 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector6)).isEmpty()) {
                double[] vs = (double[])option.get();
                double[] values = (double[])vs.clone();
                int size = Predef$.MODULE$.doubleArrayOps(values).size();
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(i) != 0.0 ? 1.0 / this.std().apply(i) : 0.0);
                }
                vector5 = Vectors$.MODULE$.dense(values);
            } else {
                SparseVector sparseVector;
                Option<Tuple3<Object, int[], double[]>> option2;
                if (!(vector6 instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector6)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector6.getClass()).toString());
                int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] vs = (double[])((Tuple3)option2.get())._3();
                double[] values = (double[])vs.clone();
                int nnz = Predef$.MODULE$.doubleArrayOps(values).size();
                for (int i = 0; i < nnz; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(indices[i]) != 0.0 ? 1.0 / this.std().apply(indices[i]) : 0.0);
                }
                vector5 = Vectors$.MODULE$.sparse(size, indices, values);
            }
            vector2 = vector5;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public StandardScalerModel(Vector std, Vector mean2, boolean withStd, boolean withMean) {
        this.std = std;
        this.mean = mean2;
        this.withStd = withStd;
        this.withMean = withMean;
        VectorTransformer$class.$init$(this);
    }

    public StandardScalerModel(Vector std, Vector mean2) {
        this(std, mean2, std != null, mean2 != null);
        Predef$.MODULE$.require(this.withStd() || this.withMean(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "at least one of std or mean vectors must be provided";
            }
        });
        if (this.withStd() && this.withMean()) {
            Predef$.MODULE$.require(mean2.size() == std.size(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "mean and std vectors must have equal size if both are provided";
                }
            });
        }
    }

    public StandardScalerModel(Vector std) {
        this(std, null);
    }
}

