/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002\u0006\r\u001f!\ty!#D\u0001\u0011\u0015\t\tB!\u0001\u0006sK\u001e\u0014Xm]:j_:L!a\u0005\t\u0003-\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/T8eK2\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003'\rc\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\"\u0011\u0001B;uS2L!a\t\u0011\u0003\u0011M\u000bg/Z1cY\u0016D\u0001\"\n\u0001\u0003\u0006\u0004%\tEJ\u0001\bo\u0016Lw\r\u001b;t+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0019a\u0017N\\1mO&\u0011A&\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\u00139\u0002!\u0011!Q\u0001\n\u001dz\u0013\u0001C<fS\u001eDGo\u001d\u0011\n\u0005\u0015\u0012\u0002\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\t\u001a\u0002\u0013%tG/\u001a:dKB$X#A\u001a\u0011\u0005e!\u0014BA\u001b\u001b\u0005\u0019!u.\u001e2mK\"Iq\u0007\u0001B\u0001B\u0003%1\u0007O\u0001\u000bS:$XM]2faR\u0004\u0013BA\u0019\u0013\u0011!Q\u0004A!b\u0001\n\u0003Y\u0014a\u00038v[\u001a+\u0017\r^;sKN,\u0012\u0001\u0010\t\u00033uJ!A\u0010\u000e\u0003\u0007%sG\u000f\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003=\u00031qW/\u001c$fCR,(/Z:!\u0011!\u0011\u0005A!b\u0001\n\u0003Y\u0014A\u00038v[\u000ec\u0017m]:fg\"AA\t\u0001B\u0001B\u0003%A(A\u0006ok6\u001cE.Y:tKN\u0004\u0003\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\bF\u0003I\u0013*[E\n\u0005\u0002\u0016\u0001!)Q%\u0012a\u0001O!)\u0011'\u0012a\u0001g!)!(\u0012a\u0001y!)!)\u0012a\u0001y!)a\t\u0001C\u0001\u001dR\u0019\u0001j\u0014)\t\u000b\u0015j\u0005\u0019A\u0014\t\u000bEj\u0005\u0019A\u001a\t\u000fI\u0003\u0001\u0019!C\u0005'\u0006IA\u000f\u001b:fg\"|G\u000eZ\u000b\u0002)B\u0019\u0011$V\u001a\n\u0005YS\"AB(qi&|g\u000eC\u0004Y\u0001\u0001\u0007I\u0011B-\u0002\u001bQD'/Z:i_2$w\fJ3r)\tQV\f\u0005\u0002\u001a7&\u0011AL\u0007\u0002\u0005+:LG\u000fC\u0004_/\u0006\u0005\t\u0019\u0001+\u0002\u0007a$\u0013\u0007\u0003\u0004a\u0001\u0001\u0006K\u0001V\u0001\u000bi\"\u0014Xm\u001d5pY\u0012\u0004\u0003\"\u00022\u0001\t\u0003\u0019\u0017\u0001D:fiRC'/Z:i_2$GC\u00013f\u001b\u0005\u0001\u0001\"\u0002*b\u0001\u0004\u0019\u0004FA1h!\tA7.D\u0001j\u0015\tQg!\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\5\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\t\u000b9\u0004A\u0011A*\u0002\u0019\u001d,G\u000f\u00165sKNDw\u000e\u001c3)\u00055<\u0007\"B9\u0001\t\u0003\u0011\u0018AD2mK\u0006\u0014H\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0002I\"\u0012\u0001o\u001a\u0005\u0006k\u0002!\tF^\u0001\raJ,G-[2u!>Lg\u000e\u001e\u000b\u0005g]L8\u0010C\u0003yi\u0002\u0007q%\u0001\u0006eCR\fW*\u0019;sSbDQA\u001f;A\u0002\u001d\nAb^3jO\"$X*\u0019;sSbDQ!\r;A\u0002MBQ! \u0001\u0005By\fAa]1wKR!!l`A\u0006\u0011\u001d\t\t\u0001 a\u0001\u0003\u0007\t!a]2\u0011\t\u0005\u0015\u0011qA\u0007\u0002\r%\u0019\u0011\u0011\u0002\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\u00055A\u00101\u0001\u0002\u0010\u0005!\u0001/\u0019;i!\u0011\t\t\"a\u0006\u000f\u0007e\t\u0019\"C\u0002\u0002\u0016i\ta\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b5!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0012!\u00044pe6\fGOV3sg&|g.\u0006\u0002\u0002\u0010\u001d9\u0011Q\u0005\u0002\t\u0002\u0005\u001d\u0012a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\r)\u0012\u0011\u0006\u0004\u0007\u0003\tA\t!a\u000b\u0014\u000f\u0005%\u0012QFA\u001a1A\u0019\u0011$a\f\n\u0007\u0005E\"D\u0001\u0004B]f\u0014VM\u001a\t\u0005?\u0005U\u0002*C\u0002\u00028\u0001\u0012a\u0001T8bI\u0016\u0014\bb\u0002$\u0002*\u0011\u0005\u00111\b\u000b\u0003\u0003OA\u0001\"a\u0010\u0002*\u0011\u0005\u0013\u0011I\u0001\u0005Y>\fG\rF\u0003I\u0003\u0007\n)\u0005\u0003\u0005\u0002\u0002\u0005u\u0002\u0019AA\u0002\u0011!\ti!!\u0010A\u0002\u0005=\u0001BCA%\u0003S\t\t\u0011\"\u0003\u0002L\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t1\fgn\u001a\u0006\u0003\u0003/\nAA[1wC&!\u00111LA)\u0005\u0019y%M[3di\u0002")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable {
    private final int numFeatures;
    private final int numClasses;
    private Option<Object> threshold;

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    @Experimental
    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    @Experimental
    public Option<Object> getThreshold() {
        return this.threshold();
    }

    @Experimental
    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        block8: {
            double d;
            block7: {
                double[] dArray;
                block3: {
                    Option<Object> option;
                    block6: {
                        double d2;
                        block5: {
                            double score;
                            block4: {
                                Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
                                if (this.numClasses() != 2) break block3;
                                Predef$.MODULE$.require(this.numFeatures() == weightMatrix.size());
                                double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
                                score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
                                option = this.threshold();
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                double t = BoxesRunTime.unboxToDouble((Object)some.x());
                                d2 = score > t ? 1.0 : 0.0;
                                break block5;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                            d2 = score;
                        }
                        d = d2;
                        break block7;
                    }
                    throw new MatchError(option);
                }
                int dataWithBiasSize = weightMatrix.size() / (this.numClasses() - 1);
                Vector vector = weightMatrix;
                if (!(vector instanceof DenseVector)) break block8;
                DenseVector denseVector = (DenseVector)vector;
                double[] weightsArray = dArray = denseVector.values();
                IndexedSeq margins = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).map((Function1)new Serializable(this, dataMatrix, dataWithBiasSize, weightsArray){
                    public static final long serialVersionUID = 0L;
                    private final Vector dataMatrix$1;
                    public final int dataWithBiasSize$1;
                    public final double[] weightsArray$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        DoubleRef margin = new DoubleRef(0.0);
                        this.dataMatrix$1.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, margin, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1 $outer;
                            private final DoubleRef margin$1;
                            private final int i$1;

                            public final void apply(int index, double value) {
                                this.apply$mcVID$sp(index, value);
                            }

                            public void apply$mcVID$sp(int index, double value) {
                                if (value != 0.0) {
                                    this.margin$1.elem += value * this.$outer.weightsArray$1[this.i$1 * this.$outer.dataWithBiasSize$1 + index];
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.margin$1 = margin$1;
                                this.i$1 = i$1;
                            }
                        });
                        if (this.dataMatrix$1.size() + 1 == this.dataWithBiasSize$1) {
                            margin.elem += this.weightsArray$1[i * this.dataWithBiasSize$1 + this.dataMatrix$1.size()];
                        }
                        return margin.elem;
                    }
                    {
                        this.dataMatrix$1 = dataMatrix$1;
                        this.dataWithBiasSize$1 = dataWithBiasSize$1;
                        this.weightsArray$1 = weightsArray$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                int bestClass = 0;
                double maxMargin = 0.0;
                for (int i = 0; i < margins.size(); ++i) {
                    if (!(BoxesRunTime.unboxToDouble((Object)margins.apply(i)) > maxMargin)) continue;
                    maxMargin = BoxesRunTime.unboxToDouble((Object)margins.apply(i));
                    bestClass = i + 1;
                }
                d = bestClass;
            }
            return d;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"weights only supports dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{weightMatrix.getClass()})));
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel$class.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel with numClasses = 2 was given non-matching values:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numFeatures = ", ", but weights.size = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numFeatures()), BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0)new Serializable(this, weightsSizeWithoutIntercept, weightsSizeWithIntercept){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;
                private final int weightsSizeWithoutIntercept$1;
                private final int weightsSizeWithIntercept$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel.load with numClasses = ", " and numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.$outer.numFeatures())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected weights of length ", " (without intercept)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithoutIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or ", " (with intercept),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but was given weights of length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.weightsSizeWithoutIntercept$1 = weightsSizeWithoutIntercept$1;
                    this.weightsSizeWithIntercept$1 = weightsSizeWithIntercept$1;
                }
            });
        }
        this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

