/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.HasMaxIter$class;
import org.apache.spark.ml.param.HasRegParam$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params$;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import scala.reflect.ScalaSignature;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001b\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dm\u0001Ba\u0004\t\u001355\t!!\u0003\u0002\u0012\u0005\ty!+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u00051A.\u001b8bY\u001eT!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011q\u0002H\u0005\u0003;\t\u0011a\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\u0005\t?\u0001\u0011)\u0019!C!A\u00051\u0001/\u0019:f]R,\u0012!\t\t\u0003\u001f\tJ!a\t\u0002\u0003!1Kg.Z1s%\u0016<'/Z:tS>t\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u000fA\f'/\u001a8uA!Aq\u0005\u0001BC\u0002\u0013\u0005\u0003&A\bgSR$\u0018N\\4QCJ\fW.T1q+\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0005\u0003\u0015\u0001\u0018M]1n\u0013\tq3F\u0001\u0005QCJ\fW.T1q\u0011!\u0001\u0004A!A!\u0002\u0013I\u0013\u0001\u00054jiRLgn\u001a)be\u0006lW*\u00199!\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0014aB<fS\u001eDGo]\u000b\u0002%!AQ\u0007\u0001B\u0001B\u0003%!#\u0001\u0005xK&<\u0007\u000e^:!\u0011!9\u0004A!b\u0001\n\u0003A\u0014!C5oi\u0016\u00148-\u001a9u+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$A\u0002#pk\ndW\r\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003:\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0005\u0007\u0005\u0002!\t\u0001B\"\u0002\rqJg.\u001b;?)\u0015QB)\u0012$H\u0011\u0015y\u0012\t1\u0001\"\u0011\u00159\u0013\t1\u0001*\u0011\u0015\u0011\u0014\t1\u0001\u0013\u0011\u00159\u0014\t1\u0001:\u0011\u0015I\u0005\u0001\"\u0015K\u0003\u001d\u0001(/\u001a3jGR$\"!O&\t\u000b1C\u0005\u0019\u0001\n\u0002\u0011\u0019,\u0017\r^;sKNDQA\u0014\u0001\u0005R=\u000bAaY8qsR\t!\u0004\u000b\u0002\u0001#B\u0011!+V\u0007\u0002'*\u0011AKB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,T\u00059\tE\u000e\u001d5b\u0007>l\u0007o\u001c8f]R\u0004")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams {
    private final LinearRegression parent;
    private final ParamMap fittingParamMap;
    private final Vector weights;
    private final double intercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    @Override
    public IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public void org$apache$spark$ml$param$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public void org$apache$spark$ml$param$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    public LinearRegression parent() {
        return this.parent;
    }

    @Override
    public ParamMap fittingParamMap() {
        return this.fittingParamMap;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.weights()) + this.intercept();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LinearRegressionModel copy() {
        void var1_1;
        LinearRegressionModel m = new LinearRegressionModel(this.parent(), this.fittingParamMap(), this.weights(), this.intercept());
        Params$.MODULE$.inheritValues(this.paramMap(), this, m);
        return var1_1;
    }

    public LinearRegressionModel(LinearRegression parent, ParamMap fittingParamMap, Vector weights, double intercept) {
        this.parent = parent;
        this.fittingParamMap = fittingParamMap;
        this.weights = weights;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
    }
}

