/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.HasMaxIter$class;
import org.apache.spark.ml.param.HasRegParam$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t\u0001B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qa\u0004E\u0003\u0010!IQ2$D\u0001\u0003\u0013\t\t\"AA\u0005SK\u001e\u0014Xm]:peB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u0011q\u0002\u0001\t\u0003\u001fqI!!\b\u0002\u0003+1Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fYB\u0011qbH\u0005\u0003A\t\u0011a\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003iAQ!\n\u0001\u0005\u0002\u0019\n1b]3u%\u0016<\u0007+\u0019:b[R\u0011q\u0005K\u0007\u0002\u0001!)\u0011\u0006\na\u0001U\u0005)a/\u00197vKB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1Ai\\;cY\u0016DQ!\r\u0001\u0005\u0002I\n!b]3u\u001b\u0006D\u0018\n^3s)\t93\u0007C\u0003*a\u0001\u0007A\u0007\u0005\u0002,k%\u0011a\u0007\f\u0002\u0004\u0013:$\b\"\u0002\u001d\u0001\t#J\u0014!\u0002;sC&tGcA\u000e;\u0005\")1h\u000ea\u0001y\u00059A-\u0019;bg\u0016$\bCA\u001fA\u001b\u0005q$BA \u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u0003z\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000b\r;\u0004\u0019\u0001#\u0002\u0011A\f'/Y7NCB\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0003\u0002\u000bA\f'/Y7\n\u0005%3%\u0001\u0003)be\u0006lW*\u00199)\u0005\u0001Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003!6\u0013a\"\u00117qQ\u0006\u001cu.\u001c9p]\u0016tG\u000f")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams {
    private final IntParam maxIter;
    private final DoubleParam regParam;

    @Override
    public IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public void org$apache$spark$ml$param$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public void org$apache$spark$ml$param$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public LinearRegressionModel train(DataFrame dataset, ParamMap paramMap) {
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset, paramMap);
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? oldDataset.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        LinearRegressionWithSGD lr = new LinearRegressionWithSGD();
        lr.optimizer().setRegParam(BoxesRunTime.unboxToDouble((Object)paramMap.apply(this.regParam()))).setNumIterations(BoxesRunTime.unboxToInt((Object)paramMap.apply(this.maxIter())));
        org.apache.spark.mllib.regression.LinearRegressionModel model = (org.apache.spark.mllib.regression.LinearRegressionModel)lr.run(oldDataset);
        LinearRegressionModel lrm = new LinearRegressionModel(this, paramMap, model.weights(), model.intercept());
        Object object2 = handlePersistence ? oldDataset.unpersist(oldDataset.unpersist$default$1()) : BoxedUnit.UNIT;
        return lrm;
    }

    public LinearRegression() {
        HasRegParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        this.setRegParam(0.1);
        this.setMaxIter(100);
    }
}

