/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.ml.Evaluator;
import org.apache.spark.ml.param.HasLabelCol;
import org.apache.spark.ml.param.HasLabelCol$class;
import org.apache.spark.ml.param.HasRawPredictionCol;
import org.apache.spark.ml.param.HasRawPredictionCol$class;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.Params$class;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\ti\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u00019\u0011\u0002d\u0007\t\u0003\u001fAi\u0011\u0001B\u0005\u0003#\u0011\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011!\u00029be\u0006l\u0017BA\f\u0015\u0005\u0019\u0001\u0016M]1ngB\u00111#G\u0005\u00035Q\u00111\u0003S1t%\u0006<\bK]3eS\u000e$\u0018n\u001c8D_2\u0004\"a\u0005\u000f\n\u0005u!\"a\u0003%bg2\u000b'-\u001a7D_2DQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0016\u0003\u0019\u00022aE\u0014*\u0013\tACCA\u0003QCJ\fW\u000e\u0005\u0002+a9\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyC\u0006\u0003\u00045\u0001\u0001\u0006IAJ\u0001\f[\u0016$(/[2OC6,\u0007\u0005C\u00037\u0001\u0011\u0005q'A\u0007hKRlU\r\u001e:jG:\u000bW.Z\u000b\u0002S!)\u0011\b\u0001C\u0001u\u0005i1/\u001a;NKR\u0014\u0018n\u0019(b[\u0016$\"a\u000f\u001f\u000e\u0003\u0001AQ!\u0010\u001dA\u0002%\nQA^1mk\u0016DQa\u0010\u0001\u0005\u0002\u0001\u000b1b]3u'\u000e|'/Z\"pYR\u00111(\u0011\u0005\u0006{y\u0002\r!\u000b\u0005\u0006\u0007\u0002!\t\u0001R\u0001\fg\u0016$H*\u00192fY\u000e{G\u000e\u0006\u0002<\u000b\")QH\u0011a\u0001S!)q\t\u0001C!\u0011\u0006AQM^1mk\u0006$X\rF\u0002J\u0019R\u0003\"a\u000b&\n\u0005-c#A\u0002#pk\ndW\rC\u0003N\r\u0002\u0007a*A\u0004eCR\f7/\u001a;\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E3\u0011aA:rY&\u00111\u000b\u0015\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQ!\u0016$A\u0002Y\u000b\u0001\u0002]1sC6l\u0015\r\u001d\t\u0003']K!\u0001\u0017\u000b\u0003\u0011A\u000b'/Y7NCBD#\u0001\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u3\u0011AC1o]>$\u0018\r^5p]&\u0011q\f\u0018\u0002\u000f\u00032\u0004\b.Y\"p[B|g.\u001a8u\u0001")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol {
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;
    private final ParamMap paramMap;

    @Override
    public Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public void org$apache$spark$ml$param$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public String getRawPredictionCol() {
        return HasRawPredictionCol$class.getRawPredictionCol(this);
    }

    @Override
    public ParamMap paramMap() {
        return this.paramMap;
    }

    @Override
    public void org$apache$spark$ml$param$Params$_setter_$paramMap_$eq(ParamMap x$1) {
        this.paramMap = x$1;
    }

    @Override
    public Param<?>[] params() {
        return Params$class.params(this);
    }

    @Override
    public void validate(ParamMap paramMap) {
        Params$class.validate(this, paramMap);
    }

    @Override
    public void validate() {
        Params$class.validate(this);
    }

    @Override
    public String explainParams() {
        return Params$class.explainParams(this);
    }

    @Override
    public boolean isSet(Param<?> param) {
        return Params$class.isSet(this, param);
    }

    @Override
    public Param<Object> getParam(String paramName) {
        return Params$class.getParam(this, paramName);
    }

    @Override
    public <T> Params set(Param<T> param, T value) {
        return Params$class.set((Params)this, param, value);
    }

    @Override
    public Params set(String param, Object value) {
        return Params$class.set((Params)this, param, value);
    }

    @Override
    public <T> T get(Param<T> param) {
        return (T)Params$class.get(this, param);
    }

    @Override
    public void checkInputColumn(StructType schema, String colName, DataType dataType) {
        Params$class.checkInputColumn(this, schema, colName, dataType);
    }

    @Override
    public StructType addOutputColumn(StructType schema, String colName, DataType dataType) {
        return Params$class.addOutputColumn(this, schema, colName, dataType);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.get(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setScoreCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset, ParamMap paramMap) {
        String string;
        block4: {
            double d;
            BinaryClassificationMetrics metrics;
            block3: {
                block2: {
                    ParamMap map = this.paramMap().$plus$plus(paramMap);
                    StructType schema = dataset.schema();
                    this.checkInputColumn(schema, map.apply(this.rawPredictionCol()), (DataType)new VectorUDT());
                    this.checkInputColumn(schema, map.apply(this.labelCol()), (DataType)DoubleType$.MODULE$);
                    RDD scoreAndLabels = dataset.select(map.apply(this.rawPredictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{map.apply(this.labelCol())})).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                Object rawPrediction = ((SeqLike)some.get()).apply(0);
                                Object label = ((SeqLike)some.get()).apply(1);
                                if (rawPrediction instanceof Vector) {
                                    Vector vector = (Vector)rawPrediction;
                                    if (label instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(vector.apply(1), d);
                                        return sp2;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
                    String string2 = string = map.apply(this.metricName());
                    if ("areaUnderROC" != null ? !"areaUnderROC".equals(string2) : string2 != null) break block2;
                    d = metrics.areaUnderROC();
                    break block3;
                }
                String string3 = string;
                if ("areaUnderPR" != null ? !"areaUnderPR".equals(string3) : string3 != null) break block4;
                d = metrics.areaUnderPR();
            }
            double metric = d;
            metrics.unpersist();
            return metric;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Does not support metric ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public BinaryClassificationEvaluator() {
        Params$class.$init$(this);
        HasRawPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", new Some((Object)"areaUnderROC"));
    }
}

