/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.HasMaxIter$class;
import org.apache.spark.ml.param.HasRegParam$class;
import org.apache.spark.ml.param.HasThreshold$class;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u001b\t\u0011Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019q\u0002#B\b\u0011%iYR\"\u0001\u0002\n\u0005E\u0011!a\u0006)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00109%\u0011QD\u0001\u0002\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"aD\u0010\n\u0005\u0001\u0012!\u0001\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ng\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\u0012A\u0007\u0005\u0006K\u0001!\tAJ\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0002(Q5\t\u0001\u0001C\u0003*I\u0001\u0007!&A\u0003wC2,X\r\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004E_V\u0014G.\u001a\u0005\u0006c\u0001!\tAM\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014HCA\u00144\u0011\u0015I\u0003\u00071\u00015!\tYS'\u0003\u00027Y\t\u0019\u0011J\u001c;\t\u000ba\u0002A\u0011A\u001d\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\u0005\u001dR\u0004\"B\u00158\u0001\u0004Q\u0003\"\u0002\u001f\u0001\t#j\u0014!\u0002;sC&tGcA\u000e?\r\")qh\u000fa\u0001\u0001\u00069A-\u0019;bg\u0016$\bCA!E\u001b\u0005\u0011%BA\"\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u000b\n\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000b\u001d[\u0004\u0019\u0001%\u0002\u0011A\f'/Y7NCB\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0003\u0002\u000bA\f'/Y7\n\u00055S%\u0001\u0003)be\u0006lW*\u00199)\u0005\u0001y\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003)F\u0013a\"\u00117qQ\u0006\u001cu.\u001c9p]\u0016tG\u000f")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams {
    private final DoubleParam threshold;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public double getThreshold() {
        return HasThreshold$class.getThreshold(this);
    }

    @Override
    public IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public void org$apache$spark$ml$param$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public void org$apache$spark$ml$param$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LogisticRegressionModel train(DataFrame dataset, ParamMap paramMap) {
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset, paramMap);
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? oldDataset.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        LogisticRegressionWithLBFGS lr = new LogisticRegressionWithLBFGS();
        lr.optimizer().setRegParam(BoxesRunTime.unboxToDouble((Object)paramMap.apply(this.regParam()))).setNumIterations(BoxesRunTime.unboxToInt((Object)paramMap.apply(this.maxIter())));
        org.apache.spark.mllib.classification.LogisticRegressionModel oldModel = (org.apache.spark.mllib.classification.LogisticRegressionModel)lr.run(oldDataset);
        LogisticRegressionModel lrm = new LogisticRegressionModel(this, paramMap, oldModel.weights(), oldModel.intercept());
        Object object2 = handlePersistence ? oldDataset.unpersist(oldDataset.unpersist$default$1()) : BoxedUnit.UNIT;
        return lrm;
    }

    public LogisticRegression() {
        HasRegParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasThreshold$class.$init$(this);
        this.setRegParam(0.1);
        this.setMaxIter(100);
        this.setThreshold(0.5);
    }
}

