#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

header = """#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#"""


def _gen_param_code(name, doc, defaultValue):
    """
    Generates Python code for a shared param class.

    :param name: param name
    :param doc: param doc
    :param defaultValue: string representation of the param
    :return: code string
    """
    # TODO: How to correctly inherit instance attributes?
    template = '''class Has$Name(Params):
    """
    Params with $name.
    """

    # a placeholder to make it appear in the generated doc
    $name = Param(Params._dummy(), "$name", "$doc", $defaultValue)

    def __init__(self):
        super(Has$Name, self).__init__()
        #: param for $doc
        self.$name = Param(self, "$name", "$doc", $defaultValue)

    def set$Name(self, value):
        """
        Sets the value of :py:attr:`$name`.
        """
        self.paramMap[self.$name] = value
        return self

    def get$Name(self):
        """
        Gets the value of $name or its default value.
        """
        if self.$name in self.paramMap:
            return self.paramMap[self.$name]
        else:
            return self.$name.defaultValue'''

    upperCamelName = name[0].upper() + name[1:]
    return template \
        .replace("$name", name) \
        .replace("$Name", upperCamelName) \
        .replace("$doc", doc) \
        .replace("$defaultValue", defaultValue)

if __name__ == "__main__":
    print header
    print "\n# DO NOT MODIFY. The code is generated by _gen_shared_params.py.\n"
    print "from pyspark.ml.param import Param, Params\n\n"
    shared = [
        ("maxIter", "max number of iterations", "100"),
        ("regParam", "regularization constant", "0.1"),
        ("featuresCol", "features column name", "'features'"),
        ("labelCol", "label column name", "'label'"),
        ("predictionCol", "prediction column name", "'prediction'"),
        ("inputCol", "input column name", "'input'"),
        ("outputCol", "output column name", "'output'"),
        ("numFeatures", "number of features", "1 << 18")]
    code = []
    for name, doc, defaultValue in shared:
        code.append(_gen_param_code(name, doc, defaultValue))
    print "\n\n\n".join(code)
