/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r%b\u0001\u0002$H\u0001QC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!I\bA!A!\u0002\u0013Q\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!I\u00111\u0004\u0001C\u0002\u0013E\u0011Q\u0004\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002 !I\u0011q\u0007\u0001C\u0002\u0013E\u0011Q\u0004\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002 !I\u00111\b\u0001C\u0002\u0013E\u0011Q\b\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002@!I\u0011Q\n\u0001C\u0002\u0013E\u0011q\n\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002R!I\u0011\u0011\f\u0001C\u0002\u0013E\u00111\f\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002^!I\u0011q\r\u0001C\u0002\u0013E\u0011\u0011\u000e\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002l!I\u0011\u0011\u0012\u0001C\u0002\u0013E\u0011Q\b\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002@!I\u0011Q\u0012\u0001C\u0002\u0013E\u0011q\u0012\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0014\u0001C\u0002\u0013E\u0011Q\b\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002@!I\u0011Q\u0014\u0001C\u0002\u0013E\u0011q\u0012\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0015\u0001C\u0002\u0013E\u0011q\u0012\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011Q\u0015\u0001C\u0002\u0013E\u0011q\u0012\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0016\u0001C\u0002\u0013E\u00111\u0016\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u0002.\"I\u0011Q\u0019\u0001C\u0002\u0013E\u0011q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u0002J\"I\u0011\u0011\u001b\u0001C\u0002\u0013E\u0011q\n\u0005\t\u0003'\u0004\u0001\u0015!\u0003\u0002R!I\u0011Q\u001b\u0001C\u0002\u0013\u0005\u0011q\u001b\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002Z\"I\u0011Q\u001e\u0001C\u0002\u0013E\u0011q\u001e\u0005\t\u0003{\u0004\u0001\u0015!\u0003\u0002r\"I\u0011q \u0001C\u0002\u0013E!\u0011\u0001\u0005\t\u0005\u000b\u0001\u0001\u0015!\u0003\u0003\u0004!I!q\u0001\u0001C\u0002\u0013E\u0011q\n\u0005\t\u0005\u0013\u0001\u0001\u0015!\u0003\u0002R!I!1\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0005\u001b\u0001\u0001\u0015!\u0003\u0002 !I!q\u0002\u0001A\u0002\u0013E!\u0011\u0003\u0005\n\u00053\u0001\u0001\u0019!C\t\u00057A\u0001Ba\n\u0001A\u0003&!1\u0003\u0005\f\u0005S\u0001\u0001\u0019!a\u0001\n#\tY\u000bC\u0006\u0003,\u0001\u0001\r\u00111A\u0005\u0012\t5\u0002b\u0003B\u0019\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[C\u0011Ba\r\u0001\u0001\u0004%\tB!\u000e\t\u0013\t\r\u0003\u00011A\u0005\u0012\t\u0015\u0003\u0002\u0003B%\u0001\u0001\u0006KAa\u000e\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005w\u0002A\u0011\u0003B?\u0011\u001d\u0011I\n\u0001C\t\u00057CqA!-\u0001\t#\u0011\u0019\fC\u0004\u0003B\u0002!\tBa1\t\u000f\te\u0007\u0001\"\u0005\u0003\\\"9!1\u001e\u0001\u0005B\t5x\u0001\u0003By\u000f\"\u0005QJa=\u0007\u000f\u0019;\u0005\u0012A'\u0003v\"9\u0011\u0011B\"\u0005\u0002\tu\bb\u0002B\u0000\u0007\u0012\u00051\u0011\u0001\u0002\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s\u0015\tA\u0015*A\u0002lqMT!AS&\u0002\u000f\rdWo\u001d;fe*\u0011A*T\u0001\ng\u000eDW\rZ;mKJT!AT(\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0002\u0001'\r\u0001Q+\u0017\t\u0003-^k\u0011aR\u0005\u00031\u001e\u0013Q#\u00112tiJ\f7\r\u001e)pIN\fE\u000e\\8dCR|'\u000f\u0005\u0002[;6\t1L\u0003\u0002]\u001b\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002_7\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"!\u00192\u000e\u00035K!aY'\u0003\u0013M\u0003\u0018M]6D_:4\u0017AB:fG6;'\u000f\u0005\u0002bM&\u0011q-\u0014\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006yQ\r_3dkR|'OQ;jY\u0012,'\u000f\u0005\u0002WU&\u00111n\u0012\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'OQ;jY\u0012,'/\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011an^\u0007\u0002_*\u0011\u0001/]\u0001\u0007G2LWM\u001c;\u000b\u0005I\u001c\u0018AC6vE\u0016\u0014h.\u001a;fg*\u0011A/^\u0001\bM\u0006\u0014'/[29\u0015\u00051\u0018AA5p\u0013\tAxN\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u0006q1O\\1qg\"|Go]*u_J,\u0007C\u0001,|\u0013\taxI\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-A\u0003dY>\u001c7\u000eE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rQ*\u0001\u0003vi&d\u0017\u0002BA\u0004\u0003\u0003\u0011Qa\u00117pG.\fa\u0001P5oSRtDCDA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\t\u0003-\u0002AQaX\u0004A\u0002\u0001DQ\u0001Z\u0004A\u0002\u0015DQ\u0001[\u0004A\u0002%DQ\u0001\\\u0004A\u00025DQ!_\u0004A\u0002iDQ!`\u0004A\u0002y\f1#\u0012-F\u0007V#vJU0J\t~\u001bu*\u0016(U\u000bJ+\"!a\b\u0011\t\u0005\u0005\u0012\u0011G\u0007\u0003\u0003GQA!!\n\u0002(\u00051\u0011\r^8nS\u000eTA!!\u000b\u0002,\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0011Q\u0006\u0006\u0003\u0003_\tAA[1wC&!\u00111GA\u0012\u00055\tEo\\7jG&sG/Z4fe\u0006!R\tW#D+R{%kX%E?\u000e{UK\u0014+F%\u0002\n1\u0002\u0015,D?\u000e{UK\u0014+F%\u0006a\u0001KV\"`\u0007>+f\nV#SA\u00059Q.\u0019=Q-\u000e\u001bXCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#BAA#\u0003\u0015\u00198-\u00197b\u0013\u0011\tI%a\u0011\u0003\u0007%sG/\u0001\u0005nCb\u0004fkQ:!\u00035\u0001x\u000eZ!mY>\u001cwJ\u001c)W\u0007V\u0011\u0011\u0011\u000b\t\u0005\u0003\u0003\n\u0019&\u0003\u0003\u0002V\u0005\r#a\u0002\"p_2,\u0017M\\\u0001\u000fa>$\u0017\t\u001c7pG>s\u0007KV\"!\u0003)\"x\u000e^1m\u000bb\u0004Xm\u0019;fI\u0016CXmY;u_J\u001c\b+\u001a:SKN|WO]2f!J|g-\u001b7f\u0013\u0012,\"!!\u0018\u0011\u0011\u0005}\u0013\u0011MA \u0003\u007fi!!a\n\n\t\u0005\r\u0014q\u0005\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\u0018a\u000b;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:QKJ\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0017\n\u001a\u0011\u0002+I\u0004\u0018\n\u001a+p%\u0016\u001cx.\u001e:dKB\u0013xNZ5mKV\u0011\u00111\u000e\t\t\u0003[\n9(a\u0010\u0002|5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0004nkR\f'\r\\3\u000b\t\u0005U\u00141I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA=\u0003_\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t)T\u0001\te\u0016\u001cx.\u001e:dK&!\u0011QQA@\u0005=\u0011Vm]8ve\u000e,\u0007K]8gS2,\u0017A\u0006:q\u0013\u0012$vNU3t_V\u00148-\u001a)s_\u001aLG.\u001a\u0011\u0002#A|G-\u00117m_\u000e\fG/[8o'&TX-\u0001\nq_\u0012\fE\u000e\\8dCRLwN\\*ju\u0016\u0004\u0013A\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf,\"!!%\u0011\t\u0005\u0005\u00131S\u0005\u0005\u0003+\u000b\u0019E\u0001\u0003M_:<\u0017a\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf\u0004\u0013AD7bqB+g\u000eZ5oOB{Gm]\u0001\u0010[\u0006D\b+\u001a8eS:<\u0007k\u001c3tA\u0005\u0011\u0002o\u001c3De\u0016\fG/[8o)&lWm\\;u\u0003M\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;!\u0003e!'/\u001b<feB{GMU3bI&tWm]:US6,w.\u001e;\u00025\u0011\u0014\u0018N^3s!>$'+Z1eS:,7o\u001d+j[\u0016|W\u000f\u001e\u0011\u0002'\u0015DXmY;u_JLE\r\\3US6,w.\u001e;\u0002)\u0015DXmY;u_JLE\r\\3US6,w.\u001e;!\u0003%q\u0017-\\3ta\u0006\u001cW-\u0006\u0002\u0002.B!\u0011qVA_\u001d\u0011\t\t,!/\u0011\t\u0005M\u00161I\u0007\u0003\u0003kS1!a.T\u0003\u0019a$o\\8u}%!\u00111XA\"\u0003\u0019\u0001&/\u001a3fM&!\u0011qXAa\u0005\u0019\u0019FO]5oO*!\u00111XA\"\u0003)q\u0017-\\3ta\u0006\u001cW\rI\u0001\u0018WV\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0004v\u000e\u001a(b[\u0016,\"!!3\u0011\r\u0005\u0005\u00131ZAW\u0013\u0011\ti-a\u0011\u0003\r=\u0003H/[8o\u0003aYWOY3s]\u0016$Xm\u001d#sSZ,'\u000fU8e\u001d\u0006lW\rI\u0001\u0016g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:t\u0003Y\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN\u0004\u0013!\u00033sSZ,'\u000fU8e+\t\tI\u000e\u0005\u0004\u0002B\u0005-\u00171\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003\u0015iw\u000eZ3m\u0015\r\t)/]\u0001\u0004CBL\u0017\u0002BAu\u0003?\u00141\u0001U8e\u0003)!'/\u001b<feB{G\rI\u0001\u0016]\u0016<H._\"sK\u0006$X\rZ#yK\u000e,Ho\u001c:t+\t\t\t\u0010\u0005\u0005\u0002n\u0005M\u0018\u0011SA|\u0013\u0011\t)0a\u001c\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!!\t\t%!?\u0002@\u0005E\u0015\u0002BA~\u0003\u0007\u0012a\u0001V;qY\u0016\u0014\u0014A\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o\u001d\u0011\u0002?M\u001c\u0007.\u001a3vY\u0016\u00148J\\8x]:+w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001c7/\u0006\u0002\u0003\u0004AA\u0011QNAz\u0003#\u000by$\u0001\u0011tG\",G-\u001e7fe.swn\u001e8OK^d\u0017p\u0011:fCR,G-\u0012=fGN\u0004\u0013\u0001\u00073z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0006IB-\u001f8b[&\u001c\u0017\t\u001c7pG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u0003IqW/\\(viN$\u0018M\u001c3j]\u001e\u0004v\u000eZ:\u0002'9,XnT;ugR\fg\u000eZ5oOB{Gm\u001d\u0011\u0002\u00191\f7\u000f^*oCB\u001c\bn\u001c;\u0016\u0005\tM\u0001c\u0001,\u0003\u0016%\u0019!qC$\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003Aa\u0017m\u001d;T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u0003\u001e\t\r\u0002\u0003BA!\u0005?IAA!\t\u0002D\t!QK\\5u\u0011%\u0011)#MA\u0001\u0002\u0004\u0011\u0019\"A\u0002yIE\nQ\u0002\\1tiNs\u0017\r]:i_R\u0004\u0013!B1qa&#\u0017!C1qa&#w\fJ3r)\u0011\u0011iBa\f\t\u0013\t\u0015B'!AA\u0002\u00055\u0016AB1qa&#\u0007%\u0001\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cXC\u0001B\u001c!\u0019\u0011IDa\u0010\u0002\u00126\u0011!1\b\u0006\u0005\u0005{\t\u0019(A\u0005j[6,H/\u00192mK&!!\u0011\tB\u001e\u0005\r\u0019V\r^\u0001\u0017I\u0016dW\r^3e\u000bb,7-\u001e;pe&#7o\u0018\u0013fcR!!Q\u0004B$\u0011%\u0011)cNA\u0001\u0002\u0004\u00119$A\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b\u0005K\u00029\u0005\u001b\u0002B!!\u0011\u0003P%!!\u0011KA\"\u0005!1x\u000e\\1uS2,\u0017!B:uCJ$HC\u0002B\u000f\u0005/\u0012Y\u0006C\u0004\u0003Ze\u0002\r!!,\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u001d\u0011i&\u000fa\u0001\u0005?\n\u0001c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0007Y\u0013\t'C\u0002\u0003d\u001d\u0013\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\f\u0011d]3u)>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgR!!Q\u0004B5\u0011\u001d\u0011YG\u000fa\u0001\u0005[\n1D]3t_V\u00148-\u001a)s_\u001aLG.\u001a+p)>$\u0018\r\\#yK\u000e\u001c\b\u0003CAX\u0005_\nY(a\u0010\n\t\tE\u0014\u0011\u0019\u0002\u0004\u001b\u0006\u0004\u0018!C5t\t\u0016dW\r^3e)\u0011\t\tFa\u001e\t\u000f\te4\b1\u0001\u0002.\u0006QQ\r_3dkR|'/\u00133\u0002\u001d=tg*Z<T]\u0006\u00048\u000f[8ugRA!Q\u0004B@\u0005\u0003\u0013\u0019\tC\u0004\u0003Zq\u0002\r!!,\t\u000f\tuC\b1\u0001\u0003`!9!Q\u0011\u001fA\u0002\t\u001d\u0015!C:oCB\u001c\bn\u001c;t!\u0019\u0011IIa%\u0003\u00149!!1\u0012BH\u001d\u0011\t\u0019L!$\n\u0005\u0005\u0015\u0013\u0002\u0002BI\u0003\u0007\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0016\n]%aA*fc*!!\u0011SA\"\u0003=9W\r\u001e*fkN\f'\r\\3Q-\u000e\u001bHC\u0002BO\u0005S\u0013Y\u000b\u0005\u0004\u0002n\t}%1U\u0005\u0005\u0005C\u000byG\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003;\u0014)+\u0003\u0003\u0003(\u0006}'!\u0006)feNL7\u000f^3oiZ{G.^7f\u00072\f\u0017.\u001c\u0005\b\u00053j\u0004\u0019AAW\u0011\u001d\u0011i+\u0010a\u0001\u0005_\u000b\u0011\u0002\u001d<dg&sWk]3\u0011\r\t%%1SAW\u0003M\u0011X-];fgRtUm^#yK\u000e,Ho\u001c:t))\u0011iB!.\u0003:\nm&q\u0018\u0005\b\u0005os\u0004\u0019AA \u0003YqW/\\#yK\u000e,Ho\u001c:t)>\fE\u000e\\8dCR,\u0007b\u0002B-}\u0001\u0007\u0011Q\u0016\u0005\b\u0005{s\u0004\u0019AA \u0003E\u0011Xm]8ve\u000e,\u0007K]8gS2,\u0017\n\u001a\u0005\b\u0005[s\u0004\u0019\u0001BX\u0003M\u0011X\r\u001d7bG\u0016\u0004fkQ:JM:+W\rZ3e)!\u0011)M!4\u0003R\nU\u0007C\u0002BE\u0005'\u00139\r\u0005\u0003\u0002^\n%\u0017\u0002\u0002Bf\u0003?\u00141\u0002S1t\u001b\u0016$\u0018\rZ1uC\"9!qZ A\u0002\u0005m\u0017a\u00019pI\"9!1[ A\u0002\t\u0015\u0017!\u0003:fg>,(oY3t\u0011\u001d\u00119n\u0010a\u0001\u0005;\u000bAB]3vg\u0006\u0014G.\u001a)W\u0007N\fa#[:Fq\u0016\u001cW\u000f^8s\u0013\u0012dW\rV5nK\u0012|U\u000f\u001e\u000b\u0007\u0003#\u0012iNa:\t\u000f\t}\u0007\t1\u0001\u0003b\u0006)1\u000f^1uKB\u0019aKa9\n\u0007\t\u0015xI\u0001\tFq\u0016\u001cW\u000f^8s!>$7\u000b^1uK\"9!\u0011\u001e!A\u0002\u0005E\u0015aC2veJ,g\u000e\u001e+j[\u0016\fAa\u001d;paR!!Q\u0004Bx\u0011\u001d\u0011I&\u0011a\u0001\u0003[\u000bQ#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'\u000f\u0005\u0002W\u0007N\u00191Ia>\u0011\t\u0005\u0005#\u0011`\u0005\u0005\u0005w\f\u0019E\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005g\f!b\u001d9mSR\u001cFn\u001c;t+\u0011\u0019\u0019a!\u0004\u0015\r\r\u00151qDB\u0013!\u0019\u0011IIa%\u0004\bAA\u0011\u0011IA}\u0007\u0013\ty\u0004\u0005\u0003\u0004\f\r5A\u0002\u0001\u0003\b\u0007\u001f)%\u0019AB\t\u0005\u0005!\u0016\u0003BB\n\u00073\u0001B!!\u0011\u0004\u0016%!1qCA\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0011\u0004\u001c%!1QDA\"\u0005\r\te.\u001f\u0005\b\u0007C)\u0005\u0019AB\u0012\u0003%\u0019wN\\:v[\u0016\u00148\u000f\u0005\u0004\u0003\n\nM5\u0011\u0002\u0005\b\u0007O)\u0005\u0019AA \u0003\u0015\u0019Hn\u001c;t\u0001")
public class ExecutorPodsAllocator
extends AbstractPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicInteger EXECUTOR_ID_COUNTER;
    private final AtomicInteger PVC_COUNTER;
    private final int maxPVCs;
    private final boolean podAllocOnPVC;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final int maxPendingPods;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private String appId;
    private volatile scala.collection.immutable.Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> Seq<Tuple2<T, Object>> splitSlots(Seq<T> seq, int n) {
        return ExecutorPodsAllocator$.MODULE$.splitSlots(seq, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AtomicInteger EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    public AtomicInteger PVC_COUNTER() {
        return this.PVC_COUNTER;
    }

    public int maxPVCs() {
        return this.maxPVCs;
    }

    public boolean podAllocOnPVC() {
        return this.podAllocOnPVC;
    }

    public ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    public HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    public int podAllocationSize() {
        return this.podAllocationSize;
    }

    public long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    public int maxPendingPods() {
        return this.maxPendingPods;
    }

    public long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    public long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    public long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    public String namespace() {
        return this.namespace;
    }

    public Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    public boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    @Override
    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    public LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    public boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    public ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    public void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public scala.collection.immutable.Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    public void deletedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    @Override
    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.appId_$eq(applicationId);
        this.driverPod().foreach((Function1 & Serializable & scala.Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Waitable)((Nameable)this.kubernetesClient.pods().inNamespace(this.namespace())).withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
        if (this.numOutstandingPods().get() == 0) {
            this.snapshotsStore.notifySubscribers();
            return;
        }
    }

    @Override
    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    public void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Received ").append(snapshots.size()).append(" snapshots").toString());
        Seq k8sKnownExecIds = (Seq)((SeqLike)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom())).distinct();
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        Seq k8sKnownPVCNames = (Seq)((SeqLike)((TraversableLike)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Iterable)x$3.executorPods().values().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.pod(), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)pod -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)v -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)v.getPersistentVolumeClaim()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getClaimName())), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.immutable.Set schedulerKnownExecs = ((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$8(x$6)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((TraversableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$7))).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long timeCreated = tuple22._2$mcJ$sp();
                    if (currentTime - timeCreated > this.podCreationTimeout()) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$9 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$15(BoxesRunTime.unboxToLong((Object)x$9)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            scala.collection.immutable.Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds.elem).intersect((GenSet)existingExecs);
        }
        Map notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> !((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$10)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((TraversableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        IntRef totalNotRunningPodCount = IntRef.create((int)0);
        Seq podsToAllocateWithRpId = (Seq)((TraversableLike)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int rpId = tuple2._1$mcI$sp();
                int targetNum = tuple2._2$mcI$sp();
                HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
                int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22(x0$4)));
                Tuple2 tuple22 = ((TraversableLike)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$23(x0$5)))).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(schedulerKnownExecs, x0$6)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
                HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
                HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple23._1();
                HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple23._2();
                IntRef pendingCountForRpId = IntRef.create((int)currentPendingExecutorsForRpId2.size());
                LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$25(rpId, x0$7)));
                LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$26(rpId, x0$8)));
                if (podsForRpId.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(170).append("ResourceProfile Id: ").append(rpId).append(" (").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created)").toString());
                }
                IntRef notRunningPodCountForRpId = IntRef.create((int)(currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()));
                int podCountForRpId = currentRunningCount + notRunningPodCountForRpId.elem;
                if (podCountForRpId > targetNum) {
                    scala.collection.mutable.Iterable pendingToDelete;
                    int excess = podCountForRpId - targetNum;
                    List newlyCreatedToDelete = ((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$28(this, currentTime, x0$9)))).keys().take(excess)).toList();
                    List toDelete = (List)newlyCreatedToDelete.$plus$plus((GenTraversableOnce)(pendingToDelete = (scala.collection.mutable.Iterable)((TraversableLike)((IterableLike)currentPendingExecutorsForRpId2.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$30(x0$10)), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom());
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        _deletedExecutorIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$13 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$33(BoxesRunTime.unboxToLong((Object)x$13)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)newlyCreatedToDelete);
                            pendingCountForRpId$1.elem -= pendingToDelete.size();
                            notRunningPodCountForRpId$1.elem -= toDelete.size();
                        });
                    }
                }
                totalPendingCount$1.elem += pendingCountForRpId.elem;
                totalNotRunningPodCount$1.elem += notRunningPodCountForRpId.elem;
                if (this.log().isDebugEnabled() && snapshots.nonEmpty()) {
                    int outstanding = pendingCountForRpId.elem + newlyCreatedExecutorsForRpId.size();
                    if (currentRunningCount >= targetNum && !this.dynamicAllocationEnabled()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    } else if (newlyCreatedExecutorsForRpId.nonEmpty()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(newlyCreatedExecutorsForRpId.size()).append(" executors for ").append("ResourceProfile Id ").append(rpId).append(" before requesting more.").toString());
                    }
                }
                if (newlyCreatedExecutorsForRpId.isEmpty() && podCountForRpId < targetNum) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)rpId), (Object)BoxesRunTime.boxToInteger((int)podCountForRpId), (Object)BoxesRunTime.boxToInteger((int)targetNum))));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        int remainingSlotFromPendingPods = this.maxPendingPods() - totalNotRunningPodCount.elem;
        if (!(remainingSlotFromPendingPods <= 0 || podsToAllocateWithRpId.size() <= 0 || snapshots.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get())) {
            ExecutorPodsAllocator$.MODULE$.splitSlots(podsToAllocateWithRpId, remainingSlotFromPendingPods).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$36(this, applicationId, k8sKnownPVCNames, x0$11);
                return BoxedUnit.UNIT;
            });
        }
        this.deletedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    public Buffer<PersistentVolumeClaim> getReusablePVCs(String applicationId, Seq<String> pvcsInUse) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && this.driverPod().nonEmpty()) {
            Buffer buffer;
            try {
                Buffer createdPVCs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PersistentVolumeClaimList)((Listable)((Filterable)this.kubernetesClient.persistentVolumeClaims().inNamespace(this.namespace())).withLabel("spark-app-selector", applicationId)).list()).getItems()).asScala();
                long now = Instant.now().toEpochMilli();
                Buffer reusablePVCs = (Buffer)((TraversableLike)createdPVCs.filterNot((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)pvcsInUse.contains((Object)pvc.getMetadata().getName())))).filter((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$getReusablePVCs$2(this, now, pvc)));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Found ").append(reusablePVCs.size()).append(" reusable PVCs from ").append(createdPVCs.size()).append(" PVCs").toString());
                buffer = reusablePVCs;
            }
            catch (KubernetesClientException kubernetesClientException) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot list PVC resources. Please check account permissions.");
                buffer = (Buffer)Buffer$.MODULE$.empty();
            }
            return buffer;
        }
        return (Buffer)Buffer$.MODULE$.empty();
    }

    public void requestNewExecutors(int numExecutorsToAllocate, String applicationId, int resourceProfileId, Seq<String> pvcsInUse) {
        Object object = new Object();
        try {
            Buffer<PersistentVolumeClaim> reusablePVCs = this.getReusablePVCs(applicationId, pvcsInUse);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                if (reusablePVCs.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Wait to reuse one of the existing ").append(this.PVC_COUNTER().get()).append(" PVCs.").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                int newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, Integer.toString(newExecutorId), applicationId, this.driverPod(), resourceProfileId);
                KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
                SparkPod executorPod = resolvedExecutorSpec.pod();
                Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                Seq<HasMetadata> resources = this.replacePVCsIfNeeded(podWithAttachedContainer, resolvedExecutorSpec.executorKubernetesResources(), reusablePVCs);
                Pod createdExecutorPod = (Pod)((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)podWithAttachedContainer)).create();
                try {
                    KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                    ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$14)))).foreach((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$requestNewExecutors$4(this, resource)));
                    this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        ((Deletable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)createdExecutorPod)).delete();
                        throw e;
                    }
                    throw throwable;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Seq<HasMetadata> replacePVCsIfNeeded(Pod pod, Seq<HasMetadata> resources, Buffer<PersistentVolumeClaim> reusablePVCs) {
        Set replacedResources = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$1(this, reusablePVCs, pod, replacedResources, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)resources.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)replacedResources.contains((Object)elem)));
    }

    public boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long creationTime = Instant.parse(state.pod().getMetadata().getCreationTimestamp()).toEpochMilli();
                if (currentTime - creationTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cannot get the creationTimestamp of the pod: ").append(state.pod()).toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void stop(String applicationId) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rp = (ResourceProfile)tuple2._1();
            int numExecs = tuple2._2$mcI$sp();
            $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
            return BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$8(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$15(long x$9) {
        return Long.toString(x$9);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$17(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long execId = tuple2._1$mcJ$sp();
            ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
            int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
            HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        return executorPodState instanceof PodRunning;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$23(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$24(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$25(int rpId$1, Tuple2 x0$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int waitingRpId = tuple2._1$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$26(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            int waitingRpId = tuple2._2$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$28(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$9;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            long createTime = tuple2._2$mcJ$sp();
            return currentTime$1 - createTime > $this.executorIdleTimeout();
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$30(Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            return id;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$33(long x$13) {
        return Long.toString(x$13);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$36(ExecutorPodsAllocator $this, String applicationId$2, Seq k8sKnownPVCNames$1, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            int sharedSlotFromPendingPods = tuple2._2$mcI$sp();
            if (tuple3 != null) {
                int rpId = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int podCountForRpId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int targetNum = BoxesRunTime.unboxToInt((Object)tuple3._3());
                int numMissingPodsForRpId = targetNum - podCountForRpId;
                int numExecutorsToAllocate = package$.MODULE$.min(package$.MODULE$.min(numMissingPodsForRpId, $this.podAllocationSize()), sharedSlotFromPendingPods);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(rpId).append(", target: ").append(targetNum).append(", known: ").append(podCountForRpId).append(", ").append("sharedSlotFromPendingPods: ").append(sharedSlotFromPendingPods).append(".").toString());
                $this.requestNewExecutors(numExecutorsToAllocate, applicationId$2, rpId, (Seq<String>)k8sKnownPVCNames$1);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getReusablePVCs$2(ExecutorPodsAllocator $this, long now$1, PersistentVolumeClaim pvc) {
        return now$1 - Instant.parse(pvc.getMetadata().getCreationTimestamp()).toEpochMilli() > $this.podCreationTimeout();
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$14) {
        String string = x$14.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$requestNewExecutors$4(ExecutorPodsAllocator $this, HasMetadata resource) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && $this.driverPod().nonEmpty()) {
            KubernetesUtils$.MODULE$.addOwnerReference((Pod)$this.driverPod().get(), (Seq<HasMetadata>)((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)));
        }
        PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
        ((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.persistentVolumeClaims().inNamespace($this.namespace())).resource((Object)pvc)).create();
        return $this.PVC_COUNTER().incrementAndGet();
    }

    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$2(PersistentVolumeClaim x2$1, PersistentVolumeClaim p) {
        String string = p.getSpec().getStorageClassName();
        String string2 = x2$1.getSpec().getStorageClassName();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(p.getSpec().getResources().getRequests().get("storage"), x2$1.getSpec().getResources().getRequests().get("storage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$3(PersistentVolumeClaim x2$1, Volume v) {
        if (v.getPersistentVolumeClaim() == null) return false;
        String string = v.getPersistentVolumeClaim().getClaimName();
        String string2 = x2$1.getMetadata().getName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePVCsIfNeeded$1(ExecutorPodsAllocator $this, Buffer reusablePVCs$3, Pod pod$2, Set replacedResources$1, HasMetadata x0$1) {
        HasMetadata hasMetadata = x0$1;
        if (hasMetadata instanceof PersistentVolumeClaim) {
            PersistentVolumeClaim persistentVolumeClaim = (PersistentVolumeClaim)hasMetadata;
            int index = reusablePVCs$3.indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$2(persistentVolumeClaim, p)));
            if (index >= 0) {
                Option volume = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod$2.getSpec().getVolumes()).asScala()).find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$3(persistentVolumeClaim, v)));
                if (volume.nonEmpty()) {
                    PersistentVolumeClaim matchedPVC = (PersistentVolumeClaim)reusablePVCs$3.remove(index);
                    replacedResources$1.add((Object)persistentVolumeClaim);
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Reuse PersistentVolumeClaim ").append(matchedPVC.getMetadata().getName()).toString());
                    ((Volume)volume.get()).getPersistentVolumeClaim().setClaimName(matchedPVC.getMetadata().getName());
                    return;
                }
                return;
            }
            return;
        }
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicInteger(0);
        this.PVC_COUNTER = new AtomicInteger(0);
        this.maxPVCs = Utils$.MODULE$.isDynamicAllocationEnabled(conf) ? BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS())) : conf.getInt(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key(), SchedulerBackendUtils$.MODULE$.DEFAULT_NUMBER_EXECUTORS());
        this.podAllocOnPVC = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_WAIT_TO_REUSE_PVC()));
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.maxPendingPods = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append((String)name).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

