/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u000b\u0017\u0001q\u0011\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f]\u0002!\u0019!C\u0001q!1q\n\u0001Q\u0001\neBq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006E\u0002!Ia\u0019\u0005\u0007\u007f\u0002!\t%!\u0001\b\u0011\u0005%a\u0003#\u0001\u001d\u0003\u00171q!\u0006\f\t\u0002q\ti\u0001\u0003\u00044\u0017\u0011\u0005\u0011q\u0002\u0005\t\u0003#Y!\u0019!C\u0001#\"9\u00111C\u0006!\u0002\u0013\u0011\u0006\u0002CA\u000b\u0017\t\u0007I\u0011A)\t\u000f\u0005]1\u0002)A\u0005%\"A\u0011\u0011D\u0006C\u0002\u0013\u0005\u0011\u000bC\u0004\u0002\u001c-\u0001\u000b\u0011\u0002*\t\u0011\u0005u1B1A\u0005\u0002ECq!a\b\fA\u0003%!KA\fN_VtGOV8mk6,7OR3biV\u0014Xm\u0015;fa*\u0011q\u0003G\u0001\tM\u0016\fG/\u001e:fg*\u0011\u0011DG\u0001\u0004Wb\u001a(BA\u000e\u001d\u0003\u0019!W\r\u001d7ps*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xmE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016,\u001b\u00051\u0012B\u0001\u0017\u0017\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;fa\u0006!1m\u001c8g\u0007\u0001\u0001\"\u0001M\u0019\u000e\u0003aI!A\r\r\u0003\u001d-+(-\u001a:oKR,7oQ8oM\u00061A(\u001b8jiz\"\"!\u000e\u001c\u0011\u0005)\u0002\u0001\"B\u0017\u0003\u0001\u0004y\u0013aE1eI&$\u0018n\u001c8bYJ+7o\\;sG\u0016\u001cX#A\u001d\u0011\u0007iz\u0014)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005y*\u0013AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002C\u001b6\t1I\u0003\u0002E\u000b\u0006)Qn\u001c3fY*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003\u0015.\u000bqAZ1ce&\u001c\u0007HC\u0001M\u0003\tIw.\u0003\u0002O\u0007\nY\u0001*Y:NKR\fG-\u0019;b\u0003Q\tG\rZ5uS>t\u0017\r\u001c*fg>,(oY3tA\u0005Q\u0011mY2fgNlu\u000eZ3\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0004TiJLgnZ\u0001\fC\u000e\u001cWm]:N_\u0012,\u0007%\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u0002^AB\u0011\u0001GX\u0005\u0003?b\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006C\u001e\u0001\r!X\u0001\u0004a>$\u0017\u0001E2p]N$(/^2u->dW/\\3t)\t!\u0017\u0010E\u0002f[Bt!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%t\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\taW%A\u0004qC\u000e\\\u0017mZ3\n\u00059|'\u0001C%uKJ\f'\r\\3\u000b\u00051,\u0003\u0003\u0002\u0013rgZL!A]\u0013\u0003\rQ+\b\u000f\\33!\t\u0011E/\u0003\u0002v\u0007\nYak\u001c7v[\u0016lu.\u001e8u!\t\u0011u/\u0003\u0002y\u0007\n1ak\u001c7v[\u0016DQA\u001f\u0005A\u0002m\f1B^8mk6,7\u000b]3dgB\u0019Q-\u001c?\u0011\u0005Aj\u0018B\u0001@\u0019\u0005QYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fG\u0006\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\t\t\u0019\u0001\u0005\u0003f\u0003\u000b\t\u0015bAA\u0004_\n\u00191+Z9\u0002/5{WO\u001c;W_2,X.Z:GK\u0006$XO]3Ti\u0016\u0004\bC\u0001\u0016\f'\tY1\u0005\u0006\u0002\u0002\f\u0005i\u0001KV\"`\u001f:{F)R'B\u001d\u0012\u000ba\u0002\u0015,D?>su\fR#N\u0003:#\u0005%A\u0002Q-\u000e\u000bA\u0001\u0015,DA\u0005Y\u0001KV\"`!>\u001bFKR%Y\u00031\u0001fkQ0Q\u001fN#f)\u0013-!\u0003=\u0001fkQ0B\u0007\u000e+5kU0N\u001f\u0012+\u0015\u0001\u0005)W\u0007~\u000b5iQ#T'~ku\nR#!\u0001")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;
    private final ArrayBuffer<HasMetadata> additionalResources;
    private final String accessMode;

    public static String PVC_ACCESS_MODE() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE();
    }

    public static String PVC_POSTFIX() {
        return MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX();
    }

    public static String PVC() {
        return MountVolumesFeatureStep$.MODULE$.PVC();
    }

    public static String PVC_ON_DEMAND() {
        return MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND();
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    public ArrayBuffer<HasMetadata> additionalResources() {
        return this.additionalResources;
    }

    public String accessMode() {
        return this.accessMode;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes((Iterable<KubernetesVolumeSpec>)this.conf.volumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable volumeMounts = (Iterable)tuple2._1();
        Iterable volumes = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
        Iterable volumeMounts2 = (Iterable)tuple22._1();
        Iterable volumes2 = (Iterable)tuple22._2();
        Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
        Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
        return new SparkPod(podWithVolumes, containerWithVolumeMounts);
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec> volumeSpecs) {
        scala.collection.immutable.Iterable duplicateMountPaths = (scala.collection.immutable.Iterable)((TraversableOnce)volumeSpecs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.mountPath(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String x = (String)A1._1();
                    Seq ys = (Seq)A1._2();
                    if (ys.length() > 1) {
                        return (B1)new StringBuilder(2).append("'").append(x).append("'").toString();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                Seq ys;
                Tuple2<String, Seq<String>> tuple2 = x1;
                return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(duplicateMountPaths.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Found duplicated mountPath: ").append(duplicateMountPaths.mkString(", ")).toString());
        return (Iterable)((TraversableLike)volumeSpecs.zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                VolumeBuilder volumeBuilder;
                KubernetesVolumeSpec spec = (KubernetesVolumeSpec)tuple2._1();
                int i = tuple2._2$mcI$sp();
                VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withSubPath(spec.mountSubPath())).withName(spec.volumeName())).build();
                KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf = spec.volumeConf();
                if (kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf) {
                    KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
                    String hostPath = kubernetesHostPathVolumeConf.hostPath();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath, ""));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf) {
                    String claimName;
                    String string;
                    KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
                    String claimNameTemplate = kubernetesPVCVolumeConf.claimName();
                    Option<String> storageClass = kubernetesPVCVolumeConf.storageClass();
                    Option<String> size = kubernetesPVCVolumeConf.size();
                    KubernetesConf kubernetesConf = $this.conf;
                    if (kubernetesConf instanceof KubernetesExecutorConf) {
                        KubernetesExecutorConf kubernetesExecutorConf = (KubernetesExecutorConf)kubernetesConf;
                        string = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(7).append($this.conf.resourceNamePrefix()).append("-exec-").append(kubernetesExecutorConf.executorId()).append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString()).replaceAll(Constants$.MODULE$.ENV_EXECUTOR_ID(), kubernetesExecutorConf.executorId());
                    } else {
                        string = claimName = claimNameTemplate.replaceAll(MountVolumesFeatureStep$.MODULE$.PVC_ON_DEMAND(), new StringBuilder(8).append($this.conf.resourceNamePrefix()).append("-driver").append(MountVolumesFeatureStep$.MODULE$.PVC_POSTFIX()).append("-").append(i).toString());
                    }
                    if (storageClass.isDefined() && size.isDefined()) {
                        this.additionalResources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HasMetadata[]{((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluentImpl)((PersistentVolumeClaimFluentImpl)new PersistentVolumeClaimBuilder().withKind(MountVolumesFeatureStep$.MODULE$.PVC())).withApiVersion("v1")).withNewMetadata().withName(claimName).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.conf.appId())).endMetadata()).withNewSpec().withStorageClassName((String)storageClass.get()).withAccessModes(new String[]{this.accessMode()}).withResources(((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withRequests((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storage"), (Object)new Quantity((String)size.get()))}))).asJava())).build())).endSpec()).build()}));
                    }
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf) {
                    KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
                    Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                    Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Quantity)sizeLimit.map((Function1 & Serializable & scala.Serializable)x$3 -> new Quantity(x$3)).orNull(Predef$.MODULE$.$conforms())));
                } else if (kubernetesVolumeSpecificConf instanceof KubernetesNFSVolumeConf) {
                    KubernetesNFSVolumeConf kubernetesNFSVolumeConf = (KubernetesNFSVolumeConf)kubernetesVolumeSpecificConf;
                    String path = kubernetesNFSVolumeConf.path();
                    String server = kubernetesNFSVolumeConf.server();
                    volumeBuilder = (VolumeBuilder)new VolumeBuilder().withNfs(new NFSVolumeSource(path, null, server));
                } else {
                    throw new MatchError((Object)kubernetesVolumeSpecificConf);
                }
                VolumeBuilder volumeBuilder2 = volumeBuilder;
                Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
                return new Tuple2((Object)volumeMount, (Object)volume);
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return this.additionalResources().toSeq();
    }

    public MountVolumesFeatureStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.additionalResources = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.accessMode = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_USE_LEGACY_PVC_ACCESS_MODE())) ? "ReadWriteOnce" : MountVolumesFeatureStep$.MODULE$.PVC_ACCESS_MODE();
    }
}

