/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Stable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@Stable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)!\b\u0001C\u0001w!Iq\b\u0001a\u0001\u0002\u0004%I\u0001\u0011\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\n%C\u0011b\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B!\t\u000bA\u0003A\u0011A)\t\u000b!\u0004A\u0011A5\u0007\t-\u0004A\u0001\u001c\u0005\u0006u%!\tA \u0005\b\u0003\u0007IA\u0011IA\u0003\u0011\u001d\ti#\u0003C!\u0003_\u0011q$\u0012=fGV$xN\u001d)pIN<\u0016\r^2i':\f\u0007o\u001d5piN{WO]2f\u0015\ty\u0001#A\u0002lqMT!!\u0005\n\u0002\u000f\rdWo\u001d;fe*\u00111\u0003F\u0001\ng\u000eDW\rZ;mKJT!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tQ3&D\u0001\u000f\u0013\tacB\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0007G2LWM\u001c;\u000b\u0005M\"\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011QGN\u0001\bM\u0006\u0014'/[29\u0015\u00059\u0014AA5p\u0013\tI\u0004G\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u00061A(\u001b8jiz\"2\u0001P\u001f?!\tQ\u0003\u0001C\u0003)\u0007\u0001\u0007\u0011\u0006C\u0003.\u0007\u0001\u0007a&A\bxCR\u001c\u0007nQ8o]\u0016\u001cG/[8o+\u0005\t\u0005C\u0001\"G\u001b\u0005\u0019%BA\u001cE\u0015\u0005)\u0015\u0001\u00026bm\u0006L!aR\"\u0003\u0013\rcwn]3bE2,\u0017aE<bi\u000eD7i\u001c8oK\u000e$\u0018n\u001c8`I\u0015\fHC\u0001&N!\ti2*\u0003\u0002M=\t!QK\\5u\u0011\u001dqU!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003A9\u0018\r^2i\u0007>tg.Z2uS>t\u0007%A\u0003ti\u0006\u0014H\u000f\u0006\u0002K%\")1k\u0002a\u0001)\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012\u0004\"!\u0016/\u000f\u0005YS\u0006CA,\u001f\u001b\u0005A&BA-\u001b\u0003\u0019a$o\\8u}%\u00111LH\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\=!\u001aq\u0001\u00194\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r$\u0012AC1o]>$\u0018\r^5p]&\u0011QM\u0019\u0002\u0006'&t7-Z\u0011\u0002O\u0006)1GL\u0019/g\u0005!1\u000f^8q)\u0005Q\u0005f\u0001\u0005aM\n\u0019R\t_3dkR|'\u000fU8eg^\u000bGo\u00195feN\u0019\u0011\"\\:\u0011\u00059\fX\"A8\u000b\u0005A$\u0015\u0001\u00027b]\u001eL!A]8\u0003\r=\u0013'.Z2u!\ryCO^\u0005\u0003kB\u0012qaV1uG\",'\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006)Qn\u001c3fY*\u00111PM\u0001\u0004CBL\u0017BA?y\u0005\r\u0001v\u000e\u001a\u000b\u0002\u007fB\u0019\u0011\u0011A\u0005\u000e\u0003\u0001\tQ\"\u001a<f]R\u0014VmY3jm\u0016$G#\u0002&\u0002\b\u0005%\u0002bBA\u0005\u0017\u0001\u0007\u00111B\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\u00055\u00111\u0005\b\u0005\u0003\u001f\tyB\u0004\u0003\u0002\u0012\u0005ua\u0002BA\n\u00037qA!!\u0006\u0002\u001a9\u0019q+a\u0006\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014BA\u00193\u0013\r\t\t\u0003M\u0001\b/\u0006$8\r[3s\u0013\u0011\t)#a\n\u0003\r\u0005\u001bG/[8o\u0015\r\t\t\u0003\r\u0005\u0007\u0003WY\u0001\u0019\u0001<\u0002\u0007A|G-A\u0004p]\u000ecwn]3\u0015\u0007)\u000b\t\u0004C\u0004\u000241\u0001\r!!\u000e\u0002\u0003\u0015\u00042aLA\u001c\u0013\r\tI\u0004\r\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\u0005pY3qi&|g\u000eK\u0002\u0001\u0003{\u00012!YA \u0013\r\t\tE\u0019\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0004\u0001\u0005\u0015\u0003cA1\u0002H%\u0019\u0011\u0011\n2\u0003\rM#\u0018M\u00197f\u0001")
public class ExecutorPodsWatchSnapshotSource
implements Logging {
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore;
    private final KubernetesClient kubernetesClient;
    private Closeable watchConnection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Closeable watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Closeable x$1) {
        this.watchConnection = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.watchConnection() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start the watcher twice.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Starting watch for pods with labels ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append("=").append(applicationId).append(",").append(" ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append("=").append(Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).append(".").toString());
        this.watchConnection_$eq((Closeable)((Watchable)((Filterable)this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).watch((Object)new ExecutorPodsWatcher()));
    }

    public void stop() {
        block0: {
            if (this.watchConnection() == null) break block0;
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.watchConnection().close());
            this.watchConnection_$eq(null);
        }
    }

    public ExecutorPodsWatchSnapshotSource(ExecutorPodsSnapshotsStore snapshotsStore, KubernetesClient kubernetesClient) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore = snapshotsStore;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
    }

    public class ExecutorPodsWatcher
    implements Watcher<Pod> {
        public void eventReceived(Watcher.Action action, Pod pod) {
            String podName = pod.getMetadata().getName();
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received executor pod update for pod named ").append(podName).append(", action ").append(action).toString());
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore.updatePod(pod);
        }

        public void onClose(KubernetesClientException e) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed (this is expected if the application is shutting down.)", (Throwable)e);
        }

        public /* synthetic */ ExecutorPodsWatchSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer() {
            return ExecutorPodsWatchSnapshotSource.this;
        }

        public ExecutorPodsWatcher() {
            if (ExecutorPodsWatchSnapshotSource.this == null) {
                throw null;
            }
        }
    }
}

