/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Patchable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg!\u0002\u000f\u001e\u0001\rJ\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000bC\u0003f\u0001\u0011\u0005a\r\u0003\u0005m\u0001!\u0015\r\u0011\"\u0003n\u0011!\t\b\u0001#b\u0001\n\u0013\u0011\bbB;\u0001\u0001\u0004%IA\u001d\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u0019i\b\u0001)Q\u0005g\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\t\u0001\u0001\u0006I!!\u0001\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u0011Q\u0018\u0001\u0005\n\u0005}vaBAc;!%\u0011q\u0019\u0004\u00079uAI!!3\t\r\u0015DB\u0011AAf\u0011%\ti\r\u0007b\u0001\n\u0003\ty\r\u0003\u0005\u0002Rb\u0001\u000b\u0011BAY\u0005q)\u00050Z2vi>\u0014\bk\u001c3t\u0019&4WmY=dY\u0016l\u0015M\\1hKJT!AH\u0010\u0002\u0007-D4O\u0003\u0002!C\u000591\r\\;ti\u0016\u0014(B\u0001\u0012$\u0003%\u00198\r[3ek2,'O\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u001a\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005U\u0012$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0016\u0003e\u0002\"AO\u001e\u000e\u0003\rJ!\u0001P\u0012\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2p]\u001a\u0004\u0013\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t\u0001\u0015*D\u0001B\u0015\t\u00115)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\t\u0016\u000b!b[;cKJtW\r^3t\u0015\t1u)A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003!\u000b!![8\n\u0005)\u000b%\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u0004\"!\u0014(\u000e\u0003uI!aT\u000f\u00035\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8ugN#xN]3\u0002+I,Wn\u001c<fI\u0016CXmY;u_J\u001c8)Y2iKB!!kW/^\u001b\u0005\u0019&B\u0001+V\u0003\u0015\u0019\u0017m\u00195f\u0015\t1v+\u0001\u0004d_6lwN\u001c\u0006\u00031f\u000baaZ8pO2,'\"\u0001.\u0002\u0007\r|W.\u0003\u0002]'\n)1)Y2iKB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&\u0001\u0002'p]\u001e\fa\u0001P5oSRtD#B4iS*\\\u0007CA'\u0001\u0011\u00151d\u00011\u0001:\u0011\u0015qd\u00011\u0001@\u0011\u0015Ye\u00011\u0001M\u0011\u0015\u0001f\u00011\u0001R\u0003U\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN,\u0012A\u001c\t\u0003W=L!\u0001\u001d\u0017\u0003\u000f\t{w\u000e\\3b]\u0006)R.[:tS:<\u0007k\u001c3EKR,7\r\u001e#fYR\fW#A:\u0011\u0005-\"\u0018B\u00013-\u0003Ia\u0017m\u001d;Gk2d7K\\1qg\"|G\u000fV:\u0002-1\f7\u000f\u001e$vY2\u001cf.\u00199tQ>$Hk]0%KF$\"\u0001_>\u0011\u0005-J\u0018B\u0001>-\u0005\u0011)f.\u001b;\t\u000fqT\u0011\u0011!a\u0001g\u0006\u0019\u0001\u0010J\u0019\u0002'1\f7\u000f\u001e$vY2\u001cf.\u00199tQ>$Hk\u001d\u0011\u0002\u001f%t\u0017m\u0019;jm\u0006$X\r\u001a)pIN,\"!!\u0001\u0011\u000b\u0005\r\u0011QB:\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tq!\\;uC\ndWMC\u0002\u0002\f1\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty!!\u0002\u0003\u000f!\u000b7\u000f[*fi\u0006\u0001\u0012N\\1di&4\u0018\r^3e!>$7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0004q\u0006]\u0001bBA\r\u001d\u0001\u0007\u00111D\u0001\u0011g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u00042!TA\u000f\u0013\r\ty\"\b\u0002\"\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0001\u000f_:tUm^*oCB\u001c\bn\u001c;t)\u0015A\u0018QEA\u0014\u0011\u001d\tIb\u0004a\u0001\u00037Aq!!\u000b\u0010\u0001\u0004\tY#A\u0005t]\u0006\u00048\u000f[8ugB1\u0011QFA\u001f\u0003\u0007rA!a\f\u0002:9!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026]\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0007\u0005mB&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0012\u0011\t\u0002\u0004'\u0016\f(bAA\u001eYA\u0019Q*!\u0012\n\u0007\u0005\u001dSD\u0001\u000bFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^\u0001\u0017_:4\u0015N\\1m\u001d>tG)\u001a7fi\u0016$7\u000b^1uKRIa.!\u0014\u0002X\u0005m\u0013Q\f\u0005\b\u0003\u001f\u0002\u0002\u0019AA)\u0003!\u0001x\u000eZ*uCR,\u0007cA'\u0002T%\u0019\u0011QK\u000f\u0003\u001b\u0019Kg.\u00197Q_\u0012\u001cF/\u0019;f\u0011\u0019\tI\u0006\u0005a\u0001g\u00061Q\r_3d\u0013\u0012Dq!!\u0007\u0011\u0001\u0004\tY\u0002\u0003\u0004\u0002`A\u0001\rA\\\u0001\u000eI\u0016dW\r^3Ge>l7\nO:\u0002+I,Wn\u001c<f\u000bb,7-\u001e;pe\u001a\u0013x.\\&9gR)\u00010!\u001a\u0002h!1\u0011\u0011L\tA\u0002MDq!!\u001b\u0012\u0001\u0004\tY'\u0001\u0006va\u0012\fG/\u001a3Q_\u0012\u0004B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0003n_\u0012,GNC\u0002\u0002v\r\u000b1!\u00199j\u0013\u0011\tI(a\u001c\u0003\u0007A{G-A\fsK6|g/Z#yK\u000e,Ho\u001c:Ge>l7\u000b]1sWR9a.a \u0002\u0002\u0006\r\u0005bBA\r%\u0001\u0007\u00111\u0004\u0005\b\u0003\u001f\u0012\u0002\u0019AA)\u0011\u0019\tIF\u0005a\u0001g\u0006qa-\u001b8e\u000bbLGOU3bg>tGCBAE\u0003#\u000b\u0019\n\u0005\u0003\u0002\f\u00065U\"A\u0011\n\u0007\u0005=\u0015E\u0001\bFq\u0016\u001cW\u000f^8s\u000bbLG/\u001a3\t\u000f\u0005=3\u00031\u0001\u0002R!1\u0011\u0011L\nA\u0002M\f\u0011#\u001a=jiJ+\u0017m]8o\u001b\u0016\u001c8/Y4f)!\tI*!+\u0002,\u00065\u0006\u0003BAN\u0003GsA!!(\u0002 B\u0019\u0011\u0011\u0007\u0017\n\u0007\u0005\u0005F&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\u000b9K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Cc\u0003bBA()\u0001\u0007\u0011\u0011\u000b\u0005\u0007\u00033\"\u0002\u0019A:\t\u000f\u0005=F\u00031\u0001\u00022\u0006AQ\r_5u\u0007>$W\rE\u0002,\u0003gK1!!.-\u0005\rIe\u000e^\u0001\rM&tG-\u0012=ji\u000e{G-\u001a\u000b\u0005\u0003c\u000bY\fC\u0004\u0002PU\u0001\r!!\u0015\u0002\u001b%\u001c\bk\u001c3J]\u0006\u001cG/\u001b<f)\rq\u0017\u0011\u0019\u0005\b\u0003\u00074\u0002\u0019AA6\u0003\r\u0001x\u000eZ\u0001\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s!\ti\u0005d\u0005\u0002\u0019UQ\u0011\u0011qY\u0001\u0012+:[ejT,O?\u0016C\u0016\nV0D\u001f\u0012+UCAAY\u0003I)fj\u0013(P/:{V\tW%U?\u000e{E)\u0012\u0011")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private long lastFullSnapshotTs;
    private final HashSet<Object> inactivatedPods;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldDeleteExecutors$lzycompute() : this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.missingPodDetectDelta$lzycompute() : this.missingPodDetectDelta;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (this.inactivatedPods().nonEmpty() && snapshots.nonEmpty()) {
                this.inactivatedPods().retain((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2)));
            }
            if (!snapshots.nonEmpty() || this.lastFullSnapshotTs() == ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) break block1;
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            scala.collection.immutable.Map lostExecutorsWithRegistrationTs = (scala.collection.immutable.Map)((Subtractable)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString((String)t._1())).toLong(), t._2$mcJ$sp()), Map$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$9(this, schedulerBackend, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                block0: {
                    if (!this.shouldDeleteExecutors()) break block0;
                    ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete();
                    break block1;
                }
                if (this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) || this.isPodInactive(updatedPod)) break block1;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Marking executor ").append(updatedPod.getMetadata().getName()).append(" as inactive since ").append("deletion is disabled.").toString());
                Pod inactivatedPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(updatedPod).editMetadata().addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL()), (Object)"true")}))).asJava())).endMetadata()).build();
                ((Patchable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).patch((Object)inactivatedPod);
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        boolean bl;
        if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(reason.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following message: ").append(message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HashSet hashSet;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    }
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else if (executorPodState instanceof PodSucceeded) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(((Object)BoxesRunTime.boxToLong((long)execId)).toString())) {
                            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else {
                    hashSet = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$9(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = new StringBuilder(276).append("The executor with ID ").append(lostExecId).append(" (registered at ").append(lostExecRegistrationTs).append(" ms) was not found in the cluster at the polling time ").append("(").append($this.lastFullSnapshotTs()).append(" ms) which is after the accepted detect delta time ").append("(").append($this.missingPodDetectDelta()).append(" ms) configured by ").append("`").append(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key()).append("`. ").append("The executor may have been deleted but the driver missed the deletion event. ").append("Marking this executor as failed.").toString();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)lostExecId)).toString(), (ExecutorLossReason)exitReason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.lastFullSnapshotTs = 0L;
        this.inactivatedPods = HashSet$.MODULE$.empty();
    }
}

