/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!\u0002\f\u0018\u0001e\u0019\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000bq\u0002A\u0011A\u001f\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1q\n\u0001Q\u0001\n\tCq\u0001\u0015\u0001A\u0002\u0013%\u0011\u000bC\u0004W\u0001\u0001\u0007I\u0011B,\t\ru\u0003\u0001\u0015)\u0003S\u0011\u001dq\u0006\u00011A\u0005\nECqa\u0018\u0001A\u0002\u0013%\u0001\r\u0003\u0004c\u0001\u0001\u0006KA\u0015\u0005\bG\u0002\u0001\r\u0011\"\u0003e\u0011\u001d1\b\u00011A\u0005\n]Da!\u001f\u0001!B\u0013)\u0007\"\u0002>\u0001\t\u0013\t\u0005\"B>\u0001\t\u0003b\b\"B?\u0001\t\u0003r\bbBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\u0007\u0003o\u0001A\u0011\u0002?\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!1\u0011Q\b\u0001\u0005\nqDq!a\u0010\u0001\t\u0003\n\tEA\u000eM_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195fe&k\u0007\u000f\u001c\u0006\u00031e\taa];c[&$(B\u0001\u000e\u001c\u0003\rY\u0007h\u001d\u0006\u00039u\ta\u0001Z3qY>L(B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0014\t\u0001!C\u0006\r\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019y%M[3diB\u0011QFL\u0007\u0002/%\u0011qf\u0006\u0002\u0018\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ\u0004\"!\r\u001b\u000e\u0003IR!aM\u000f\u0002\u0011%tG/\u001a:oC2L!!\u000e\u001a\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"!\u000f\u001e\u000e\u0003eI!aO\r\u0003)-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011ah\u0010\t\u0003[\u0001AQA\u000e\u0002A\u0002a\nQ!\u00199q\u0013\u0012,\u0012A\u0011\t\u0003\u00072s!\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d;\u0014A\u0002\u001fs_>$hHC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&I\u0003\u0019\t\u0007\u000f]%eA\u0005a\u0001o\u001c3D_6\u0004H.\u001a;fIV\t!\u000b\u0005\u0002T)6\t\u0001*\u0003\u0002V\u0011\n9!i\\8mK\u0006t\u0017\u0001\u00059pI\u000e{W\u000e\u001d7fi\u0016$w\fJ3r)\tA6\f\u0005\u0002T3&\u0011!\f\u0013\u0002\u0005+:LG\u000fC\u0004]\r\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0013'A\u0007q_\u0012\u001cu.\u001c9mKR,G\rI\u0001\u0017e\u0016\u001cx.\u001e:dKR{wn\u00147e%\u0016\u001cW-\u001b<fI\u0006Q\"/Z:pkJ\u001cW\rV8p\u001f2$'+Z2fSZ,Gm\u0018\u0013fcR\u0011\u0001,\u0019\u0005\b9&\t\t\u00111\u0001S\u0003]\u0011Xm]8ve\u000e,Gk\\8PY\u0012\u0014VmY3jm\u0016$\u0007%A\u0002q_\u0012,\u0012!\u001a\t\u0004'\u001aD\u0017BA4I\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000e^\u0007\u0002U*\u00111\u000e\\\u0001\u0006[>$W\r\u001c\u0006\u0003[:\f1!\u00199j\u0015\ty\u0007/\u0001\u0006lk\n,'O\\3uKNT!!\u001d:\u0002\u000f\u0019\f'M]5dq)\t1/\u0001\u0002j_&\u0011QO\u001b\u0002\u0004!>$\u0017a\u00029pI~#S-\u001d\u000b\u00031bDq\u0001\u0018\u0007\u0002\u0002\u0003\u0007Q-\u0001\u0003q_\u0012\u0004\u0013!\u00029iCN,\u0017!\u0002:fg\u0016$H#\u0001-\u0002\u001b\u00154XM\u001c;SK\u000e,\u0017N^3e)\u0011Av0!\n\t\u000f\u0005\u0005\u0001\u00031\u0001\u0002\u0004\u00051\u0011m\u0019;j_:\u0004B!!\u0002\u0002 9!\u0011qAA\r\u001d\u0011\tI!!\u0006\u000f\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\t\tBD\u0002F\u0003\u001fI\u0011a]\u0005\u0003cJL!a\u001c9\n\u0007\u0005]a.\u0001\u0004dY&,g\u000e^\u0005\u0005\u00037\ti\"A\u0004XCR\u001c\u0007.\u001a:\u000b\u0007\u0005]a.\u0003\u0003\u0002\"\u0005\r\"AB!di&|gN\u0003\u0003\u0002\u001c\u0005u\u0001\"B2\u0011\u0001\u0004A\u0017aB8o\u00072|7/\u001a\u000b\u00041\u0006-\u0002bBA\u0017#\u0001\u0007\u0011qF\u0001\u0002KB!\u0011\u0011GA\u001a\u001b\t\ti\"\u0003\u0003\u00026\u0005u!!G&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u000bb\u001cW\r\u001d;j_:\fQ\u0002\\8h\u0019>twm\u0015;biV\u001c\u0018\u0001\u00045bg\u000e{W\u000e\u001d7fi\u0016$G#\u0001*\u0002\u0015\rdwn]3XCR\u001c\u0007.A\u0006xCR\u001c\u0007n\u0014:Ti>\u0004Hc\u0001*\u0002D!1\u0011QI\u000bA\u0002\t\u000b1a]%e\u0001")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final KubernetesDriverConf conf;
    private final String appId;
    private boolean podCompleted;
    private boolean resourceTooOldReceived;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private boolean podCompleted() {
        return this.podCompleted;
    }

    private void podCompleted_$eq(boolean x$1) {
        this.podCompleted = x$1;
    }

    private boolean resourceTooOldReceived() {
        return this.resourceTooOldReceived;
    }

    private void resourceTooOldReceived_$eq(boolean x$1) {
        this.resourceTooOldReceived = x$1;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown");
    }

    @Override
    public void reset() {
        this.resourceTooOldReceived_$eq(false);
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(KubernetesClientException e) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append(this.appId()).append(" with last-observed phase ").append(this.phase()).toString());
        if (e != null && e.getCode() == 410) {
            this.resourceTooOldReceived_$eq(true);
            this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Got HTTP Gone code, resource version changed in k8s api: ").append(e).toString());
        } else {
            this.closeWatch();
        }
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & java.io.Serializable & Serializable)pod -> KubernetesUtils$.MODULE$.formatPodState((Pod)pod)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private synchronized void closeWatch() {
        this.podCompleted_$eq(true);
        this.notifyAll();
    }

    @Override
    public boolean watchOrStop(String sId) {
        boolean bl;
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()))) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Waiting for application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" to finish...").toString());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf.get(Config$.MODULE$.REPORT_INTERVAL()));
            LoggingPodStatusWatcherImpl loggingPodStatusWatcherImpl = this;
            synchronized (loggingPodStatusWatcherImpl) {
                while (!this.podCompleted() && !this.resourceTooOldReceived()) {
                    this.wait(interval);
                    this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Application status for ").append(this.appId()).append(" (phase: ").append(this.phase()).append(")").toString());
                }
            }
            if (this.podCompleted()) {
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> (String)this.pod().map((Function1 & java.io.Serializable & Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(KubernetesUtils$.MODULE$.containersDescription((Pod)p, KubernetesUtils$.MODULE$.containersDescription$default$2())).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "No containers were found in the driver pod."));
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append("Application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" finished").toString());
            }
            bl = this.podCompleted();
        } else {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(63).append("Deployed Spark application ").append($this.conf.appName()).append(" with submission ID ").append(sId).append(" into Kubernetes").toString());
            bl = true;
        }
        return bl;
    }

    public LoggingPodStatusWatcherImpl(KubernetesDriverConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.appId = conf.appId();
        this.podCompleted = false;
        this.resourceTooOldReceived = false;
        this.pod = Option$.MODULE$.empty();
    }
}

