/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.spark.SparkException;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.client.package;
import org.apache.spark.sql.hive.client.package$hive$;
import org.apache.spark.sql.hive.client.package$hive$v12$;
import org.apache.spark.sql.hive.client.package$hive$v13$;
import org.apache.spark.sql.hive.client.package$hive$v14$;
import org.apache.spark.sql.hive.client.package$hive$v1_0$;
import org.apache.spark.sql.hive.client.package$hive$v1_1$;
import org.apache.spark.sql.hive.client.package$hive$v1_2$;
import org.apache.spark.sql.hive.client.package$hive$v2_0$;
import org.apache.spark.sql.hive.client.package$hive$v2_1$;
import org.apache.spark.sql.hive.execution.HiveFileFormat;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable$;
import org.apache.spark.sql.internal.SessionState;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0001\u0003\u0001>\u00111#\u00138tKJ$\u0018J\u001c;p\u0011&4X\rV1cY\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\u0011A\u0017N^3\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"$I\u0014\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00111+\u0017M\u001a(pI\u0016\u0004\"aG\u0010\u000e\u0003qQ!!\b\u0010\u0002\u000f\r|W.\\1oI*\u00111AB\u0005\u0003Aq\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\b!J|G-^2u!\t\u0011\u0003&\u0003\u0002*G\ta1+\u001a:jC2L'0\u00192mK\"A1\u0006\u0001BK\u0002\u0013\u0005A&A\u0003uC\ndW-F\u0001.!\tq\u0013'D\u00010\u0015\t\u0001d#A\u0004dCR\fGn\\4\n\u0005Iz#\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0017\u0002\rQ\f'\r\\3!\u0011!1\u0004A!f\u0001\n\u00039\u0014!\u00039beRLG/[8o+\u0005A\u0004\u0003B\u001d=\u007f\ts!A\t\u001e\n\u0005m\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t\u0019Q*\u00199\u000b\u0005m\u001a\u0003CA\u001dA\u0013\t\teH\u0001\u0004TiJLgn\u001a\t\u0004E\r{\u0014B\u0001#$\u0005\u0019y\u0005\u000f^5p]\"Aa\t\u0001B\tB\u0003%\u0001(\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!S\u0001\u0006cV,'/_\u000b\u0002\u0015B\u0011\u0011cS\u0005\u0003\u0019J\u00111\u0002T8hS\u000e\fG\u000e\u00157b]\"Aa\n\u0001B\tB\u0003%!*\u0001\u0004rk\u0016\u0014\u0018\u0010\t\u0005\t!\u0002\u0011)\u001a!C\u0001#\u0006IqN^3soJLG/Z\u000b\u0002%B\u0011!eU\u0005\u0003)\u000e\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005W\u0001\tE\t\u0015!\u0003S\u0003)yg/\u001a:xe&$X\r\t\u0005\t1\u0002\u0011)\u001a!C\u0001#\u0006!\u0012N\u001a)beRLG/[8o\u001d>$X\t_5tiND\u0001B\u0017\u0001\u0003\u0012\u0003\u0006IAU\u0001\u0016S\u001a\u0004\u0016M\u001d;ji&|gNT8u\u000bbL7\u000f^:!\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0019a\u0014N\\5u}Q1a\fY1cG\u0012\u0004\"a\u0018\u0001\u000e\u0003\tAQaK.A\u00025BQAN.A\u0002aBQ\u0001S.A\u0002)CQ\u0001U.A\u0002ICQ\u0001W.A\u0002ICQA\u001a\u0001\u0005R\u001d\fQ\"\u001b8oKJ\u001c\u0005.\u001b7ee\u0016tW#\u00015\u0011\u0007%\f(J\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011QND\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!\u0001]\u0012\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0004'\u0016\f(B\u00019$\u0011\u001d)\b\u00011A\u0005\u0002Y\fab\u0019:fCR,G\rV3na\u0012K'/F\u0001x!\r\u00113\t\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\f!AZ:\u000b\u0005uT\u0011A\u00025bI>|\u0007/\u0003\u0002\u0000u\n!\u0001+\u0019;i\u0011%\t\u0019\u0001\u0001a\u0001\n\u0003\t)!\u0001\nde\u0016\fG/\u001a3UK6\u0004H)\u001b:`I\u0015\fH\u0003BA\u0004\u0003\u001b\u00012AIA\u0005\u0013\r\tYa\t\u0002\u0005+:LG\u000fC\u0005\u0002\u0010\u0005\u0005\u0011\u0011!a\u0001o\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005M\u0001\u0001)Q\u0005o\u0006y1M]3bi\u0016$G+Z7q\t&\u0014\b\u0005C\u0004\u0002\u0018\u0001!I!!\u0007\u0002\u0017\u0015DXmY;uS>t\u0017\nZ\u000b\u0002\u007f!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011!D4fiN#\u0018mZ5oO\u0012K'\u000fF\u0004y\u0003C\t)#!\u000e\t\u000f\u0005\r\u00121\u0004a\u0001q\u0006I\u0011N\u001c9viB\u000bG\u000f\u001b\u0005\t\u0003O\tY\u00021\u0001\u0002*\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f}\u0003\u0011\u0019wN\u001c4\n\t\u0005M\u0012Q\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005]\u00121\u0004a\u0001\u007f\u0005Q1\u000f^1hS:<G)\u001b:\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005)r-\u001a;FqR,'O\\1m'\u000e\u0014\u0018\r^2i\t&\u0014Hc\u0002=\u0002@\u0005M\u0013Q\u000b\u0005\t\u0003\u0003\nI\u00041\u0001\u0002D\u00051Q\r\u001f;V%&\u0003B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0002oKRT!!!\u0014\u0002\t)\fg/Y\u0005\u0005\u0003#\n9EA\u0002V%&C\u0001\"a\n\u0002:\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003o\tI\u00041\u0001@\u0011\u001d\tI\u0006\u0001C\u0001\u00037\n!cZ3u\u000bb$XM\u001d8bYRk\u0007\u000fU1uQRY\u00010!\u0018\u0002b\u00055\u0015qRAI\u0011\u001d\ty&a\u0016A\u0002a\fA\u0001]1uQ\"A\u00111MA,\u0001\u0004\t)'A\u0006iSZ,g+\u001a:tS>t\u0007\u0003BA4\u0003\u000fsA!!\u001b\u0002\u0004:!\u00111NA@\u001d\u0011\ti'! \u000f\t\u0005=\u00141\u0010\b\u0005\u0003c\nIH\u0004\u0003\u0002t\u0005]dbA6\u0002v%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005\u0005E!\u0001\u0004dY&,g\u000e^\u0005\u0004a\u0006\u0015%bAAA\t%!\u0011\u0011RAF\u0005-A\u0015N^3WKJ\u001c\u0018n\u001c8\u000b\u0007A\f)\t\u0003\u0005\u0002(\u0005]\u0003\u0019AA\u0015\u0011\u001d\t9$a\u0016A\u0002}Bq!a%\u0002X\u0001\u0007q(\u0001\u0006tGJ\fGo\u00195ESJDq!a&\u0001\t\u0003\tI*\u0001\u000epY\u00124VM]:j_:,\u0005\u0010^3s]\u0006dG+Z7q!\u0006$\b\u000eF\u0004y\u00037\u000bi*a(\t\u000f\u0005}\u0013Q\u0013a\u0001q\"A\u0011qEAK\u0001\u0004\tI\u0003C\u0004\u0002\u0014\u0006U\u0005\u0019A \t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\u0006Qb.Z<WKJ\u001c\u0018n\u001c8FqR,'O\\1m)\u0016l\u0007\u000fU1uQR9\u00010a*\u0002*\u0006-\u0006bBA0\u0003C\u0003\r\u0001\u001f\u0005\t\u0003O\t\t\u000b1\u0001\u0002*!9\u0011qGAQ\u0001\u0004y\u0004bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u0013O\u0016$X\t\u001f;U[B\u0004\u0016\r\u001e5SK2$v\u000eF\u0004y\u0003g\u000b),a.\t\u000f\u0005}\u0013Q\u0016a\u0001q\"A\u0011qEAW\u0001\u0004\tI\u0003C\u0004\u00028\u00055\u0006\u0019A \t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\u0006\u0019!/\u001e8\u0015\t\u0005}\u0016\u0011\u001a\t\u0005SF\f\t\r\u0005\u0003\u0002D\u0006\u0015W\"\u0001\u0004\n\u0007\u0005\u001dgAA\u0002S_^D\u0001\"a3\u0002:\u0002\u0007\u0011QZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003\u0007\fy-C\u0002\u0002R\u001a\u0011Ab\u00159be.\u001cVm]:j_:D\u0011\"!6\u0001\u0003\u0003%\t!a6\u0002\t\r|\u0007/\u001f\u000b\f=\u0006e\u00171\\Ao\u0003?\f\t\u000f\u0003\u0005,\u0003'\u0004\n\u00111\u0001.\u0011!1\u00141\u001bI\u0001\u0002\u0004A\u0004\u0002\u0003%\u0002TB\u0005\t\u0019\u0001&\t\u0011A\u000b\u0019\u000e%AA\u0002IC\u0001\u0002WAj!\u0003\u0005\rA\u0015\u0005\n\u0003K\u0004\u0011\u0013!C\u0001\u0003O\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002j*\u001aQ&a;,\u0005\u00055\b\u0003BAx\u0003sl!!!=\u000b\t\u0005M\u0018Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a>$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\f\tPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a@\u0001#\u0003%\tA!\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0001\u0016\u0004q\u0005-\b\"\u0003B\u0004\u0001E\u0005I\u0011\u0001B\u0005\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u0003+\u0007)\u000bY\u000fC\u0005\u0003\u0010\u0001\t\n\u0011\"\u0001\u0003\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\nU\r\u0011\u00161\u001e\u0005\n\u0005/\u0001\u0011\u0013!C\u0001\u0005#\tabY8qs\u0012\"WMZ1vYR$S\u0007C\u0005\u0003\u001c\u0001\t\t\u0011\"\u0011\u0003\u001e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQAA!\n\u0002L\u0005!A.\u00198h\u0013\r\t%1\u0005\u0005\n\u0005W\u0001\u0011\u0011!C\u0001\u0005[\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\f\u0011\u0007\t\u0012\t$C\u0002\u00034\r\u00121!\u00138u\u0011%\u00119\u0004AA\u0001\n\u0003\u0011I$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tm\"\u0011\t\t\u0004E\tu\u0012b\u0001B G\t\u0019\u0011I\\=\t\u0015\u0005=!QGA\u0001\u0002\u0004\u0011y\u0003C\u0005\u0003F\u0001\t\t\u0011\"\u0011\u0003H\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003JA1!1\nB)\u0005wi!A!\u0014\u000b\u0007\t=3%\u0001\u0006d_2dWm\u0019;j_:LAAa\u0015\u0003N\tA\u0011\n^3sCR|'\u000fC\u0005\u0003X\u0001\t\t\u0011\"\u0001\u0003Z\u0005A1-\u00198FcV\fG\u000eF\u0002S\u00057B!\"a\u0004\u0003V\u0005\u0005\t\u0019\u0001B\u001e\u0011%\u0011y\u0006AA\u0001\n\u0003\u0012\t'\u0001\u0004fcV\fGn\u001d\u000b\u0004%\n\r\u0004BCA\b\u0005;\n\t\u00111\u0001\u0003<\u001dI!q\r\u0002\u0002\u0002#\u0005!\u0011N\u0001\u0014\u0013:\u001cXM\u001d;J]R|\u0007*\u001b<f)\u0006\u0014G.\u001a\t\u0004?\n-d\u0001C\u0001\u0003\u0003\u0003E\tA!\u001c\u0014\u000b\t-$qN\u0014\u0011\u0015\tE$qO\u00179\u0015J\u0013f,\u0004\u0002\u0003t)\u0019!QO\u0012\u0002\u000fI,h\u000e^5nK&!!\u0011\u0010B:\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\u000e\u0005\b9\n-D\u0011\u0001B?)\t\u0011I\u0007\u0003\u0006\u0003\u0002\n-\u0014\u0011!C#\u0005\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005?A!Ba\"\u0003l\u0005\u0005I\u0011\u0011BE\u0003\u0015\t\u0007\u000f\u001d7z)-q&1\u0012BG\u0005\u001f\u0013\tJa%\t\r-\u0012)\t1\u0001.\u0011\u00191$Q\u0011a\u0001q!1\u0001J!\"A\u0002)Ca\u0001\u0015BC\u0001\u0004\u0011\u0006B\u0002-\u0003\u0006\u0002\u0007!\u000b\u0003\u0006\u0003\u0018\n-\u0014\u0011!CA\u00053\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001c\n\r\u0006\u0003\u0002\u0012D\u0005;\u0003\u0002B\tBP[aR%KU\u0005\u0004\u0005C\u001b#A\u0002+va2,W\u0007C\u0005\u0003&\nU\u0015\u0011!a\u0001=\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t%&1NA\u0001\n\u0013\u0011Y+A\u0006sK\u0006$'+Z:pYZ,GC\u0001BW!\u0011\u0011\tCa,\n\t\tE&1\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class InsertIntoHiveTable
extends LeafNode
implements RunnableCommand,
Serializable {
    private final CatalogTable table;
    private final Map<String, Option<String>> partition;
    private final LogicalPlan query;
    private final boolean overwrite;
    private final boolean ifPartitionNotExists;
    private Option<Path> createdTempDir;

    public static Function1<Tuple5<CatalogTable, Map<String, Option<String>>, LogicalPlan, Object, Object>, InsertIntoHiveTable> tupled() {
        return InsertIntoHiveTable$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Map<String, Option<String>>, Function1<LogicalPlan, Function1<Object, Function1<Object, InsertIntoHiveTable>>>>> curried() {
        return InsertIntoHiveTable$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public CatalogTable table() {
        return this.table;
    }

    public Map<String, Option<String>> partition() {
        return this.partition;
    }

    public LogicalPlan query() {
        return this.query;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public boolean ifPartitionNotExists() {
        return this.ifPartitionNotExists;
    }

    public Seq<LogicalPlan> innerChildren() {
        LogicalPlan logicalPlan = this.query();
        return Nil$.MODULE$.$colon$colon((Object)logicalPlan);
    }

    public Option<Path> createdTempDir() {
        return this.createdTempDir;
    }

    public void createdTempDir_$eq(Option<Path> x$1) {
        this.createdTempDir = x$1;
    }

    private String executionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS", Locale.US);
        return new StringBuilder().append((Object)"hive_").append((Object)format.format(new Date())).append((Object)"_").append((Object)BoxesRunTime.boxToLong((long)Math.abs(rand.nextLong()))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private Path getStagingDir(Path inputPath, Configuration hadoopConf, String stagingDir) {
        void var8_8;
        block4: {
            ObjectRef stagingPathName;
            URI inputPathUri = inputPath.toUri();
            String inputPathName = inputPathUri.getPath();
            FileSystem fs = inputPath.getFileSystem(hadoopConf);
            ObjectRef objectRef = stagingPathName = inputPathName.indexOf(stagingDir) == -1 ? new ObjectRef((Object)new Path(inputPathName, stagingDir).toString()) : new ObjectRef((Object)inputPathName.substring(0, inputPathName.indexOf(stagingDir) + stagingDir.length()));
            if (FileUtils.isSubDir((Path)new Path((String)stagingPathName.elem), (Path)inputPath, (FileSystem)fs) && !new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)stagingPathName.elem)).stripPrefix(inputPathName))).stripPrefix(File.separator).startsWith(".")) {
                this.logDebug((Function0)new Serializable(this, stagingPathName){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stagingPathName$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The staging dir '", "' should be a child directory starts "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.stagingPathName$1.elem}))).append((Object)"with '.' to avoid being deleted if we set hive.exec.stagingdir under the table ").append((Object)"directory.").toString();
                    }
                    {
                        this.stagingPathName$1 = stagingPathName$1;
                    }
                });
                stagingPathName.elem = new Path(inputPathName, ".hive-staging").toString();
            }
            Path dir = fs.makeQualified(new Path(new StringBuilder().append((Object)((String)stagingPathName.elem)).append((Object)"_").append((Object)this.executionId()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString()));
            this.logDebug((Function0)new Serializable(this, inputPath, dir){
                public static final long serialVersionUID = 0L;
                private final Path inputPath$1;
                private final Path dir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created staging dir = ").append((Object)this.dir$1).append((Object)" for path = ").append((Object)this.inputPath$1).toString();
                }
                {
                    this.inputPath$1 = inputPath$1;
                    this.dir$1 = dir$1;
                }
            });
            try {
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dir, (boolean)true, (Configuration)hadoopConf)) break block4;
                this.createdTempDir_$eq((Option<Path>)new Some((Object)dir));
                fs.deleteOnExit(dir);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory '").append((Object)var8_8.toString()).append((Object)"': ").append((Object)iOException.getMessage()).toString(), iOException);
            }
            return dir;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory  '").append((Object)var8_8.toString()).append((Object)"'").toString());
    }

    private Path getExternalScratchDir(URI extURI, Configuration hadoopConf, String stagingDir) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), hadoopConf, stagingDir);
    }

    public Path getExternalTmpPath(Path path, package.HiveVersion hiveVersion, Configuration hadoopConf, String stagingDir, String scratchDir) {
        block4: {
            Path path2;
            block3: {
                scala.collection.immutable.Set hiveVersionsUsingNewExternalTempPath;
                block2: {
                    scala.collection.immutable.Set hiveVersionsUsingOldExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v12$.MODULE$, package$hive$v13$.MODULE$, package$hive$v14$.MODULE$, package$hive$v1_0$.MODULE$}));
                    hiveVersionsUsingNewExternalTempPath = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.HiveVersion[]{package$hive$v1_1$.MODULE$, package$hive$v1_2$.MODULE$, package$hive$v2_0$.MODULE$, package$hive$v2_1$.MODULE$}));
                    Set set = hiveVersionsUsingNewExternalTempPath.$plus$plus((GenTraversableOnce)hiveVersionsUsingOldExternalTempPath);
                    scala.collection.immutable.Set<Product> set2 = package$hive$.MODULE$.allSupportedHiveVersions();
                    Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
                    if (!hiveVersionsUsingOldExternalTempPath.contains((Object)hiveVersion)) break block2;
                    path2 = this.oldVersionExternalTempPath(path, hadoopConf, scratchDir);
                    break block3;
                }
                if (!hiveVersionsUsingNewExternalTempPath.contains((Object)hiveVersion)) break block4;
                path2 = this.newVersionExternalTempPath(path, hadoopConf, stagingDir);
            }
            return path2;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Unsupported hive version: ").append((Object)hiveVersion.fullVersion()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Path oldVersionExternalTempPath(Path path, Configuration hadoopConf, String scratchDir) {
        void var6_6;
        block3: {
            URI extURI = path.toUri();
            Path scratchPath = new Path(scratchDir, this.executionId());
            Path dirPath = new Path(extURI.getScheme(), extURI.getAuthority(), new StringBuilder().append((Object)scratchPath.toUri().getPath()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString());
            try {
                FileSystem fs = dirPath.getFileSystem(hadoopConf);
                dirPath = new Path(fs.makeQualified(dirPath).toString());
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dirPath, (boolean)true, (Configuration)hadoopConf)) break block3;
                this.createdTempDir_$eq((Option<Path>)new Some((Object)dirPath));
                fs.deleteOnExit(dirPath);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory: ").append((Object)var6_6.toString()).toString(), iOException);
            }
            return dirPath;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory: ").append((Object)var6_6.toString()).toString());
    }

    public Path newVersionExternalTempPath(Path path, Configuration hadoopConf, String stagingDir) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.getExtTmpPathRelTo(path.getParent(), hadoopConf, stagingDir) : new Path(this.getExternalScratchDir(extURI, hadoopConf, stagingDir), "-ext-10000");
    }

    public Path getExtTmpPathRelTo(Path path, Configuration hadoopConf, String stagingDir) {
        return new Path(this.getStagingDir(path, hadoopConf, stagingDir), "-ext-10000");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState = sparkSession.sessionState();
        ExternalCatalog externalCatalog = sparkSession.sharedState().externalCatalog();
        package.HiveVersion hiveVersion = ((HiveExternalCatalog)externalCatalog).client().version();
        Configuration hadoopConf = sessionState.newHadoopConf();
        String stagingDir = hadoopConf.get("hive.exec.stagingdir", ".hive-staging");
        String scratchDir = hadoopConf.get("hive.exec.scratchdir", "/tmp/hive");
        Table hiveQlTable = HiveClientImpl$.MODULE$.toHiveTable(this.table(), HiveClientImpl$.MODULE$.toHiveTable$default$2());
        TableDesc tableDesc = new TableDesc(hiveQlTable.getInputFormatClass(), hiveQlTable.getOutputFormatClass(), hiveQlTable.getMetadata());
        Path tableLocation = hiveQlTable.getDataLocation();
        Path tmpLocation = this.getExternalTmpPath(tableLocation, hiveVersion, hadoopConf, stagingDir, scratchDir);
        HiveShim.ShimFileSinkDesc fileSinkConf = new HiveShim.ShimFileSinkDesc(tmpLocation.toString(), tableDesc, false);
        boolean isCompressed = new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("hive.exec.compress.output", "false"))).toBoolean();
        if (isCompressed) {
            hadoopConf.set("mapreduce.output.fileoutputformat.compress", "true");
            fileSinkConf.setCompressed(true);
            fileSinkConf.setCompressCodec(hadoopConf.get("mapreduce.output.fileoutputformat.compress.codec"));
            fileSinkConf.setCompressType(hadoopConf.get("mapreduce.output.fileoutputformat.compress.type"));
        }
        int numDynamicPartitions = this.partition().values().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<String> x$2) {
                return x$2.isEmpty();
            }
        });
        int numStaticPartitions = this.partition().values().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<String> x$3) {
                return x$3.nonEmpty();
            }
        });
        Map partitionSpec = (Map)this.partition().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, Option<String>> x0$1) {
                Tuple2<String, Option<String>> tuple2;
                block4: {
                    Tuple2 tuple22;
                    block3: {
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            String key = (String)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String value = (String)some.x();
                            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String key = (String)tuple2._1();
                        Option option = (Option)tuple2._2();
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)"");
                    }
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        String partitionColumns = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getProperties().getProperty("partition_columns");
        String[] partitionColumnNames = (String[])Option$.MODULE$.apply((Object)partitionColumns).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$4) {
                return x$4.split("/");
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        });
        scala.collection.immutable.Set set = Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).toSet();
        scala.collection.immutable.Set set2 = this.partition().keySet();
        if (set != null ? !set.equals(set2) : set2 != null) throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested partitioning does not match the ", " table:\n           |Requested partitions: ", "\n           |Table partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier().table(), this.partition().keys().mkString(","), this.table().partitionColumnNames().mkString(",")})))).stripMargin());
        if (numDynamicPartitions > 0) {
            if (!new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("hive.exec.dynamic.partition", "true"))).toBoolean()) throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg());
            if (numStaticPartitions == 0 && hadoopConf.get("hive.exec.dynamic.partition.mode", "strict").equalsIgnoreCase("strict")) {
                throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
            }
            boolean[] isDynamic = (boolean[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).map((Function1)new Serializable(this, partitionSpec){
                public static final long serialVersionUID = 0L;
                private final Map partitionSpec$1;

                public final boolean apply(String x$5) {
                    return ((String)this.partitionSpec$1.apply((Object)x$5)).isEmpty();
                }
                {
                    this.partitionSpec$1 = partitionSpec$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
            if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).init()).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).tail()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).contains((Object)new Tuple2.mcZZ.sp(true, false))) {
                throw new AnalysisException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(sparkSession.sessionState().conf().fileCommitProtocolClass(), UUID.randomUUID().toString(), tmpLocation.toString(), false);
        Attribute[] partitionAttributes = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).takeRight(numDynamicPartitions)).map((Function1)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InsertIntoHiveTable $outer;
            private final SparkSession sparkSession$1;

            public final Attribute apply(String name) {
                String string = name;
                return (Attribute)this.$outer.query().resolve((Seq)Nil$.MODULE$.$colon$colon((Object)string), this.sparkSession$1.sessionState().analyzer().resolver()).getOrElse((Function0)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final String name$1;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to resolve ", " given [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, ((TraversableOnce)this.$outer.org$apache$spark$sql$hive$execution$InsertIntoHiveTable$$anonfun$$$outer().query().output().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Attribute x$7) {
                                return x$7.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.name$1 = name$1;
                    }
                });
            }

            public /* synthetic */ InsertIntoHiveTable org$apache$spark$sql$hive$execution$InsertIntoHiveTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sparkSession$1 = sparkSession$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
        FileFormatWriter$.MODULE$.write(sparkSession, Dataset$.MODULE$.ofRows(sparkSession, this.query()).queryExecution(), (FileFormat)new HiveFileFormat(fileSinkConf), committer, new FileFormatWriter.OutputSpec(tmpLocation.toString(), Predef$.MODULE$.Map().empty()), hadoopConf, (Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionAttributes), (Option)None$.MODULE$, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<Map<String, String>> x$8) {
            }
        }, Predef$.MODULE$.Map().empty());
        if (this.partition().nonEmpty()) {
            if (numDynamicPartitions > 0) {
                externalCatalog.loadDynamicPartitions(this.table().database(), this.table().identifier().table(), tmpLocation.toString(), partitionSpec, this.overwrite(), numDynamicPartitions);
            } else {
                Option oldPart = externalCatalog.getPartitionOption(this.table().database(), this.table().identifier().table(), partitionSpec);
                BooleanRef doHiveOverwrite = new BooleanRef(this.overwrite());
                if (oldPart.isEmpty() || !this.ifPartitionNotExists()) {
                    if (oldPart.nonEmpty() && this.overwrite()) {
                        ((CatalogTablePartition)oldPart.get()).storage().locationUri().foreach((Function1)new Serializable(this, hadoopConf, doHiveOverwrite){
                            public static final long serialVersionUID = 0L;
                            private final Configuration hadoopConf$1;
                            private final BooleanRef doHiveOverwrite$1;

                            public final void apply(URI uri) {
                                Path partitionPath = new Path(uri);
                                FileSystem fs = partitionPath.getFileSystem(this.hadoopConf$1);
                                if (fs.exists(partitionPath)) {
                                    if (fs.delete(partitionPath, true)) {
                                        this.doHiveOverwrite$1.elem = false;
                                    } else {
                                        throw new RuntimeException(new StringBuilder().append((Object)"Cannot remove partition directory '").append((Object)partitionPath.toString()).toString());
                                    }
                                }
                            }
                            {
                                this.hadoopConf$1 = hadoopConf$1;
                                this.doHiveOverwrite$1 = doHiveOverwrite$1;
                            }
                        });
                    }
                    boolean inheritTableSpecs = true;
                    externalCatalog.loadPartition(this.table().database(), this.table().identifier().table(), tmpLocation.toString(), partitionSpec, doHiveOverwrite.elem, inheritTableSpecs, false);
                }
            }
        } else {
            externalCatalog.loadTable(this.table().database(), this.table().identifier().table(), tmpLocation.toString(), this.overwrite(), false);
        }
        try {
            this.createdTempDir().foreach((Function1)new Serializable(this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final Object apply(Path path) {
                    FileSystem fs = path.getFileSystem(this.hadoopConf$1);
                    return fs.delete(path, true) ? BoxesRunTime.boxToBoolean((boolean)fs.cancelDeleteOnExit(path)) : BoxedUnit.UNIT;
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0)new Serializable(this, stagingDir, e){
                public static final long serialVersionUID = 0L;
                private final String stagingDir$1;
                private final Throwable e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete staging directory: ", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stagingDir$1}))).append((Object)this.e$1).toString();
                }
                {
                    this.stagingDir$1 = stagingDir$1;
                    this.e$1 = e$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        sparkSession.catalog().uncacheTable(this.table().identifier().quotedString());
        sparkSession.sessionState().catalog().refreshTable(this.table().identifier());
        return (Seq)Seq$.MODULE$.empty();
    }

    public InsertIntoHiveTable copy(CatalogTable table, Map<String, Option<String>> partition, LogicalPlan query, boolean overwrite, boolean ifPartitionNotExists) {
        return new InsertIntoHiveTable(table, partition, query, overwrite, ifPartitionNotExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public Map<String, Option<String>> copy$default$2() {
        return this.partition();
    }

    public LogicalPlan copy$default$3() {
        return this.query();
    }

    public boolean copy$default$4() {
        return this.overwrite();
    }

    public boolean copy$default$5() {
        return this.ifPartitionNotExists();
    }

    public String productPrefix() {
        return "InsertIntoHiveTable";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifPartitionNotExists());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            case 2: {
                object = this.query();
                break;
            }
            case 1: {
                object = this.partition();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InsertIntoHiveTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InsertIntoHiveTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        InsertIntoHiveTable insertIntoHiveTable = (InsertIntoHiveTable)((Object)x$1);
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = insertIntoHiveTable.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        Map<String, Option<String>> map = this.partition();
        Map<String, Option<String>> map2 = insertIntoHiveTable.partition();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        LogicalPlan logicalPlan = this.query();
        LogicalPlan logicalPlan2 = insertIntoHiveTable.query();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        if (this.overwrite() != insertIntoHiveTable.overwrite()) return false;
        if (this.ifPartitionNotExists() != insertIntoHiveTable.ifPartitionNotExists()) return false;
        if (!insertIntoHiveTable.canEqual((Object)this)) return false;
        return true;
    }

    public InsertIntoHiveTable(CatalogTable table, Map<String, Option<String>> partition, LogicalPlan query, boolean overwrite, boolean ifPartitionNotExists) {
        this.table = table;
        this.partition = partition;
        this.query = query;
        this.overwrite = overwrite;
        this.ifPartitionNotExists = ifPartitionNotExists;
        Command.class.$init$((Command)this);
        this.createdTempDir = None$.MODULE$;
    }
}

