/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.util.Locale;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions$;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.RelationConversions$;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u00016\u00111CU3mCRLwN\\\"p]Z,'o]5p]NT!a\u0001\u0003\u0002\t!Lg/\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019qB\u0005E\u0002\u0010)Yi\u0011\u0001\u0005\u0006\u0003#I\tQA];mKNT!a\u0005\u0003\u0002\u0011\r\fG/\u00197zgRL!!\u0006\t\u0003\tI+H.\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u001c%\u0005)\u0001\u000f\\1og&\u0011Q\u0004\u0007\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013\u0001B2p]\u001a,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012qaU)M\u0007>tg\r\u0003\u00052\u0001\tE\t\u0015!\u0003+\u0003\u0015\u0019wN\u001c4!\u0011!\u0019\u0004A!f\u0001\n\u0003!\u0014AD:fgNLwN\\\"bi\u0006dwnZ\u000b\u0002kA\u0011agN\u0007\u0002\u0005%\u0011\u0001H\u0001\u0002\u0013\u0011&4XmU3tg&|gnQ1uC2|w\r\u0003\u0005;\u0001\tE\t\u0015!\u00036\u0003=\u0019Xm]:j_:\u001c\u0015\r^1m_\u001e\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0002?\u007f\u0001\u0003\"A\u000e\u0001\t\u000b!Z\u0004\u0019\u0001\u0016\t\u000bMZ\u0004\u0019A\u001b\t\u000b\t\u0003A\u0011B\"\u0002\u001b%\u001c8i\u001c8wKJ$\u0018N\u00197f)\t!u\t\u0005\u0002 \u000b&\u0011a\t\t\u0002\b\u0005>|G.Z1o\u0011\u0015A\u0015\t1\u0001J\u0003!\u0011X\r\\1uS>t\u0007C\u0001&N\u001b\u0005Y%B\u0001'\u0013\u0003\u001d\u0019\u0017\r^1m_\u001eL!AT&\u0003#!Kg/\u001a+bE2,'+\u001a7bi&|g\u000eC\u0003Q\u0001\u0011%\u0011+A\u0004d_:4XM\u001d;\u0015\u0005IS\u0006CA*Y\u001b\u0005!&BA+W\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005]#\u0011!C3yK\u000e,H/[8o\u0013\tIFKA\bM_\u001eL7-\u00197SK2\fG/[8o\u0011\u0015Au\n1\u0001J\u0011\u0015a\u0006\u0001\"\u0011^\u0003\u0015\t\u0007\u000f\u001d7z)\t1b\fC\u0003`7\u0002\u0007a#\u0001\u0003qY\u0006t\u0007bB1\u0001\u0003\u0003%\tAY\u0001\u0005G>\u0004\u0018\u0010F\u0002?G\u0012Dq\u0001\u000b1\u0011\u0002\u0003\u0007!\u0006C\u00044AB\u0005\t\u0019A\u001b\t\u000f\u0019\u0004\u0011\u0013!C\u0001O\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00015+\u0005)J7&\u00016\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017!C;oG\",7m[3e\u0015\ty\u0007%\u0001\u0006b]:|G/\u0019;j_:L!!\u001d7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004t\u0001E\u0005I\u0011\u0001;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tQO\u000b\u00026S\"9q\u000fAA\u0001\n\u0003B\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw\rC\u0005\u0002\u0006\u0001\t\t\u0011\"\u0001\u0002\b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0002\t\u0004?\u0005-\u0011bAA\u0007A\t\u0019\u0011J\u001c;\t\u0013\u0005E\u0001!!A\u0005\u0002\u0005M\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003+\tY\u0002E\u0002 \u0003/I1!!\u0007!\u0005\r\te.\u001f\u0005\u000b\u0003;\ty!!AA\u0002\u0005%\u0011a\u0001=%c!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00131E\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0005\t\u0007\u0003O\ti#!\u0006\u000e\u0005\u0005%\"bAA\u0016A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0011QG\u0001\tG\u0006tW)];bYR\u0019A)a\u000e\t\u0015\u0005u\u0011\u0011GA\u0001\u0002\u0004\t)\u0002C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\n!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00131I\u0001\ti>\u001cFO]5oOR\t\u0011\u0010C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J\u00051Q-];bYN$2\u0001RA&\u0011)\ti\"!\u0012\u0002\u0002\u0003\u0007\u0011QC\u0004\n\u0003\u001f\u0012\u0011\u0011!E\u0001\u0003#\n1CU3mCRLwN\\\"p]Z,'o]5p]N\u00042ANA*\r!\t!!!A\t\u0002\u0005U3#BA*\u0003/\"\u0003cBA-\u0003?RSGP\u0007\u0003\u00037R1!!\u0018!\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0019\u0002\\\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fq\n\u0019\u0006\"\u0001\u0002fQ\u0011\u0011\u0011\u000b\u0005\u000b\u0003\u0003\n\u0019&!A\u0005F\u0005\r\u0003\"\u0003/\u0002T\u0005\u0005I\u0011QA6)\u0015q\u0014QNA8\u0011\u0019A\u0013\u0011\u000ea\u0001U!11'!\u001bA\u0002UB!\"a\u001d\u0002T\u0005\u0005I\u0011QA;\u0003\u001d)h.\u00199qYf$B!a\u001e\u0002\u0004B)q$!\u001f\u0002~%\u0019\u00111\u0010\u0011\u0003\r=\u0003H/[8o!\u0015y\u0012q\u0010\u00166\u0013\r\t\t\t\t\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005\u0015\u0015\u0011OA\u0001\u0002\u0004q\u0014a\u0001=%a!Q\u0011\u0011RA*\u0003\u0003%I!a#\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u001b\u00032A_AH\u0013\r\t\tj\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class RelationConversions
extends Rule<LogicalPlan>
implements Product,
Serializable {
    private final SQLConf conf;
    private final HiveSessionCatalog sessionCatalog;

    public static Function1<Tuple2<SQLConf, HiveSessionCatalog>, RelationConversions> tupled() {
        return RelationConversions$.MODULE$.tupled();
    }

    public static Function1<SQLConf, Function1<HiveSessionCatalog, RelationConversions>> curried() {
        return RelationConversions$.MODULE$.curried();
    }

    public SQLConf conf() {
        return this.conf;
    }

    public HiveSessionCatalog sessionCatalog() {
        return this.sessionCatalog;
    }

    public boolean org$apache$spark$sql$hive$RelationConversions$$isConvertible(HiveTableRelation relation) {
        String serde = ((String)relation.tableMeta().storage().serde().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toLowerCase(Locale.ROOT);
        return serde.contains("parquet") && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET())) || serde.contains("orc") && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(HiveUtils$.MODULE$.CONVERT_METASTORE_ORC()));
    }

    public LogicalRelation org$apache$spark$sql$hive$RelationConversions$$convert(HiveTableRelation relation) {
        LogicalRelation logicalRelation;
        String serde = ((String)relation.tableMeta().storage().serde().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toLowerCase(Locale.ROOT);
        if (serde.contains("parquet")) {
            Map options = relation.tableMeta().storage().properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ParquetOptions$.MODULE$.MERGE_SCHEMA()), (Object)this.conf().getConf(HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET_WITH_SCHEMA_MERGING()).toString()));
            logicalRelation = this.sessionCatalog().metastoreCatalog().convertToLogicalRelation(relation, (Map<String, String>)options, ParquetFileFormat.class, "parquet");
        } else {
            Map options = relation.tableMeta().storage().properties();
            logicalRelation = this.sessionCatalog().metastoreCatalog().convertToLogicalRelation(relation, (Map<String, String>)options, OrcFileFormat.class, "orc");
        }
        return logicalRelation;
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transformUp((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationConversions $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                HiveTableRelation hiveTableRelation;
                Object object;
                A1 A1 = x4;
                if (A1 instanceof InsertIntoTable) {
                    InsertIntoTable insertIntoTable = (InsertIntoTable)A1;
                    LogicalPlan r = insertIntoTable.table();
                    Map partition = insertIntoTable.partition();
                    LogicalPlan query = insertIntoTable.query();
                    boolean overwrite = insertIntoTable.overwrite();
                    boolean ifPartitionNotExists = insertIntoTable.ifPartitionNotExists();
                    if (r instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation2 = (HiveTableRelation)r;
                        if (query.resolved() && DDLUtils$.MODULE$.isHiveTable(hiveTableRelation2.tableMeta()) && !hiveTableRelation2.isPartitioned() && this.$outer.org$apache$spark$sql$hive$RelationConversions$$isConvertible(hiveTableRelation2)) {
                            object = new InsertIntoTable((LogicalPlan)this.$outer.org$apache$spark$sql$hive$RelationConversions$$convert(hiveTableRelation2), partition, query, overwrite, ifPartitionNotExists);
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)A1).tableMeta()) && this.$outer.org$apache$spark$sql$hive$RelationConversions$$isConvertible(hiveTableRelation)) {
                    object = this.$outer.org$apache$spark$sql$hive$RelationConversions$$convert(hiveTableRelation);
                    return (B1)object;
                }
                object = function1.apply(x4);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x4) {
                LogicalPlan logicalPlan = x4;
                if (logicalPlan instanceof InsertIntoTable) {
                    InsertIntoTable insertIntoTable = (InsertIntoTable)logicalPlan;
                    LogicalPlan r = insertIntoTable.table();
                    LogicalPlan query = insertIntoTable.query();
                    if (r instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)r;
                        if (query.resolved() && DDLUtils$.MODULE$.isHiveTable(hiveTableRelation.tableMeta()) && !hiveTableRelation.isPartitioned() && this.$outer.org$apache$spark$sql$hive$RelationConversions$$isConvertible(hiveTableRelation)) {
                            return true;
                        }
                    }
                }
                if (!(logicalPlan instanceof HiveTableRelation)) return false;
                HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan;
                if (!DDLUtils$.MODULE$.isHiveTable(hiveTableRelation.tableMeta())) return false;
                if (!this.$outer.org$apache$spark$sql$hive$RelationConversions$$isConvertible(hiveTableRelation)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public RelationConversions copy(SQLConf conf, HiveSessionCatalog sessionCatalog) {
        return new RelationConversions(conf, sessionCatalog);
    }

    public SQLConf copy$default$1() {
        return this.conf();
    }

    public HiveSessionCatalog copy$default$2() {
        return this.sessionCatalog();
    }

    public String productPrefix() {
        return "RelationConversions";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        HiveSessionCatalog hiveSessionCatalog;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                hiveSessionCatalog = this.sessionCatalog();
                break;
            }
            case 0: {
                hiveSessionCatalog = this.conf();
            }
        }
        return hiveSessionCatalog;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RelationConversions;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RelationConversions)) return false;
        boolean bl = true;
        if (!bl) return false;
        RelationConversions relationConversions = (RelationConversions)((Object)x$1);
        SQLConf sQLConf = this.conf();
        SQLConf sQLConf2 = relationConversions.conf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        HiveSessionCatalog hiveSessionCatalog = this.sessionCatalog();
        HiveSessionCatalog hiveSessionCatalog2 = relationConversions.sessionCatalog();
        if (hiveSessionCatalog == null) {
            if (hiveSessionCatalog2 != null) {
                return false;
            }
        } else if (!((Object)((Object)hiveSessionCatalog)).equals((Object)hiveSessionCatalog2)) return false;
        if (!relationConversions.canEqual((Object)this)) return false;
        return true;
    }

    public RelationConversions(SQLConf conf, HiveSessionCatalog sessionCatalog) {
        this.conf = conf;
        this.sessionCatalog = sessionCatalog;
        Product.class.$init$((Product)this);
    }
}

