/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0001\u0005\rvA\u0002\u0011\"\u0011\u0003\u0019SF\u0002\u00040C!\u00051\u0005\r\u0005\u0006{\u0005!\ta\u0010\u0005\b\u0001\u0006\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0015\u0001)A\u0005\u0005\"91*\u0001b\u0001\n\u0013a\u0005BB,\u0002A\u0003%Q\nC\u0005Y\u0003\u0001\u0007\t\u0019!C\u00053\"I\u0011-\u0001a\u0001\u0002\u0004%IA\u0019\u0005\nQ\u0006\u0001\r\u0011!Q!\niCq![\u0001C\u0002\u00135!\u000e\u0003\u0004o\u0003\u0001\u0006ia\u001b\u0005\u0006_\u0006!\t\u0001\u001d\u0005\u0006c\u0006!\tA\u001d\u0005\u0006q\u0006!\t!\u001f\u0004\u0007_\u0005\u00021%!\u0005\t\ruzA\u0011AA\r\u0011%\tib\u0004b\u0001\n\u0013\ty\u0002C\u0004\u0002\"=\u0001\u000b\u0011B@\t\u0013\u0005\rrB1A\u0005\n\u0005\u0015\u0002\u0002CA\u001a\u001f\u0001\u0006I!a\n\t\u0013\u0005UrB1A\u0005\n\u0005]\u0002\u0002CA)\u001f\u0001\u0006I!!\u000f\t\u0011a|!\u0019!C\u0005\u0003'Bq!!\u0016\u0010A\u0003%!\u0010C\u0005\u0002X=\u0011\r\u0011\"\u0003\u0002Z!A\u0011QM\b!\u0002\u0013\tY\u0006C\u0004\u0002h=!\t%!\u001b\t\r\u0005mt\u0002\"\u0001q\u0011\u001d\tih\u0004C!\u0003\u007fBq!a#\u0010\t\u0003\ni\tC\u0004\u0002\u0018>!I!!'\u0002#M\u0003\u0018M]6T#2\u001bE*\u0013#sSZ,'O\u0003\u0002#G\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011A%J\u0001\u0005Q&4XM\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u0004\"AL\u0001\u000e\u0003\u0005\u0012\u0011c\u00159be.\u001c\u0016\u000bT\"M\u0013\u0012\u0013\u0018N^3s'\r\t\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005i:\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ&\u0001\u0004qe>l\u0007\u000f^\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB*ue&tw-A\u0004qe>l\u0007\u000f\u001e\u0011\u0002\u001f\r|g\u000e^5ok\u0016$\u0007K]8naR,\u0012!\u0014\t\u0003\u001dVs!aT*\u0011\u0005A\u001bT\"A)\u000b\u0005Is\u0014A\u0002\u001fs_>$h(\u0003\u0002Ug\u00051\u0001K]3eK\u001aL!!\u0013,\u000b\u0005Q\u001b\u0014\u0001E2p]RLg.^3e!J|W\u000e\u001d;!\u0003%!(/\u00198ta>\u0014H/F\u0001[!\tYv,D\u0001]\u0015\tAVL\u0003\u0002_S\u00051A\u000f\u001b:jMRL!\u0001\u0019/\u0003\u000fQ\u001bvnY6fi\u0006iAO]1ogB|'\u000f^0%KF$\"a\u00194\u0011\u0005I\"\u0017BA34\u0005\u0011)f.\u001b;\t\u000f\u001dD\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u0015Q\u0014\u0018M\\:q_J$\b%\u0001\rT!\u0006\u00136j\u0018%B\t>{\u0005k\u0018)S\u001fB{\u0006KU#G\u0013b+\u0012a[\b\u0002Y\u0006\nQ.A\u0007ta\u0006\u00148N\f5bI>|\u0007OL\u0001\u001a'B\u000b%kS0I\u0003\u0012{u\nU0Q%>\u0003v\f\u0015*F\r&C\u0006%\u0001\u000bj]N$\u0018\r\u001c7TS\u001et\u0017\r\u001c%b]\u0012dWM\u001d\u000b\u0002G\u0006!Q.Y5o)\t\u00197\u000fC\u0003u\u001b\u0001\u0007Q/\u0001\u0003be\u001e\u001c\bc\u0001\u001aw\u001b&\u0011qo\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\rSN\u0014V-\\8uK6{G-\u001a\u000b\u0003uv\u0004\"AM>\n\u0005q\u001c$a\u0002\"p_2,\u0017M\u001c\u0005\u0006}:\u0001\ra`\u0001\u0006gR\fG/\u001a\t\u0005\u0003\u0003\ti!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\r\u0019G.\u001b\u0006\u0004I\u0005%!bAA\u0006S\u00051\u0001.\u00193p_BLA!a\u0004\u0002\u0004\ty1\t\\5TKN\u001c\u0018n\u001c8Ti\u0006$Xm\u0005\u0003\u0010\u0003'9\u0004\u0003BA\u0001\u0003+IA!a\u0006\u0002\u0004\tI1\t\\5Ee&4XM\u001d\u000b\u0003\u00037\u0001\"AL\b\u0002\u0019M,7o]5p]N#\u0018\r^3\u0016\u0003}\fQb]3tg&|gn\u0015;bi\u0016\u0004\u0013a\u0001'P\u000fV\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF\u0016\u0002\u000bMdg\r\u000e6\n\t\u0005E\u00121\u0006\u0002\u0007\u0019><w-\u001a:\u0002\t1{u\tI\u0001\bG>t7o\u001c7f+\t\tI\u0004\u0005\u0003\u0002<\u0005-c\u0002BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\bg\u0016\u001c8/[8o\u0015\u0011\t)%a\u0002\u0002\u0005Ed\u0017\u0002BA%\u0003\u007f\tAbU3tg&|gn\u0015;bi\u0016LA!!\u0014\u0002P\tIAj\\4IK2\u0004XM\u001d\u0006\u0005\u0003\u0013\ny$\u0001\u0005d_:\u001cx\u000e\\3!+\u0005Q\u0018!D5t%\u0016lw\u000e^3N_\u0012,\u0007%\u0001\u0003d_:4WCAA.!\u0011\ti&!\u0019\u000e\u0005\u0005}#\u0002BA,\u0003\u0013IA!a\u0019\u0002`\ti1i\u001c8gS\u001e,(/\u0019;j_:\fQaY8oM\u0002\n\u0001c]3u\u0011&4XMV1sS\u0006\u0014G.Z:\u0015\u0007\r\fY\u0007C\u0004\u0002nm\u0001\r!a\u001c\u0002\u001b!Lg/\u001a,be&\f'\r\\3t!\u0019\t\t(a\u001eN\u001b6\u0011\u00111\u000f\u0006\u0004\u0003k2\u0015\u0001B;uS2LA!!\u001f\u0002t\t\u0019Q*\u00199\u0002'A\u0014\u0018N\u001c;NCN$XM]!oI\u0006\u0003\b/\u00133\u0002\u0015A\u0014xnY3tg\u000ekG\r\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u0001\u001a\u0002\u0004&\u0019\u0011QQ\u001a\u0003\u0007%sG\u000f\u0003\u0004\u0002\nv\u0001\r!T\u0001\u0004G6$\u0017a\u00039s_\u000e,7o\u001d'j]\u0016$b!!!\u0002\u0010\u0006M\u0005BBAI=\u0001\u0007Q*\u0001\u0003mS:,\u0007BBAK=\u0001\u0007!0A\tbY2|w/\u00138uKJ\u0014X\u000f\u001d;j]\u001e\fab\u001d9mSR\u001cV-\\5D_2|g\u000e\u0006\u0003\u0002\u001c\u0006\u0005\u0006#BA9\u0003;k\u0015\u0002BAP\u0003g\u0012A\u0001T5ti\"1\u0011\u0011S\u0010A\u00025\u0003")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Logger LOG;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Logger LOG() {
        return this.LOG;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int n;
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long startTimeNs = System.nanoTime();
            super.processCmd(cmd);
            long endTimeNs = System.nanoTime();
            double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
            n = 0;
        } else {
            int ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc != null) {
                if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor) {
                    SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                    driver.init();
                    PrintStream out = this.sessionState().out;
                    PrintStream err = this.sessionState().err;
                    long startTimeNs = System.nanoTime();
                    if (this.sessionState().getIsVerbose()) {
                        out.println(cmd);
                    }
                    CommandProcessorResponse rc = driver.run(cmd);
                    long endTimeNs = System.nanoTime();
                    double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                    ret = rc.getResponseCode();
                    if (ret != 0) {
                        Throwable throwable = rc.getException();
                        if (throwable instanceof AnalysisException) {
                            AnalysisException analysisException = (AnalysisException)throwable;
                            Option option = analysisException.cause();
                            if (option instanceof Some && !this.sessionState().getIsSilent()) {
                                err.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Error in query: ").append(analysisException.getMessage()).append("\n                       |").append(StringUtils.stringifyException((Throwable)analysisException)).append("\n                     ").toString())).stripMargin());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                err.println(new StringBuilder(16).append("Error in query: ").append(analysisException.getMessage()).toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            err.println(rc.getErrorMessage());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        driver.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                        Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable & scala.Serializable)fields -> {
                            out.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                            return BoxedUnit.UNIT;
                        });
                    }
                    IntRef counter = IntRef.create((int)0);
                    try {
                        while (!out.checkError() && driver.getResults(res)) {
                            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                                SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                                return BoxedUnit.UNIT;
                            });
                            res.clear();
                        }
                    }
                    catch (IOException e) {
                        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())).stripMargin());
                        ret = 1;
                    }
                    int cret = driver.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                    if (counter.elem != 0) {
                        responseMsg = new StringBuilder(17).append(responseMsg).append(", Fetched ").append(counter.elem).append(" row(s)").toString();
                    }
                    this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(responseMsg, null);
                    driver.destroy();
                } else {
                    if (this.sessionState().getIsVerbose()) {
                        this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                    }
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
            n = ret;
        }
        return n;
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        Object object = new Object();
        try {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            System.exit(127);
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable & scala.Serializable)oneCmd -> {
                    SparkSQLCLIDriver.$anonfun$processLine$1(this, command, lastRet, object, oneCmd);
                    return BoxedUnit.UNIT;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal != null && interruptSignal != null) {
                Signal.handle(interruptSignal, oldSignal);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    private List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideSimpleComment = BooleanRef.create((boolean)false);
        IntRef bracketedCommentLevel = IntRef.create((int)0);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        BooleanRef leavingBracketedComment = BooleanRef.create((boolean)false);
        BooleanRef isStatement = BooleanRef.create((boolean)false);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            if (leavingBracketedComment$1.elem) {
                --bracketedCommentLevel$1.elem;
                leavingBracketedComment$1.elem = false;
            }
            if (line.charAt(index) == '\'' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                    insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                }
            } else if (line.charAt(index) == '\"' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideSingleQuote$1.elem) {
                    insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                }
            } else if (line.charAt(index) == '-') {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel) && hasNext && line.charAt(index + 1) == '-') {
                    insideSimpleComment$1.elem = true;
                }
            } else if (line.charAt(index) == ';') {
                if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel))) {
                    Object object = isStatement$1.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex$1.elem, index))) : BoxedUnit.UNIT;
                    beginIndex$1.elem = index + 1;
                    isStatement$1.elem = false;
                }
            } else if (line.charAt(index) == '\n') {
                if (!escape$1.elem) {
                    insideSimpleComment$1.elem = false;
                }
            } else if (line.charAt(index) == '/' && !insideSimpleComment$1.elem) {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideSingleQuote$1.elem && !insideDoubleQuote$1.elem) {
                    if (SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index - 1) == '*') {
                        leavingBracketedComment$1.elem = true;
                    } else if (hasNext && !SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index + 1) == '*') {
                        ++bracketedCommentLevel$1.elem;
                    }
                }
            }
            if (escape$1.elem) {
                escape$1.elem = false;
            } else if (line.charAt(index) == '\\') {
                escape$1.elem = true;
            }
            isStatement$1.elem = SparkSQLCLIDriver.statementInProgress$1(index, isStatement, beginIndex, line, insideSimpleComment, bracketedCommentLevel);
        });
        Object object = isStatement.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex.elem))) : BoxedUnit.UNIT;
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public static final /* synthetic */ void $anonfun$processLine$1(SparkSQLCLIDriver $this, ObjectRef command$1, IntRef lastRet$1, Object nonLocalReturnKey1$1, String oneCmd) {
        if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
            command$1.elem = new StringBuilder(1).append((String)command$1.elem).append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd)).append(";").toString();
        } else {
            command$1.elem = new StringBuilder(0).append((String)command$1.elem).append(oneCmd).toString();
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)command$1.elem))) {
                int ret = $this.processCmd((String)command$1.elem);
                command$1.elem = "";
                lastRet$1.elem = ret;
                boolean ignoreErrors = HiveConf.getBoolVar((Configuration)$this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
                if (ret != 0 && !ignoreErrors) {
                    CommandProcessorFactory.clean((HiveConf)((HiveConf)$this.conf()));
                    throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, ret);
                }
            }
        }
    }

    private static final boolean insideBracketedComment$1(IntRef bracketedCommentLevel$1) {
        return bracketedCommentLevel$1.elem > 0;
    }

    private static final boolean insideComment$1(BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return insideSimpleComment$1.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel$1);
    }

    private static final boolean statementInProgress$1(int index, BooleanRef isStatement$1, IntRef beginIndex$1, String line$1, BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return isStatement$1.elem || !SparkSQLCLIDriver.insideComment$1(insideSimpleComment$1, bracketedCommentLevel$1) && index > beginIndex$1.elem && !String.valueOf(BoxesRunTime.boxToCharacter((char)line$1.charAt(index))).trim().isEmpty();
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LoggerFactory.getLogger(SparkSQLCLIDriver.class);
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel(Level.WARN.toString());
            }
        } else {
            throw new RuntimeException("Remote operations not supported");
        }
    }
}

