/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$ExecutionState$;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener$;
import org.apache.spark.sql.hive.thriftserver.ui.LiveExecutionData;
import org.apache.spark.sql.hive.thriftserver.ui.LiveSessionData;
import org.apache.spark.sql.hive.thriftserver.ui.SessionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationCanceled;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationError;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationFinish;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationParsed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationStart;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionCreated;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.LiveEntity;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=d!B\u0016-\u00019R\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t;\u0002\u0011\t\u0011)A\u0005=\")\u0011\r\u0001C\u0001E\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007bBA\u0004\u0001\u0001\u0006Ia\u001b\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"!\u0006\u0001A\u0003%\u0011Q\u0002\u0005\r\u0003/\u0001\u0001\u0013!A\u0002B\u0003%\u0011\u0011\u0004\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"!\u000b\u0001A\u0003%\u0011q\u0004\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003OA\u0001\"!\f\u0001A\u0003%\u0011q\u0004\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"!\u000f\u0001A\u0003%\u00111\u0007\u0005\t\u0003w\u0001A\u0011\u0001\u0018\u0002>!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"I\u0011Q\u001f\u0001\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!1\u000b\u0001\u0005\n\tUsA\u0003B0Y\u0005\u0005\t\u0012\u0001\u0018\u0003b\u0019I1\u0006LA\u0001\u0012\u0003q#1\r\u0005\u0007C\"\"\tAa\u001b\t\u0013\t5\u0004&%A\u0005\u0002\u0005](!\u0007%jm\u0016$\u0006N]5giN+'O^3se1K7\u000f^3oKJT!!\f\u0018\u0002\u0005UL'BA\u00181\u00031!\bN]5giN,'O^3s\u0015\t\t$'\u0001\u0003iSZ,'BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sON\u0011\u0001a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}Q\n\u0011b]2iK\u0012,H.\u001a:\n\u0005\u0001k$!D*qCJ\\G*[:uK:,'/A\u0004lmN$xN]3\u0004\u0001A\u0011AiR\u0007\u0002\u000b*\u0011a\tN\u0001\u0007gR\fG/^:\n\u0005!+%\u0001F#mK6,g\u000e\u001e+sC\u000e\\\u0017N\\4Ti>\u0014X-A\u0005ta\u0006\u00148nQ8oMB\u00111\nT\u0007\u0002i%\u0011Q\n\u000e\u0002\n'B\f'o[\"p]\u001a\faa]3sm\u0016\u0014\bc\u0001)T+6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004PaRLwN\u001c\t\u0003-nk\u0011a\u0016\u0006\u0003\u001dbS!!\u0017.\u0002\u000fM,'O^5dK*\u0011\u0011GN\u0005\u00039^\u00131\u0002S5wKN+'O^3se\u0005!A.\u001b<f!\t\u0001v,\u0003\u0002a#\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0003dK\u001a<\u0007\u000e\u0005\u0002e\u00015\tA\u0006C\u0003B\u000b\u0001\u00071\tC\u0003J\u000b\u0001\u0007!\nC\u0003O\u000b\u0001\u0007q\nC\u0004^\u000bA\u0005\t\u0019\u00010\u0002\u0017M,7o]5p]2K7\u000f^\u000b\u0002WB)An];\u0002\u00025\tQN\u0003\u0002o_\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\f\u0018\u0001B;uS2T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u[\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005YlhBA<|!\tA\u0018+D\u0001z\u0015\tQ()\u0001\u0004=e>|GOP\u0005\u0003yF\u000ba\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0\u0015\t\u0004I\u0006\r\u0011bAA\u0003Y\tyA*\u001b<f'\u0016\u001c8/[8o\t\u0006$\u0018-\u0001\u0007tKN\u001c\u0018n\u001c8MSN$\b%A\u0007fq\u0016\u001cW\u000f^5p]2K7\u000f^\u000b\u0003\u0003\u001b\u0001R\u0001\\:v\u0003\u001f\u00012\u0001ZA\t\u0013\r\t\u0019\u0002\f\u0002\u0012\u0019&4X-\u0012=fGV$\u0018n\u001c8ECR\f\u0017AD3yK\u000e,H/[8o\u0019&\u001cH\u000fI\u0001\u0004q\u0012\n\u0004c\u0002)\u0002\u001c\u0005}\u0011qD\u0005\u0004\u0003;\t&A\u0002+va2,'\u0007E\u0002Q\u0003CI1!a\tR\u0005\rIe\u000e^\u0001\u0013e\u0016$\u0018-\u001b8fIN#\u0018\r^3nK:$8/\u0006\u0002\u0002 \u0005\u0019\"/\u001a;bS:,Gm\u0015;bi\u0016lWM\u001c;tA\u0005\u0001\"/\u001a;bS:,GmU3tg&|gn]\u0001\u0012e\u0016$\u0018-\u001b8fIN+7o]5p]N\u0004\u0013A\u00057jm\u0016,\u0006\u000fZ1uKB+'/[8e\u001dN,\"!a\r\u0011\u0007A\u000b)$C\u0002\u00028E\u0013A\u0001T8oO\u0006\u0019B.\u001b<f+B$\u0017\r^3QKJLw\u000e\u001a(tA\u0005Qan\u001c'jm\u0016$\u0015\r^1\u0015\u0003y\u000b\u0001c\u001c8BaBd\u0017nY1uS>tWI\u001c3\u0015\t\u0005\r\u0013\u0011\n\t\u0004!\u0006\u0015\u0013bAA$#\n!QK\\5u\u0011\u001d\tYE\u0005a\u0001\u0003\u001b\na\"\u00199qY&\u001c\u0017\r^5p]\u0016sG\rE\u0002=\u0003\u001fJ1!!\u0015>\u0005m\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0006\u0003\b\u000f\\5dCRLwN\\#oI\u0006QqN\u001c&pEN#\u0018M\u001d;\u0015\t\u0005\r\u0013q\u000b\u0005\b\u00033\u001a\u0002\u0019AA.\u0003!QwNY*uCJ$\bc\u0001\u001f\u0002^%\u0019\u0011qL\u001f\u0003+M\u0003\u0018M]6MSN$XM\\3s\u0015>\u00147\u000b^1si\u0006\u0001R\u000f\u001d3bi\u0016TuN\u0019#fi\u0006LGn\u001d\u000b\u0007\u0003\u0007\n)'!\u001b\t\r\u0005\u001dD\u00031\u0001v\u0003\u0015QwNY%e\u0011\u0019\tY\u0007\u0006a\u0001k\u00069qM]8va&#\u0017\u0001D8o\u001fRDWM]#wK:$H\u0003BA\"\u0003cBq!a\u001d\u0016\u0001\u0004\t)(A\u0003fm\u0016tG\u000fE\u0002=\u0003oJ1!!\u001f>\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\u0002!=t7+Z:tS>t7I]3bi\u0016$G\u0003BA\"\u0003\u007fBq!!!\u0017\u0001\u0004\t\u0019)A\u0001f!\r!\u0017QQ\u0005\u0004\u0003\u000fc#aJ*qCJ\\G*[:uK:,'\u000f\u00165sS\u001a$8+\u001a:wKJ\u001cVm]:j_:\u001c%/Z1uK\u0012\fqb\u001c8TKN\u001c\u0018n\u001c8DY>\u001cX\r\u001a\u000b\u0005\u0003\u0007\ni\tC\u0004\u0002\u0002^\u0001\r!a$\u0011\u0007\u0011\f\t*C\u0002\u0002\u00142\u0012ae\u00159be.d\u0015n\u001d;f]\u0016\u0014H\u000b\u001b:jMR\u001cVM\u001d<feN+7o]5p]\u000ecwn]3e\u0003Aygn\u00149fe\u0006$\u0018n\u001c8Ti\u0006\u0014H\u000f\u0006\u0003\u0002D\u0005e\u0005bBAA1\u0001\u0007\u00111\u0014\t\u0004I\u0006u\u0015bAAPY\t93\u000b]1sW2K7\u000f^3oKJ$\u0006N]5giN+'O^3s\u001fB,'/\u0019;j_:\u001cF/\u0019:u\u0003Eygn\u00149fe\u0006$\u0018n\u001c8QCJ\u001cX\r\u001a\u000b\u0005\u0003\u0007\n)\u000bC\u0004\u0002\u0002f\u0001\r!a*\u0011\u0007\u0011\fI+C\u0002\u0002,2\u0012\u0001f\u00159be.d\u0015n\u001d;f]\u0016\u0014H\u000b\u001b:jMR\u001cVM\u001d<fe>\u0003XM]1uS>t\u0007+\u0019:tK\u0012\f1c\u001c8Pa\u0016\u0014\u0018\r^5p]\u000e\u000bgnY3mK\u0012$B!a\u0011\u00022\"9\u0011\u0011\u0011\u000eA\u0002\u0005M\u0006c\u00013\u00026&\u0019\u0011q\u0017\u0017\u0003UM\u0003\u0018M]6MSN$XM\\3s)\"\u0014\u0018N\u001a;TKJ4XM](qKJ\fG/[8o\u0007\u0006t7-\u001a7fI\u0006\u0001rN\\(qKJ\fG/[8o\u000bJ\u0014xN\u001d\u000b\u0005\u0003\u0007\ni\fC\u0004\u0002\u0002n\u0001\r!a0\u0011\u0007\u0011\f\t-C\u0002\u0002D2\u0012qe\u00159be.d\u0015n\u001d;f]\u0016\u0014H\u000b\u001b:jMR\u001cVM\u001d<fe>\u0003XM]1uS>tWI\u001d:pe\u0006\u0019rN\\(qKJ\fG/[8o\r&t\u0017n\u001d5fIR!\u00111IAe\u0011\u001d\t\t\t\ba\u0001\u0003\u0017\u00042\u0001ZAg\u0013\r\ty\r\f\u0002)'B\f'o\u001b'jgR,g.\u001a:UQJLg\r^*feZ,'o\u00149fe\u0006$\u0018n\u001c8GS:L7\u000f[\u0001\u0012_:|\u0005/\u001a:bi&|gn\u00117pg\u0016$G\u0003BA\"\u0003+Dq!!!\u001e\u0001\u0004\t9\u000eE\u0002e\u00033L1!a7-\u0005!\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8feRC'/\u001b4u'\u0016\u0014h/\u001a:Pa\u0016\u0014\u0018\r^5p]\u000ecwn]3e\u0003u)\b\u000fZ1uKN#xN]3XSRDGK]5hO\u0016\u0014XI\\1cY\u0016$G\u0003BA\"\u0003CDq!a9\u001f\u0001\u0004\t)/\u0001\u0004f]RLG/\u001f\t\u0004\t\u0006\u001d\u0018bAAu\u000b\nQA*\u001b<f\u000b:$\u0018\u000e^=\u0002\u001fU\u0004H-\u0019;f\u0019&4Xm\u0015;pe\u0016$b!a\u0011\u0002p\u0006E\bbBAr?\u0001\u0007\u0011Q\u001d\u0005\t\u0003g|\u0002\u0013!a\u0001=\u00069AO]5hO\u0016\u0014\u0018!G;qI\u0006$X\rT5wKN#xN]3%I\u00164\u0017-\u001e7uII*\"!!?+\u0007y\u000bYp\u000b\u0002\u0002~B!\u0011q B\u0005\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\t\u0015\u0011!C;oG\",7m[3e\u0015\r\u00119!U\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0006\u0005\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00151G.^:i)\u0011\t\u0019E!\u0005\t\u000f\tM\u0011\u00051\u0001\u0003\u0016\u0005yQM\u001c;jif4E.^:i\rVt7\rE\u0004Q\u0005/\t)/a\u0011\n\u0007\te\u0011KA\u0005Gk:\u001cG/[8oc\u0005\u0011r-\u001a;Pe\u000e\u0013X-\u0019;f'\u0016\u001c8/[8o))\t\tAa\b\u0003$\t\u001d\"1\u0006\u0005\u0007\u0005C\u0011\u0003\u0019A;\u0002\u0013M,7o]5p]&#\u0007b\u0002B\u0013E\u0001\u0007\u00111G\u0001\ngR\f'\u000f\u001e+j[\u0016DaA!\u000b#\u0001\u0004)\u0018AA5q\u0011\u0019\u0011iC\ta\u0001k\u0006AQo]3s]\u0006lW-\u0001\u000bhKR|%o\u0011:fCR,W\t_3dkRLwN\u001c\u000b\r\u0003\u001f\u0011\u0019Da\u000e\u0003<\tu\"\u0011\t\u0005\u0007\u0005k\u0019\u0003\u0019A;\u0002\r\u0015DXmY%e\u0011\u0019\u0011Id\ta\u0001k\u0006I1\u000f^1uK6,g\u000e\u001e\u0005\u0007\u0005C\u0019\u0003\u0019A;\t\u000f\t}2\u00051\u0001\u00024\u0005q1\u000f^1siRKW.Z:uC6\u0004\bB\u0002B\"G\u0001\u0007Q/\u0001\u0005vg\u0016\u0014h*Y7f\u0003E\u0019G.Z1okB,\u00050Z2vi&|gn\u001d\u000b\u0005\u0003\u0007\u0012I\u0005C\u0004\u0003L\u0011\u0002\r!a\r\u0002\u000b\r|WO\u001c;\u0002\u001d\rdW-\u00198vaN+7o]5p]R!\u00111\tB)\u0011\u001d\u0011Y%\na\u0001\u0003g\tqcY1mGVd\u0017\r^3Ok6\u0014WM\u001d+p%\u0016lwN^3\u0015\r\u0005M\"q\u000bB.\u0011\u001d\u0011IF\na\u0001\u0003g\t\u0001\u0002Z1uCNK'0\u001a\u0005\b\u0005;2\u0003\u0019AA\u001a\u00031\u0011X\r^1j]\u0016$7+\u001b>f\u0003eA\u0015N^3UQJLg\r^*feZ,'O\r'jgR,g.\u001a:\u0011\u0005\u0011D3c\u0001\u0015\u0003fA\u0019\u0001Ka\u001a\n\u0007\t%\u0014K\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005C\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class HiveThriftServer2Listener
extends SparkListener {
    private final ElementTrackingStore kvstore;
    private final Option<HiveServer2> server;
    private final boolean live;
    private final ConcurrentHashMap<String, LiveSessionData> sessionList;
    private final ConcurrentHashMap<String, LiveExecutionData> executionList;
    private final /* synthetic */ Tuple2 x$1;
    private final int retainedStatements;
    private final int retainedSessions;
    private final long liveUpdatePeriodNs;

    public static boolean $lessinit$greater$default$4() {
        return HiveThriftServer2Listener$.MODULE$.$lessinit$greater$default$4();
    }

    private ConcurrentHashMap<String, LiveSessionData> sessionList() {
        return this.sessionList;
    }

    private ConcurrentHashMap<String, LiveExecutionData> executionList() {
        return this.executionList;
    }

    private int retainedStatements() {
        return this.retainedStatements;
    }

    private int retainedSessions() {
        return this.retainedSessions;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    public boolean noLiveData() {
        return this.sessionList().isEmpty() && this.executionList().isEmpty();
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        block0: {
            if (!this.live) break block0;
            this.server.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        block0: {
            String groupId;
            Properties properties = jobStart.properties();
            if (properties == null || (groupId = properties.getProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID())) == null) break block0;
            this.updateJobDetails(((Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())).toString(), groupId);
        }
    }

    private void updateJobDetails(String jobId, String groupId) {
        Seq execList = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executionList().values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$updateJobDetails$1(groupId, x$3)))).toSeq();
        if (execList.nonEmpty()) {
            execList.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                HiveThriftServer2Listener.$anonfun$updateJobDetails$2(this, jobId, exec);
                return BoxedUnit.UNIT;
            });
        } else {
            Iterable storeExecInfo = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.kvstore.view(ExecutionInfo.class)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$updateJobDetails$3(groupId, x$4)));
            storeExecInfo.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                LiveExecutionData liveExec = this.getOrCreateExecution(exec.execId(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userName());
                liveExec.jobId().$plus$eq((Object)jobId.toString());
                this.updateStoreWithTriggerEnabled(liveExec);
                return this.executionList().remove(liveExec.execId());
            });
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerThriftServerSessionCreated) {
            SparkListenerThriftServerSessionCreated sparkListenerThriftServerSessionCreated = (SparkListenerThriftServerSessionCreated)sparkListenerEvent;
            this.onSessionCreated(sparkListenerThriftServerSessionCreated);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerSessionClosed) {
            SparkListenerThriftServerSessionClosed sparkListenerThriftServerSessionClosed = (SparkListenerThriftServerSessionClosed)sparkListenerEvent;
            this.onSessionClosed(sparkListenerThriftServerSessionClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationStart) {
            SparkListenerThriftServerOperationStart sparkListenerThriftServerOperationStart = (SparkListenerThriftServerOperationStart)sparkListenerEvent;
            this.onOperationStart(sparkListenerThriftServerOperationStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationParsed) {
            SparkListenerThriftServerOperationParsed sparkListenerThriftServerOperationParsed = (SparkListenerThriftServerOperationParsed)sparkListenerEvent;
            this.onOperationParsed(sparkListenerThriftServerOperationParsed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationCanceled) {
            SparkListenerThriftServerOperationCanceled sparkListenerThriftServerOperationCanceled = (SparkListenerThriftServerOperationCanceled)sparkListenerEvent;
            this.onOperationCanceled(sparkListenerThriftServerOperationCanceled);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationError) {
            SparkListenerThriftServerOperationError sparkListenerThriftServerOperationError = (SparkListenerThriftServerOperationError)sparkListenerEvent;
            this.onOperationError(sparkListenerThriftServerOperationError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationFinish) {
            SparkListenerThriftServerOperationFinish sparkListenerThriftServerOperationFinish = (SparkListenerThriftServerOperationFinish)sparkListenerEvent;
            this.onOperationFinished(sparkListenerThriftServerOperationFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerThriftServerOperationClosed) {
            SparkListenerThriftServerOperationClosed sparkListenerThriftServerOperationClosed = (SparkListenerThriftServerOperationClosed)sparkListenerEvent;
            this.onOperationClosed(sparkListenerThriftServerOperationClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onSessionCreated(SparkListenerThriftServerSessionCreated e) {
        LiveSessionData session = this.getOrCreateSession(e.sessionId(), e.startTime(), e.ip(), e.userName());
        this.sessionList().put(e.sessionId(), session);
        this.updateLiveStore(session, this.updateLiveStore$default$2());
    }

    private void onSessionClosed(SparkListenerThriftServerSessionClosed e) {
        LiveSessionData session = this.sessionList().get(e.sessionId());
        session.finishTimestamp_$eq(e.finishTime());
        this.updateStoreWithTriggerEnabled(session);
        this.sessionList().remove(e.sessionId());
    }

    private void onOperationStart(SparkListenerThriftServerOperationStart e) {
        LiveExecutionData info = this.getOrCreateExecution(e.id(), e.statement(), e.sessionId(), e.startTime(), e.userName());
        info.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.STARTED());
        this.executionList().put(e.id(), info);
        LiveSessionData liveSessionData = this.sessionList().get(e.sessionId());
        liveSessionData.totalExecution_$eq(liveSessionData.totalExecution() + 1);
        this.executionList().get(e.id()).groupId_$eq(e.groupId());
        this.updateLiveStore(this.executionList().get(e.id()), this.updateLiveStore$default$2());
        this.updateLiveStore(this.sessionList().get(e.sessionId()), this.updateLiveStore$default$2());
    }

    private void onOperationParsed(SparkListenerThriftServerOperationParsed e) {
        this.executionList().get(e.id()).executePlan_$eq(e.executionPlan());
        this.executionList().get(e.id()).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.COMPILED());
        this.updateLiveStore(this.executionList().get(e.id()), this.updateLiveStore$default$2());
    }

    private void onOperationCanceled(SparkListenerThriftServerOperationCanceled e) {
        this.executionList().get(e.id()).finishTimestamp_$eq(e.finishTime());
        this.executionList().get(e.id()).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.CANCELED());
        this.updateLiveStore(this.executionList().get(e.id()), this.updateLiveStore$default$2());
    }

    private void onOperationError(SparkListenerThriftServerOperationError e) {
        this.executionList().get(e.id()).finishTimestamp_$eq(e.finishTime());
        this.executionList().get(e.id()).detail_$eq(e.errorMsg());
        this.executionList().get(e.id()).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FAILED());
        this.updateLiveStore(this.executionList().get(e.id()), this.updateLiveStore$default$2());
    }

    private void onOperationFinished(SparkListenerThriftServerOperationFinish e) {
        this.executionList().get(e.id()).finishTimestamp_$eq(e.finishTime());
        this.executionList().get(e.id()).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FINISHED());
        this.updateLiveStore(this.executionList().get(e.id()), this.updateLiveStore$default$2());
    }

    private void onOperationClosed(SparkListenerThriftServerOperationClosed e) {
        this.executionList().get(e.id()).closeTimestamp_$eq(e.closeTime());
        this.executionList().get(e.id()).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.CLOSED());
        this.updateStoreWithTriggerEnabled(this.executionList().get(e.id()));
        this.executionList().remove(e.id());
    }

    public void updateStoreWithTriggerEnabled(LiveEntity entity) {
        entity.write(this.kvstore, System.nanoTime(), true);
    }

    public void updateLiveStore(LiveEntity entity, boolean trigger) {
        block0: {
            long now = System.nanoTime();
            if (!this.live || this.liveUpdatePeriodNs() < 0L || now - entity.lastWriteTime() <= this.liveUpdatePeriodNs()) break block0;
            entity.write(this.kvstore, now, trigger);
        }
    }

    public boolean updateLiveStore$default$2() {
        return false;
    }

    private void flush(Function1<LiveEntity, BoxedUnit> entityFlushFunc) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sessionList().values()).asScala()).foreach(entityFlushFunc);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.executionList().values()).asScala()).foreach(entityFlushFunc);
    }

    private LiveSessionData getOrCreateSession(String sessionId, long startTime, String ip, String username) {
        return this.sessionList().computeIfAbsent(sessionId, x$5 -> new LiveSessionData(sessionId, startTime, ip, username));
    }

    private LiveExecutionData getOrCreateExecution(String execId, String statement, String sessionId, long startTimestamp, String userName) {
        return this.executionList().computeIfAbsent(execId, x$6 -> new LiveExecutionData(execId, statement, sessionId, startTimestamp, userName));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedStatements());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(ExecutionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$cleanupExecutions$1(j)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.execId());
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupSession(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedSessions());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SessionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)j -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$cleanupSession$1(j)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.sessionId());
            return BoxedUnit.UNIT;
        });
    }

    private long calculateNumberToRemove(long dataSize, long retainedSize) {
        return dataSize > retainedSize ? package$.MODULE$.max(retainedSize / 10L, dataSize - retainedSize) : 0L;
    }

    public static final /* synthetic */ boolean $anonfun$updateJobDetails$1(String groupId$1, LiveExecutionData x$3) {
        String string = x$3.groupId();
        String string2 = groupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateJobDetails$2(HiveThriftServer2Listener $this, String jobId$1, LiveExecutionData exec) {
        exec.jobId().$plus$eq((Object)jobId$1.toString());
        $this.updateLiveStore(exec, $this.updateLiveStore$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$updateJobDetails$3(String groupId$1, ExecutionInfo x$4) {
        String string = x$4.groupId();
        String string2 = groupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(ExecutionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupSession$1(SessionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public HiveThriftServer2Listener(ElementTrackingStore kvstore, SparkConf sparkConf, Option<HiveServer2> server, boolean live) {
        this.kvstore = kvstore;
        this.server = server;
        this.live = live;
        this.sessionList = new ConcurrentHashMap();
        this.executionList = new ConcurrentHashMap();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_UI_STATEMENT_LIMIT())), BoxesRunTime.unboxToInt((Object)sparkConf.get(SQLConf$.MODULE$.THRIFTSERVER_UI_SESSION_LIMIT())));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int retainedStatements = sp2._1$mcI$sp();
        int retainedSessions = sp2._2$mcI$sp();
        int n = retainedStatements;
        int n2 = retainedSessions;
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(n, n2);
        this.x$1 = sp3;
        this.retainedStatements = this.x$1._1$mcI$sp();
        this.retainedSessions = this.x$1._2$mcI$sp();
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)sparkConf.get(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        kvstore.addTrigger(SessionInfo.class, (long)this.retainedSessions(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupSession(count));
        kvstore.addTrigger(ExecutionInfo.class, (long)this.retainedStatements(), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupExecutions(count));
        kvstore.onFlush((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.live) break block0;
                this.flush((Function1<LiveEntity, BoxedUnit>)(Function1 & Serializable & scala.Serializable)entity -> {
                    this.updateStoreWithTriggerEnabled(entity);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }
}

