/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLSessionManager;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3QAB\u0004\u0001\u0013MA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)a\u0006\u0001C\u0001_!)1\u0007\u0001C!i!)a\t\u0001C!\u000f\n\u00112\u000b]1sWN\u000bFj\u0011'J'\u0016\u0014h/[2f\u0015\tA\u0011\"\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002\u000b\u0017\u0005!\u0001.\u001b<f\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\n\u0004\u0001Qi\u0002CA\u000b\u001c\u001b\u00051\"BA\f\u0019\u0003\r\u0019G.\u001b\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u000b\u001f%\u0011AD\u0006\u0002\u000b\u00072K5+\u001a:wS\u000e,\u0007C\u0001\u0010 \u001b\u00059\u0011B\u0001\u0011\b\u0005e\u0011VM\u001a7fGR,GmQ8na>\u001c\u0018\u000e^3TKJ4\u0018nY3\u0002\u0015!Lg/Z*feZ,'o\u0001\u0001\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019B\u0012AB:feZ,'/\u0003\u0002)K\tY\u0001*\u001b<f'\u0016\u0014h/\u001a:3\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003W1j\u0011aC\u0005\u0003[-\u0011!bU)M\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0001'\r\u001a\u0011\u0005y\u0001\u0001\"B\u0011\u0004\u0001\u0004\u0019\u0003\"B\u0015\u0004\u0001\u0004Q\u0013\u0001B5oSR$\"!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006y\u0011\u0001\r!P\u0001\tQ&4XmQ8oMB\u0011a\bR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005G>tgM\u0003\u0002\u000b\u0005*\u00111iD\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0015{$\u0001\u0003%jm\u0016\u001cuN\u001c4\u0002\u000f\u001d,G/\u00138g_R\u0019\u0001j\u0013)\u0011\u0005UI\u0015B\u0001&\u0017\u000519U\r^%oM>4\u0016\r\\;f\u0011\u0015aU\u00011\u0001N\u00035\u0019Xm]:j_:D\u0015M\u001c3mKB\u0011QCT\u0005\u0003\u001fZ\u0011QbU3tg&|g\u000eS1oI2,\u0007\"B)\u0006\u0001\u0004\u0011\u0016aC4fi&sgm\u001c+za\u0016\u0004\"!F*\n\u0005Q3\"aC$fi&sgm\u001c+za\u0016\u0004")
public class SparkSQLCLIService
extends CLIService
implements ReflectedCompositeService {
    private final HiveServer2 hiveServer;
    private final SQLContext sqlContext;

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService.initCompositeService$(this, hiveConf);
    }

    @Override
    public void init(HiveConf hiveConf) {
        ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
        SparkSQLSessionManager sparkSqlSessionManager = new SparkSQLSessionManager(this.hiveServer, this.sqlContext);
        ReflectionUtils$.MODULE$.setSuperField(this, "sessionManager", sparkSqlSessionManager);
        this.addService(sparkSqlSessionManager);
        UserGroupInformation sparkServiceUGI = null;
        UserGroupInformation httpUGI = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                UserGroupInformation userGroupInformation;
                String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
                String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
                if (principal.isEmpty() || keyTabFile.isEmpty()) {
                    throw new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
                }
                UserGroupInformation originalUgi = UserGroupInformation.getCurrentUser();
                if (HiveAuthFactory.needUgiLogin(originalUgi, SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), keyTabFile)) {
                    HiveAuthFactory.loginFromKeytab(hiveConf);
                    userGroupInformation = Utils.getUGI();
                } else {
                    userGroupInformation = originalUgi;
                }
                sparkServiceUGI = userGroupInformation;
                ReflectionUtils$.MODULE$.setSuperField(this, "serviceUGI", sparkServiceUGI);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof LoginException;
                if (bl) {
                    throw new ServiceException("Unable to login to kerberos with given principal/keytab", throwable2);
                }
                throw throwable;
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL).trim();
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB).trim();
            if (new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(keyTabFile)).nonEmpty()) {
                try {
                    httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    ReflectionUtils$.MODULE$.setSuperField(this, "httpUGI", httpUGI);
                }
                catch (IOException e) {
                    throw new ServiceException(new StringBuilder(61).append("Unable to login to spnego with given principal ").append(principal).append(" and keytab ").append(keyTabFile).append(": ").append(e).toString(), e);
                }
            }
        }
        this.initCompositeService(hiveConf);
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) {
        GetInfoType getInfoType2 = getInfoType;
        GetInfoValue getInfoValue = ((Object)((Object)GetInfoType.CLI_SERVER_NAME)).equals((Object)getInfoType2) ? new GetInfoValue("Spark SQL") : (((Object)((Object)GetInfoType.CLI_DBMS_NAME)).equals((Object)getInfoType2) ? new GetInfoValue("Spark SQL") : (((Object)((Object)GetInfoType.CLI_DBMS_VER)).equals((Object)getInfoType2) ? new GetInfoValue(this.sqlContext.sparkContext().version()) : super.getInfo(sessionHandle, getInfoType)));
        return getInfoValue;
    }

    public SparkSQLCLIService(HiveServer2 hiveServer, SQLContext sqlContext) {
        this.hiveServer = hiveServer;
        this.sqlContext = sqlContext;
        super(hiveServer);
        ReflectedCompositeService.$init$(this);
    }
}

