/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001E4Qa\u0003\u0007\u0001\u001daA\u0001B\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!Y\u0005A!A!\u0002\u0013q\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u00115\u0003!\u0011!Q\u0001\n9CQA\u0016\u0001\u0005\u0002]CQa\u0018\u0001\u0005B\u0001DQ!\u001a\u0001\u0005\n\u0019\u0014qc\u00159be.<U\r\u001e+bE2,7o\u00149fe\u0006$\u0018n\u001c8\u000b\u00055q\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\b\u0011\u0003\u0011A\u0017N^3\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0005\u0003\u00013\u0011B\u0003C\u0001\u000e#\u001b\u0005Y\"B\u0001\u000f\u001e\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u001f?\u0005\u00191\r\\5\u000b\u0005\u0001\n\u0013aB:feZL7-\u001a\u0006\u0003\u001fQI!aI\u000e\u0003%\u001d+G\u000fV1cY\u0016\u001cx\n]3sCRLwN\u001c\t\u0003K\u0019j\u0011\u0001D\u0005\u0003O1\u0011ab\u00159be.|\u0005/\u001a:bi&|g\u000e\u0005\u0002*Y5\t!F\u0003\u0002,%\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017AC:rY\u000e{g\u000e^3yi\u000e\u0001Q#A\u0019\u0011\u0005I\u001aT\"\u0001\t\n\u0005Q\u0002\"AC*R\u0019\u000e{g\u000e^3yi\u0006Y1/\u001d7D_:$X\r\u001f;!\u00035\u0001\u0018M]3oiN+7o]5p]B\u0011\u0001hO\u0007\u0002s)\u0011!(H\u0001\bg\u0016\u001c8/[8o\u0013\ta\u0014HA\u0006ISZ,7+Z:tS>t\u0017aC2bi\u0006dwn\u001a(b[\u0016\u0004\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"0\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9E)\u0001\u0006tG\",W.\u0019(b[\u0016\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u0015Q\f'\r\\3UsB,7\u000fE\u0002P)zj\u0011\u0001\u0015\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u0011a\u0015n\u001d;\u0002\rqJg.\u001b;?)\u001dA\u0016LW.];z\u0003\"!\n\u0001\t\u000b9B\u0001\u0019A\u0019\t\u000bYB\u0001\u0019A\u001c\t\u000buB\u0001\u0019\u0001 \t\u000b-C\u0001\u0019\u0001 \t\u000b1C\u0001\u0019\u0001 \t\u000b5C\u0001\u0019\u0001(\u0002\u0017I,h.\u00138uKJt\u0017\r\u001c\u000b\u0002CB\u0011!mY\u0007\u0002\t&\u0011A\r\u0012\u0002\u0005+:LG/A\u0006bI\u0012$vNU8x'\u0016$H#B1hS*d\u0007\"\u00025\u000b\u0001\u0004q\u0014A\u00023c\u001d\u0006lW\rC\u0003M\u0015\u0001\u0007a\bC\u0003l\u0015\u0001\u0007a(A\u0005uC\ndW\rV=qK\")QN\u0003a\u0001]\u000691m\\7nK:$\bc\u00012p}%\u0011\u0001\u000f\u0012\u0002\u0007\u001fB$\u0018n\u001c8")
public class SparkGetTablesOperation
extends GetTablesOperation
implements SparkOperation {
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<String> tableTypes;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void runInternal() {
        String cmdStr = new StringBuilder(28).append("catalog : ").append(this.catalogName).append(", schemaPattern : ").append(this.schemaName).toString();
        String tableTypesStr = this.tableTypes == null ? "null" : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableTypes).asScala()).mkString(",");
        String logMsg = new StringBuilder(46).append("Listing tables '").append(cmdStr).append(", tableTypes : ").append(tableTypesStr).append(", tableName : ").append(this.tableName).append("'").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(logMsg).append(" with ").append(this.statementId()).toString());
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        SessionCatalog catalog = this.sqlContext().sessionState().catalog();
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        String tablePattern = this.convertIdentifierPattern(this.tableName, true);
        Seq matchingDbs = catalog.listDatabases(schemaPattern);
        if (this.isAuthV2Enabled()) {
            List privObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(matchingDbs).asJava()));
            this.authorizeMetaGets(HiveOperationType.GET_TABLES, privObjs, cmdStr);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        try {
            matchingDbs.foreach((Function1 & Serializable & scala.Serializable)dbName -> {
                SparkGetTablesOperation.$anonfun$runInternal$2(this, catalog, tablePattern, dbName);
                return BoxedUnit.UNIT;
            });
            if (this.tableTypes == null || this.tableTypes.isEmpty() || this.tableTypes.contains(CatalogTableType$.MODULE$.VIEW().name())) {
                String globalTempViewDb = catalog.globalTempViewManager().database();
                Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
                Seq tempViews = databasePattern.matcher(globalTempViewDb).matches() ? catalog.listTables(globalTempViewDb, tablePattern, true) : catalog.listLocalTempViews(tablePattern);
                tempViews.foreach((Function1 & Serializable & scala.Serializable)view -> {
                    this.addToRowSet((String)view.database().orNull(Predef$.MODULE$.$conforms()), view.table(), CatalogTableType$.MODULE$.VIEW().name(), (Option<String>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            }
            this.setState(OperationState.FINISHED);
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error executing get tables operation with ").append(this.statementId()).toString(), e);
            this.setState(OperationState.ERROR);
            Throwable throwable = e;
            if (throwable instanceof HiveSQLException) {
                HiveSQLException hiveSQLException = (HiveSQLException)throwable;
                HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), hiveSQLException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)hiveSQLException));
                throw hiveSQLException;
            }
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), root.getMessage(), Utils$.MODULE$.exceptionString(root));
            throw new HiveSQLException(new StringBuilder(22).append("Error getting tables: ").append(root.toString()).toString(), root);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    private void addToRowSet(String dbName, String tableName, String tableType, Option<String> comment) {
        Object[] rowData = new Object[]{"", dbName, tableName, tableType, comment.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")};
        if (HiveUtils$.MODULE$.isHive23()) {
            this.rowSet.addRow((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rowData)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null, null, null}), ClassTag$.MODULE$.Null()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
        } else {
            this.rowSet.addRow(rowData);
        }
    }

    public static final /* synthetic */ void $anonfun$runInternal$3(SparkGetTablesOperation $this, CatalogTable table) {
        block0: {
            String tableType = $this.tableTypeString(table.tableType());
            if ($this.tableTypes != null && !$this.tableTypes.isEmpty() && !$this.tableTypes.contains(tableType)) break block0;
            $this.addToRowSet(table.database(), table.identifier().table(), tableType, (Option<String>)table.comment());
        }
    }

    public static final /* synthetic */ void $anonfun$runInternal$2(SparkGetTablesOperation $this, SessionCatalog catalog$1, String tablePattern$1, String dbName) {
        Seq tables = catalog$1.listTables(dbName, tablePattern$1, false);
        catalog$1.getTablesByName(tables).foreach((Function1 & Serializable & scala.Serializable)table -> {
            SparkGetTablesOperation.$anonfun$runInternal$3($this, table);
            return BoxedUnit.UNIT;
        });
    }

    public SparkGetTablesOperation(SQLContext sqlContext, HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableTypes = tableTypes;
        super(parentSession, catalogName, schemaName, tableName, tableTypes);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
    }
}

