/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4QAC\u0006\u0001\u001b]A\u0001\"\f\u0001\u0003\u0006\u0004%\ta\f\u0005\ti\u0001\u0011\t\u0011)A\u0005a!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!Q\u0005A!A!\u0002\u0013i\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b1\u0003A\u0011A'\t\u000bQ\u0003A\u0011I+\t\u0015i\u0003\u0001\u0013!A\u0001\u0002\u0013\u00051L\u0001\u000eTa\u0006\u00148nR3u\rVt7\r^5p]N|\u0005/\u001a:bi&|gN\u0003\u0002\r\u001b\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011abD\u0001\u0005Q&4XM\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001cB\u0001\u0001\r$OA\u0011\u0011$I\u0007\u00025)\u00111\u0004H\u0001\n_B,'/\u0019;j_:T!!\b\u0010\u0002\u0007\rd\u0017N\u0003\u0002 A\u000591/\u001a:wS\u000e,'B\u0001\b\u0014\u0013\t\u0011#DA\u000bHKR4UO\\2uS>t7o\u00149fe\u0006$\u0018n\u001c8\u0011\u0005\u0011*S\"A\u0006\n\u0005\u0019Z!AD*qCJ\\w\n]3sCRLwN\u001c\t\u0003Q-j\u0011!\u000b\u0006\u0003UE\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u00011!\t\t$'D\u0001\u0010\u0013\t\u0019tB\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005i\u0001/\u0019:f]R\u001cVm]:j_:\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u000f\u0002\u000fM,7o]5p]&\u00111\b\u000f\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007C\u0001 H\u001d\tyT\t\u0005\u0002A\u00076\t\u0011I\u0003\u0002C]\u00051AH]8pizR\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aiQ\u0001\u000bg\u000eDW-\\1OC6,\u0017\u0001\u00044v]\u000e$\u0018n\u001c8OC6,\u0017A\u0002\u001fj]&$h\b\u0006\u0004O\u001fB\u000b&k\u0015\t\u0003I\u0001AQ!L\u0004A\u0002ABQ!N\u0004A\u0002YBQ\u0001P\u0004A\u0002uBQAS\u0004A\u0002uBQaS\u0004A\u0002u\n1B];o\u0013:$XM\u001d8bYR\ta\u000b\u0005\u0002X16\t1)\u0003\u0002Z\u0007\n!QK\\5u\u0003A\u0001(o\u001c;fGR,G\r\n:poN+G\u000f\u0006\u0002]AB\u0011QLX\u0007\u00029%\u0011q\f\b\u0002\u0007%><8+\u001a;\t\u000f\u0005L\u0011\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010J\u0019")
public class SparkGetFunctionsOperation
extends GetFunctionsOperation
implements SparkOperation {
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String functionName;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ RowSet protected$rowSet(SparkGetFunctionsOperation x$1) {
        return x$1.rowSet;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void runInternal() {
        String cmdStr = new StringBuilder(28).append("catalog : ").append(this.catalogName).append(", schemaPattern : ").append(this.schemaName).toString();
        String logMsg = new StringBuilder(37).append("Listing functions '").append(cmdStr).append(", functionName : ").append(this.functionName).append("'").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(logMsg).append(" with ").append(this.statementId()).toString());
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        SessionCatalog catalog = this.sqlContext().sessionState().catalog();
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        Seq matchingDbs = catalog.listDatabases(schemaPattern);
        String functionPattern = CLIServiceUtils.patternToRegex(this.functionName);
        if (this.isAuthV2Enabled()) {
            List privObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(matchingDbs).asJava()));
            this.authorizeMetaGets(HiveOperationType.GET_FUNCTIONS, privObjs, cmdStr);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        try {
            matchingDbs.foreach((Function1 & Serializable & scala.Serializable)db -> {
                SparkGetFunctionsOperation.$anonfun$runInternal$2(this, catalog, functionPattern, db);
                return BoxedUnit.UNIT;
            });
            this.setState(OperationState.FINISHED);
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error executing get functions operation with ").append(this.statementId()).toString(), e);
            this.setState(OperationState.ERROR);
            Throwable throwable = e;
            if (throwable instanceof HiveSQLException) {
                HiveSQLException hiveSQLException = (HiveSQLException)throwable;
                HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), hiveSQLException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)hiveSQLException));
                throw hiveSQLException;
            }
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), root.getMessage(), Utils$.MODULE$.exceptionString(root));
            throw new HiveSQLException(new StringBuilder(25).append("Error getting functions: ").append(root.toString()).toString(), root);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    public static final /* synthetic */ void $anonfun$runInternal$2(SparkGetFunctionsOperation $this, SessionCatalog catalog$1, String functionPattern$1, String db) {
        catalog$1.listFunctions(db, functionPattern$1).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier funcIdentifier = (FunctionIdentifier)tuple2._1();
            ExpressionInfo info = catalog$1.lookupFunctionInfo(funcIdentifier);
            Object[] rowData = new Object[]{"", db, funcIdentifier.funcName(), info.getUsage(), BoxesRunTime.boxToInteger((int)0), info.getClassName()};
            RowSet rowSet = $this.protected$rowSet($this).addRow(rowData);
            return rowSet;
        });
    }

    public SparkGetFunctionsOperation(SQLContext sqlContext, HiveSession parentSession, String catalogName, String schemaName, String functionName) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.functionName = functionName;
        super(parentSession, catalogName, schemaName, functionName);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
    }
}

