/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.Arrays;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.sparkproject.jetty.server.AbstractConnectionFactory;
import org.sparkproject.jetty.server.ConnectionFactory;
import org.sparkproject.jetty.server.Connector;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.HttpConnectionFactory;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.ServerConnector;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import org.sparkproject.jetty.servlet.ServletHolder;
import org.sparkproject.jetty.util.ssl.SslContextFactory;
import org.sparkproject.jetty.util.thread.ExecutorThreadPool;
import org.sparkproject.jetty.util.thread.ScheduledExecutorScheduler;
import org.sparkproject.jetty.util.thread.Scheduler;
import org.sparkproject.jetty.util.thread.ThreadPool;

public class ThriftHttpCLIService
extends ThriftCLIService {
    public ThriftHttpCLIService(CLIService cliService) {
        super(cliService, ThriftHttpCLIService.class.getSimpleName());
    }

    @Override
    public void run() {
        try {
            ConnectionFactory[] connectionFactories;
            String schemeName;
            String threadPoolName = "HiveServer2-HttpHandler-Pool";
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.minWorkerThreads, this.maxWorkerThreads, this.workerKeepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryWithGarbageCleanup(threadPoolName));
            ExecutorThreadPool threadPool = new ExecutorThreadPool(executorService);
            this.httpServer = new Server((ThreadPool)threadPool);
            boolean useSsl = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                String keyStorePassword = ShimLoader.getHadoopShims().getPassword((Configuration)this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname);
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                Object[] excludedProtocols = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST).split(",");
                LOG.info("HTTP Server SSL: adding excluded protocols: " + Arrays.toString(excludedProtocols));
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols);
                LOG.info("HTTP Server SSL: SslContextFactory.getExcludeProtocols = " + Arrays.toString(sslContextFactory.getExcludeProtocols()));
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                connectionFactories = AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()});
            } else {
                connectionFactories = new ConnectionFactory[]{new HttpConnectionFactory()};
            }
            ServerConnector connector = new ServerConnector(this.httpServer, null, (Scheduler)new ScheduledExecutorScheduler("HiveServer2-HttpHandler-JettyScheduler", true), null, -1, -1, connectionFactories);
            connector.setPort(this.portNum);
            connector.setReuseAddress(!Shell.WINDOWS);
            int maxIdleTime = (int)this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_IDLE_TIME, TimeUnit.MILLISECONDS);
            connector.setIdleTimeout((long)maxIdleTime);
            this.httpServer.addConnector((Connector)connector);
            hiveAuthFactory = new HiveAuthFactory(this.hiveConf);
            TCLIService.Processor<ThriftHttpCLIService> processor = new TCLIService.Processor<ThriftHttpCLIService>(this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            UserGroupInformation serviceUGI = this.cliService.getServiceUGI();
            UserGroupInformation httpUGI = this.cliService.getHttpUGI();
            String authType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet(processor, (TProtocolFactory)protocolFactory, authType, serviceUGI, httpUGI, hiveAuthFactory);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            String httpPath = this.getHttpPath(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
            this.httpServer.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.httpServer.start();
            this.portNum = connector.getLocalPort();
            String msg = "Started " + ThriftHttpCLIService.class.getSimpleName() + " in " + schemeName + " mode on port " + this.portNum + " path=" + httpPath + " with " + this.minWorkerThreads + "..." + this.maxWorkerThreads + " worker threads";
            LOG.info(msg);
            this.httpServer.join();
        }
        catch (Throwable t) {
            LOG.error("Error starting HiveServer2: could not start " + ThriftHttpCLIService.class.getSimpleName(), t);
            System.exit(-1);
        }
    }

    private String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }
}

