/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.service.cli.ColumnValue;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.TypeDescriptor;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;

public class RowBasedSet
implements RowSet {
    private long startOffset;
    private final TypeDescriptor[] descriptors;
    private final RemovableList<TRow> rows;

    public RowBasedSet(TableSchema schema) {
        this.descriptors = schema.toTypeDescriptors();
        this.rows = new RemovableList();
    }

    public RowBasedSet(TRowSet tRowSet) {
        this.descriptors = null;
        this.rows = new RemovableList<TRow>(tRowSet.getRows());
        this.startOffset = tRowSet.getStartRowOffset();
    }

    private RowBasedSet(TypeDescriptor[] descriptors, List<TRow> rows, long startOffset) {
        this.descriptors = descriptors;
        this.rows = new RemovableList<TRow>(rows);
        this.startOffset = startOffset;
    }

    @Override
    public RowBasedSet addRow(Object[] fields) {
        TRow tRow = new TRow();
        for (int i = 0; i < fields.length; ++i) {
            tRow.addToColVals(ColumnValue.toTColumnValue(this.descriptors[i], fields[i]));
        }
        this.rows.add(tRow);
        return this;
    }

    @Override
    public int numColumns() {
        return this.rows.isEmpty() ? 0 : ((TRow)this.rows.get(0)).getColVals().size();
    }

    @Override
    public int numRows() {
        return this.rows.size();
    }

    @Override
    public RowBasedSet extractSubset(int maxRows) {
        int numRows = Math.min(this.numRows(), maxRows);
        RowBasedSet result = new RowBasedSet(this.descriptors, this.rows.subList(0, numRows), this.startOffset);
        this.rows.removeRange(0, numRows);
        this.startOffset += (long)numRows;
        return result;
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public int getSize() {
        return this.rows.size();
    }

    @Override
    public TRowSet toTRowSet() {
        TRowSet tRowSet = new TRowSet();
        tRowSet.setStartRowOffset(this.startOffset);
        tRowSet.setRows(new ArrayList<TRow>(this.rows));
        return tRowSet;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new Iterator<Object[]>(){
            final Iterator<TRow> iterator;
            final Object[] convey;
            {
                this.iterator = RowBasedSet.this.rows.iterator();
                this.convey = new Object[RowBasedSet.this.numColumns()];
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Object[] next() {
                TRow row = this.iterator.next();
                List<TColumnValue> values = row.getColVals();
                for (int i = 0; i < values.size(); ++i) {
                    this.convey[i] = ColumnValue.toColumnValue(values.get(i));
                }
                return this.convey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private static class RemovableList<E>
    extends ArrayList<E> {
        RemovableList() {
        }

        RemovableList(List<E> rows) {
            super(rows);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

