/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class DataTypeProtoConverter$ {
    public static DataTypeProtoConverter$ MODULE$;

    static {
        new DataTypeProtoConverter$();
    }

    public DataType toCatalystType(org.apache.spark.connect.proto.DataType t) {
        DataType.KindCase kindCase = t.getKindCase();
        if (((Object)((Object)DataType.KindCase.NULL)).equals((Object)kindCase)) {
            return NullType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BINARY)).equals((Object)kindCase)) {
            return BinaryType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BOOLEAN)).equals((Object)kindCase)) {
            return BooleanType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BYTE)).equals((Object)kindCase)) {
            return ByteType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.SHORT)).equals((Object)kindCase)) {
            return ShortType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.INTEGER)).equals((Object)kindCase)) {
            return IntegerType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.LONG)).equals((Object)kindCase)) {
            return LongType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.FLOAT)).equals((Object)kindCase)) {
            return FloatType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.DOUBLE)).equals((Object)kindCase)) {
            return DoubleType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.DECIMAL)).equals((Object)kindCase)) {
            return this.toCatalystDecimalType(t.getDecimal());
        }
        if (((Object)((Object)DataType.KindCase.STRING)).equals((Object)kindCase)) {
            return StringType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.CHAR)).equals((Object)kindCase)) {
            return new CharType(t.getChar().getLength());
        }
        if (((Object)((Object)DataType.KindCase.VAR_CHAR)).equals((Object)kindCase)) {
            return new VarcharType(t.getVarChar().getLength());
        }
        if (((Object)((Object)DataType.KindCase.DATE)).equals((Object)kindCase)) {
            return DateType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.TIMESTAMP)).equals((Object)kindCase)) {
            return TimestampType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.TIMESTAMP_NTZ)).equals((Object)kindCase)) {
            return TimestampNTZType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.CALENDAR_INTERVAL)).equals((Object)kindCase)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.YEAR_MONTH_INTERVAL)).equals((Object)kindCase)) {
            return this.toCatalystYearMonthIntervalType(t.getYearMonthInterval());
        }
        if (((Object)((Object)DataType.KindCase.DAY_TIME_INTERVAL)).equals((Object)kindCase)) {
            return this.toCatalystDayTimeIntervalType(t.getDayTimeInterval());
        }
        if (((Object)((Object)DataType.KindCase.ARRAY)).equals((Object)kindCase)) {
            return this.toCatalystArrayType(t.getArray());
        }
        if (((Object)((Object)DataType.KindCase.STRUCT)).equals((Object)kindCase)) {
            return this.toCatalystStructType(t.getStruct());
        }
        if (((Object)((Object)DataType.KindCase.MAP)).equals((Object)kindCase)) {
            return this.toCatalystMapType(t.getMap());
        }
        if (((Object)((Object)DataType.KindCase.UDT)).equals((Object)kindCase)) {
            return this.toCatalystUDT(t.getUdt());
        }
        throw new InvalidPlanInput(new StringBuilder(44).append("Does not support convert ").append((Object)t.getKindCase()).append(" to catalyst types.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
    }

    private DecimalType toCatalystDecimalType(DataType.Decimal t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasPrecision(), t.hasScale());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DecimalType(t.getPrecision(), t.getScale());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return new DecimalType(t.getPrecision());
            }
        }
        return new DecimalType();
    }

    private YearMonthIntervalType toCatalystYearMonthIntervalType(DataType.YearMonthInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new YearMonthIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return YearMonthIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return YearMonthIntervalType$.MODULE$.apply();
    }

    private DayTimeIntervalType toCatalystDayTimeIntervalType(DataType.DayTimeInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DayTimeIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return DayTimeIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return DayTimeIntervalType$.MODULE$.apply();
    }

    private ArrayType toCatalystArrayType(DataType.Array t) {
        return new ArrayType(this.toCatalystType(t.getElementType()), t.getContainsNull());
    }

    private StructType toCatalystStructType(DataType.Struct t) {
        Seq fields = (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(t.getFieldsList()).toSeq().map((Function1 & Serializable & scala.Serializable)protoField -> {
            Metadata metadata = protoField.hasMetadata() ? Metadata$.MODULE$.fromJson(protoField.getMetadata()) : Metadata$.MODULE$.empty();
            return new StructField(protoField.getName(), MODULE$.toCatalystType(protoField.getDataType()), protoField.getNullable(), metadata);
        }, Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(fields);
    }

    private MapType toCatalystMapType(DataType.Map t) {
        return new MapType(this.toCatalystType(t.getKeyType()), this.toCatalystType(t.getValueType()), t.getValueContainsNull());
    }

    private UserDefinedType<?> toCatalystUDT(DataType.UDT t) {
        String string = t.getType();
        String string2 = "udt";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new InvalidPlanInput(new StringBuilder(66).append("UserDefinedType requires the 'type' field to be 'udt', but got '").append(t.getType()).append("'.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        if (t.hasJvmClass()) {
            return (UserDefinedType)Utils$.MODULE$.classForName(t.getJvmClass(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (!(t.hasPythonClass() && t.hasSerializedPythonClass() && t.hasSqlType())) {
            throw new InvalidPlanInput("PythonUserDefinedType requires all the three fields: python_class, serialized_python_class and sql_type.", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return new PythonUserDefinedType(this.toCatalystType(t.getSqlType()), t.getPythonClass(), t.getSerializedPythonClass());
    }

    public org.apache.spark.connect.proto.DataType toConnectProtoType(DataType t) {
        StructType structType;
        StructField[] fields;
        DecimalType decimalType;
        Option option;
        DataType dataType = t;
        if (NullType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setNull(DataType.NULL.getDefaultInstance()).build();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setBoolean(DataType.Boolean.getDefaultInstance()).build();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setBinary(DataType.Binary.getDefaultInstance()).build();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setByte(DataType.Byte.getDefaultInstance()).build();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setShort(DataType.Short.getDefaultInstance()).build();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setInteger(DataType.Integer.getDefaultInstance()).build();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setLong(DataType.Long.getDefaultInstance()).build();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setFloat(DataType.Float.getDefaultInstance()).build();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setDouble(DataType.Double.getDefaultInstance()).build();
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDecimal(DataType.Decimal.newBuilder().setPrecision(precision).setScale(scale).build()).build();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setString(DataType.String.getDefaultInstance()).build();
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setChar(DataType.Char.newBuilder().setLength(length).build()).build();
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setVarChar(DataType.VarChar.newBuilder().setLength(length).build()).build();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setDate(DataType.Date.getDefaultInstance()).build();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setTimestamp(DataType.Timestamp.getDefaultInstance()).build();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setTimestampNtz(DataType.TimestampNTZ.getDefaultInstance()).build();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return org.apache.spark.connect.proto.DataType.newBuilder().setCalendarInterval(DataType.CalendarInterval.getDefaultInstance()).build();
        }
        if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            byte startField = yearMonthIntervalType.startField();
            byte endField = yearMonthIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setYearMonthInterval(DataType.YearMonthInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            byte startField = dayTimeIntervalType.startField();
            byte endField = dayTimeIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDayTimeInterval(DataType.DayTimeInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (elementType != null) {
                DataType dataType2 = elementType;
                boolean bl = containsNull;
                return org.apache.spark.connect.proto.DataType.newBuilder().setArray(DataType.Array.newBuilder().setElementType(this.toConnectProtoType(dataType2)).setContainsNull(bl).build()).build();
            }
        }
        if (dataType instanceof StructType && (fields = (structType = (StructType)dataType).fields()) != null) {
            StructField[] structFieldArray = fields;
            Seq protoFields = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structFieldArray)).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata metadata = structField.metadata();
                    if (name != null) {
                        String string = name;
                        if (dataType != null) {
                            DataType dataType2 = dataType;
                            boolean bl = nullable;
                            if (metadata != null) {
                                Metadata metadata2 = metadata;
                                if (metadata2.equals((Object)Metadata$.MODULE$.empty())) {
                                    return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType2)).setNullable(bl).build();
                                }
                                return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType2)).setNullable(bl).setMetadata(metadata2.json()).build();
                            }
                        }
                    }
                }
                throw new MatchError((Object)structField);
            }, Seq$.MODULE$.canBuildFrom());
            return org.apache.spark.connect.proto.DataType.newBuilder().setStruct(DataType.Struct.newBuilder().addAllFields(ImplicitConversions$.MODULE$.seq$u0020AsJavaList(protoFields)).build()).build();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (keyType != null) {
                DataType dataType3 = keyType;
                if (valueType != null) {
                    DataType dataType4 = valueType;
                    boolean bl = valueContainsNull;
                    return org.apache.spark.connect.proto.DataType.newBuilder().setMap(DataType.Map.newBuilder().setKeyType(this.toConnectProtoType(dataType3)).setValueType(this.toConnectProtoType(dataType4)).setValueContainsNull(bl).build()).build();
                }
            }
        }
        if (dataType instanceof PythonUserDefinedType) {
            PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(DataType.UDT.newBuilder().setType("udt").setPythonClass(pythonUserDefinedType.pyUDT()).setSqlType(this.toConnectProtoType(pythonUserDefinedType.sqlType())).setSerializedPythonClass(pythonUserDefinedType.serializedPyClass()).build()).build();
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            DataType.UDT.Builder builder = DataType.UDT.newBuilder();
            builder.setType("udt").setJvmClass(userDefinedType.getClass().getName()).setSqlType(this.toConnectProtoType(userDefinedType.sqlType()));
            Object object = userDefinedType.pyUDT() != null ? builder.setPythonClass(userDefinedType.pyUDT()) : BoxedUnit.UNIT;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(builder.build()).build();
        }
        throw new InvalidPlanInput(new StringBuilder(49).append("Does not support convert ").append(t.typeName()).append(" to connect proto types.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
    }

    private DataTypeProtoConverter$() {
        MODULE$ = this;
    }
}

