/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.config;

import java.io.Serializable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.SparkStringUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ConfigHelpers$ {
    public static final ConfigHelpers$ MODULE$ = new ConfigHelpers$();

    public <T> T toNumber(String s, Function1<String, T> converter, String key, String configType) {
        Object object;
        try {
            object = converter.apply((Object)s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.configTypeMismatchError(key, s, configType);
        }
        return (T)object;
    }

    public boolean toBoolean(String s, String key) {
        boolean bl;
        try {
            bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s.trim()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.configTypeMismatchError(key, s, "boolean");
        }
        return bl;
    }

    public <E extends Enumeration> Enumeration.Value toEnum(String s, E enumClass, String key) {
        Enumeration.Value value;
        try {
            value = enumClass.withName(s.trim().toUpperCase(Locale.ROOT));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw this.configOutOfRangeOfOptionsError(key, s, (Iterable<Object>)enumClass.values());
        }
        return value;
    }

    public <E extends Enum<E>> E toEnum(String s, Class<E> enumClass, String key) {
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])enumClass.getEnumConstants()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelpers$.$anonfun$toEnum$1(s, x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Enum enum_ = (Enum)some.value();
            return (E)enum_;
        }
        if (None$.MODULE$.equals(option)) {
            throw this.configOutOfRangeOfOptionsError(key, s, (Iterable<Object>)Predef$.MODULE$.wrapRefArray((Object[])enumClass.getEnumConstants()));
        }
        throw new MatchError((Object)option);
    }

    public <T> Seq<T> stringToSeq(String str, Function1<String, T> converter) {
        return (Seq)SparkStringUtils$.MODULE$.stringToSeq(str).map(converter);
    }

    public <T> String seqToString(Seq<T> v, Function1<T, String> stringConverter) {
        return ((IterableOnceOps)v.map(stringConverter)).mkString(",");
    }

    public long timeFromString(String str, TimeUnit unit, String key) {
        long l;
        try {
            l = JavaUtils.timeStringAs((String)str, (TimeUnit)unit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.configTypeMismatchError(key, str, "time in " + unit);
        }
        return l;
    }

    public String timeToString(long v, TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(v, unit) + "ms";
    }

    public long byteFromString(String str, ByteUnit unit, String key) {
        long l;
        try {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(str)) && str.charAt(0) == '-' ? new Tuple2((Object)str.substring(1), (Object)BoxesRunTime.boxToInteger((int)-1)) : new Tuple2((Object)str, (Object)BoxesRunTime.boxToInteger((int)1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String input = (String)tuple2._1();
            int multiplier = tuple2._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)input, (Object)BoxesRunTime.boxToInteger((int)multiplier));
            String input2 = (String)tuple23._1();
            int multiplier2 = tuple23._2$mcI$sp();
            l = (long)multiplier2 * JavaUtils.byteStringAs((String)input2, (ByteUnit)unit);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NumberFormatException ? true : throwable2 instanceof IllegalArgumentException) {
                throw this.configTypeMismatchError(key, str, "bytes in " + unit);
            }
            throw throwable;
        }
        return l;
    }

    public String byteToString(long v, ByteUnit unit, String key) {
        String string;
        try {
            string = unit.convertTo(v, ByteUnit.BYTE) + "b";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.configTypeMismatchError(key, Long.toString(v), "bytes in " + unit);
        }
        return string;
    }

    public Regex regexFromString(String str, String key) {
        Regex regex;
        try {
            regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(str));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw this.configTypeMismatchError(key, str, "regex");
        }
        return regex;
    }

    public SparkIllegalArgumentException configTypeMismatchError(String key, String value, String configType) {
        return new SparkIllegalArgumentException("INVALID_CONF_VALUE.TYPE_MISMATCH", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confName"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confValue"), (Object)value), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confType"), (Object)configType)}))));
    }

    public SparkIllegalArgumentException configOutOfRangeOfOptionsError(String key, String value, Iterable<Object> options) {
        return new SparkIllegalArgumentException("INVALID_CONF_VALUE.OUT_OF_RANGE_OF_OPTIONS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confName"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confValue"), (Object)value), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confOptions"), (Object)options.mkString(", "))}))));
    }

    public SparkIllegalArgumentException configRequirementError(String key, String value, String requirement) {
        return new SparkIllegalArgumentException("INVALID_CONF_VALUE.REQUIREMENT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confName"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confValue"), (Object)value), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confRequirement"), (Object)requirement)}))));
    }

    public static final /* synthetic */ boolean $anonfun$toEnum$1(String s$1, Enum x$1) {
        return x$1.name().equalsIgnoreCase(s$1.trim());
    }

    private ConfigHelpers$() {
    }
}

