/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.JsonArraysAsStructsException;
import org.apache.spark.sql.catalyst.util.LazyBadRecordCauseWrapper;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.StringAsDataTypeException;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\n\u0014\u0001\u0001B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007]\u0002\u0001\u000b\u0011B'\t\u000f=\u0004!\u0019!C\u0005a\"1q\u000f\u0001Q\u0001\nEDq\u0001\u001f\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004z\u0001\u0001\u0006I!\u001d\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\t)\u0002\u0001Q\u0001\nqDq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002&\u0001!I!a\n\u0003#\u0019\u000b\u0017\u000e\\;sKN\u000bg-\u001a)beN,'O\u0003\u0002\u0015+\u0005!Q\u000f^5m\u0015\t1r#\u0001\u0005dCR\fG._:u\u0015\tA\u0012$A\u0002tc2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001+\t\tcf\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\f\u0011B]1x!\u0006\u00148/\u001a:\u0011\t\rRCfN\u0005\u0003W\u0011\u0012\u0011BR;oGRLwN\\\u0019\u0011\u00055rC\u0002\u0001\u0003\u0006_\u0001\u0011\r\u0001\r\u0002\u0003\u0013:\u000b\"!\r\u001b\u0011\u0005\r\u0012\u0014BA\u001a%\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aI\u001b\n\u0005Y\"#aA!osB\u0019\u0001\bQ\"\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f \u0003\u0019a$o\\8u}%\tQ%\u0003\u0002@I\u00059\u0001/Y2lC\u001e,\u0017BA!C\u0005!IE/\u001a:bE2,'BA %!\t!U)D\u0001\u0016\u0013\t1UCA\u0006J]R,'O\\1m%><\u0018\u0001B7pI\u0016\u0004\"!\u0013&\u000e\u0003MI!aS\n\u0003\u0013A\u000b'o]3N_\u0012,\u0017AB:dQ\u0016l\u0017\r\u0005\u0002O#6\tqJ\u0003\u0002Q/\u0005)A/\u001f9fg&\u0011!k\u0014\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!G2pYVlgNT1nK>37i\u001c:skB$(+Z2pe\u0012\u0004\"!V-\u000f\u0005Y;\u0006C\u0001\u001e%\u0013\tAF%\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-%\u0003\u0019a\u0014N\\5u}Q)al\u00181bEB\u0019\u0011\n\u0001\u0017\t\u000b!*\u0001\u0019A\u0015\t\u000b\u001d+\u0001\u0019\u0001%\t\u000b1+\u0001\u0019A'\t\u000bM+\u0001\u0019\u0001+\u0002#\r|'O];qi\u001aKW\r\u001c3J]\u0012,\u00070F\u0001f!\r\u0019c\r[\u0005\u0003O\u0012\u0012aa\u00149uS>t\u0007CA\u0012j\u0013\tQGEA\u0002J]R\f!cY8seV\u0004HOR5fY\u0012Le\u000eZ3yA\u0005a\u0011m\u0019;vC2\u001c6\r[3nCV\tQ*A\u0007bGR,\u0018\r\\*dQ\u0016l\u0017\rI\u0001\ne\u0016\u001cX\u000f\u001c;S_^,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iV\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011ao\u001d\u0002\u0013\u000f\u0016tWM]5d\u0013:$XM\u001d8bYJ{w/\u0001\u0006sKN,H\u000e\u001e*po\u0002\n!B\\;mYJ+7/\u001e7u\u0003-qW\u000f\u001c7SKN,H\u000e\u001e\u0011\u0002\u0017Q|'+Z:vYR\u0014vn^\u000b\u0002yB11%`@\u0002\u0002\rK!A \u0013\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA\u0012g\u0007B)1%a\u0001\u0002\b%\u0019\u0011Q\u0001\u0013\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA\u0005\u0003#i!!a\u0003\u000b\u0007A\u000biAC\u0002\u0002\u0010e\ta!\u001e8tC\u001a,\u0017\u0002BA\n\u0003\u0017\u0011!\"\u0016+GqM#(/\u001b8h\u00031!xNU3tk2$(k\\<!\u0003\u0015\u0001\u0018M]:f)\u0011\tY\"!\t\u0011\ta\nibQ\u0005\u0004\u0003?\u0011%\u0001C%uKJ\fGo\u001c:\t\r\u0005\r\u0002\u00031\u0001-\u0003\u0015Ig\u000e];u\u0003E\"\bN]8x\u001b\u0006dgm\u001c:nK\u0012\u0014VmY8sIN$U\r^3di\u0016$\u0017J\u001c*fG>\u0014H\rU1sg&tw-\u0012:s_J$R!MA\u0015\u0003gAq!a\u000b\u0012\u0001\u0004\ti#A\u0001f!\rI\u0015qF\u0005\u0004\u0003c\u0019\"A\u0005\"bIJ+7m\u001c:e\u000bb\u001cW\r\u001d;j_:Dq!!\u000e\u0012\u0001\u0004\t9$A\u0003dCV\u001cX\rE\u00029\u0003sI1!a\u000fC\u0005%!\u0006N]8xC\ndW\r")
public class FailureSafeParser<IN> {
    private final Function1<IN, Iterable<InternalRow>> rawParser;
    private final ParseMode mode;
    private final StructType schema;
    private final String columnNameOfCorruptRecord;
    private final Option<Object> corruptFieldIndex;
    private final StructType actualSchema;
    private final GenericInternalRow resultRow;
    private final GenericInternalRow nullResult;
    private final Function2<Option<InternalRow>, Function0<UTF8String>, InternalRow> toResultRow;

    private Option<Object> corruptFieldIndex() {
        return this.corruptFieldIndex;
    }

    private StructType actualSchema() {
        return this.actualSchema;
    }

    private GenericInternalRow resultRow() {
        return this.resultRow;
    }

    private GenericInternalRow nullResult() {
        return this.nullResult;
    }

    private Function2<Option<InternalRow>, Function0<UTF8String>, InternalRow> toResultRow() {
        return this.toResultRow;
    }

    public Iterator<InternalRow> parse(IN input) {
        Iterator iterator;
        try {
            iterator = ((IterableOnce)this.rawParser.apply(input)).iterator().map((Function1 & Serializable)row -> (InternalRow)this.toResultRow().apply((Object)new Some(row), (Function0 & Serializable)() -> null));
        }
        catch (BadRecordException e) {
            ParseMode parseMode = this.mode;
            if (PermissiveMode$.MODULE$.equals(parseMode)) {
                InternalRow[] partialResults = (InternalRow[])e.partialResults().apply();
                iterator = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])partialResults)) ? ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])partialResults)).map((Function1 & Serializable)row -> (InternalRow)this.toResultRow().apply((Object)new Some(row), e.record())) : package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalRow[]{(InternalRow)this.toResultRow().apply((Object)None$.MODULE$, e.record())}));
            }
            if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                iterator = package$.MODULE$.Iterator().empty();
            }
            if (FailFastMode$.MODULE$.equals(parseMode)) {
                Throwable throwable = e.getCause();
                if (throwable instanceof JsonArraysAsStructsException) {
                    throw QueryExecutionErrors$.MODULE$.cannotParseJsonArraysAsStructsError(((UTF8String)e.record().apply()).toString());
                }
                if (throwable instanceof StringAsDataTypeException) {
                    StringAsDataTypeException stringAsDataTypeException = (StringAsDataTypeException)throwable;
                    String fieldName = stringAsDataTypeException.fieldName();
                    String fieldValue = stringAsDataTypeException.fieldValue();
                    DataType dataType = stringAsDataTypeException.dataType();
                    throw QueryExecutionErrors$.MODULE$.cannotParseStringAsDataTypeError(((UTF8String)e.record().apply()).toString(), fieldName, fieldValue, dataType);
                }
                if (throwable instanceof LazyBadRecordCauseWrapper) {
                    LazyBadRecordCauseWrapper lazyBadRecordCauseWrapper = (LazyBadRecordCauseWrapper)throwable;
                    throw this.throwMalformedRecordsDetectedInRecordParsingError(e, (Throwable)lazyBadRecordCauseWrapper.cause().apply());
                }
                throw this.throwMalformedRecordsDetectedInRecordParsingError(e, throwable);
            }
            throw new MatchError((Object)parseMode);
        }
        return iterator;
    }

    private Nothing$ throwMalformedRecordsDetectedInRecordParsingError(BadRecordException e, Throwable cause) {
        throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInRecordParsingError(this.toResultRow().apply((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])e.partialResults().apply())), e.record()).toString(), cause);
    }

    public static final /* synthetic */ boolean $anonfun$actualSchema$1(FailureSafeParser $this, StructField x$1) {
        String string = x$1.name();
        String string2 = $this.columnNameOfCorruptRecord;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public FailureSafeParser(Function1<IN, Iterable<InternalRow>> rawParser, ParseMode mode, StructType schema, String columnNameOfCorruptRecord) {
        this.rawParser = rawParser;
        this.mode = mode;
        this.schema = schema;
        this.columnNameOfCorruptRecord = columnNameOfCorruptRecord;
        this.corruptFieldIndex = schema.getFieldIndex(columnNameOfCorruptRecord);
        this.actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FailureSafeParser.$anonfun$actualSchema$1(this, x$1))));
        this.resultRow = new GenericInternalRow(schema.length());
        this.nullResult = new GenericInternalRow(schema.length());
        this.toResultRow = this.corruptFieldIndex().isDefined() ? (Function2 & Serializable)(row, badRecord) -> {
            IntRef i = IntRef.create((int)0);
            while (i.elem < this.actualSchema().length()) {
                StructField from = this.actualSchema().apply(i.elem);
                this.resultRow().update($this.schema.fieldIndex(from.name()), row.map((Function1 & Serializable)x$2 -> x$2.get(i$1.elem, from.dataType())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                ++i.elem;
            }
            this.resultRow().update(BoxesRunTime.unboxToInt((Object)this.corruptFieldIndex().get()), badRecord.apply());
            return this.resultRow();
        } : (Function2 & Serializable)(row, x$3) -> (InternalRow)row.getOrElse((Function0 & Serializable)() -> this.nullResult());
    }
}

