/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.Inline;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.variant.ToVariantObject$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExpressionEvalUtils$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Convert a nested input (array/map/struct) into a variant where maps and structs are converted to variant objects which are unordered unlike SQL structs. Input maps can only have string keys.", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(array(1, 2, 3));\n       [1,2,3]\n      > SELECT _FUNC_(array(named_struct('a', 1)));\n       [{\"a\":1}]\n      > SELECT _FUNC_(array(map(\"a\", 2)));\n       [{\"a\":2}]\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u000f\u001e\u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")A\u000b\u0001C!+\"9\u0011\f\u0001b\u0001\n\u0003R\u0006BB1\u0001A\u0003%1\fC\u0003c\u0001\u0011\u00053\rC\u0003k\u0001\u0011\u00053\u000eC\u0003u\u0001\u0011ES\u000fC\u0003y\u0001\u0011E\u0013\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\n\u0003;\u0001\u0011\u0011!C\u0001\u0003?A\u0011\"a\t\u0001#\u0003%\t!!\n\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0002\"CA'\u0001\u0005\u0005I\u0011AA(\u0011%\t9\u0006AA\u0001\n\u0003\tI\u0006C\u0005\u0002`\u0001\t\t\u0011\"\u0011\u0002b!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"a\u001f\u0001\u0003\u0003%\t%! \b\u0013\u0005\u0005V$!A\t\u0002\u0005\rf\u0001\u0003\u000f\u001e\u0003\u0003E\t!!*\t\r=3B\u0011AA_\u0011%\tyLFA\u0001\n\u000b\n\t\rC\u0005\u0002DZ\t\t\u0011\"!\u0002F\"I\u0011\u0011\u001a\f\u0002\u0002\u0013\u0005\u00151\u001a\u0005\n\u0003/4\u0012\u0011!C\u0005\u00033\u0014q\u0002V8WCJL\u0017M\u001c;PE*,7\r\u001e\u0006\u0003=}\tqA^1sS\u0006tGO\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0015\u0001Q&M\u001c>!\tqs&D\u0001 \u0013\t\u0001tDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011T'D\u00014\u0015\t!4%\u0001\u0004feJ|'o]\u0005\u0003mM\u0012q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\b!J|G-^2u!\tqdI\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iK\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!!R\u001d\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u000bf\nQa\u00195jY\u0012,\u0012a\u0013\t\u0003]1K!!T\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u001b\u0006C\u0001*\u0001\u001b\u0005i\u0002\"B%\u0004\u0001\u0004Y\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002-B\u0011\u0001hV\u0005\u00031f\u0012qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010$\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001WL\u0001\u0005ECR\fG+\u001f9f\u0003%!\u0017\r^1UsB,\u0007%A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001e!\t)\u0007.D\u0001g\u0015\t9\u0017%\u0001\u0005b]\u0006d\u0017p]5t\u0013\tIgMA\bUsB,7\t[3dWJ+7/\u001e7u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002YB\u0011Q.\u001d\b\u0003]>\u0004\"\u0001Q\u001d\n\u0005AL\u0014A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001]\u001d\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t\tf\u000fC\u0003x\u0013\u0001\u00071*\u0001\u0005oK^\u001c\u0005.\u001b7e\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tQX\u0010\u0005\u00029w&\u0011A0\u000f\u0002\u0004\u0003:L\b\"\u0002@\u000b\u0001\u0004Q\u0018!B5oaV$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019!a\u0004\u0002\u001aA!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n}\tqaY8eK\u001e,g.\u0003\u0003\u0002\u000e\u0005\u001d!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005E1\u00021\u0001\u0002\u0014\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0011QC\u0005\u0005\u0003/\t9A\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005m1\u00021\u0001\u0002\u0004\u0005\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0002R\u0003CAq!\u0013\u0007\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d\"fA&\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GMC\u0002\u00026e\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\u0007I\f\u0019%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002RA\u0019\u0001(a\u0015\n\u0007\u0005U\u0013HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002{\u00037B\u0011\"!\u0018\u0011\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0007E\u0003\u0002f\u0005-$0\u0004\u0002\u0002h)\u0019\u0011\u0011N\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002n\u0005\u001d$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AVA:\u0011!\tiFEA\u0001\u0002\u0004Q\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0010\u0002z!I\u0011QL\n\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\u0007Y\u000by\b\u0003\u0005\u0002^Q\t\t\u00111\u0001{QM\u0001\u00111QAE\u0003\u0017\u000by)!%\u0002\u0016\u0006]\u00151TAO!\rq\u0013QQ\u0005\u0004\u0003\u000f{\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\u000b\u00111T0G+:\u001bu\fK3yaJL\u0003%\f\u0011D_:4XM\u001d;!C\u0002rWm\u001d;fI\u0002Jg\u000e];uA!\n'O]1z_5\f\u0007oL:ueV\u001cG/\u000b\u0011j]R|\u0007%\u0019\u0011wCJL\u0017M\u001c;!o\",'/\u001a\u0011nCB\u001c\b%\u00198eAM$(/^2ug\u0002\n'/\u001a\u0011d_:4XM\u001d;fI\u0002\"x\u000e\t<be&\fg\u000e\u001e\u0011pE*,7\r^:!o\"L7\r\u001b\u0011be\u0016\u0004SO\\8sI\u0016\u0014X\r\u001a\u0011v]2L7.\u001a\u0011T#2\u00033\u000f\u001e:vGR\u001ch\u0006I%oaV$\b%\\1qg\u0002\u001a\u0017M\u001c\u0011p]2L\b\u0005[1wK\u0002\u001aHO]5oO\u0002ZW-_:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAJ\u0003\t\u0015\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u001a~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIb3'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEjXL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K7ba\"\u0012\u0013M\t\u0017!e%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\n\n'E\u000f\u001a~;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u001a\u0006)AG\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011qT\u0001\u000em\u0006\u0014\u0018.\u00198u?\u001a,hnY:\u0002\u001fQ{g+\u0019:jC:$xJ\u00196fGR\u0004\"A\u0015\f\u0014\u000bY\t9+a-\u0011\r\u0005%\u0016qV&R\u001b\t\tYKC\u0002\u0002.f\nqA];oi&lW-\u0003\u0003\u00022\u0006-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011QWA^\u001b\t\t9L\u0003\u0003\u0002:\u0006\u001d\u0013AA5p\u0013\r9\u0015q\u0017\u000b\u0003\u0003G\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007f\tQ!\u00199qYf$2!UAd\u0011\u0015I\u0015\u00041\u0001L\u0003\u001d)h.\u00199qYf$B!!4\u0002TB!\u0001(a4L\u0013\r\t\t.\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005U'$!AA\u0002E\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u000e\u0005\u0003\u0002B\u0005u\u0017\u0002BAp\u0003\u0007\u0012aa\u00142kK\u000e$\b")
public class ToVariantObject
extends UnaryExpression
implements QueryErrorsBase,
Serializable {
    private final Expression child;
    private final DataType dataType;

    public static Option<Expression> unapply(ToVariantObject x$0) {
        return ToVariantObject$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ToVariantObject, A> g) {
        return ToVariantObject$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ToVariantObject> compose(Function1<A$, Expression> g) {
        return ToVariantObject$.MODULE$.compose(g);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        boolean checkResult;
        DataType dataType = this.child().dataType();
        boolean bl = checkResult = (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType)) ? VariantGet$.MODULE$.checkDataType(this.child().dataType(), true) : false;
        if (!checkResult) {
            return new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)this.toSQLType((AbstractDataType)this.child().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)VariantType$.MODULE$))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "to_variant_object";
    }

    @Override
    public ToVariantObject withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return VariantExpressionEvalUtils$.MODULE$.castToVariant(input, this.child().dataType());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode childCode = this.child().genCode(ctx);
        String cls = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(VariantExpressionEvalUtils$.MODULE$.getClass().getName()), "$");
        String fromArg = ctx.addReferenceObj("from", this.child().dataType(), ctx.addReferenceObj$default$3());
        Inline javaType = JavaCode$.MODULE$.javaType((DataType)VariantType$.MODULE$);
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = ", ";\n        ", " ", " = ", ";\n        if (!", ") {\n          ", " = ", ".castToVariant(", ", ", ");\n        }\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{childCode.code(), ev.isNull(), childCode.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue((DataType)VariantType$.MODULE$, CodeGenerator$.MODULE$.defaultValue$default$2()), childCode.isNull(), ev.value(), cls, childCode.value(), fromArg}));
        return ev.copy(code, ev.copy$default$2(), ev.copy$default$3());
    }

    public ToVariantObject copy(Expression child) {
        return new ToVariantObject(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ToVariantObject";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToVariantObject;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToVariantObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToVariantObject toVariantObject = (ToVariantObject)x$1;
        Expression expression = this.child();
        Expression expression2 = toVariantObject.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!toVariantObject.canEqual(this)) return false;
        return true;
    }

    public ToVariantObject(Expression child) {
        this.child = child;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.dataType = VariantType$.MODULE$;
    }
}

