/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnBase64$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str) - Converts the argument from a base 64 string `str` to a binary.", examples="\n    Examples:\n      > SELECT _FUNC_('U3BhcmsgU1FM');\n       Spark SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011Q\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015Y\u0007\u0001\"\u0011Q\u0011\u0015)\u0006\u0001\"\u0001m\u0011\u0015y\u0007\u0001\"\u0015q\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\tY\u0001\u0001C)\u0003\u001bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005u\u0001\"CA\u001a\u0001E\u0005I\u0011AA\u001b\u0011%\tI\u0004AA\u0001\n\u0003\nY\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u000f\u001d\t\tK\tE\u0001\u0003G3a!\t\u0012\t\u0002\u0005\u0015\u0006BB+\u001a\t\u0003\t9\fC\u0004\u0002:f!\t!a/\t\u0013\u0005=\u0017$!A\u0005\u0002\u0006E\u0007\"CAl3E\u0005I\u0011AA\u001b\u0011%\tI.GA\u0001\n\u0003\u000bY\u000eC\u0005\u0002nf\t\n\u0011\"\u0001\u00026!I\u0011q^\r\u0002\u0002\u0013%\u0011\u0011\u001f\u0002\t+:\u0014\u0015m]37i)\u00111\u0005J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002&M\u0005A1-\u0019;bYf\u001cHO\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001aQ:T\b\u0005\u00022e5\t!%\u0003\u00024E\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00022k%\u0011aG\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001 G\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002C]\u00051AH]8pizJ\u0011AO\u0005\u0003\u000bf\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\na1+\u001a:jC2L'0\u00192mK*\u0011Q)O\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0017B\u0011\u0011\u0007T\u0005\u0003\u001b\n\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005\t\u0006C\u0001\u001dS\u0013\t\u0019\u0016HA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r9\u0006,\u0017\t\u0003c\u0001AQ!S\u0003A\u0002-CqaT\u0003\u0011\u0002\u0003\u0007\u0011+\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u001a\nQ\u0001^=qKNL!AY0\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0007c\u0001 gQ&\u0011q\r\u0013\u0002\u0004'\u0016\f\bC\u00010j\u0013\tQwL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q2m\u001c8uKb$\u0018J\u001c3fa\u0016tG-\u001a8u\r>dG-\u00192mKR\u0011q+\u001c\u0005\u0006]*\u0001\raS\u0001\u0005Kb\u0004(/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002riB\u0011\u0001H]\u0005\u0003gf\u00121!\u00118z\u0011\u0015)8\u00021\u0001r\u0003\u0019\u0019HO]5oO\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005qz\f9\u0001\u0005\u0002zy6\t!P\u0003\u0002|E\u000591m\u001c3fO\u0016t\u0017BA?{\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007BB@\r\u0001\u0004\t\t!A\u0002dib\u00042!_A\u0002\u0013\r\t)A\u001f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\tI\u0001\u0004a\u0001q\u0006\u0011QM^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007]\u000by\u0001\u0003\u0004\u0002\u00125\u0001\raS\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u00159\u0016qCA\r\u0011\u001dIe\u0002%AA\u0002-Cqa\u0014\b\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}!fA&\u0002\"-\u0012\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0002.e\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\"fA)\u0002\"\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005!A.\u00198h\u0015\t\t9%\u0001\u0003kCZ\f\u0017\u0002BA&\u0003\u0003\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA)!\rA\u00141K\u0005\u0004\u0003+J$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA9\u0002\\!I\u0011QL\n\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0004#BA3\u0003W\nXBAA4\u0015\r\tI'O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0011+a\u001d\t\u0011\u0005uS#!AA\u0002E\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QHA=\u0011%\tiFFA\u0001\u0002\u0004\t\t&\u0001\u0004fcV\fGn\u001d\u000b\u0004#\u0006}\u0004\u0002CA//\u0005\u0005\t\u0019A9)'\u0001\t\u0019)!#\u0002\f\u0006=\u0015\u0011SAK\u0003/\u000bY*!(\u0011\u0007E\n))C\u0002\u0002\b\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u000e\u0006auLR+O\u0007~C3\u000f\u001e:*A5\u00023i\u001c8wKJ$8\u000f\t;iK\u0002\n'oZ;nK:$\bE\u001a:p[\u0002\n\u0007EY1tK\u00022D\u0007I:ue&tw\r\t1tiJ\u0004\u0007\u0005^8!C\u0002\u0012\u0017N\\1ss:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003'\u000b\u0011J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(+N\u0012\u0005nY7tOV\u000bd)T\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:lAM\u000bFJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI*A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002 \u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006AQK\u001c\"bg\u00164D\u0007\u0005\u000223M)\u0011$a*\u0002.B\u0019\u0001(!+\n\u0007\u0005-\u0016H\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003_\u000b),\u0004\u0002\u00022*!\u00111WA#\u0003\tIw.C\u0002H\u0003c#\"!a)\u0002\u001b%\u001ch+\u00197jI\n\u000b7/\u001a\u001c5)\r\t\u0016Q\u0018\u0005\b\u0003\u007f[\u0002\u0019AAa\u0003%\u0019(oY*ue&tw\r\u0005\u0003\u0002D\u0006-WBAAc\u0015\r\u0001\u0017q\u0019\u0006\u0004\u0003\u0013D\u0013AB;og\u00064W-\u0003\u0003\u0002N\u0006\u0015'AC+U\rb\u001aFO]5oO\u0006)\u0011\r\u001d9msR)q+a5\u0002V\")\u0011\n\ba\u0001\u0017\"9q\n\bI\u0001\u0002\u0004\t\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q\\Au!\u0015A\u0014q\\Ar\u0013\r\t\t/\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\n)oS)\n\u0007\u0005\u001d\u0018H\u0001\u0004UkBdWM\r\u0005\t\u0003Wt\u0012\u0011!a\u0001/\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\u0010\u0005\u0003\u0002@\u0005U\u0018\u0002BA|\u0003\u0003\u0012aa\u00142kK\u000e$\b")
public class UnBase64
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return UnBase64$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnBase64 x$0) {
        return UnBase64$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnBase64$.MODULE$.apply$default$2();
    }

    public static boolean isValidBase64(UTF8String srcString) {
        return UnBase64$.MODULE$.isValidBase64(srcString);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object string) {
        if (this.failOnError() && !UnBase64$.MODULE$.isValidBase64((UTF8String)string)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)string, UTF8String.fromString((String)"BASE64"), "try_to_binary");
        }
        return Base64.getMimeDecoder().decode(((UTF8String)string).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)child -> {
            String string;
            if (this.failOnError()) {
                String unbase64 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(UnBase64$.MODULE$.getClass().getName()), "$");
                String binaryType = ctx.addReferenceObj("to", BinaryType$.MODULE$, BinaryType$.MODULE$.getClass().getName());
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + unbase64 + ".isValidBase64(" + child + ")) {\n           |  throw QueryExecutionErrors.invalidInputInConversionError(\n           |    " + binaryType + ",\n           |    " + child + ",\n           |    UTF8String.fromString(\"BASE64\"),\n           |    \"try_to_binary\");\n           |}\n       "));
            } else {
                string = "";
            }
            String maybeValidateInputCode = string;
            return "\n         " + maybeValidateInputCode + "\n         " + ev.value() + " = " + Base64.class.getName() + ".getMimeDecoder().decode(" + child + ".toString());\n       ";
        });
    }

    @Override
    public UnBase64 withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public UnBase64 copy(Expression child, boolean failOnError) {
        return new UnBase64(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnBase64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnBase64;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnBase64)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnBase64 unBase64 = (UnBase64)x$1;
        if (this.failOnError() != unBase64.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unBase64.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unBase64.canEqual(this)) return false;
        return true;
    }

    public UnBase64(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnBase64(Expression expr) {
        this(expr, false);
    }
}

