/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryMakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.TryMakeTimestampFromDateTime;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec[, timezone]) - Try to create a timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`. The function returns NULL on invalid inputs.\n\n    _FUNC_(date[, time[, timezone]]) - Try to create a timestamp from date, time, and timezone fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date expression\n      * time - a time expression (optional). Default is 00:00:00.\n      * timezone - the time zone identifier (optional). For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28');\n       2014-12-28 00:00:00\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887', 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(2024, 13, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="4.0.0")
public final class TryMakeTimestampExpressionBuilder$
implements ExpressionBuilder {
    public static final TryMakeTimestampExpressionBuilder$ MODULE$ = new TryMakeTimestampExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 1) {
            return new TryMakeTimestampFromDateTime((Expression)expressions.apply(0));
        }
        if (numArgs == 2) {
            return new TryMakeTimestampFromDateTime((Expression)expressions.apply(0), (Expression)expressions.apply(1));
        }
        if (numArgs == 3) {
            return new TryMakeTimestampFromDateTime((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2));
        }
        if (numArgs == 6) {
            return new TryMakeTimestamp((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3), (Expression)expressions.apply(4), (Expression)expressions.apply(5));
        }
        if (numArgs == 7) {
            return new TryMakeTimestamp((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3), (Expression)expressions.apply(4), (Expression)expressions.apply(5), (Expression)expressions.apply(6));
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6, 7}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private TryMakeTimestampExpressionBuilder$() {
    }
}

