/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:<br><br>\n          _ matches any one character in the input (similar to . in posix regular expressions)\\\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)<br><br>\n          Since Spark 2.0, string literals are unescaped in our SQL parser, see the unescaping\n          rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, in order to match \"\\abc\", the pattern should be \"\\\\abc\".<br><br>\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SELECT '\\\\abc' AS S, S _FUNC_ r'\\\\abc', S _FUNC_ '\\\\\\\\abc';\n      \\abc\ttrue\ttrue\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ r'%SystemDrive%\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003\u0011\u0006\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B*\t\u000b]\u0003A\u0011\u0001-\t\u000b]\u0003A\u0011A/\t\u000b]\u0003A\u0011\u00011\t\u000b\u0011\u0004A\u0011I3\t\u000bA\u0004A\u0011I9\t\u0013\u0005\u0015\u0001A1A\u0005F\u0005\u001d\u0001\u0002CA\u001d\u0001\u0001\u0006i!!\u0003\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!1!\u0006\u0001C!\u0003\u007fAq!!\u0011\u0001\t#\n\u0019\u0005C\u0004\u0002`\u0001!\t&!\u0019\t\u0013\u0005-\u0004!!A\u0005\u0002\u00055\u0004\"CA;\u0001E\u0005I\u0011AA<\u0011%\ti\tAI\u0001\n\u0003\t9\bC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003G\u0003\u0011\u0011!C\u0001\u0003KC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005m\u0006!!A\u0005B\u0005u\u0006\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\t\t\u000eAA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\u001eI!\u0011B\u0013\u0002\u0002#\u0005!1\u0002\u0004\tI\u0015\n\t\u0011#\u0001\u0003\u000e!1qK\bC\u0001\u0005KA\u0011\"a\u000f\u001f\u0003\u0003%)Ea\n\t\u0013\t%b$!A\u0005\u0002\n-\u0002\"\u0003B\u001a=\u0005\u0005I\u0011\u0011B\u001b\u0011%\u00119EHA\u0001\n\u0013\u0011IE\u0001\u0003MS.,'B\u0001\u0014(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005!J\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005)Z\u0013aA:rY*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0019t'\u0010\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012Qc\u0015;sS:<'+Z4fq\u0016C\bO]3tg&|g\u000e\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0015'\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005!A.\u001a4u+\u0005Y\u0005C\u0001\u001bM\u0013\tiUE\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013AC3tG\u0006\u0004Xm\u00115beV\t1\u000b\u0005\u00029)&\u0011Q+\u000f\u0002\u0005\u0007\"\f'/A\u0006fg\u000e\f\u0007/Z\"iCJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Z5nc\u0006C\u0001\u001b\u0001\u0011\u0015Iu\u00011\u0001L\u0011\u0015yu\u00011\u0001L\u0011\u0015\tv\u00011\u0001T)\rIfl\u0018\u0005\u0006\u0013\"\u0001\ra\u0013\u0005\u0006\u001f\"\u0001\ra\u0013\u000b\u00053\u0006\u00147\rC\u0003J\u0013\u0001\u00071\nC\u0003P\u0013\u0001\u00071\nC\u0003R\u0013\u0001\u00071*\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0003M:\u0004\"aZ6\u000f\u0005!L\u0007C\u0001!:\u0013\tQ\u0017(\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016:\u0011\u0015y'\u00021\u0001g\u0003\u00051\u0018aB7bi\u000eDWm\u001d\u000b\u0005eV\f\t\u0001\u0005\u00029g&\u0011A/\u000f\u0002\b\u0005>|G.Z1o\u0011\u001518\u00021\u0001x\u0003\u0015\u0011XmZ3y!\tAh0D\u0001z\u0015\t1(P\u0003\u0002|y\u0006!Q\u000f^5m\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a`=\u0003\u000fA\u000bG\u000f^3s]\"1\u00111A\u0006A\u0002\u0019\f1a\u001d;s\u00031qw\u000eZ3QCR$XM\u001d8t+\t\tI\u0001E\u0003?\u0003\u0017\ty!C\u0002\u0002\u000e!\u00131aU3r!\u0011\t\t\"a\r\u000f\t\u0005M\u0011Q\u0006\b\u0005\u0003+\tIC\u0004\u0003\u0002\u0018\u0005\u001db\u0002BA\r\u0003KqA!a\u0007\u0002$9!\u0011QDA\u0011\u001d\r\u0001\u0015qD\u0005\u0002a%\u0011afL\u0005\u0003Y5J!AK\u0016\n\u0005!J\u0013bAA\u0016O\u0005)AO]3fg&!\u0011qFA\u0019\u0003-!&/Z3QCR$XM\u001d8\u000b\u0007\u0005-r%\u0003\u0003\u00026\u0005]\"a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:TA!a\f\u00022\u0005ian\u001c3f!\u0006$H/\u001a:og\u0002\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002MV\ta-A\u0005e_\u001e+gnQ8eKR1\u0011QIA)\u00037\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017*\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u001f\nIE\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003+\n1a\u0019;y!\u0011\t9%a\u0016\n\t\u0005e\u0013\u0011\n\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\ti\u0006\u0005a\u0001\u0003\u000b\n!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B-\u0002d\u0005\u001d\u0004BBA3#\u0001\u00071*A\u0004oK^dUM\u001a;\t\r\u0005%\u0014\u00031\u0001L\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$r!WA8\u0003c\n\u0019\bC\u0004J%A\u0005\t\u0019A&\t\u000f=\u0013\u0002\u0013!a\u0001\u0017\"9\u0011K\u0005I\u0001\u0002\u0004\u0019\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sR3aSA>W\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0013Ut7\r[3dW\u0016$'bAADs\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019JK\u0002T\u0003w\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAPy\u0006!A.\u00198h\u0013\ra\u0017QT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00032\u0001OAU\u0013\r\tY+\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\u000b9\fE\u00029\u0003gK1!!.:\u0005\r\te.\u001f\u0005\n\u0003sC\u0012\u0011!a\u0001\u0003O\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA`!\u0019\t\t-a2\u000226\u0011\u00111\u0019\u0006\u0004\u0003\u000bL\u0014AC2pY2,7\r^5p]&!\u0011\u0011ZAb\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007I\fy\rC\u0005\u0002:j\t\t\u00111\u0001\u00022\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI*!6\t\u0013\u0005e6$!AA\u0002\u0005\u001d\u0016AB3rk\u0006d7\u000fF\u0002s\u00037D\u0011\"!/\u001d\u0003\u0003\u0005\r!!-)7\u0001\ty.!:\u0002h\u0006-\u0018Q^Ay\u0003g\f90!?\u0002~\u0006}(1\u0001B\u0003!\r!\u0014\u0011]\u0005\u0004\u0003G,#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003S\f\u0011QC:ue\u0002zf)\u0016(D?\u0002\u0002\u0018\r\u001e;fe:\\\u0006%R*D\u0003B+\u0005%Z:dCB,W\fI\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u001aHO\u001d\u0011nCR\u001c\u0007.Z:!AB\fG\u000f^3s]\u0002\u0004s/\u001b;iA\u0001,7oY1qK\u0002d\u0003E\\;mY\u0002Jg\rI1os\u0002\n'oZ;nK:$8\u000fI1sK\u0002rW\u000f\u001c7-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013!C1sOVlWM\u001c;tC\t\ty/AF\u001b\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0002\u0018\r\u001e;fe:\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u0002\u0018\r\u001e;fe:\u0004\u0013n\u001d\u0011bAM$(/\u001b8hA]D\u0017n\u00195!SN\u0004S.\u0019;dQ\u0016$\u0007\u0005\\5uKJ\fG\u000e\\=-A]LG\u000f\u001b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*\u0007pY3qi&|g\u000e\t;pAQDW\r\t4pY2|w/\u001b8hAM\u0004XmY5bY\u0002\u001a\u00180\u001c2pYNTDH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A}\u0003S.\u0019;dQ\u0016\u001c\b%\u00198zA=tW\rI2iCJ\f7\r^3sA%t\u0007\u0005\u001e5fA%t\u0007/\u001e;!QMLW.\u001b7be\u0002\"x\u000e\t\u0018!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tSqS\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011&A5\fGo\u00195fg\u0002RXM]8!_J\u0004Sn\u001c:fA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\rI5oaV$\b\u0005K:j[&d\u0017M\u001d\u0011u_\u0002r#\u0006I5oAA|7/\u001b=!e\u0016<W\u000f\\1s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8og&b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000fI1sK\u0002*h.Z:dCB,G\rI5oA=,(\u000fI*R\u0019\u0002\u0002\u0018M]:fe2\u00023/Z3!i\",\u0007%\u001e8fg\u000e\f\u0007/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E];mKN\u0004\u0013\r\u001e\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006\\5uKJ\fGn\u001d\u0018ii6d7e\u001d;sS:<W\u0006\\5uKJ\fGN\t TiJLgn\u001a\u0011MSR,'/\u00197=_\u0005tdF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!S:\u0004sN\u001d3fe\u0002\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGn\u001d\u0011cC\u000e\\'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nrCH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%#xe\u001d\u0011sK\u000e|W.\\3oI\u0016$\u0007\u0005^8!kN,\u0007%\u0019\u0011sC^\u00043\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d\u0007\u0005K<ji\"\u0004C\u000f[3!AJ\u0004\u0007\u0005\u001d:fM&D\u0018\u0006\t;pA\u00054x.\u001b3!KN\u001c\u0017\r]5oO*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:qK\u000eL\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0003/\u0019;uKJt\u0007e\u001d;sS:<\u0007%\u001b4!KbL7\u000f^:/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*7oY1qK\u0002j\u0003%\u00198!G\"\f'/Y2uKJ\u0004\u0013\r\u001a3fI\u0002\u001a\u0018N\\2fAM\u0003\u0018M]6!g9\u0002d\u0006\t+iK\u0002\"WMZ1vYR\u0004Sm]2ba\u0016\u00043\r[1sC\u000e$XM\u001d\u0011jg\u0002\"\b.\u001a\u0011(9\u001er#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0013M\u001c\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\u0002(/Z2fI\u0016\u001c\b%\u0019\u0011ta\u0016\u001c\u0017.\u00197!gfl'm\u001c7!_J\u0004\u0013M\\8uQ\u0016\u0014\b%Z:dCB,\u0007e\u00195be\u0006\u001cG/\u001a:-AQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019|G\u000e\\8xS:<\u0007e\u00195be\u0006\u001cG/\u001a:!SN\u0004S.\u0019;dQ\u0016$\u0007\u0005\\5uKJ\fG\u000e\\=/A%#\b%[:!S:4\u0018\r\\5eAQ|\u0007%Z:dCB,\u0007%\u00198zA=$\b.\u001a:!G\"\f'/Y2uKJt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!>\u0002\u000b\u001fQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\w\u0005\f\u0011(?B\f'o[\u0014*w)\u0001\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!Oqc\u0016MY2(A\u0005\u001b\u0006e\u0015\u0017!'\u0002zf)\u0016(D?\u0002\u0012x\u0005\u0018/bE\u000e<C\u0006I*!?\u001a+fjQ0!OqcF\fX1cG\u001eZ$\u0002\t\u0011!A\u0001\u0002C,\u00192d\u0013Q\u0014X/Z\u0005ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fueV,7H\u0003\u0011!A\u0001\u0002\u0003e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197t\u0013Q\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9V\u001bXM]:]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcVk]3sg\u0016:3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012+!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cXHZ1mg\u0016\\$\u0002\t\u0011!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:\nM\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9r+6/\u001a:t9rSu\u000e\u001b8(A}3UKT\"`AI<SeU=ti\u0016lGI]5wK\u0016bF,V:feN,se\u000f\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eJ\u0013TsN$X-\u001c#sSZ,WeL+tKJ\u001cxFS8i]\u001e\u0002sLR+O\u0007~\u0003seL\u0013TsN$X-\u001c#sSZ,w&J\u00180+N,'o]\u0013(A\u0015\u001b6)\u0011)FA\u001dzse\u000f\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002|\u0006i$\u0002\t\u0011!AU\u001bX\r\t*M\u0013.+\u0005\u0005^8![\u0006$8\r\u001b\u0011xSRD\u0007e\u001d;b]\u0012\f'\u000f\u001a\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7O\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012!\u0011A\u0001\u0006c9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u000f\tq\u0002\u001d:fI&\u001c\u0017\r^3`MVt7m]\u0001\u0005\u0019&\\W\r\u0005\u00025=M)aDa\u0004\u0003\u001cAA!\u0011\u0003B\f\u0017.\u001b\u0016,\u0004\u0002\u0003\u0014)\u0019!QC\u001d\u0002\u000fI,h\u000e^5nK&!!\u0011\u0004B\n\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005?\u0002\u0005%|\u0017bA$\u0003 Q\u0011!1\u0002\u000b\u0003\u00033\u000bQ!\u00199qYf$r!\u0017B\u0017\u0005_\u0011\t\u0004C\u0003JC\u0001\u00071\nC\u0003PC\u0001\u00071\nC\u0003RC\u0001\u00071+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t]\"1\t\t\u0006q\te\"QH\u0005\u0004\u0005wI$AB(qi&|g\u000e\u0005\u00049\u0005\u007fY5jU\u0005\u0004\u0005\u0003J$A\u0002+va2,7\u0007\u0003\u0005\u0003F\t\n\t\u00111\u0001Z\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0017\u0002B!a'\u0003N%!!qJAO\u0005\u0019y%M[3di\u0002")
public class Like
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;
    private final Seq<Enumeration.Value> nodePatterns;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like x$0) {
        return Like$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String toString() {
        String escapeSuffix = this.escapeChar() == '\\' ? "" : " ESCAPE '" + this.escapeChar() + "'";
        return this.left() + " " + this.prettyName().toUpperCase(Locale.ROOT) + " " + this.right() + escapeSuffix;
    }

    @Override
    public String sql() {
        String escapeSuffix = this.escapeChar() == '\\' ? "" : " ESCAPE " + Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)this.escapeChar())).sql();
        return this.left().sql() + " " + this.prettyName().toUpperCase(Locale.ROOT) + " " + this.right().sql() + escapeSuffix;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String patternClass = Pattern.class.getName();
        String escapeFunc = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName()), "$") + ".escapeLikeRegex";
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable)v -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(v + " = " + patternClass + ".compile(\"" + regexStr + "\", " + this.collationRegexFlags() + ");")), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
        }
        String pattern = ctx.freshName("pattern");
        String rightStr = ctx.freshName("rightStr");
        String escapedEscapeChar = StringEscapeUtils.escapeJava((String)Character.toString(this.escapeChar()));
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> "\n          String " + rightStr + " = " + eval2 + ".toString();\n          " + patternClass + " " + pattern + " = " + patternClass + ".compile(\n            " + escapeFunc + "(" + rightStr + ", '" + escapedEscapeChar + "'), " + this.collationRegexFlags() + ");\n          " + ev.value() + " = " + pattern + ".matcher(" + eval1 + ".toString()).matches();\n        ");
    }

    @Override
    public Like withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToCharacter((char)this.escapeChar());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "escapeChar";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        if (this.escapeChar() != like.escapeChar()) return false;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.LIKE_FAMLIY(), (List)Nil$.MODULE$);
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }

    public Like(Expression left, Expression right, Expression escapeChar) {
        this(left, right, StringRegexExpression$.MODULE$.expressionToEscapeChar(escapeChar));
    }
}

